/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import com.sun.jnlp.JNLPClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;

public class JdicManager {
    private boolean isShareNativeInitialized = false;
    String nativeLibPath = null;
    private static JdicManager sSingleton = null;

    private JdicManager() {
    }

    public static synchronized JdicManager getManager() {
        if (sSingleton == null) {
            sSingleton = new JdicManager();
        }
        return sSingleton;
    }

    public void initShareNative() throws JdicInitException {
        WebBrowserUtil.trace("init share native..... ");
        if (this.isShareNativeInitialized) {
            return;
        }
        try {
            String string = System.getProperty("javawebstart.version");
            if (string != null) {
                WebBrowserUtil.trace("Loaded by JavaWebStart,version is " + string);
                this.nativeLibPath = this.caculateNativeLibPathBySunJWS();
                return;
            }
            WebBrowserUtil.trace("not loaded by jws ");
            String string2 = new URL(JdicManager.class.getProtectionDomain().getCodeSource().getLocation(), ".").openConnection().getPermission().getName();
            WebBrowserUtil.trace("current runnning path " + string2);
            String string3 = new File(string2).getCanonicalPath();
            string3 = this.dealExtensionMode(string3);
            WebBrowserUtil.trace("runnning path after dealing " + string2);
            this.nativeLibPath = this.dealCrossPlatformVersion(string3);
            String string4 = this.nativeLibPath + File.pathSeparator + System.getProperty("java.library.path");
            System.setProperty("java.library.path", string4);
            Field field = ClassLoader.class.getDeclaredField("sys_paths");
            field.setAccessible(true);
            if (field != null) {
                field.set(System.class.getClassLoader(), null);
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isShareNativeInitialized = true;
    }

    private String dealExtensionMode(String string) {
        WebBrowserUtil.trace("check if loaded in extension mode");
        String string2 = string + "/" + "jdic_native.jar";
        String string3 = string + "/" + "jdic_crossplatform.jar";
        if (this.extractJarFile(string3, string + "/jdic_crossplatform")) {
            WebBrowserUtil.trace("loaded in extension mode with cross platform format");
            return string + "/jdic_crossplatform";
        }
        if (this.extractJarFile(string2, string + "/jdic_native")) {
            WebBrowserUtil.trace("loaded in extension mode with os specific format");
            return string + "/jdic_native";
        }
        return string;
    }

    private boolean extractJarFile(String string, String string2) {
        WebBrowserUtil.trace(" jar path to verify" + string);
        if (new File(string).exists()) {
            try {
                JarFile jarFile = new JarFile(string);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory()) continue;
                    String string3 = jarEntry.getName();
                    WebBrowserUtil.trace(" dealing with " + string3);
                    File file = new File(string2, string3);
                    if (file.exists()) continue;
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    WebBrowserUtil.copyIsToOs(inputStream, fileOutputStream);
                }
            }
            catch (Exception exception) {
                WebBrowserUtil.error(exception.getMessage());
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private String dealCrossPlatformVersion(String string) throws MalformedURLException, JdicInitException {
        String string2 = string + File.separator + JdicManager.getPlatform();
        File file = new File(string2 + File.separator + "jdic_stub.jar");
        if (!file.exists()) {
            return string;
        }
        String string3 = string2 + File.separator + JdicManager.getArchitecture();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            String string4 = "We detect that you are not using java.net.URLClassLoader for cross platform versoin,you have to set jdic_stub.jar manually!";
            WebBrowserUtil.error(string4);
            return string3;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, file.toURL());
            return string3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new JdicInitException("Error, could not add URL to system classloader");
        }
    }

    public String getBinaryPath() {
        System.out.print("native lib path " + this.nativeLibPath);
        return this.nativeLibPath;
    }

    private String caculateNativeLibPathBySunJWS() throws IOException, JdicInitException {
        String string = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof JNLPClassLoader)) {
            throw new JdicInitException("Unexpected ClassLoader for webstart, only com.sun.jnlp.JNLPClassLoader is supported.");
        }
        JNLPClassLoader jNLPClassLoader = (JNLPClassLoader)classLoader;
        String string2 = jNLPClassLoader.findLibrary("jdic");
        string = new File(string2).getParentFile().getCanonicalPath();
        WebBrowserUtil.trace("running path " + this.nativeLibPath);
        this.isShareNativeInitialized = true;
        return string;
    }

    private static String getPlatform() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "windows";
        }
        return JdicManager.canonical(string);
    }

    private static String getArchitecture() {
        String string = System.getProperty("os.arch");
        if (string.endsWith("86")) {
            return "x86";
        }
        return JdicManager.canonical(string);
    }

    private static String canonical(String string) {
        WebBrowserUtil.trace("value:" + string);
        WebBrowserUtil.trace("canonical:" + string.toLowerCase().replaceAll("[\\\\/ ]", "_"));
        return string.toLowerCase().replaceAll("[\\\\/ ]", "_");
    }
}

