/*
 * 
 * HIIT Timer - A simple timer for high intensity trainings
 Copyright (C) 2015 Lorenzo Chiovini

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.hiittimer.database.generated;

import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table ROUND.
*/
public class RoundDao extends AbstractDao<Round, Long> {

    public static final String TABLENAME = "ROUND";

    /**
     * Properties of entity Round.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Number = new Property(1, Integer.class, "number", false, "NUMBER");
        public final static Property WorkInSeconds = new Property(2, int.class, "workInSeconds", false, "WORK_IN_SECONDS");
        public final static Property RestInSeconds = new Property(3, int.class, "restInSeconds", false, "REST_IN_SECONDS");
        public final static Property TrainingPlanId = new Property(4, long.class, "trainingPlanId", false, "TRAINING_PLAN_ID");
    };

    private Query<Round> trainingPlan_RoundsQuery;

    public RoundDao(DaoConfig config) {
        super(config);
    }
    
    public RoundDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'ROUND' (" + //
                "'_id' INTEGER PRIMARY KEY ASC AUTOINCREMENT ," + // 0: id
                "'NUMBER' INTEGER," + // 1: number
                "'WORK_IN_SECONDS' INTEGER NOT NULL ," + // 2: workInSeconds
                "'REST_IN_SECONDS' INTEGER NOT NULL ," + // 3: restInSeconds
                "'TRAINING_PLAN_ID' INTEGER NOT NULL );"); // 4: trainingPlanId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'ROUND'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Round entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Integer number = entity.getNumber();
        if (number != null) {
            stmt.bindLong(2, number);
        }
        stmt.bindLong(3, entity.getWorkInSeconds());
        stmt.bindLong(4, entity.getRestInSeconds());
        stmt.bindLong(5, entity.getTrainingPlanId());
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Round readEntity(Cursor cursor, int offset) {
        Round entity = new Round( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1), // number
            cursor.getInt(offset + 2), // workInSeconds
            cursor.getInt(offset + 3), // restInSeconds
            cursor.getLong(offset + 4) // trainingPlanId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Round entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setNumber(cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1));
        entity.setWorkInSeconds(cursor.getInt(offset + 2));
        entity.setRestInSeconds(cursor.getInt(offset + 3));
        entity.setTrainingPlanId(cursor.getLong(offset + 4));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Round entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Round entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "rounds" to-many relationship of TrainingPlan. */
    public List<Round> _queryTrainingPlan_Rounds(long trainingPlanId) {
        synchronized (this) {
            if (trainingPlan_RoundsQuery == null) {
                QueryBuilder<Round> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.TrainingPlanId.eq(null));
                queryBuilder.orderRaw("NUMBER ASC");
                trainingPlan_RoundsQuery = queryBuilder.build();
            }
        }
        Query<Round> query = trainingPlan_RoundsQuery.forCurrentThread();
        query.setParameter(0, trainingPlanId);
        return query.list();
    }

}
