/*
 * 
 * HIIT Timer - A simple timer for high intensity trainings
 Copyright (C) 2015 Lorenzo Chiovini

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.hiittimer.database.generated;

import java.util.List;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT. Enable "keep" sections if you want to edit. 
/**
 * Entity mapped to table TRAINING_PLAN.
 */
public class TrainingPlan {

    private Long id;
    /** Not-null value. */
    private String name;
    private int getReadyTimeInSeconds;

    /** Used to resolve relations */
    private transient DaoSession daoSession;

    /** Used for active entity operations. */
    private transient TrainingPlanDao myDao;

    private List<Round> rounds;

    public TrainingPlan() {
    }

    public TrainingPlan(Long id) {
        this.id = id;
    }

    public TrainingPlan(Long id, String name, int getReadyTimeInSeconds) {
        this.id = id;
        this.name = name;
        this.getReadyTimeInSeconds = getReadyTimeInSeconds;
    }

    /** called by internal mechanisms, do not call yourself. */
    public void __setDaoSession(DaoSession daoSession) {
        this.daoSession = daoSession;
        myDao = daoSession != null ? daoSession.getTrainingPlanDao() : null;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /** Not-null value. */
    public String getName() {
        return name;
    }

    /** Not-null value; ensure this value is available before it is saved to the database. */
    public void setName(String name) {
        this.name = name;
    }

    public int getGetReadyTimeInSeconds() {
        return getReadyTimeInSeconds;
    }

    public void setGetReadyTimeInSeconds(int getReadyTimeInSeconds) {
        this.getReadyTimeInSeconds = getReadyTimeInSeconds;
    }

    /** To-many relationship, resolved on first access (and after reset). Changes to to-many relations are not persisted, make changes to the target entity. */
    public List<Round> getRounds() {
        if (rounds == null) {
            if (daoSession == null) {
                throw new DaoException("Entity is detached from DAO context");
            }
            RoundDao targetDao = daoSession.getRoundDao();
            List<Round> roundsNew = targetDao._queryTrainingPlan_Rounds(id);
            synchronized (this) {
                if(rounds == null) {
                    rounds = roundsNew;
                }
            }
        }
        return rounds;
    }

    /** Resets a to-many relationship, making the next get call to query for a fresh result. */
    public synchronized void resetRounds() {
        rounds = null;
    }

    /** Convenient call for {@link AbstractDao#delete(Object)}. Entity must attached to an entity context. */
    public void delete() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.delete(this);
    }

    /** Convenient call for {@link AbstractDao#update(Object)}. Entity must attached to an entity context. */
    public void update() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.update(this);
    }

    /** Convenient call for {@link AbstractDao#refresh(Object)}. Entity must attached to an entity context. */
    public void refresh() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.refresh(this);
    }

}
