/*
 * 
 * HIIT Timer - A simple timer for high intensity trainings
 Copyright (C) 2015 Lorenzo Chiovini

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.hiittimer.database.generated;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/**
 * DAO for table TRAINING_PLAN.
 */
public class TrainingPlanDao extends AbstractDao<TrainingPlan, Long> {

	public static final String TABLENAME = "TRAINING_PLAN";

	/**
	 * Properties of entity TrainingPlan.<br/>
	 * Can be used for QueryBuilder and for referencing column names.
	 */
	public static class Properties {
		public final static Property Id = new Property(0, Long.class, "id", true, "_id");
		public final static Property Name = new Property(1, String.class, "name", false, "NAME");
		public final static Property GetReadyTimeInSeconds = new Property(2, int.class, "getReadyTimeInSeconds", false,
				"GET_READY_TIME_IN_SECONDS");
	};

	private DaoSession daoSession;

	public TrainingPlanDao(DaoConfig config) {
		super(config);
	}

	public TrainingPlanDao(DaoConfig config, DaoSession daoSession) {
		super(config, daoSession);
		this.daoSession = daoSession;
	}

	/** Creates the underlying database table. */
	public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
		String constraint = ifNotExists ? "IF NOT EXISTS " : "";
		db.execSQL("CREATE TABLE " + constraint + "'TRAINING_PLAN' (" + //
				"'_id' INTEGER PRIMARY KEY ASC AUTOINCREMENT ," + // 0: id
				"'NAME' TEXT NOT NULL ," + // 1: name
				"'GET_READY_TIME_IN_SECONDS' INTEGER NOT NULL );"); // 2:
																	// getReadyTimeInSeconds
	}

	/** Drops the underlying database table. */
	public static void dropTable(SQLiteDatabase db, boolean ifExists) {
		String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'TRAINING_PLAN'";
		db.execSQL(sql);
	}

	/** @inheritdoc */
	@Override
	protected void bindValues(SQLiteStatement stmt, TrainingPlan entity) {
		stmt.clearBindings();

		Long id = entity.getId();
		if (id != null) {
			stmt.bindLong(1, id);
		}
		stmt.bindString(2, entity.getName());
		stmt.bindLong(3, entity.getGetReadyTimeInSeconds());
	}

	@Override
	protected void attachEntity(TrainingPlan entity) {
		super.attachEntity(entity);
		entity.__setDaoSession(daoSession);
	}

	/** @inheritdoc */
	@Override
	public Long readKey(Cursor cursor, int offset) {
		return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
	}

	/** @inheritdoc */
	@Override
	public TrainingPlan readEntity(Cursor cursor, int offset) {
		TrainingPlan entity = new TrainingPlan( //
				cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
				cursor.getString(offset + 1), // name
				cursor.getInt(offset + 2) // getReadyTimeInSeconds
		);
		return entity;
	}

	/** @inheritdoc */
	@Override
	public void readEntity(Cursor cursor, TrainingPlan entity, int offset) {
		entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
		entity.setName(cursor.getString(offset + 1));
		entity.setGetReadyTimeInSeconds(cursor.getInt(offset + 2));
	}

	/** @inheritdoc */
	@Override
	protected Long updateKeyAfterInsert(TrainingPlan entity, long rowId) {
		entity.setId(rowId);
		return rowId;
	}

	/** @inheritdoc */
	@Override
	public Long getKey(TrainingPlan entity) {
		if (entity != null) {
			return entity.getId();
		} else {
			return null;
		}
	}

	/** @inheritdoc */
	@Override
	protected boolean isEntityUpdateable() {
		return true;
	}

}
