/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.dialogs;

import java.io.IOException;

import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.ActionBar;

import android.os.Bundle;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.widget.TextView;

import org.inventati.massimol.liberovocab.Config;
import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.helpers.RawUtils;

public class AboutDialog extends AppCompatActivity
{
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.dialog_about);

		// This activity has an ActionBar:
		ActionBar actionBar = getSupportActionBar();
		actionBar.setHomeButtonEnabled(true);

		// In order to set the title in the ActionBar:
		actionBar.setTitle(R.string.menu_about_app);

		String txt = "";
		try
		{
			txt = RawUtils.readText(getResources(), R.raw.about);
		}
		catch (IOException e)
		{
			e.printStackTrace();
			finish();
			return;
		}

		// The text for version:
		TextView tv = (TextView) findViewById(R.id.text_version);
		tv.setText(String.format("%s %s (%d)", getResources().getString(R.string.version), Config.getVersionName(), Config.getVersionCode()));

		// The text for about:
		tv = (TextView) findViewById(R.id.text_about);
		tv.setText(Html.fromHtml(txt));
		tv.setMovementMethod(LinkMovementMethod.getInstance());
	}
}