/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.dialogs;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import org.inventati.massimol.liberovocab.Config;
import org.inventati.massimol.liberovocab.R;

import java.io.File;

public class ChoiceOtherBaseFolderForAudioFilesDialog extends FileOpenDialog
{
	/**
	 * Initialize choice base folder for audio files dialog.
	 */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	@Override
	public void onCreateThis() {
		setContentView(R.layout.dialog_file_copy);

		TextView labelView = (TextView) findViewById(R.id.label);
		labelView.setText(R.string.label_base_folder_for_audio_files);

		// The button Cancel:
		Button buttonCancel = (Button) findViewById(R.id.button_cancel);
		buttonCancel.setText(R.string.button_cancel);
		buttonCancel.setOnClickListener(new View.OnClickListener()
									   {
										   @Override
										   public void onClick(View v)
										   {
											   finish();
										   }
									   }
		);

		// The button Select:
		Button buttonSelect = (Button) findViewById(R.id.button_ok);
		buttonSelect.setText(R.string.button_select);
		buttonSelect.setOnClickListener(new View.OnClickListener()
									   {
										   @Override
										   public void onClick(View v)
										   {
											   setBaseFolderIntoPreference();
											   finish();
										   }
									   }
		);
	}

	// Set the chosen base folder into the preferences:
	private void setBaseFolderIntoPreference()
	{
		String baseFolder = (String) mTxtPath.getText();

		Config.setBaseDirectoryForAudioFilesValue(baseFolder);
		Config.setBaseDirectoryForAudioFilesOtherPath(baseFolder);
	}

	// For this Action no kvtml files must be showed, only directories:
	@Override
	void updateListForKvtmlFiles(DialogEntry entry)
	{
	}

	@Override
	protected String getLastPathPrefName()
	{
		return "file_browser_default_dir";
	}
}