/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.dialogs;

import java.io.File;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import org.inventati.massimol.liberovocab.Config;
import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.helpers.AssetsUtils;

public class FileCopyDialog extends FileOpenDialog
{
	/**
	 * Initialize File Copy dialog.
	 */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	@Override
	public void onCreateThis() {
		setContentView(R.layout.dialog_file_copy);

		TextView labelView = (TextView) findViewById(R.id.label);
		labelView.setText(R.string.label_copy_kvtml_files);

		Button buttonCancel = (Button) findViewById(R.id.button_cancel);
		buttonCancel.setText(R.string.button_cancel);
		buttonCancel.setOnClickListener(new View.OnClickListener()
									   {
										   @Override
										   public void onClick(View v)
										   {
											   finish();
										   }
									   }
		);

		Button buttonCopy = (Button) findViewById(R.id.button_ok);
		buttonCopy.setText(R.string.button_copy);
		buttonCopy.setOnClickListener(new View.OnClickListener()
									   {
										   @Override
										   public void onClick(View v)
										   {
											   copyKvtmlFiles();
											   finish();
										   }
									   }
		);
	}

	// For this Action no kvtml files must be showed, only directories:
	@Override
	void updateListForKvtmlFiles(DialogEntry entry)
	{
	}

	private void copyKvtmlFiles()
	{
		// The Kvtml destination sub-directory into the directory selected by
		// the user:
		File kvtmlDestinationDir = new File(mTxtPath.getText() + "/" + Config.KVTML_ASSET_DIRECTORY + "-from-Libero-Vocab");

		// The original files are copied, eventually recursively, into the destination directory:
		Boolean wasCopyOK = AssetsUtils.copyFromAssetsToFolderRecursively(FileCopyDialog.this,
					                                                  Config.KVTML_ASSET_DIRECTORY,
					                                                  kvtmlDestinationDir);

		// Message about the outcome of the copy procedure:
		if (wasCopyOK)
			Toast.makeText(FileCopyDialog.this, R.string.success_copy_kvtml_files, Toast.LENGTH_LONG).show();
		else
			Toast.makeText(FileCopyDialog.this, R.string.error_copy_kvtml_files, Toast.LENGTH_LONG).show();
	}

	@Override
	protected String getLastPathPrefName()
	{
		return "file_browser_default_dir";
	}
}