/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.models;

import android.content.ContentValues;
import android.database.Cursor;


public class FileModel extends BaseModel
{
	public static final String[] fields = new String[] { "_id", "name", "opened" };
	
	public static final String CREATE_STATEMENT = "CREATE TABLE files (_id INTEGER PRIMARY KEY, name TEXT, opened NUMERIC)";
	
	private String mName;
	private int mOpened;
	
	public FileModel(long id, String name, int opened)
	{
		super(id);
		setName(name);
		setOpened(opened);
	}
	
	public String getName()
	{
		return mName;
	}
	
	public void setName(String name)
	{
		mName = name;
	}
	
	public int getOpened()
	{
		return mOpened;
	}
	
	public void setOpened(int opened)
	{
		mOpened = opened;
	}
	
	@Override
	public ContentValues getValues(boolean includeId)
	{
		ContentValues values = super.getValues(includeId);
		values.put("name", getName());
		values.put("opened", getName());
		return values;
	}
	
	@Override
	public FileModel populate(Cursor data, boolean idIncluded)
	{
		super.populate(data, idIncluded);
		
		if (data == null)
			return null;
		
		int start = 1;
		if (idIncluded)
		{
			setId(data.getLong(0));
			start = 0;
		}
		
		setName(data.getString(1 - start));
		setOpened(data.getInt(2 - start));
		return this;
	}
}
