/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;

import org.inventati.massimol.liberovocab.kvtml.Kvtml;

public final class Question
{
	private ArrayList<Kvtml.Entry> mQuestionEntries = null;
	private Kvtml.Entry mSolution = null;
	private int mSolutionIndex = -1;

	public Question(HashMap<String, Kvtml.Entry> entries, Kvtml.Entry solution, Random rnd)
	{
		initialize(entries, solution, rnd);
	}

	public Question(HashMap<String, Kvtml.Entry> entries, Kvtml.Entry solution)
	{
		Random rnd = new Random(System.nanoTime() * Double.doubleToLongBits(Math.random()));
		initialize(entries, solution, rnd);
	}

	private void initialize(HashMap<String, Kvtml.Entry> entries, Kvtml.Entry solution, Random rnd)
	{
		mQuestionEntries = new ArrayList<Kvtml.Entry>();
		mQuestionEntries.addAll(entries.values());
		if (rnd != null)
			Collections.shuffle(mQuestionEntries, rnd);
		mSolution = solution;
		mSolutionIndex = mQuestionEntries.indexOf(solution);
	}

	public ArrayList<Kvtml.Entry> getQuestionEntries()
	{
		return mQuestionEntries;
	}

	public Kvtml.Entry getSolution()
	{
		return mSolution;
	}

	public String getQuestionEntry(int index)
	{
		return mQuestionEntries.get(index).id;
	}

	/**
	 * Index of the solution within the question entries array.
	 *
	 * @return
	 */
	public int getSolutionIndex()
	{
		return mSolutionIndex;
	}

	public String getSolutionEntryId()
	{
		return mSolution.id;
	}
}