/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.adapters;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.dialogs.RecentFilesDialog.RecentItem;

/**
 * A simple Adapter for dealing with an array of filenames.
 *
 * @author Kiripolszky Károly <karcsi@ekezet.com>
 * @see <a href="http://www.youtube.com/watch?v=wDBM6wVEO70">Google I/O 2010 -
 *      The world of ListView</a>
 */
public class RecentFilesAdapter extends ArrayAdapter<RecentItem>
{
	/**
	 * Static helper class for caching views.
	 *
	 * @author Kiripolszky Károly <karcsi@ekezet.com>
	 */
	private static class ViewHolder
	{
		public TextView text;
		public TextView text2;
	}

	private int mViewResource;

	/**
	 * Frequently used static handle for the layout inflater service.
	 */
	private static LayoutInflater sInflater;

	/**
	 * Overridden ArrayAdapter constructor.
	 */
	public RecentFilesAdapter(Context context, int textViewResourceId)
	{
		super(context, textViewResourceId);
		// get and store a handle for the layout inflater
		sInflater = (LayoutInflater) context
			.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		mViewResource = textViewResourceId;
	}

	/**
	 * Returns the proper view to display a filename.
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent)
	{
		// prepare view cache
		ViewHolder holder;
		// view cache verification...
		if (convertView == null)
		{
			// ...inflate new layout resource
			convertView = sInflater.inflate(mViewResource, null);
			holder = new ViewHolder();
			holder.text = (TextView) convertView.findViewById(R.id.rowtext);
			holder.text.setTextColor(Color.WHITE);
			holder.text2 = (TextView) convertView.findViewById(R.id.rowtext2);
			// cache layout data as view tag
			convertView.setTag(holder);
		} else
			// ...use cached resource
			holder = (ViewHolder) convertView.getTag();

		// format list item (FIXME!)
		RecentItem entry = getItem(position);
		holder.text.setText(entry.getName());
		holder.text2.setText(entry.getDisplayPath());
		// return item view
		return convertView;
	}
}
