/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.dialogs;

import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.ActionBar;

import android.os.Bundle;
import android.webkit.WebView;
import android.widget.TextView;

import org.inventati.massimol.liberovocab.Config;
import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.helpers.AssetsUtils;

import java.io.IOException;

public class ManualDialog extends AppCompatActivity
{
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.dialog_manual);

		// This activity has an ActionBar:
		ActionBar actionBar = getSupportActionBar();
		actionBar.setHomeButtonEnabled(true);

		// In order to set the title in the ActionBar:
		actionBar.setTitle(R.string.menu_manual_app);

		// The text for version:
		TextView tv = (TextView) findViewById(R.id.text_version);
		tv.setText(String.format("%s %s (%d)", getResources().getString(R.string.version), Config.getVersionName(), Config.getVersionCode()));

		// Prepare the localized name of the manual in the assets (for example: manual-en.html):
		String asset_name = "manual-" + getResources().getString(R.string.lang_for_assets) + ".html";

		// The Html text for the manual:
		String htmlText = "";
		try
		{
			htmlText = AssetsUtils.readText(ManualDialog.this, asset_name);
		}
		catch (IOException e)
		{
			e.printStackTrace();
			System.err.println("### ERROR: IOException in AssetsUtils.readText() ###");
		}

		// We substitute a proper template sub-string into the HTML text in order to set
		// the properties of the BODY tag.
		//
		// It seems that the color specification could not be in the form with the alpha channel
		// pair of chars appended, when used in HTML tags. As a consequence, we must consider
		// only the last six chars part (RRGGBB and NOT AARRGGBB):
		String sBgcolor = String.format("%X", ContextCompat.getColor(ManualDialog.this, R.color.html_bgcolor));
		sBgcolor = sBgcolor.substring(2);

		String sText = String.format("%X", ContextCompat.getColor(ManualDialog.this, R.color.html_text));
		sText = sText.substring(2);

		String sLink = String.format("%X", ContextCompat.getColor(ManualDialog.this, R.color.html_link));
		sLink = sLink.substring(2);

		String sAlink = String.format("%X", ContextCompat.getColor(ManualDialog.this, R.color.html_alink));
		sAlink = sAlink.substring(2);

		String sVlink = String.format("%X", ContextCompat.getColor(ManualDialog.this, R.color.html_vlink));
		sVlink = sVlink.substring(2);

		// Now we are ready to substitute the template sub-string into the HTML text:
		String templateSubstitute = String.format("bgcolor=\"#%s\" text=\"#%s\" link=\"#%s\" alink=\"#%s\" vlink=\"#%s\"",
												  sBgcolor,
												  sText,
												  sLink,
												  sAlink,
												  sVlink
		);
		htmlText = htmlText.replaceFirst("#### template for body properties ####", templateSubstitute);

		// The WebView object:
		WebView wv = (WebView) findViewById(R.id.web_text_manual);

		//wv.loadUrl("file:///android_asset/" + asset_name);
		//wv.loadData(htmlText, "text/html", "utf-8");
		wv.loadDataWithBaseURL(null, htmlText, "text/html", "utf-8", null);
	}
}