/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019, 2020  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.widgets;

import android.app.AlertDialog.Builder;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.preference.ListPreference;
import android.util.AttributeSet;

import org.inventati.massimol.liberovocab.Config;
import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.dialogs.ChoiceOtherBaseFolderForAudioFilesDialog;

public class AudioBaseFolderListPreference extends ListPreference
{
	public AudioBaseFolderListPreference(Context context, AttributeSet attrs)
	{
		super(context, attrs);
	}

	@Override
	protected void onPrepareDialogBuilder(Builder builder)
	{
		super.onPrepareDialogBuilder(builder);

		// Set the alternative path for the base folder for the audio file. This correspond to the
        // third element of the options array:
		getEntryValues()[2] = Config.getBaseDirectoryForAudioFilesOtherPath();
        getEntries()[2] = getContext().getResources().getString(R.string.pref_button_for_baseDirectoryForAudioFiles) + ":\n" + getEntryValues()[2];

        // Set the list of options:
        builder.setSingleChoiceItems(getEntries(),
									 findIndexOfValue(getValue()),
				                     new DialogInterface.OnClickListener()
										 {
											  public void onClick(DialogInterface dialog, int which)
											  {
											  	  String newValue = (String) getEntryValues()[which];

												  setValue(newValue);
												  callChangeListener(newValue);

												  dialog.cancel();
											  }
										 }
		);

		// Set the button for choosing an other folder:
		builder.setPositiveButton(R.string.button_other_folder,
								    new DialogInterface.OnClickListener()
										{
											@Override
											public void onClick(DialogInterface dialog, int id)
											{
												// Start the dialog for choice an alternative
												// base folder for the audio files:
												Intent intent = new Intent(getContext(), ChoiceOtherBaseFolderForAudioFilesDialog.class);
												getContext().startActivity(intent);

												dialog.cancel();
											}
										}
									);
	}
}