/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019-2021  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.activities;

import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.LinearLayout;

import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.helpers.Gradient;

import java.util.ArrayList;
import java.util.List;

public class BaseMenuActivity extends AppCompatActivity
{
	protected LinearLayout mMenuLayout = null;

	@Override
	public void onWindowFocusChanged(boolean hasFocus)
	{
		if (hasFocus)
			toggleMenuButtons();
	}

	protected void updateMenuColours()
	{
		if (mMenuLayout == null)
		{
			mMenuLayout = (LinearLayout) findViewById(R.id.menu_layout);
			// if onCreate() wasn't called yet
			if (mMenuLayout == null)
				return;
		}

		// update menu colours
		List<View> views = new ArrayList<>();
		View child;
		for (int i = 0, I = mMenuLayout.getChildCount(); i < I; i++)
		{
			child = mMenuLayout.getChildAt(i);
			if (child.getVisibility() == View.VISIBLE)
				views.add(child);
		}
		Gradient.colorize(views);
	}

	/**
	 * Show/hide menu buttons.
	 */
	protected void toggleMenuButtons()
	{
		updateMenuColours();
	}
}
