/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019-2021  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.activities.test_types;

import java.lang.NullPointerException;

import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;
import android.widget.TextView;

import org.inventati.massimol.liberovocab.Config;
import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.adapters.WordListAdapter;
import org.inventati.massimol.liberovocab.kvtml.Kvtml;

public class MultipleChoiceActivity extends TestActivity
{
	private static WordListAdapter sAdapter = null;

	/**
	 * Event that handles click over a View item.
	 */
	private final OnItemClickListener mOnItemClickListener = new OnItemClickListener()
	{
		@Override
		public void onItemClick(AdapterView<?> list, View item, int position, long id)
		{
			// The previous MediaPlayer object is released:
			if (mediaPlayer != null)
				mediaPlayer.release();

			// The TextView which was selected by user as the answer:
			final TextView tv = (TextView) item.findViewById(R.id.rowtext);

			// First we check if the answer was correct or wrong:
			if (position == mQuestion.getSolutionIndex())
			{
				// handles right answer, removing entry from the list of questions
				if (!correct(mQuestion.getSolution()))
					// no more unanswered questions left
					return;
				else
					tv.setBackgroundResource(R.color.right_answer);
			}
			else
			{
				// handles wrong answer, increase number of mistakes
				tv.setBackgroundResource(R.color.wrong_answer);
				mistake(mQuestion.getSolution());
			}

			list.invalidate();

			// After answer was checked, we wait a bit, change background color of the
			// rowtext and execute updateQuestion() to prepare the next question.
			try
			{
				// new thread for delaying the upcoming question
				new Thread(new Runnable()
					{
						@Override
						public void run()
						{
							// We wait a time egual to Config.questionDelay:
							try
							{
								Thread.sleep(Config.questionDelay);
							}
							catch (InterruptedException e)
							{
								e.printStackTrace();
							}

							// trigger UI update after the delay
							runOnUiThread(new Runnable()
								{
									@Override
									public void run()
									{
										tv.setBackgroundResource(R.color.window_background);
										updateQuestion();
									}
								}
							);
						}
					}
				).start();
			}
			catch (Exception e)
			{
				return;
			}
		}
	};

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		// create and bind the string adapter for the list view
		ListView list = (ListView) findViewById(R.id.list);

		list.setOnItemClickListener(mOnItemClickListener);

		sAdapter = new WordListAdapter(this, R.id.rowtext);
		list.setAdapter(sAdapter);

		mMaxItems = Config.choiceNumber;
		restart();
	}

	@Override
	protected void updateQuestion(boolean configChange)
	{
		super.updateQuestion(configChange);
		if (mQuestion == null)
		{
			finish();
			return;
		}

		// We prepare the new question. In order to archive this, we have to populate again
		// the list:
		sAdapter.clear();

		Kvtml.Entry entry = null;
		for (int i = 0, I = mQuestion.getQuestionEntries().size(); i < I; i++)
		{
			// TODO: this is a workaround. A better solution would be to create objects Kvtml, and
			//       obviously relative files, with all the fields always made explicit, also
			//       if empty.
			try
			{
				// The new Entry pull down from the group of Entry which must be exercised:
				entry = mQuestion.getQuestionEntries().get(i);

				// We add the translation of this Entry into the next element of the list:
				String text = entry.translations.get(Config.getAnswerLangId()).text;
				if (text.equals(""))
					sAdapter.add("- - -");
				else
					sAdapter.add(text);
			}
			catch (NullPointerException e)
			{
				e.printStackTrace();
				System.err.println("### ERROR: Exception in MultipleChoiceActivity ###");
				sAdapter.add("- - -");
			}
		}
	}

	@Override
	protected void loadContentView()
	{
		setContentView(R.layout.activity_multiple_choice);
	}
}