/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019-2021  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.activities.test_types;

import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;
import android.widget.Toast;

import org.inventati.massimol.liberovocab.Config;
import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.kvtml.Kvtml;

public class WritingActivity extends TestActivity
{
	private EditText mInput;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		mInput = (EditText) findViewById(R.id.edit_question);
		mInput.setOnEditorActionListener(
				new OnEditorActionListener()
						{
							@Override
							public boolean onEditorAction(TextView v, int actionId, KeyEvent event)
							{
								if (actionId == EditorInfo.IME_ACTION_DONE)
								{
									submit();
									return true;
								}

								return false;
							}
						}
		);

		Button btn = (Button) findViewById(R.id.button_go);
		btn.setOnClickListener(
				new OnClickListener()
					{
						@Override
						public void onClick(View v)
						{
							submit();
						}
					}
		);

		restart();
	}

    private void submit()
	{
		// The previous MediaPlayer object is released:
		if (mediaPlayer != null)
			mediaPlayer.release();

		String value = mInput.getEditableText().toString();
		Kvtml.Entry solution = mQuestion.getSolution();
		Kvtml.Translation mTranslation = solution.translations.get(Config.getAnswerLangId());

		// TODO: this is a workaround. A better solution would be to create objects Kvtml, and
		//       obviously relative files, with all the fields always made explicit, also
		//       whether empty.
		String right = mTranslation != null ? mTranslation.text : "- - -";

		String msg = "";
		if (mTranslation == null)
		{
			msg = getResources().getString(R.string.error_no_translation_for_entry);
			mistake(solution);
			updateQuestion();
		}
		else if (value.equals(right))
		{
			msg = getResources().getString(R.string.right_answer_message);

			// Only if there are other questions:
			if (correct(solution))
				updateQuestion();
		}
		else
		{
			msg = getResources().getString(R.string.error_answer_message);
			mistake(solution);
			updateQuestion();
		}

		Toast.makeText(WritingActivity.this, msg, Toast.LENGTH_SHORT).show();
	}

	@Override
	protected void loadContentView()
	{
		setContentView(R.layout.activity_writing);
	}

	@Override
	protected void updateQuestion(boolean configChanged)
	{
		super.updateQuestion(configChanged);
		mInput.setText("");
	}
}