/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019-2021  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.ActionBar;

import android.content.Intent;
import android.os.Bundle;
import android.text.Html;
import android.widget.TextView;

import org.inventati.massimol.liberovocab.R;
import org.inventati.massimol.liberovocab.helpers.AssetsUtils;

public class NewsDialog extends AppCompatActivity
{
	private int mLimit = 0;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.dialog_news);

		// This activity has an ActionBar:
		ActionBar actionBar = getSupportActionBar();
		actionBar.setHomeButtonEnabled(true);

		// In order to set the title in the ActionBar:
		actionBar.setTitle(R.string.menu_show_news);

		Intent i = getIntent();
		if (i != null)
			mLimit = i.getIntExtra("limit", mLimit);

		HashMap<String, String> messages = null;
		try
		{
			messages = getMessages();
		}
		catch (IOException e)
		{
			e.printStackTrace();
			finish();
			return;
		}

		List<String> versions = new ArrayList<String>();
		versions.addAll(messages.keySet());
		Collections.sort(versions);
		Collections.reverse(versions);

		if (mLimit != 0)
		{
			List<String> tmp = new ArrayList<String>();
			for (int n = 0, N = versions.size(); n < mLimit && n < N; n++)
				tmp.add(versions.get(n));
			versions = tmp;
		}

		String txt = "";
		String ver = "";
		for (int n = 0, N = versions.size(); n < N; n++)
		{
			ver = versions.get(n);
			txt += String.format("<h2>v%s<h2><p>%s</p>", ver, messages.get(ver));
		}

		TextView tv = (TextView) findViewById(R.id.text);
		tv.setText(Html.fromHtml(txt));
	}

	private HashMap<String, String> getMessages() throws IOException
	{
		HashMap<String, String> msgs = new HashMap<String, String>();

		// Prepare the localized name of the asset (for example manual-en.html):
		String asset_directory_name = "news-" + getResources().getString(R.string.lang_for_assets);

		String[] files = AssetsUtils.listFiles(this, asset_directory_name);
		for (int n = 0, N = files.length; n < N; n++)
			msgs.put(files[n].replace(".html", ""), AssetsUtils.readText(this, asset_directory_name + "/" + files[n]));
		return msgs;
	}
}
