/*
 * Libero Vocab
 *     An app for Android systems which allows to do practice with kvtml
 *     vocabulary files.
 *     This program is a fork of another program called "Vocab Drill" by:
 *       - Károly Kiripolszky <karcsi@ekezet.com>
 *       - Matthias Völlinger <matthias.voellinger@gmx.de>
 *
 *     Copyright (C) 2019-2021  Lo Iacono Massimo (massimol@inventati.org)
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.inventati.massimol.liberovocab.models;

import android.content.ContentValues;
import android.database.Cursor;


public class BaseModel
{
	public static final String[] fields = new String[] { "_id" };
	
	private long mId = -1;
	
	public BaseModel()
	{
		
	}
	
	public BaseModel(long id)
	{
		setId(id);
	}
	
	public long getId()
	{
		return mId;
	}
	
	public void setId(long id)
	{
		mId = id;
	}
	
	public ContentValues getValues()
	{
		return getValues(false);
	}
	
	/**
	 * Returns the data associated with the model as a ContentValues object.
	 * 
	 * @param includeId
	 * @return
	 */
	public ContentValues getValues(boolean includeId)
	{
		ContentValues values = new ContentValues();
		if (!includeId)
			return values;
		values.put("_id", getId());
		return values;
	}
	
	public BaseModel populate(Cursor data)
	{
		return populate(data, true);
	}
	
	/**
	 * Populates the model with data.
	 * 
	 * @param data The data to be set.
	 * @param idIncluded True when the model already has an id.
	 * @return
	 */
	public BaseModel populate(Cursor data, boolean idIncluded)
	{
		if (data == null)
			return null;
		
		if (idIncluded)
			setId(data.getLong(0));
		
		return this;
	}
}
