/*
   Copyright 2010 Johan Hilding

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package org.johanhil.flygtider.provider;

import java.util.List;

import org.johanhil.flygtider.provider.impl.LFVFlightSearch;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.util.Log;

    public class FetchFlights extends AsyncTask<Object, Void, List<FlightInfo>>
    {
    	private ProgressDialog dialog;    	
    	/**
    	 * Tells the task to include a keyword in the search.
    	 * This makes the list display in another way and the keyword that's
    	 * passed to execute() gets searched for at the airports web site.
		*/
    	private boolean useKeyword;
    	
    	private Activity activity;
    	private ResultHandler resultHandler;
    	private int progressTextId;
    	
    	public FetchFlights(Activity activity, int progressTextId, ResultHandler resultHandler)
    	{
    		this.activity = activity;
    		this.progressTextId = progressTextId;
    		this.resultHandler = resultHandler;
    	}


    	/**
    	 * Displays a progress bar and enables canceling of the flight fetching.
    	 */
    	protected void onPreExecute()
    	{
    		CancelHandler cancelHandler = new CancelHandler(activity, this);
    		dialog = ProgressDialog.show(activity, 
    									 "", 
    									 activity.getText(progressTextId), 
    									 true,
    									 true,
    									 cancelHandler
    		);
    	}
    	
    	protected List<FlightInfo> doInBackground(Object... params)
    	{
    		String airport = (String) params[0];
    		Boolean arriving = (Boolean) params[1];
    		String keyword = null;
    		Integer page = 1;
    		
    		if (params.length == 3)
    		{
    			keyword = (String) params[2];
    		}
    		
    		if (params.length == 4)
    		{
    		     page = (Integer) params[4];
    		}

    		FlightSearch flightSearcher = new LFVFlightSearch(activity);
    		
    		if (keyword != null)
    		{
    			return flightSearcher.getFlights(airport, arriving, keyword, page);
    		}
    		else
    		{
    			return flightSearcher.getFlights(airport, arriving, page);
    		}
    	}
    	
    	protected void onPostExecute(List<FlightInfo> result)
    	{
    		dialog.dismiss();
    		resultHandler.handleResult(result);
    	}
    	
    	public interface ResultHandler
    	{
    		void handleResult(List<FlightInfo> result); 
    	}
    }   
    
    class CancelHandler implements DialogInterface.OnCancelListener
    {
    	Activity activity;
    	@SuppressWarnings("unchecked")
        AsyncTask task;
    	
    	@SuppressWarnings("unchecked")
        public CancelHandler(Activity activity, AsyncTask task)
    	{
    		this.activity = activity;
    		this.task = task;
    	}
    	
    	public void onCancel(DialogInterface dialog)
		{
    		// Don't allow double canceling
			if (task != null && ! task.isCancelled())
	        {
	        	Log.e("CancelHandler", "canceling!");
	        	task.cancel(false);
	        	activity.finish();
	        }
		}
    }