/*
   Copyright 2010 Johan Hilding

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */


package org.johanhil.flygtider.provider;

import java.io.Serializable;

import android.util.Log;

/**
 * This is just a container for information for a specific flight. 
 */
public class FlightInfo implements Serializable {
	private static final long serialVersionUID = 3L;
	
	private String date;
	private String time;
	private String departingAirport;
	private String arrivingAirport;
	private String flightNr;
	private String terminal;
	private String airline;
	private String notes;
	private boolean arriving;
	
	public String getAirline() {
		return airline;
	}
	public String getNotes() {
		return notes;
	}
	public String getDate() {
		return date;
	}
	public String getTime() {
		return time;
	}
	public String getFlightNr() {
		return flightNr;
	}
	public String getTerminal() {
		return terminal;
	}
	public boolean isArriving() {
		return arriving;
	}
	/**
	 * Returns the airport that is used to search for the flight. 
	 */
	public String getIdentifyingAirport()
	{
	    if (isArriving())
	        return arrivingAirport;
	    else
	        return departingAirport;
	}
	public String getDepartingAirport() {
		return departingAirport;
	}
	public String getArrivingAirport() {
		return arrivingAirport;
	}
	public void setDepartingAirport(String departingAirport) {
		this.departingAirport = departingAirport;
	}
	public void setArrivingAirport(String arrivingAirport) {
		this.arrivingAirport = arrivingAirport;
	}
	public void setArriving(boolean arriving) {
		this.arriving = arriving;
	}
	public void setDate(String date) {
		this.date = date;
	}
	public void setTime(String time) {
		this.time = time;
	}
	public void setFlightNr(String flightNr) {
	    if (flightNr.contains(","))
	        this.flightNr = flightNr.substring(0, flightNr.indexOf(','));
	    else
	        this.flightNr = flightNr;
	}
	public void setAirline(String airline) {
		this.airline = airline;
	}
	public void setNotes(String notes) {
		this.notes = notes;
	}
	public void setTerminal(String terminal) {
		this.terminal = terminal;
	}
	public void setCompany(String company) {
		this.airline = company;
	}
	
	public boolean equals(Object o)
	{
		if (! (o instanceof FlightInfo))
			return false;
		
		return (hashCode() == o.hashCode());		
	}
	
	// TODO lol. fix this.
	public int hashCode()
	{
		return ("" + flightNr + date + arrivingAirport).hashCode();
	}
}
