/*
   Copyright 2010 Johan Hilding

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package org.johanhil.flygtider.provider;

import java.util.List;

/**
 * The FlightSearch interface provides methods to 
 * get flights from an airport, with or without a search string and a page offset.
 */
public interface FlightSearch {
	public List<FlightInfo> getFlights(String airport, boolean arriving);
	public List<FlightInfo> getFlights(String airport, boolean arriving, int page);
	public List<FlightInfo> getFlights(String airport, boolean arriving, String searchString);
	public List<FlightInfo> getFlights(String airport, boolean arriving, String searchString, int page);
	public FlightInfo getFlight(String airport, boolean arriving, String flightnr, String date);
}
