/*
   Copyright 2010 Johan Hilding

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package org.johanhil.flygtider.provider.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import org.johanhil.flygtider.provider.AirportDataProvider;
import org.johanhil.flygtider.provider.FlightInfo;
import org.johanhil.flygtider.provider.FlightSearch;

import android.content.Context;
import android.net.Uri;

public class LFVFlightSearch implements FlightSearch {
	
	private Context context;
	
	public LFVFlightSearch(Context c)
	{
		this.context = c;
	}

	@Override
	public List<FlightInfo> getFlights(String airport, boolean arriving) {
		return getFlights(airport, arriving, "", 1);
	}
	
	@Override
	public List<FlightInfo> getFlights(String airport, boolean arriving, int page) {
	    return getFlights(airport, arriving, "", page);
	}
	

    @Override
    public List<FlightInfo> getFlights(String airport, boolean arriving,
            String searchString)
    {
        return getFlights(airport, arriving, searchString, 1);
    }

	@Override
	public List<FlightInfo> getFlights(String airport, boolean arriving,
			String keyword, int page) {
        
        // find the url and parse LFV's website
        AirportDataProvider airportDataProvider = new StaticAirportDataProvider(context);
        StringBuilder airportUrlBuilder = new StringBuilder(airportDataProvider.getBaseUrl(airport));        
        URL airportUrl = null;
        
        if (arriving)
        	airportUrlBuilder.append("_ankomster");
        else
        	airportUrlBuilder.append("_avgangar");
        
        if (keyword != null && ! "".equals(keyword))
        {
        	airportUrlBuilder.append("?search=")
        					 .append(Uri.encode(keyword))
        					 .append("&type=all&date=none");
        }
        
        try
        {
            // TODO do this (the encoding of special chars) the correct way
        	airportUrl = new URL(airportUrlBuilder.toString().replaceAll(" ", "%20"));
        }
        catch (MalformedURLException mue)
        {
        	// should never happen... send back to the search activity?
        }
        
        return new LFVWebsiteParser(airportUrl).getFlights(airport, arriving);
	}
	
	/**
	 * Fetch a certain flight. Flights are identified by their flightnr + their
	 * date, afaik.
	 * TODO use the date (currently it is not used in the searching, just the filtering)
	 */
	public FlightInfo getFlight(String airport, boolean arriving,
			String flightnr, String date) {
		List<FlightInfo> flights = getFlights(airport, arriving, flightnr);
		
		for (FlightInfo flight : flights)
		{
			if (date.equals(flight.getDate()))
			{
				return flight;
			}
		}
		
		return null;
	}


}
