/*
   Copyright 2010 Johan Hilding

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package org.johanhil.flygtider.utils;

import android.text.format.Time;

public class ParseTime
{
    /**
     * Returns the time represented by the <tt>time</tt> String.
     * @param time A String formatted like "HH:MM"
     * @return A Time object representing the time, or null if the String could not be parsed.
     */
    public static Time parseHHMM(String time)
    {
        Time t = new Time();
        // if the format is not "HH:MM" we return null
        try
        {
            String hours = time.substring(0, 2);
            String minutes = time.substring(3);

            t.hour = Integer.parseInt(hours);
            t.minute = Integer.parseInt(minutes);
        } 
        catch (Exception e) // TODO is this nice enough? 
        {
            return null;
        }
        
        return t;
    }
}
