package org.katsarov.dofcalc;

import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.View;
import android.widget.TextView;
import android.widget.EditText;
import android.widget.Spinner;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.view.MenuItem;
import android.content.res.Resources;
import android.app.Dialog;
import android.content.SharedPreferences;

public class MainActivity extends Activity {
    private double[] apertureValues = {1.0, 1.1, 1.2, 1.4, 1.6, 1.8, 2.0, 2.2, 2.5, 2.8, 3.2, 3.5, 4.0, 4.5, 5.0, 5.6, 6.3, 7.1, 8.0, 9.0, 10.0, 11.0, 13.0, 14.0, 16.0, 18.0, 20.0, 22.0, 32.0};
    private double[] sensorValues = {0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.023, 0.030, 0.030, 0.030, 0.019, 0.030, 0.020, 0.020, 0.020, 0.020, 0.020, 0.015, 0.023, 0.030, 0.023, 0.039, 0.020, 0.030, 0.020, 0.020, 0.030, 0.020, 0.011, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.050, 0.020, 0.020, 0.020, 0.020, 0.020, 0.020, 0.020, 0.020, 0.018, 0.020, 0.018, 0.020, 0.020, 0.030, 0.020, 0.020, 0.020};
    private double[] focalLengthValues = {8.0, 10.0, 17.0, 20.0, 22.0, 24.0, 28.0, 35.0, 50.0, 70.0, 80.0, 100.0, 135.0, 150.0, 200.0, 210.0, 300.0, 350.0, 400.0, 600.0, 800.0};
    public static final String PREFS_NAME = "FoFcalcPrefs";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Spinner aperture = (Spinner) findViewById(R.id.aperture);
        Spinner sensor = (Spinner) findViewById(R.id.sensor);
        Spinner focalLength = (Spinner) findViewById(R.id.focalLength);
        SharedPreferences settings = getSharedPreferences(PREFS_NAME, 0);
        aperture.setSelection(settings.getInt("aperture",15));
        sensor.setSelection(settings.getInt("sensor",5));
        focalLength.setSelection(settings.getInt("focalLength",8));
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch(item.getItemId())
        {
            case R.id.aboutMenu:
               return showAbout(item);

            case R.id.close:
                return quitApp(item);
        }
        return true;
    }


    public boolean quitApp(MenuItem item) {
        this.onStop();
        System.exit(0);
        return true;
    }

    public boolean showAbout(MenuItem item) {
        Dialog about = new Dialog(this);
        about.setContentView(R.layout.about);
        about.setTitle(R.string.about);
        about.show();
        return true;
    }

    public void calculateDOF(View view) {
        Resources res = getResources();
        EditText editText = (EditText) findViewById(R.id.distance);
        String distance = editText.getText().toString();
        Spinner aperture = (Spinner) findViewById(R.id.aperture);
        Spinner sensor = (Spinner) findViewById(R.id.sensor);
        Spinner focalLength = (Spinner) findViewById(R.id.focalLength);
        double selectedAperture = apertureValues[aperture.getSelectedItemPosition()];
        double selectedSensor = sensorValues[sensor.getSelectedItemPosition()];
        double selectedFocalLength = focalLengthValues[focalLength.getSelectedItemPosition()];
        TextView nearText = (TextView) findViewById(R.id.near);
        TextView farText = (TextView) findViewById(R.id.far);
        TextView deltaText = (TextView) findViewById(R.id.delta);
        if (distance.equals("")) {
            new AlertDialog.Builder(this)
                .setTitle(R.string.error)
                .setMessage(R.string.pleaseEnter)
                .setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int which) {
                         // continue with delete
                    }
                }).show();
        } else {
            double dist = Double.valueOf(distance);
            dist = dist * 1000;
            double hyperFocal = (selectedFocalLength * selectedFocalLength) / (selectedAperture * selectedSensor);
            double near = (hyperFocal * dist) / (hyperFocal + (dist - selectedFocalLength));
            double far = (hyperFocal * dist) / (hyperFocal - (dist - selectedFocalLength));
            nearText.setText(String.valueOf(String.format("%.3f %s", near / 1000, res.getString(R.string.meters))));
            if (far < 0) {
                farText.setText(R.string.infinity);
            } else {
                farText.setText(String.valueOf(String.format("%.3f %s", far / 1000, res.getString(R.string.meters))));
            }
            double delta = far - near;
            if (delta < 0) {
                deltaText.setText(R.string.infinity);
            } else {
                    if (delta > 0 && delta/1000 < 0.001) {
                        deltaText.setText(R.string.lessThan1);
                    } else {
                        deltaText.setText(String.valueOf(String.format("%.3f %s", delta / 1000, res.getString(R.string.meters))));
                    }
            }

        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        SharedPreferences settings = getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        Spinner aperture = (Spinner) findViewById(R.id.aperture);
        Spinner sensor = (Spinner) findViewById(R.id.sensor);
        Spinner focalLength = (Spinner) findViewById(R.id.focalLength);
        editor.putInt("sensor", sensor.getSelectedItemPosition());
        editor.putInt("aperture", aperture.getSelectedItemPosition());
        editor.putInt("focalLength", focalLength.getSelectedItemPosition());
        editor.commit();
    }

}


