/*
 * Copyright 2014  Martin Klapetek <mklapetek@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "timezonesi18n.h"

#include <KLocalizedString>

TimezonesI18n::TimezonesI18n(QObject *parent) : QObject(parent), m_isInitialized(false) {}

QString TimezonesI18n::i18nCity(const QString &city)
{
    if (!m_isInitialized) {
        init();
    }
    return m_i18nCities.value(city);
}

QString TimezonesI18n::i18nContinents(const QString &continent)
{
    if (!m_isInitialized) {
        init();
    }
    return m_i18nContinents.value(continent);
}

QString TimezonesI18n::i18nCountry(QLocale::Country country)
{
    if (!m_isInitialized) {
        init();
    }
    return m_i18nCountries.value(country);
}

void TimezonesI18n::init()
{
    m_i18nCities = QHash<QString, QString>({ { QStringLiteral("Abidjan"), i18nc("This is a city associated with particular time zone", "Abidjan") },
                                             { QStringLiteral("Accra"), i18nc("This is a city associated with particular time zone", "Accra") },
                                             { QStringLiteral("Adak"), i18nc("This is a city associated with particular time zone", "Adak") },
                                             { QStringLiteral("Addis_Ababa"), i18nc("This is a city associated with particular time zone", "Addis Ababa") },
                                             { QStringLiteral("Adelaide"), i18nc("This is a city associated with particular time zone", "Adelaide") },
                                             { QStringLiteral("Aden"), i18nc("This is a city associated with particular time zone", "Aden") },
                                             { QStringLiteral("Algiers"), i18nc("This is a city associated with particular time zone", "Algiers") },
                                             { QStringLiteral("Almaty"), i18nc("This is a city associated with particular time zone", "Almaty") },
                                             { QStringLiteral("Amman"), i18nc("This is a city associated with particular time zone", "Amman") },
                                             { QStringLiteral("Amsterdam"), i18nc("This is a city associated with particular time zone", "Amsterdam") },
                                             { QStringLiteral("Anadyr"), i18nc("This is a city associated with particular time zone", "Anadyr") },
                                             { QStringLiteral("Anchorage"), i18nc("This is a city associated with particular time zone", "Anchorage") },
                                             { QStringLiteral("Andorra"), i18nc("This is a city associated with particular time zone", "Andorra") },
                                             { QStringLiteral("Anguilla"), i18nc("This is a city associated with particular time zone", "Anguilla") },
                                             { QStringLiteral("Antananarivo"), i18nc("This is a city associated with particular time zone", "Antananarivo") },
                                             { QStringLiteral("Antigua"), i18nc("This is a city associated with particular time zone", "Antigua") },
                                             { QStringLiteral("Apia"), i18nc("This is a city associated with particular time zone", "Apia") },
                                             { QStringLiteral("Aqtau"), i18nc("This is a city associated with particular time zone", "Aqtau") },
                                             { QStringLiteral("Aqtobe"), i18nc("This is a city associated with particular time zone", "Aqtobe") },
                                             { QStringLiteral("Araguaina"), i18nc("This is a city associated with particular time zone", "Araguaina") },
                                             { QStringLiteral("Aruba"), i18nc("This is a city associated with particular time zone", "Aruba") },
                                             { QStringLiteral("Ashgabat"), i18nc("This is a city associated with particular time zone", "Ashgabat") },
                                             { QStringLiteral("Asmara"), i18nc("This is a city associated with particular time zone", "Asmara") },
                                             { QStringLiteral("Asuncion"), i18nc("This is a city associated with particular time zone", "Asuncion") },
                                             { QStringLiteral("Athens"), i18nc("This is a city associated with particular time zone", "Athens") },
                                             { QStringLiteral("Atikokan"), i18nc("This is a city associated with particular time zone", "Atikokan") },
                                             { QStringLiteral("Auckland"), i18nc("This is a city associated with particular time zone", "Auckland") },
                                             { QStringLiteral("Azores"), i18nc("This is a city associated with particular time zone", "Azores") },
                                             { QStringLiteral("Baghdad"), i18nc("This is a city associated with particular time zone", "Baghdad") },
                                             { QStringLiteral("Bahia_Banderas"), i18nc("This is a city associated with particular time zone", "Bahia Banderas") },
                                             { QStringLiteral("Bahia"), i18nc("This is a city associated with particular time zone", "Bahia") },
                                             { QStringLiteral("Bahrain"), i18nc("This is a city associated with particular time zone", "Bahrain") },
                                             { QStringLiteral("Baku"), i18nc("This is a city associated with particular time zone", "Baku") },
                                             { QStringLiteral("Bamako"), i18nc("This is a city associated with particular time zone", "Bamako") },
                                             { QStringLiteral("Bangkok"), i18nc("This is a city associated with particular time zone", "Bangkok") },
                                             { QStringLiteral("Bangui"), i18nc("This is a city associated with particular time zone", "Bangui") },
                                             { QStringLiteral("Banjul"), i18nc("This is a city associated with particular time zone", "Banjul") },
                                             { QStringLiteral("Barbados"), i18nc("This is a city associated with particular time zone", "Barbados") },
                                             { QStringLiteral("Beirut"), i18nc("This is a city associated with particular time zone", "Beirut") },
                                             { QStringLiteral("Belem"), i18nc("This is a city associated with particular time zone", "Belem") },
                                             { QStringLiteral("Belgrade"), i18nc("This is a city associated with particular time zone", "Belgrade") },
                                             { QStringLiteral("Belize"), i18nc("This is a city associated with particular time zone", "Belize") },
                                             { QStringLiteral("Berlin"), i18nc("This is a city associated with particular time zone", "Berlin") },
                                             { QStringLiteral("Bermuda"), i18nc("This is a city associated with particular time zone", "Bermuda") },
                                             { QStringLiteral("Beulah"), i18nc("This is a city associated with particular time zone", "Beulah") },
                                             { QStringLiteral("Bishkek"), i18nc("This is a city associated with particular time zone", "Bishkek") },
                                             { QStringLiteral("Bissau"), i18nc("This is a city associated with particular time zone", "Bissau") },
                                             { QStringLiteral("Blanc-Sablon"), i18nc("This is a city associated with particular time zone", "Blanc-Sablon") },
                                             { QStringLiteral("Blantyre"), i18nc("This is a city associated with particular time zone", "Blantyre") },
                                             { QStringLiteral("Boa_Vista"), i18nc("This is a city associated with particular time zone", "Boa Vista") },
                                             { QStringLiteral("Bogota"), i18nc("This is a city associated with particular time zone", "Bogota") },
                                             { QStringLiteral("Boise"), i18nc("This is a city associated with particular time zone", "Boise") },
                                             { QStringLiteral("Bratislava"), i18nc("This is a city associated with particular time zone", "Bratislava") },
                                             { QStringLiteral("Brazzaville"), i18nc("This is a city associated with particular time zone", "Brazzaville") },
                                             { QStringLiteral("Brisbane"), i18nc("This is a city associated with particular time zone", "Brisbane") },
                                             { QStringLiteral("Broken_Hill"), i18nc("This is a city associated with particular time zone", "Broken Hill") },
                                             { QStringLiteral("Brunei"), i18nc("This is a city associated with particular time zone", "Brunei") },
                                             { QStringLiteral("Brussels"), i18nc("This is a city associated with particular time zone", "Brussels") },
                                             { QStringLiteral("Bucharest"), i18nc("This is a city associated with particular time zone", "Bucharest") },
                                             { QStringLiteral("Budapest"), i18nc("This is a city associated with particular time zone", "Budapest") },
                                             { QStringLiteral("Buenos_Aires"), i18nc("This is a city associated with particular time zone", "Buenos Aires") },
                                             { QStringLiteral("Bujumbura"), i18nc("This is a city associated with particular time zone", "Bujumbura") },
                                             { QStringLiteral("Busingen"), i18nc("This is a city associated with particular time zone", "Busingen") },
                                             { QStringLiteral("Cairo"), i18nc("This is a city associated with particular time zone", "Cairo") },
                                             { QStringLiteral("Cambridge_Bay"), i18nc("This is a city associated with particular time zone", "Cambridge Bay") },
                                             { QStringLiteral("Campo_Grande"), i18nc("This is a city associated with particular time zone", "Campo Grande") },
                                             { QStringLiteral("Canary"), i18nc("This is a city associated with particular time zone", "Canary") },
                                             { QStringLiteral("Cancun"), i18nc("This is a city associated with particular time zone", "Cancun") },
                                             { QStringLiteral("Cape_Verde"), i18nc("This is a city associated with particular time zone", "Cape Verde") },
                                             { QStringLiteral("Caracas"), i18nc("This is a city associated with particular time zone", "Caracas") },
                                             { QStringLiteral("Casablanca"), i18nc("This is a city associated with particular time zone", "Casablanca") },
                                             { QStringLiteral("Casey"), i18nc("This is a city associated with particular time zone", "Casey") },
                                             { QStringLiteral("Catamarca"), i18nc("This is a city associated with particular time zone", "Catamarca") },
                                             { QStringLiteral("Cayenne"), i18nc("This is a city associated with particular time zone", "Cayenne") },
                                             { QStringLiteral("Cayman"), i18nc("This is a city associated with particular time zone", "Cayman") },
                                             { QStringLiteral("Center"), i18nc("This is a city associated with particular time zone", "Center") },
                                             { QStringLiteral("Ceuta"), i18nc("This is a city associated with particular time zone", "Ceuta") },
                                             { QStringLiteral("Chagos"), i18nc("This is a city associated with particular time zone", "Chagos") },
                                             { QStringLiteral("Chatham"), i18nc("This is a city associated with particular time zone", "Chatham") },
                                             { QStringLiteral("Chicago"), i18nc("This is a city associated with particular time zone", "Chicago") },
                                             { QStringLiteral("Chihuahua"), i18nc("This is a city associated with particular time zone", "Chihuahua") },
                                             { QStringLiteral("Chisinau"), i18nc("This is a city associated with particular time zone", "Chisinau") },
                                             { QStringLiteral("Choibalsan"), i18nc("This is a city associated with particular time zone", "Choibalsan") },
                                             { QStringLiteral("Chongqing"), i18nc("This is a city associated with particular time zone", "Chongqing") },
                                             { QStringLiteral("Christmas"), i18nc("This is a city associated with particular time zone", "Christmas") },
                                             { QStringLiteral("Chuuk"), i18nc("This is a city associated with particular time zone", "Chuuk") },
                                             { QStringLiteral("Cocos"), i18nc("This is a city associated with particular time zone", "Cocos") },
                                             { QStringLiteral("Colombo"), i18nc("This is a city associated with particular time zone", "Colombo") },
                                             { QStringLiteral("Comoro"), i18nc("This is a city associated with particular time zone", "Comoro") },
                                             { QStringLiteral("Conakry"), i18nc("This is a city associated with particular time zone", "Conakry") },
                                             { QStringLiteral("Copenhagen"), i18nc("This is a city associated with particular time zone", "Copenhagen") },
                                             { QStringLiteral("Cordoba"), i18nc("This is a city associated with particular time zone", "Cordoba") },
                                             { QStringLiteral("Costa_Rica"), i18nc("This is a city associated with particular time zone", "Costa Rica") },
                                             { QStringLiteral("Creston"), i18nc("This is a city associated with particular time zone", "Creston") },
                                             { QStringLiteral("Cuiaba"), i18nc("This is a city associated with particular time zone", "Cuiaba") },
                                             { QStringLiteral("Curacao"), i18nc("This is a city associated with particular time zone", "Curacao") },
                                             { QStringLiteral("Currie"), i18nc("This is a city associated with particular time zone", "Currie") },
                                             { QStringLiteral("Dakar"), i18nc("This is a city associated with particular time zone", "Dakar") },
                                             { QStringLiteral("Damascus"), i18nc("This is a city associated with particular time zone", "Damascus") },
                                             { QStringLiteral("Danmarkshavn"), i18nc("This is a city associated with particular time zone", "Danmarkshavn") },
                                             { QStringLiteral("Dar_es_Salaam"), i18nc("This is a city associated with particular time zone", "Dar es Salaam") },
                                             { QStringLiteral("Darwin"), i18nc("This is a city associated with particular time zone", "Darwin") },
                                             { QStringLiteral("Davis"), i18nc("This is a city associated with particular time zone", "Davis") },
                                             { QStringLiteral("Dawson_Creek"), i18nc("This is a city associated with particular time zone", "Dawson Creek") },
                                             { QStringLiteral("Dawson"), i18nc("This is a city associated with particular time zone", "Dawson") },
                                             { QStringLiteral("Denver"), i18nc("This is a city associated with particular time zone", "Denver") },
                                             { QStringLiteral("Detroit"), i18nc("This is a city associated with particular time zone", "Detroit") },
                                             { QStringLiteral("Dhaka"), i18nc("This is a city associated with particular time zone", "Dhaka") },
                                             { QStringLiteral("Dili"), i18nc("This is a city associated with particular time zone", "Dili") },
                                             { QStringLiteral("Djibouti"), i18nc("This is a city associated with particular time zone", "Djibouti") },
                                             { QStringLiteral("Dominica"), i18nc("This is a city associated with particular time zone", "Dominica") },
                                             { QStringLiteral("Douala"), i18nc("This is a city associated with particular time zone", "Douala") },
                                             { QStringLiteral("Dubai"), i18nc("This is a city associated with particular time zone", "Dubai") },
                                             { QStringLiteral("Dublin"), i18nc("This is a city associated with particular time zone", "Dublin") },
                                             { QStringLiteral("DumontDUrville"), i18nc("This is a city associated with particular time zone", "Dumont d’Urville") },
                                             { QStringLiteral("Dushanbe"), i18nc("This is a city associated with particular time zone", "Dushanbe") },
                                             { QStringLiteral("Easter"), i18nc("This is a city associated with particular time zone", "Easter") },
                                             { QStringLiteral("Edmonton"), i18nc("This is a city associated with particular time zone", "Edmonton") },
                                             { QStringLiteral("Efate"), i18nc("This is a city associated with particular time zone", "Efate") },
                                             { QStringLiteral("Eirunepe"), i18nc("This is a city associated with particular time zone", "Eirunepe") },
                                             { QStringLiteral("El_Aaiun"), i18nc("This is a city associated with particular time zone", "El Aaiun") },
                                             { QStringLiteral("El_Salvador"), i18nc("This is a city associated with particular time zone", "El Salvador") },
                                             { QStringLiteral("Enderbury"), i18nc("This is a city associated with particular time zone", "Enderbury") },
                                             { QStringLiteral("Eucla"), i18nc("This is a city associated with particular time zone", "Eucla") },
                                             { QStringLiteral("Fakaofo"), i18nc("This is a city associated with particular time zone", "Fakaofo") },
                                             { QStringLiteral("Faroe"), i18nc("This is a city associated with particular time zone", "Faroe") },
                                             { QStringLiteral("Fiji"), i18nc("This is a city associated with particular time zone", "Fiji") },
                                             { QStringLiteral("Fortaleza"), i18nc("This is a city associated with particular time zone", "Fortaleza") },
                                             { QStringLiteral("Freetown"), i18nc("This is a city associated with particular time zone", "Freetown") },
                                             { QStringLiteral("Funafuti"), i18nc("This is a city associated with particular time zone", "Funafuti") },
                                             { QStringLiteral("Gaborone"), i18nc("This is a city associated with particular time zone", "Gaborone") },
                                             { QStringLiteral("Galapagos"), i18nc("This is a city associated with particular time zone", "Galapagos") },
                                             { QStringLiteral("Gambier"), i18nc("This is a city associated with particular time zone", "Gambier") },
                                             { QStringLiteral("Gaza"), i18nc("This is a city associated with particular time zone", "Gaza") },
                                             { QStringLiteral("Gibraltar"), i18nc("This is a city associated with particular time zone", "Gibraltar") },
                                             { QStringLiteral("Glace_Bay"), i18nc("This is a city associated with particular time zone", "Glace Bay") },
                                             { QStringLiteral("Godthab"), i18nc("This is a city associated with particular time zone", "Godthab") },
                                             { QStringLiteral("Goose_Bay"), i18nc("This is a city associated with particular time zone", "Goose Bay") },
                                             { QStringLiteral("Grand_Turk"), i18nc("This is a city associated with particular time zone", "Grand Turk") },
                                             { QStringLiteral("Grenada"), i18nc("This is a city associated with particular time zone", "Grenada") },
                                             { QStringLiteral("Guadalcanal"), i18nc("This is a city associated with particular time zone", "Guadalcanal") },
                                             { QStringLiteral("Guadeloupe"), i18nc("This is a city associated with particular time zone", "Guadeloupe") },
                                             { QStringLiteral("Guam"), i18nc("This is a city associated with particular time zone", "Guam") },
                                             { QStringLiteral("Guatemala"), i18nc("This is a city associated with particular time zone", "Guatemala") },
                                             { QStringLiteral("Guayaquil"), i18nc("This is a city associated with particular time zone", "Guayaquil") },
                                             { QStringLiteral("Guernsey"), i18nc("This is a city associated with particular time zone", "Guernsey") },
                                             { QStringLiteral("Guyana"), i18nc("This is a city associated with particular time zone", "Guyana") },
                                             { QStringLiteral("Halifax"), i18nc("This is a city associated with particular time zone", "Halifax") },
                                             { QStringLiteral("Harare"), i18nc("This is a city associated with particular time zone", "Harare") },
                                             { QStringLiteral("Harbin"), i18nc("This is a city associated with particular time zone", "Harbin") },
                                             { QStringLiteral("Havana"), i18nc("This is a city associated with particular time zone", "Havana") },
                                             { QStringLiteral("Hebron"), i18nc("This is a city associated with particular time zone", "Hebron") },
                                             { QStringLiteral("Helsinki"), i18nc("This is a city associated with particular time zone", "Helsinki") },
                                             { QStringLiteral("Hermosillo"), i18nc("This is a city associated with particular time zone", "Hermosillo") },
                                             { QStringLiteral("Ho_Chi_Minh"), i18nc("This is a city associated with particular time zone", "Ho Chi Minh") },
                                             { QStringLiteral("Hobart"), i18nc("This is a city associated with particular time zone", "Hobart") },
                                             { QStringLiteral("Hong_Kong"), i18nc("This is a city associated with particular time zone", "Hong Kong") },
                                             { QStringLiteral("Honolulu"), i18nc("This is a city associated with particular time zone", "Honolulu") },
                                             { QStringLiteral("Hovd"), i18nc("This is a city associated with particular time zone", "Hovd") },
                                             { QStringLiteral("Indianapolis"), i18nc("This is a city associated with particular time zone", "Indianapolis") },
                                             { QStringLiteral("Inuvik"), i18nc("This is a city associated with particular time zone", "Inuvik") },
                                             { QStringLiteral("Iqaluit"), i18nc("This is a city associated with particular time zone", "Iqaluit") },
                                             { QStringLiteral("Irkutsk"), i18nc("This is a city associated with particular time zone", "Irkutsk") },
                                             { QStringLiteral("Isle_of_Man"), i18nc("This is a city associated with particular time zone", "Isle of Man") },
                                             { QStringLiteral("Istanbul"), i18nc("This is a city associated with particular time zone", "Istanbul") },
                                             { QStringLiteral("Jakarta"), i18nc("This is a city associated with particular time zone", "Jakarta") },
                                             { QStringLiteral("Jamaica"), i18nc("This is a city associated with particular time zone", "Jamaica") },
                                             { QStringLiteral("Jayapura"), i18nc("This is a city associated with particular time zone", "Jayapura") },
                                             { QStringLiteral("Jersey"), i18nc("This is a city associated with particular time zone", "Jersey") },
                                             { QStringLiteral("Jerusalem"), i18nc("This is a city associated with particular time zone", "Jerusalem") },
                                             { QStringLiteral("Johannesburg"), i18nc("This is a city associated with particular time zone", "Johannesburg") },
                                             { QStringLiteral("Johnston"), i18nc("This is a city associated with particular time zone", "Johnston") },
                                             { QStringLiteral("Juba"), i18nc("This is a city associated with particular time zone", "Juba") },
                                             { QStringLiteral("Jujuy"), i18nc("This is a city associated with particular time zone", "Jujuy") },
                                             { QStringLiteral("Juneau"), i18nc("This is a city associated with particular time zone", "Juneau") },
                                             { QStringLiteral("Kabul"), i18nc("This is a city associated with particular time zone", "Kabul") },
                                             { QStringLiteral("Kaliningrad"), i18nc("This is a city associated with particular time zone", "Kaliningrad") },
                                             { QStringLiteral("Kamchatka"), i18nc("This is a city associated with particular time zone", "Kamchatka") },
                                             { QStringLiteral("Kampala"), i18nc("This is a city associated with particular time zone", "Kampala") },
                                             { QStringLiteral("Karachi"), i18nc("This is a city associated with particular time zone", "Karachi") },
                                             { QStringLiteral("Kashgar"), i18nc("This is a city associated with particular time zone", "Kashgar") },
                                             { QStringLiteral("Kathmandu"), i18nc("This is a city associated with particular time zone", "Kathmandu") },
                                             { QStringLiteral("Kerguelen"), i18nc("This is a city associated with particular time zone", "Kerguelen") },
                                             { QStringLiteral("Khandyga"), i18nc("This is a city associated with particular time zone", "Khandyga") },
                                             { QStringLiteral("Khartoum"), i18nc("This is a city associated with particular time zone", "Khartoum") },
                                             { QStringLiteral("Kiev"), i18nc("This is a city associated with particular time zone", "Kiev") },
                                             { QStringLiteral("Kigali"), i18nc("This is a city associated with particular time zone", "Kigali") },
                                             { QStringLiteral("Kinshasa"), i18nc("This is a city associated with particular time zone", "Kinshasa") },
                                             { QStringLiteral("Kiritimati"), i18nc("This is a city associated with particular time zone", "Kiritimati") },
                                             { QStringLiteral("Knox"), i18nc("This is a city associated with particular time zone", "Knox") },
                                             { QStringLiteral("Kolkata"), i18nc("This is a city associated with particular time zone", "Kolkata") },
                                             { QStringLiteral("Kosrae"), i18nc("This is a city associated with particular time zone", "Kosrae") },
                                             { QStringLiteral("Kralendijk"), i18nc("This is a city associated with particular time zone", "Kralendijk") },
                                             { QStringLiteral("Krasnoyarsk"), i18nc("This is a city associated with particular time zone", "Krasnoyarsk") },
                                             { QStringLiteral("Kuala_Lumpur"), i18nc("This is a city associated with particular time zone", "Kuala Lumpur") },
                                             { QStringLiteral("Kuching"), i18nc("This is a city associated with particular time zone", "Kuching") },
                                             { QStringLiteral("Kuwait"), i18nc("This is a city associated with particular time zone", "Kuwait") },
                                             { QStringLiteral("Kwajalein"), i18nc("This is a city associated with particular time zone", "Kwajalein") },
                                             { QStringLiteral("La_Paz"), i18nc("This is a city associated with particular time zone", "La Paz") },
                                             { QStringLiteral("La_Rioja"), i18nc("This is a city associated with particular time zone", "La Rioja") },
                                             { QStringLiteral("Lagos"), i18nc("This is a city associated with particular time zone", "Lagos") },
                                             { QStringLiteral("Libreville"), i18nc("This is a city associated with particular time zone", "Libreville") },
                                             { QStringLiteral("Lima"), i18nc("This is a city associated with particular time zone", "Lima") },
                                             { QStringLiteral("Lindeman"), i18nc("This is a city associated with particular time zone", "Lindeman") },
                                             { QStringLiteral("Lisbon"), i18nc("This is a city associated with particular time zone", "Lisbon") },
                                             { QStringLiteral("Ljubljana"), i18nc("This is a city associated with particular time zone", "Ljubljana") },
                                             { QStringLiteral("Lome"), i18nc("This is a city associated with particular time zone", "Lome") },
                                             { QStringLiteral("London"), i18nc("This is a city associated with particular time zone", "London") },
                                             { QStringLiteral("Longyearbyen"), i18nc("This is a city associated with particular time zone", "Longyearbyen") },
                                             { QStringLiteral("Lord_Howe"), i18nc("This is a city associated with particular time zone", "Lord Howe") },
                                             { QStringLiteral("Los_Angeles"), i18nc("This is a city associated with particular time zone", "Los Angeles") },
                                             { QStringLiteral("Louisville"), i18nc("This is a city associated with particular time zone", "Louisville") },
                                             { QStringLiteral("Lower_Princes"), i18nc("This is a city associated with particular time zone", "Lower Princes") },
                                             { QStringLiteral("Luanda"), i18nc("This is a city associated with particular time zone", "Luanda") },
                                             { QStringLiteral("Lubumbashi"), i18nc("This is a city associated with particular time zone", "Lubumbashi") },
                                             { QStringLiteral("Lusaka"), i18nc("This is a city associated with particular time zone", "Lusaka") },
                                             { QStringLiteral("Luxembourg"), i18nc("This is a city associated with particular time zone", "Luxembourg") },
                                             { QStringLiteral("Macau"), i18nc("This is a city associated with particular time zone", "Macau") },
                                             { QStringLiteral("Maceio"), i18nc("This is a city associated with particular time zone", "Maceio") },
                                             { QStringLiteral("Macquarie"), i18nc("This is a city associated with particular time zone", "Macquarie") },
                                             { QStringLiteral("Madeira"), i18nc("This is a city associated with particular time zone", "Madeira") },
                                             { QStringLiteral("Madrid"), i18nc("This is a city associated with particular time zone", "Madrid") },
                                             { QStringLiteral("Magadan"), i18nc("This is a city associated with particular time zone", "Magadan") },
                                             { QStringLiteral("Mahe"), i18nc("This is a city associated with particular time zone", "Mahe") },
                                             { QStringLiteral("Majuro"), i18nc("This is a city associated with particular time zone", "Majuro") },
                                             { QStringLiteral("Makassar"), i18nc("This is a city associated with particular time zone", "Makassar") },
                                             { QStringLiteral("Malabo"), i18nc("This is a city associated with particular time zone", "Malabo") },
                                             { QStringLiteral("Maldives"), i18nc("This is a city associated with particular time zone", "Maldives") },
                                             { QStringLiteral("Malta"), i18nc("This is a city associated with particular time zone", "Malta") },
                                             { QStringLiteral("Managua"), i18nc("This is a city associated with particular time zone", "Managua") },
                                             { QStringLiteral("Manaus"), i18nc("This is a city associated with particular time zone", "Manaus") },
                                             { QStringLiteral("Manila"), i18nc("This is a city associated with particular time zone", "Manila") },
                                             { QStringLiteral("Maputo"), i18nc("This is a city associated with particular time zone", "Maputo") },
                                             { QStringLiteral("Marengo"), i18nc("This is a city associated with particular time zone", "Marengo") },
                                             { QStringLiteral("Mariehamn"), i18nc("This is a city associated with particular time zone", "Mariehamn") },
                                             { QStringLiteral("Marigot"), i18nc("This is a city associated with particular time zone", "Marigot") },
                                             { QStringLiteral("Marquesas"), i18nc("This is a city associated with particular time zone", "Marquesas") },
                                             { QStringLiteral("Martinique"), i18nc("This is a city associated with particular time zone", "Martinique") },
                                             { QStringLiteral("Maseru"), i18nc("This is a city associated with particular time zone", "Maseru") },
                                             { QStringLiteral("Matamoros"), i18nc("This is a city associated with particular time zone", "Matamoros") },
                                             { QStringLiteral("Mauritius"), i18nc("This is a city associated with particular time zone", "Mauritius") },
                                             { QStringLiteral("Mawson"), i18nc("This is a city associated with particular time zone", "Mawson") },
                                             { QStringLiteral("Mayotte"), i18nc("This is a city associated with particular time zone", "Mayotte") },
                                             { QStringLiteral("Mazatlan"), i18nc("This is a city associated with particular time zone", "Mazatlan") },
                                             { QStringLiteral("Mbabane"), i18nc("This is a city associated with particular time zone", "Mbabane") },
                                             { QStringLiteral("McMurdo"), i18nc("This is a city associated with particular time zone", "McMurdo") },
                                             { QStringLiteral("Melbourne"), i18nc("This is a city associated with particular time zone", "Melbourne") },
                                             { QStringLiteral("Mendoza"), i18nc("This is a city associated with particular time zone", "Mendoza") },
                                             { QStringLiteral("Menominee"), i18nc("This is a city associated with particular time zone", "Menominee") },
                                             { QStringLiteral("Merida"), i18nc("This is a city associated with particular time zone", "Merida") },
                                             { QStringLiteral("Metlakatla"), i18nc("This is a city associated with particular time zone", "Metlakatla") },
                                             { QStringLiteral("Mexico_City"), i18nc("This is a city associated with particular time zone", "Mexico City") },
                                             { QStringLiteral("Midway"), i18nc("This is a city associated with particular time zone", "Midway") },
                                             { QStringLiteral("Minsk"), i18nc("This is a city associated with particular time zone", "Minsk") },
                                             { QStringLiteral("Miquelon"), i18nc("This is a city associated with particular time zone", "Miquelon") },
                                             { QStringLiteral("Mogadishu"), i18nc("This is a city associated with particular time zone", "Mogadishu") },
                                             { QStringLiteral("Monaco"), i18nc("This is a city associated with particular time zone", "Monaco") },
                                             { QStringLiteral("Moncton"), i18nc("This is a city associated with particular time zone", "Moncton") },
                                             { QStringLiteral("Monrovia"), i18nc("This is a city associated with particular time zone", "Monrovia") },
                                             { QStringLiteral("Monterrey"), i18nc("This is a city associated with particular time zone", "Monterrey") },
                                             { QStringLiteral("Montevideo"), i18nc("This is a city associated with particular time zone", "Montevideo") },
                                             { QStringLiteral("Monticello"), i18nc("This is a city associated with particular time zone", "Monticello") },
                                             { QStringLiteral("Montserrat"), i18nc("This is a city associated with particular time zone", "Montserrat") },
                                             { QStringLiteral("Moscow"), i18nc("This is a city associated with particular time zone", "Moscow") },
                                             { QStringLiteral("Muscat"), i18nc("This is a city associated with particular time zone", "Muscat") },
                                             { QStringLiteral("Nairobi"), i18nc("This is a city associated with particular time zone", "Nairobi") },
                                             { QStringLiteral("Nassau"), i18nc("This is a city associated with particular time zone", "Nassau") },
                                             { QStringLiteral("Nauru"), i18nc("This is a city associated with particular time zone", "Nauru") },
                                             { QStringLiteral("Ndjamena"), i18nc("This is a city associated with particular time zone", "Ndjamena") },
                                             { QStringLiteral("New_Salem"), i18nc("This is a city associated with particular time zone", "New Salem") },
                                             { QStringLiteral("New_York"), i18nc("This is a city associated with particular time zone", "New York") },
                                             { QStringLiteral("Niamey"), i18nc("This is a city associated with particular time zone", "Niamey") },
                                             { QStringLiteral("Nicosia"), i18nc("This is a city associated with particular time zone", "Nicosia") },
                                             { QStringLiteral("Nipigon"), i18nc("This is a city associated with particular time zone", "Nipigon") },
                                             { QStringLiteral("Niue"), i18nc("This is a city associated with particular time zone", "Niue") },
                                             { QStringLiteral("Nome"), i18nc("This is a city associated with particular time zone", "Nome") },
                                             { QStringLiteral("Norfolk"), i18nc("This is a city associated with particular time zone", "Norfolk") },
                                             { QStringLiteral("Noronha"), i18nc("This is a city associated with particular time zone", "Noronha") },
                                             { QStringLiteral("Nouakchott"), i18nc("This is a city associated with particular time zone", "Nouakchott") },
                                             { QStringLiteral("Noumea"), i18nc("This is a city associated with particular time zone", "Noumea") },
                                             { QStringLiteral("Novokuznetsk"), i18nc("This is a city associated with particular time zone", "Novokuznetsk") },
                                             { QStringLiteral("Novosibirsk"), i18nc("This is a city associated with particular time zone", "Novosibirsk") },
                                             { QStringLiteral("Ojinaga"), i18nc("This is a city associated with particular time zone", "Ojinaga") },
                                             { QStringLiteral("Omsk"), i18nc("This is a city associated with particular time zone", "Omsk") },
                                             { QStringLiteral("Oral"), i18nc("This is a city associated with particular time zone", "Oral") },
                                             { QStringLiteral("Oslo"), i18nc("This is a city associated with particular time zone", "Oslo") },
                                             { QStringLiteral("Ouagadougou"), i18nc("This is a city associated with particular time zone", "Ouagadougou") },
                                             { QStringLiteral("Pago_Pago"), i18nc("This is a city associated with particular time zone", "Pago Pago") },
                                             { QStringLiteral("Palau"), i18nc("This is a city associated with particular time zone", "Palau") },
                                             { QStringLiteral("Palmer"), i18nc("This is a city associated with particular time zone", "Palmer") },
                                             { QStringLiteral("Panama"), i18nc("This is a city associated with particular time zone", "Panama") },
                                             { QStringLiteral("Pangnirtung"), i18nc("This is a city associated with particular time zone", "Pangnirtung") },
                                             { QStringLiteral("Paramaribo"), i18nc("This is a city associated with particular time zone", "Paramaribo") },
                                             { QStringLiteral("Paris"), i18nc("This is a city associated with particular time zone", "Paris") },
                                             { QStringLiteral("Perth"), i18nc("This is a city associated with particular time zone", "Perth") },
                                             { QStringLiteral("Petersburg"), i18nc("This is a city associated with particular time zone", "Petersburg") },
                                             { QStringLiteral("Phnom_Penh"), i18nc("This is a city associated with particular time zone", "Phnom Penh") },
                                             { QStringLiteral("Phoenix"), i18nc("This is a city associated with particular time zone", "Phoenix") },
                                             { QStringLiteral("Pitcairn"), i18nc("This is a city associated with particular time zone", "Pitcairn") },
                                             { QStringLiteral("Podgorica"), i18nc("This is a city associated with particular time zone", "Podgorica") },
                                             { QStringLiteral("Pohnpei"), i18nc("This is a city associated with particular time zone", "Pohnpei") },
                                             { QStringLiteral("Pontianak"), i18nc("This is a city associated with particular time zone", "Pontianak") },
                                             { QStringLiteral("Port-au-Prince"), i18nc("This is a city associated with particular time zone", "Port-au-Prince") },
                                             { QStringLiteral("Port_Moresby"), i18nc("This is a city associated with particular time zone", "Port Moresby") },
                                             { QStringLiteral("Port_of_Spain"), i18nc("This is a city associated with particular time zone", "Port of Spain") },
                                             { QStringLiteral("Porto-Novo"), i18nc("This is a city associated with particular time zone", "Porto-Novo") },
                                             { QStringLiteral("Porto_Velho"), i18nc("This is a city associated with particular time zone", "Porto Velho") },
                                             { QStringLiteral("Prague"), i18nc("This is a city associated with particular time zone", "Prague") },
                                             { QStringLiteral("Puerto_Rico"), i18nc("This is a city associated with particular time zone", "Puerto Rico") },
                                             { QStringLiteral("Pyongyang"), i18nc("This is a city associated with particular time zone", "Pyongyang") },
                                             { QStringLiteral("Qatar"), i18nc("This is a city associated with particular time zone", "Qatar") },
                                             { QStringLiteral("Qyzylorda"), i18nc("This is a city associated with particular time zone", "Qyzylorda") },
                                             { QStringLiteral("Rainy_River"), i18nc("This is a city associated with particular time zone", "Rainy River") },
                                             { QStringLiteral("Rangoon"), i18nc("This is a city associated with particular time zone", "Rangoon") },
                                             { QStringLiteral("Rankin_Inlet"), i18nc("This is a city associated with particular time zone", "Rankin Inlet") },
                                             { QStringLiteral("Rarotonga"), i18nc("This is a city associated with particular time zone", "Rarotonga") },
                                             { QStringLiteral("Recife"), i18nc("This is a city associated with particular time zone", "Recife") },
                                             { QStringLiteral("Regina"), i18nc("This is a city associated with particular time zone", "Regina") },
                                             { QStringLiteral("Resolute"), i18nc("This is a city associated with particular time zone", "Resolute") },
                                             { QStringLiteral("Reunion"), i18nc("This is a city associated with particular time zone", "Reunion") },
                                             { QStringLiteral("Reykjavik"), i18nc("This is a city associated with particular time zone", "Reykjavik") },
                                             { QStringLiteral("Riga"), i18nc("This is a city associated with particular time zone", "Riga") },
                                             { QStringLiteral("Rio_Branco"), i18nc("This is a city associated with particular time zone", "Rio Branco") },
                                             { QStringLiteral("Rio_Gallegos"), i18nc("This is a city associated with particular time zone", "Rio Gallegos") },
                                             { QStringLiteral("Riyadh"), i18nc("This is a city associated with particular time zone", "Riyadh") },
                                             { QStringLiteral("Rome"), i18nc("This is a city associated with particular time zone", "Rome") },
                                             { QStringLiteral("Rothera"), i18nc("This is a city associated with particular time zone", "Rothera") },
                                             { QStringLiteral("Saipan"), i18nc("This is a city associated with particular time zone", "Saipan") },
                                             { QStringLiteral("Sakhalin"), i18nc("This is a city associated with particular time zone", "Sakhalin") },
                                             { QStringLiteral("Salta"), i18nc("This is a city associated with particular time zone", "Salta") },
                                             { QStringLiteral("Samara"), i18nc("This is a city associated with particular time zone", "Samara") },
                                             { QStringLiteral("Samarkand"), i18nc("This is a city associated with particular time zone", "Samarkand") },
                                             { QStringLiteral("San_Juan"), i18nc("This is a city associated with particular time zone", "San Juan") },
                                             { QStringLiteral("San_Luis"), i18nc("This is a city associated with particular time zone", "San Luis") },
                                             { QStringLiteral("San_Marino"), i18nc("This is a city associated with particular time zone", "San Marino") },
                                             { QStringLiteral("Santa_Isabel"), i18nc("This is a city associated with particular time zone", "Santa Isabel") },
                                             { QStringLiteral("Santarem"), i18nc("This is a city associated with particular time zone", "Santarem") },
                                             { QStringLiteral("Santiago"), i18nc("This is a city associated with particular time zone", "Santiago") },
                                             { QStringLiteral("Santo_Domingo"), i18nc("This is a city associated with particular time zone", "Santo Domingo") },
                                             { QStringLiteral("Sao_Paulo"), i18nc("This is a city associated with particular time zone", "Sao Paulo") },
                                             { QStringLiteral("Sao_Tome"), i18nc("This is a city associated with particular time zone", "Sao Tome") },
                                             { QStringLiteral("Sarajevo"), i18nc("This is a city associated with particular time zone", "Sarajevo") },
                                             { QStringLiteral("Scoresbysund"), i18nc("This is a city associated with particular time zone", "Scoresbysund") },
                                             { QStringLiteral("Seoul"), i18nc("This is a city associated with particular time zone", "Seoul") },
                                             { QStringLiteral("Shanghai"), i18nc("This is a city associated with particular time zone", "Shanghai") },
                                             { QStringLiteral("Simferopol"), i18nc("This is a city associated with particular time zone", "Simferopol") },
                                             { QStringLiteral("Singapore"), i18nc("This is a city associated with particular time zone", "Singapore") },
                                             { QStringLiteral("Sitka"), i18nc("This is a city associated with particular time zone", "Sitka") },
                                             { QStringLiteral("Skopje"), i18nc("This is a city associated with particular time zone", "Skopje") },
                                             { QStringLiteral("Sofia"), i18nc("This is a city associated with particular time zone", "Sofia") },
                                             { QStringLiteral("South_Georgia"), i18nc("This is a city associated with particular time zone", "South Georgia") },
                                             { QStringLiteral("St_Barthelemy"), i18nc("This is a city associated with particular time zone", "St Barthelemy") },
                                             { QStringLiteral("St_Helena"), i18nc("This is a city associated with particular time zone", "St Helena") },
                                             { QStringLiteral("St_Johns"), i18nc("This is a city associated with particular time zone", "St Johns") },
                                             { QStringLiteral("St_Kitts"), i18nc("This is a city associated with particular time zone", "St Kitts") },
                                             { QStringLiteral("St_Lucia"), i18nc("This is a city associated with particular time zone", "St Lucia") },
                                             { QStringLiteral("St_Thomas"), i18nc("This is a city associated with particular time zone", "St Thomas") },
                                             { QStringLiteral("St_Vincent"), i18nc("This is a city associated with particular time zone", "St Vincent") },
                                             { QStringLiteral("Stanley"), i18nc("This is a city associated with particular time zone", "Stanley") },
                                             { QStringLiteral("Stockholm"), i18nc("This is a city associated with particular time zone", "Stockholm") },
                                             { QStringLiteral("Swift_Current"), i18nc("This is a city associated with particular time zone", "Swift Current") },
                                             { QStringLiteral("Sydney"), i18nc("This is a city associated with particular time zone", "Sydney") },
                                             { QStringLiteral("Syowa"), i18nc("This is a city associated with particular time zone", "Syowa") },
                                             { QStringLiteral("Tahiti"), i18nc("This is a city associated with particular time zone", "Tahiti") },
                                             { QStringLiteral("Taipei"), i18nc("This is a city associated with particular time zone", "Taipei") },
                                             { QStringLiteral("Tallinn"), i18nc("This is a city associated with particular time zone", "Tallinn") },
                                             { QStringLiteral("Tarawa"), i18nc("This is a city associated with particular time zone", "Tarawa") },
                                             { QStringLiteral("Tashkent"), i18nc("This is a city associated with particular time zone", "Tashkent") },
                                             { QStringLiteral("Tbilisi"), i18nc("This is a city associated with particular time zone", "Tbilisi") },
                                             { QStringLiteral("Tegucigalpa"), i18nc("This is a city associated with particular time zone", "Tegucigalpa") },
                                             { QStringLiteral("Tehran"), i18nc("This is a city associated with particular time zone", "Tehran") },
                                             { QStringLiteral("Tell_City"), i18nc("This is a city associated with particular time zone", "Tell City") },
                                             { QStringLiteral("Thimphu"), i18nc("This is a city associated with particular time zone", "Thimphu") },
                                             { QStringLiteral("Thule"), i18nc("This is a city associated with particular time zone", "Thule") },
                                             { QStringLiteral("Thunder_Bay"), i18nc("This is a city associated with particular time zone", "Thunder Bay") },
                                             { QStringLiteral("Tijuana"), i18nc("This is a city associated with particular time zone", "Tijuana") },
                                             { QStringLiteral("Tirane"), i18nc("This is a city associated with particular time zone", "Tirane") },
                                             { QStringLiteral("Tokyo"), i18nc("This is a city associated with particular time zone", "Tokyo") },
                                             { QStringLiteral("Tongatapu"), i18nc("This is a city associated with particular time zone", "Tongatapu") },
                                             { QStringLiteral("Toronto"), i18nc("This is a city associated with particular time zone", "Toronto") },
                                             { QStringLiteral("Tortola"), i18nc("This is a city associated with particular time zone", "Tortola") },
                                             { QStringLiteral("Tripoli"), i18nc("This is a city associated with particular time zone", "Tripoli") },
                                             { QStringLiteral("Troll"), i18nc("This is a city associated with particular time zone", "Troll") },
                                             { QStringLiteral("Tucuman"), i18nc("This is a city associated with particular time zone", "Tucuman") },
                                             { QStringLiteral("Tunis"), i18nc("This is a city associated with particular time zone", "Tunis") },
                                             { QStringLiteral("Ulaanbaatar"), i18nc("This is a city associated with particular time zone", "Ulaanbaatar") },
                                             { QStringLiteral("Urumqi"), i18nc("This is a city associated with particular time zone", "Urumqi") },
                                             { QStringLiteral("Ushuaia"), i18nc("This is a city associated with particular time zone", "Ushuaia") },
                                             { QStringLiteral("Ust-Nera"), i18nc("This is a city associated with particular time zone", "Ust-Nera") },
                                             { QStringLiteral("UTC+00:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+00:00") },
                                             { QStringLiteral("UTC+01:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+01:00") },
                                             { QStringLiteral("UTC+02:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+02:00") },
                                             { QStringLiteral("UTC+03:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+03:00") },
                                             { QStringLiteral("UTC+03:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+03:30") },
                                             { QStringLiteral("UTC+04:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+04:00") },
                                             { QStringLiteral("UTC+04:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+04:30") },
                                             { QStringLiteral("UTC+05:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+05:00") },
                                             { QStringLiteral("UTC+05:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+05:30") },
                                             { QStringLiteral("UTC+05:45"), i18nc("This is a generic time zone name, localize as needed", "UTC+05:45") },
                                             { QStringLiteral("UTC+06:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+06:00") },
                                             { QStringLiteral("UTC+06:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+06:30") },
                                             { QStringLiteral("UTC+07:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+07:00") },
                                             { QStringLiteral("UTC+08:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+08:00") },
                                             { QStringLiteral("UTC+09:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+09:00") },
                                             { QStringLiteral("UTC+09:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+09:30") },
                                             { QStringLiteral("UTC+10:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+10:00") },
                                             { QStringLiteral("UTC+11:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+11:00") },
                                             { QStringLiteral("UTC+12:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+12:00") },
                                             { QStringLiteral("UTC+13:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+13:00") },
                                             { QStringLiteral("UTC+14:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+14:00") },
                                             { QStringLiteral("UTC-00:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-00:00") },
                                             { QStringLiteral("UTC-01:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-01:00") },
                                             { QStringLiteral("UTC-02:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-02:00") },
                                             { QStringLiteral("UTC-03:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-03:00") },
                                             { QStringLiteral("UTC-03:30"), i18nc("This is a generic time zone name, localize as needed", "UTC-03:30") },
                                             { QStringLiteral("UTC-04:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-04:00") },
                                             { QStringLiteral("UTC-04:30"), i18nc("This is a generic time zone name, localize as needed", "UTC-04:30") },
                                             { QStringLiteral("UTC-05:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-05:00") },
                                             { QStringLiteral("UTC-06:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-06:00") },
                                             { QStringLiteral("UTC-07:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-07:00") },
                                             { QStringLiteral("UTC-08:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-08:00") },
                                             { QStringLiteral("UTC-09:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-09:00") },
                                             { QStringLiteral("UTC-10:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-10:00") },
                                             { QStringLiteral("UTC-11:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-11:00") },
                                             { QStringLiteral("UTC-12:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-12:00") },
                                             { QStringLiteral("UTC-13:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-13:00") },
                                             { QStringLiteral("UTC-14:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-14:00") },
                                             { QStringLiteral("UTC"), i18nc("This is a generic time zone name, localize as needed", "UTC") },
                                             { QStringLiteral("Uzhgorod"), i18nc("This is a city associated with particular time zone", "Uzhgorod") },
                                             { QStringLiteral("Vaduz"), i18nc("This is a city associated with particular time zone", "Vaduz") },
                                             { QStringLiteral("Vancouver"), i18nc("This is a city associated with particular time zone", "Vancouver") },
                                             { QStringLiteral("Vatican"), i18nc("This is a city associated with particular time zone", "Vatican") },
                                             { QStringLiteral("Vevay"), i18nc("This is a city associated with particular time zone", "Vevay") },
                                             { QStringLiteral("Vienna"), i18nc("This is a city associated with particular time zone", "Vienna") },
                                             { QStringLiteral("Vientiane"), i18nc("This is a city associated with particular time zone", "Vientiane") },
                                             { QStringLiteral("Vilnius"), i18nc("This is a city associated with particular time zone", "Vilnius") },
                                             { QStringLiteral("Vincennes"), i18nc("This is a city associated with particular time zone", "Vincennes") },
                                             { QStringLiteral("Vladivostok"), i18nc("This is a city associated with particular time zone", "Vladivostok") },
                                             { QStringLiteral("Volgograd"), i18nc("This is a city associated with particular time zone", "Volgograd") },
                                             { QStringLiteral("Vostok"), i18nc("This is a city associated with particular time zone", "Vostok") },
                                             { QStringLiteral("Wake"), i18nc("This is a city associated with particular time zone", "Wake") },
                                             { QStringLiteral("Wallis"), i18nc("This is a city associated with particular time zone", "Wallis") },
                                             { QStringLiteral("Warsaw"), i18nc("This is a city associated with particular time zone", "Warsaw") },
                                             { QStringLiteral("Whitehorse"), i18nc("This is a city associated with particular time zone", "Whitehorse") },
                                             { QStringLiteral("Winamac"), i18nc("This is a city associated with particular time zone", "Winamac") },
                                             { QStringLiteral("Windhoek"), i18nc("This is a city associated with particular time zone", "Windhoek") },
                                             { QStringLiteral("Winnipeg"), i18nc("This is a city associated with particular time zone", "Winnipeg") },
                                             { QStringLiteral("Yakutat"), i18nc("This is a city associated with particular time zone", "Yakutat") },
                                             { QStringLiteral("Yakutsk"), i18nc("This is a city associated with particular time zone", "Yakutsk") },
                                             { QStringLiteral("Yekaterinburg"), i18nc("This is a city associated with particular time zone", "Yekaterinburg") },
                                             { QStringLiteral("Yellowknife"), i18nc("This is a city associated with particular time zone", "Yellowknife") },
                                             { QStringLiteral("Yerevan"), i18nc("This is a city associated with particular time zone", "Yerevan") },
                                             { QStringLiteral("Zagreb"), i18nc("This is a city associated with particular time zone", "Zagreb") },
                                             { QStringLiteral("Zaporozhye"), i18nc("This is a city associated with particular time zone", "Zaporozhye") },
                                             { QStringLiteral("Zurich"), i18nc("This is a city associated with particular time zone", "Zurich") } });

#define ENTRY_ISO_3166(qlocale_enum, string) { QLocale::qlocale_enum, i18nd("iso_3166", string) }
    /* Make sure the country names match their versions in iso-codes,
     * ISO 3166. */
    m_i18nCountries = QHash<QLocale::Country, QString>({
            ENTRY_ISO_3166(IvoryCoast, "Côte d'Ivoire"),
            ENTRY_ISO_3166(Ghana, "Ghana"),
            ENTRY_ISO_3166(Ethiopia, "Ethiopia"),
            ENTRY_ISO_3166(Algeria, "Algeria"),
            ENTRY_ISO_3166(Eritrea, "Eritrea"),
            ENTRY_ISO_3166(Mali, "Mali"),
            ENTRY_ISO_3166(CentralAfricanRepublic, "Central African Republic"),
            ENTRY_ISO_3166(Gambia, "Gambia"),
            ENTRY_ISO_3166(GuineaBissau, "Guinea-Bissau"),
            ENTRY_ISO_3166(Malawi, "Malawi"),
            ENTRY_ISO_3166(CongoBrazzaville, "Congo"),
            ENTRY_ISO_3166(Burundi, "Burundi"),
            ENTRY_ISO_3166(Egypt, "Egypt"),
            ENTRY_ISO_3166(Morocco, "Morocco"),
            ENTRY_ISO_3166(Spain, "Spain"),
            ENTRY_ISO_3166(Guinea, "Guinea"),
            ENTRY_ISO_3166(Senegal, "Senegal"),
            ENTRY_ISO_3166(Tanzania, "Tanzania"),
            ENTRY_ISO_3166(Djibouti, "Djibouti"),
            ENTRY_ISO_3166(Cameroon, "Cameroon"),
            ENTRY_ISO_3166(WesternSahara, "Western Sahara"),
            ENTRY_ISO_3166(SierraLeone, "Sierra Leone"),
            ENTRY_ISO_3166(Botswana, "Botswana"),
            ENTRY_ISO_3166(BouvetIsland, "Bouvet Island"),
            ENTRY_ISO_3166(Zimbabwe, "Zimbabwe"),
            ENTRY_ISO_3166(SouthAfrica, "South Africa"),
            ENTRY_ISO_3166(SouthSudan, "South Sudan"),
            ENTRY_ISO_3166(Uganda, "Uganda"),
            ENTRY_ISO_3166(Sudan, "Sudan"),
            ENTRY_ISO_3166(Rwanda, "Rwanda"),
            ENTRY_ISO_3166(CongoKinshasa, "Congo, The Democratic Republic of the"),
            ENTRY_ISO_3166(Nigeria, "Nigeria"),
            ENTRY_ISO_3166(Gabon, "Gabon"),
            ENTRY_ISO_3166(Togo, "Togo"),
            ENTRY_ISO_3166(Angola, "Angola"),
            ENTRY_ISO_3166(Zambia, "Zambia"),
            ENTRY_ISO_3166(EquatorialGuinea, "Equatorial Guinea"),
            ENTRY_ISO_3166(Mozambique, "Mozambique"),
            ENTRY_ISO_3166(Lesotho, "Lesotho"),
            ENTRY_ISO_3166(Swaziland, "Swaziland"),
            ENTRY_ISO_3166(Somalia, "Somalia"),
            ENTRY_ISO_3166(Liberia, "Liberia"),
            ENTRY_ISO_3166(Kenya, "Kenya"),
            ENTRY_ISO_3166(Chad, "Chad"),
            ENTRY_ISO_3166(Niger, "Niger"),
            ENTRY_ISO_3166(Mauritania, "Mauritania"),
            ENTRY_ISO_3166(BurkinaFaso, "Burkina Faso"),
            ENTRY_ISO_3166(Benin, "Benin"),
            ENTRY_ISO_3166(SaoTomeAndPrincipe, "Sao Tome and Principe"),
            ENTRY_ISO_3166(Libya, "Libya"),
            ENTRY_ISO_3166(Tunisia, "Tunisia"),
            ENTRY_ISO_3166(Namibia, "Namibia"),
            ENTRY_ISO_3166(UnitedStates, "United States"),
            ENTRY_ISO_3166(Anguilla, "Anguilla"),
            ENTRY_ISO_3166(AntiguaAndBarbuda, "Antigua and Barbuda"),
            ENTRY_ISO_3166(Brazil, "Brazil"),
            ENTRY_ISO_3166(Argentina, "Argentina"),
            ENTRY_ISO_3166(Aruba, "Aruba"),
            ENTRY_ISO_3166(Paraguay, "Paraguay"),
            ENTRY_ISO_3166(Canada, "Canada"),
            ENTRY_ISO_3166(Mexico, "Mexico"),
            ENTRY_ISO_3166(Barbados, "Barbados"),
            ENTRY_ISO_3166(Belize, "Belize"),
            ENTRY_ISO_3166(Colombia, "Colombia"),
            ENTRY_ISO_3166(Venezuela, "Venezuela"),
            ENTRY_ISO_3166(FrenchGuiana, "French Guiana"),
            ENTRY_ISO_3166(CaymanIslands, "Cayman Islands"),
            ENTRY_ISO_3166(CostaRica, "Costa Rica"),
            ENTRY_ISO_3166(CuraSao, "Curaçao"),
            ENTRY_ISO_3166(Greenland, "Greenland"),
            ENTRY_ISO_3166(Dominica, "Dominica"),
            ENTRY_ISO_3166(ElSalvador, "El Salvador"),
            ENTRY_ISO_3166(TurksAndCaicosIslands, "Turks and Caicos Islands"),
            ENTRY_ISO_3166(Grenada, "Grenada"),
            ENTRY_ISO_3166(Guadeloupe, "Guadeloupe"),
            ENTRY_ISO_3166(Guatemala, "Guatemala"),
            ENTRY_ISO_3166(Ecuador, "Ecuador"),
            ENTRY_ISO_3166(Guyana, "Guyana"),
            ENTRY_ISO_3166(Cuba, "Cuba"),
            ENTRY_ISO_3166(Jamaica, "Jamaica"),
            ENTRY_ISO_3166(Bonaire, "Bonaire, Sint Eustatius and Saba"),
            ENTRY_ISO_3166(Bolivia, "Bolivia"),
            ENTRY_ISO_3166(Peru, "Peru"),
            ENTRY_ISO_3166(SintMaarten, "Sint Maarten (Dutch part)"),
            ENTRY_ISO_3166(Nicaragua, "Nicaragua"),
            ENTRY_ISO_3166(SaintMartin, "Saint Martin (French part)"),
            ENTRY_ISO_3166(Martinique, "Martinique"),
            ENTRY_ISO_3166(SaintPierreAndMiquelon, "Saint Pierre and Miquelon"),
            ENTRY_ISO_3166(Uruguay, "Uruguay"),
            ENTRY_ISO_3166(Montserrat, "Montserrat"),
            ENTRY_ISO_3166(Bahamas, "Bahamas"),
            ENTRY_ISO_3166(Panama, "Panama"),
            ENTRY_ISO_3166(Suriname, "Suriname"),
            ENTRY_ISO_3166(Haiti, "Haiti"),
            ENTRY_ISO_3166(HeardAndMcDonaldIslands, "Heard Island and McDonald Islands"),
            ENTRY_ISO_3166(TrinidadAndTobago, "Trinidad and Tobago"),
            ENTRY_ISO_3166(PuertoRico, "Puerto Rico"),
            ENTRY_ISO_3166(Chile, "Chile"),
            ENTRY_ISO_3166(DominicanRepublic, "Dominican Republic"),
            ENTRY_ISO_3166(SaintBarthelemy, "Saint Barthélemy"),
            ENTRY_ISO_3166(SaintKittsAndNevis, "Saint Kitts and Nevis"),
            ENTRY_ISO_3166(SaintLucia, "Saint Lucia"),
            ENTRY_ISO_3166(UnitedStatesVirginIslands, "Virgin Islands, U.S."),
            ENTRY_ISO_3166(SaintVincentAndTheGrenadines, "Saint Vincent and the Grenadines"),
            ENTRY_ISO_3166(Honduras, "Honduras"),
            ENTRY_ISO_3166(BritishVirginIslands, "Virgin Islands, British"),
            ENTRY_ISO_3166(Antarctica, "Antarctica"),
            ENTRY_ISO_3166(Australia, "Australia"),
            ENTRY_ISO_3166(SvalbardAndJanMayenIslands, "Svalbard and Jan Mayen"),
            ENTRY_ISO_3166(Yemen, "Yemen"),
            ENTRY_ISO_3166(Kazakhstan, "Kazakhstan"),
            ENTRY_ISO_3166(Jordan, "Jordan"),
            ENTRY_ISO_3166(Russia, "Russian Federation"),
            ENTRY_ISO_3166(Turkmenistan, "Turkmenistan"),
            ENTRY_ISO_3166(Iraq, "Iraq"),
            ENTRY_ISO_3166(Bahrain, "Bahrain"),
            ENTRY_ISO_3166(Azerbaijan, "Azerbaijan"),
            ENTRY_ISO_3166(Thailand, "Thailand"),
            ENTRY_ISO_3166(Lebanon, "Lebanon"),
            ENTRY_ISO_3166(Kyrgyzstan, "Kyrgyzstan"),
            ENTRY_ISO_3166(Brunei, "Brunei Darussalam"),
            ENTRY_ISO_3166(Mongolia, "Mongolia"),
            ENTRY_ISO_3166(China, "China"),
            ENTRY_ISO_3166(SriLanka, "Sri Lanka"),
            ENTRY_ISO_3166(Syria, "Syrian Arab Republic"),
            ENTRY_ISO_3166(Bangladesh, "Bangladesh"),
            ENTRY_ISO_3166(EastTimor, "Timor-Leste"),
            ENTRY_ISO_3166(UnitedArabEmirates, "United Arab Emirates"),
            ENTRY_ISO_3166(Tajikistan, "Tajikistan"),
            ENTRY_ISO_3166(PalestinianTerritories, "Palestine, State of"),
            ENTRY_ISO_3166(Vietnam, "Viet Nam"),
            ENTRY_ISO_3166(HongKong, "Hong Kong"),
            ENTRY_ISO_3166(Indonesia, "Indonesia"),
            ENTRY_ISO_3166(Israel, "Israel"),
            ENTRY_ISO_3166(Afghanistan, "Afghanistan"),
            ENTRY_ISO_3166(Pakistan, "Pakistan"),
            ENTRY_ISO_3166(Nepal, "Nepal"),
            ENTRY_ISO_3166(India, "India"),
            ENTRY_ISO_3166(Malaysia, "Malaysia"),
            ENTRY_ISO_3166(Kuwait, "Kuwait"),
            ENTRY_ISO_3166(Macau, "Macao"),
            ENTRY_ISO_3166(Philippines, "Philippines"),
            ENTRY_ISO_3166(Oman, "Oman"),
            ENTRY_ISO_3166(Cyprus, "Cyprus"),
            ENTRY_ISO_3166(Cambodia, "Cambodia"),
            ENTRY_ISO_3166(NorthKorea, "Korea, Democratic People's Republic of"),
            ENTRY_ISO_3166(Qatar, "Qatar"),
            ENTRY_ISO_3166(Myanmar, "Myanmar"),
            ENTRY_ISO_3166(SaudiArabia, "Saudi Arabia"),
            ENTRY_ISO_3166(Uzbekistan, "Uzbekistan"),
            ENTRY_ISO_3166(SouthKorea, "Korea, Republic of"),
            ENTRY_ISO_3166(Singapore, "Singapore"),
            ENTRY_ISO_3166(Taiwan, "Taiwan"),
            ENTRY_ISO_3166(Georgia, "Georgia"),
            ENTRY_ISO_3166(Iran, "Iran, Islamic Republic of"),
            ENTRY_ISO_3166(Bhutan, "Bhutan"),
            ENTRY_ISO_3166(Japan, "Japan"),
            ENTRY_ISO_3166(Laos, "Lao People's Democratic Republic"),
            ENTRY_ISO_3166(Armenia, "Armenia"),
            ENTRY_ISO_3166(Portugal, "Portugal"),
            ENTRY_ISO_3166(Bermuda, "Bermuda"),
            ENTRY_ISO_3166(CapeVerde, "Cape Verde"),
            ENTRY_ISO_3166(FaroeIslands, "Faroe Islands"),
            ENTRY_ISO_3166(Iceland, "Iceland"),
            ENTRY_ISO_3166(SouthGeorgiaAndTheSouthSandwichIslands, "South Georgia and the South Sandwich Islands"),
            ENTRY_ISO_3166(SaintHelena, "Saint Helena, Ascension and Tristan da Cunha"),
            ENTRY_ISO_3166(FalklandIslands, "Falkland Islands (Malvinas)"),
            ENTRY_ISO_3166(Netherlands, "Netherlands"),
            ENTRY_ISO_3166(Andorra, "Andorra"),
            ENTRY_ISO_3166(Greece, "Greece"),
            ENTRY_ISO_3166(Serbia, "Serbia"),
            ENTRY_ISO_3166(Germany, "Germany"),
            ENTRY_ISO_3166(Slovakia, "Slovakia"),
            ENTRY_ISO_3166(Belgium, "Belgium"),
            ENTRY_ISO_3166(Romania, "Romania"),
            ENTRY_ISO_3166(Hungary, "Hungary"),
            ENTRY_ISO_3166(Moldova, "Moldova"),
            ENTRY_ISO_3166(Denmark, "Denmark"),
            ENTRY_ISO_3166(Ireland, "Ireland"),
            ENTRY_ISO_3166(Gibraltar, "Gibraltar"),
            ENTRY_ISO_3166(Guernsey, "Guernsey"),
            ENTRY_ISO_3166(Finland, "Finland"),
            ENTRY_ISO_3166(IsleOfMan, "Isle of Man"),
            ENTRY_ISO_3166(Turkey, "Turkey"),
            ENTRY_ISO_3166(Jersey, "Jersey"),
            ENTRY_ISO_3166(Ukraine, "Ukraine"),
            ENTRY_ISO_3166(Slovenia, "Slovenia"),
            ENTRY_ISO_3166(UnitedKingdom, "United Kingdom"),
            ENTRY_ISO_3166(Luxembourg, "Luxembourg"),
            ENTRY_ISO_3166(Malta, "Malta"),
            ENTRY_ISO_3166(AlandIslands, "Åland Islands"),
            ENTRY_ISO_3166(Belarus, "Belarus"),
            ENTRY_ISO_3166(Monaco, "Monaco"),
            ENTRY_ISO_3166(Norway, "Norway"),
            ENTRY_ISO_3166(France, "France"),
            ENTRY_ISO_3166(Montenegro, "Montenegro"),
            ENTRY_ISO_3166(CzechRepublic, "Czechia"),
            ENTRY_ISO_3166(Latvia, "Latvia"),
            ENTRY_ISO_3166(Italy, "Italy"),
            ENTRY_ISO_3166(SanMarino, "San Marino"),
            ENTRY_ISO_3166(BosniaAndHerzegowina, "Bosnia and Herzegovina"),
            ENTRY_ISO_3166(Macedonia, "Macedonia, Republic of"),
            ENTRY_ISO_3166(Bulgaria, "Bulgaria"),
            ENTRY_ISO_3166(Sweden, "Sweden"),
            ENTRY_ISO_3166(Estonia, "Estonia"),
            ENTRY_ISO_3166(Albania, "Albania"),
            ENTRY_ISO_3166(Liechtenstein, "Liechtenstein"),
            ENTRY_ISO_3166(VaticanCityState, "Holy See (Vatican City State)"),
            ENTRY_ISO_3166(Austria, "Austria"),
            ENTRY_ISO_3166(Lithuania, "Lithuania"),
            ENTRY_ISO_3166(Poland, "Poland"),
            ENTRY_ISO_3166(Croatia, "Croatia"),
            ENTRY_ISO_3166(Switzerland, "Switzerland"),
            ENTRY_ISO_3166(Madagascar, "Madagascar"),
            ENTRY_ISO_3166(BritishIndianOceanTerritory, "British Indian Ocean Territory"),
            ENTRY_ISO_3166(ChristmasIsland, "Christmas Island"),
            ENTRY_ISO_3166(CocosIslands, "Cocos (Keeling) Islands"),
            ENTRY_ISO_3166(Comoros, "Comoros"),
            ENTRY_ISO_3166(FrenchSouthernTerritories, "French Southern Territories"),
            ENTRY_ISO_3166(Seychelles, "Seychelles"),
            ENTRY_ISO_3166(Maldives, "Maldives"),
            ENTRY_ISO_3166(Mauritius, "Mauritius"),
            ENTRY_ISO_3166(Mayotte, "Mayotte"),
            ENTRY_ISO_3166(Reunion, "Réunion"),
            ENTRY_ISO_3166(Samoa, "Samoa"),
            ENTRY_ISO_3166(NewZealand, "New Zealand"),
            ENTRY_ISO_3166(Micronesia, "Micronesia, Federated States of"),
            ENTRY_ISO_3166(Vanuatu, "Vanuatu"),
            ENTRY_ISO_3166(Kiribati, "Kiribati"),
            ENTRY_ISO_3166(Tokelau, "Tokelau"),
            ENTRY_ISO_3166(Fiji, "Fiji"),
            ENTRY_ISO_3166(Tuvalu, "Tuvalu"),
            ENTRY_ISO_3166(FrenchPolynesia, "French Polynesia"),
            ENTRY_ISO_3166(SolomonIslands, "Solomon Islands"),
            ENTRY_ISO_3166(Guam, "Guam"),
            ENTRY_ISO_3166(UnitedStatesMinorOutlyingIslands, "United States Minor Outlying Islands"),
            ENTRY_ISO_3166(MarshallIslands, "Marshall Islands"),
            ENTRY_ISO_3166(NauruCountry, "Nauru"),
            ENTRY_ISO_3166(Niue, "Niue"),
            ENTRY_ISO_3166(NorfolkIsland, "Norfolk Island"),
            ENTRY_ISO_3166(NewCaledonia, "New Caledonia"),
            ENTRY_ISO_3166(AmericanSamoa, "American Samoa"),
            ENTRY_ISO_3166(Palau, "Palau"),
            ENTRY_ISO_3166(Pitcairn, "Pitcairn"),
            ENTRY_ISO_3166(PapuaNewGuinea, "Papua New Guinea"),
            ENTRY_ISO_3166(CookIslands, "Cook Islands"),
            ENTRY_ISO_3166(NorthernMarianaIslands, "Northern Mariana Islands"),
            ENTRY_ISO_3166(Tonga, "Tonga"),
            ENTRY_ISO_3166(WallisAndFutunaIslands, "Wallis and Futuna")
            //           {QLocale::Default,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Default")} },
    });
#undef ENTRY_ISO_3166

    m_i18nContinents = QHash<QString, QString>({ { QStringLiteral("Africa"), i18nc("This is a continent/area associated with a particular timezone", "Africa") },
                                                 { QStringLiteral("America"), i18nc("This is a continent/area associated with a particular timezone", "America") },
                                                 { QStringLiteral("Antarctica"), i18nc("This is a continent/area associated with a particular timezone", "Antarctica") },
                                                 { QStringLiteral("Asia"), i18nc("This is a continent/area associated with a particular timezone", "Asia") },
                                                 { QStringLiteral("Atlantic"), i18nc("This is a continent/area associated with a particular timezone", "Atlantic") },
                                                 { QStringLiteral("Australia"), i18nc("This is a continent/area associated with a particular timezone", "Australia") },
                                                 { QStringLiteral("Europe"), i18nc("This is a continent/area associated with a particular timezone", "Europe") },
                                                 { QStringLiteral("Indian"), i18nc("This is a continent/area associated with a particular timezone", "Indian") },
                                                 { QStringLiteral("Pacific"), i18nc("This is a continent/area associated with a particular timezone", "Pacific") } });

    m_isInitialized = true;
}
