#!/bin/bash -e

NDK="$ANDROID_NDK"

if [ "$NDK_DEBUG" == "1" ]; then
  MODE=debug
else
  MODE=release
fi

function mkjni()
{
  if [ "$NDK_DEBUG" == "1" ]; then
    ANDROID_CFLAGS="$ANDROID_CFLAGS"
  else
    ANDROID_CFLAGS="$ANDROID_CFLAGS -ffunction-sections"
  fi

  pushd ioquake3

  # XXX: ioquake3 assumes, that NOKIA="OpenGL ES"
  CC="$CC --sysroot=$SYSROOT" ANDROID_NDK_DIR="$NDK" LDFLAGS="$LDFLAGS" \
  CFLAGS="$ANDROID_CFLAGS -fno-short-enums -fpic -fstack-protector -DANDROID -DNOKIA" \
  COMPILE_ARCH=$(uname -m | sed -e s/i.86/i386/) ARCH=$ARCH make -e $MODE

  popd
}

# build ARM
ARCH=arm
TRIPLEX=arm-linux-androideabi
# API 4 is needed by native GLES
SYSROOT="$NDK/platforms/android-4/arch-arm/"
CC="$NDK/toolchains/$TRIPLEX-4.6/prebuilt/*/bin/$TRIPLEX-gcc"

mkdir -p kwaak/project/jni/prebuilt/armeabi/
mkdir -p kwaak/project/jni/prebuilt/armeabi-v7a/

# ARMv6
ANDROID_CFLAGS="-march=armv5te -mtune=xscale -msoft-float -mthumb-interwork -funwind-tables -D__ARM_ARCH_5__ -D__ARM_ARCH_5T__  -D__ARM_ARCH_5E__ -D__ARM_ARCH_5TE__"
mkjni

# ARMv6 with VFP support, sorry
cp ioquake3/build/$MODE-linux-arm/libquake3.so kwaak/project/jni/prebuilt/armeabi/libquake3.so
cp ioquake3/build/$MODE-linux-arm/libquake3.so kwaak/project/jni/prebuilt/armeabi/libquake3_vfp.so
cp ioquake3/build/$MODE-linux-arm/baseq3/{libcgamearm.so,libuiarm.so,libqagamearm.so} \
  kwaak/project/jni/prebuilt/armeabi/

rm -rf ioquake3/build/$MODE-linux-arm/*

# ARMv7
ANDROID_CFLAGS="-march=armv7-a -mfloat-abi=softfp -mfpu=vfpv3-d16 -funwind-tables"
mkjni

cp ioquake3/build/$MODE-linux-arm/libquake3.so kwaak/project/jni/prebuilt/armeabi-v7a/libquake3_vfp.so
cp ioquake3/build/$MODE-linux-arm/baseq3/{libcgamearm.so,libuiarm.so,libqagamearm.so} \
  kwaak/project/jni/prebuilt/armeabi-v7a/

rm -rf ioquake3/build/$MODE-linux-arm/*

# ARMv7 - Neon
ANDROID_CFLAGS="-mtune=cortex-a8 -mfloat-abi=softfp -mfpu=neon -funwind-tables -ftree-vectorize -fsingle-precision-constant -D__MATH_NEON"
LDFLAGS='-march=armv7-a -Wl,--fix-cortex-a8'
mkjni

# only libquake3.so is Neon-specific, rest are same for all ARM versions
cp ioquake3/build/$MODE-linux-arm/libquake3.so kwaak/project/jni/prebuilt/armeabi-v7a/libquake3_neon.so

LDFLAGS=""

# these platforms aren't yet supported by upstream

# build MIPS
ARCH=mips
TRIPLEX=mipsel-linux-android
SYSROOT="$NDK/platforms/android-9/arch-mips/"
ANDROID_CFLAGS="-march=mips32 -mhard-float"
CC="$NDK/toolchains/$TRIPLEX-4.6/prebuilt/*/bin/$TRIPLEX-gcc"
#mkjni

# build i686
ARCH=x86
TRIPLEX=i686-linux-android
SYSROOT="$NDK/platforms/android-9/arch-x86/"
# NDK docs suggest -mtune=atom, but my ancient notebook, used for testing, disagrees
ANDROID_CFLAGS="-march=i686 -mtune=pentium4 -mstackrealign -msse2 -mfpmath=sse -m32"
CC="$NDK/toolchains/$ARCH-4.6/prebuilt/*/bin/$TRIPLEX-gcc"
#mkjni
