> To survive and evade in arid or desert areas, you must understand and prepare for the environment you will face. You must determine your equipment needs, the tactics you will use, and how the environment will affect you and your tactics. Your survival will depend upon your knowledge of the terrain, basic climatic elements, your ability to cope with these elements, and your will to survive.

### TERRAIN

13-1\. Most arid areas have several types of terrain. The five basic desert terrain types are—

*  Mountainous (high altitude).
*  Rocky plateau.
*  Sand dunes.
*  Salt marshes.
*  Broken, dissected terrain ("gebel" or "wadi").

13-2\. Desert terrain makes movement difficult and demanding. Land navigation will be extremely difficult as there may be very few landmarks. Cover and concealment may be very limited; therefore, the threat of exposure to the enemy remains constant.

**MOUNTAIN DESERTS**

13-3\. Scattered ranges or areas of barren hills or mountains separated by dry, flat basins characterize mountain deserts. High ground may rise gradually or abruptly from flat areas to several thousand meters above sea level. Most of the infrequent rainfall occurs on high ground and runs off rapidly in the form of flash floods. These floodwaters erode deep gullies and ravines and deposit sand and gravel around the edges of the basins. Water rapidly evaporates, leaving the land as barren as before, although there may be short-lived vegetation. If enough water enters the basin to compensate for the rate of evaporation, shallow lakes may develop, such as the Great Salt Lake in Utah or the Dead Sea. Most of these lakes have a high salt content.

**ROCKY PLATEAU DESERTS**

13-4\. Rocky plateau deserts have relatively slight relief interspersed with extensive flat areas with quantities of solid or broken rock at or near the surface. There may be steep-walled, eroded valleys, known as wadis in the Middle East and arroyos or canyons in the United States and Mexico. Although their flat bottoms may be superficially attractive as assembly areas, the narrower valleys can be extremely dangerous to men and material due to flash flooding after rains. The Golan Heights is an example of a rocky plateau desert.

**SANDY OR DUNE DESERTS**

13-5\. Sandy or dune deserts are extensive flat areas covered with sand or gravel. "Flat" is a relative term, as some areas may contain sand dunes that are over 300 meters (1,000 feet) high and 16 to 24 kilometers (10 to 15 miles) long. Trafficability in such terrain will depend on the windward or leeward slope of the dunes and the texture of the sand. However, other areas may be flat for 3,000 meters (10,000 feet) and more. Plant life may vary from none to scrub over 2 meters (7 feet) high. Examples of this type of desert include the edges of the Sahara, the empty quarter of the Arabian Desert, areas of California and New Mexico, and the Kalahari in South Africa.

**SALT MARSHES**

13-6\. Salt marshes are flat, desolate areas, sometimes studded with clumps of grass but devoid of other vegetation. They occur in arid areas where rainwater has collected, evaporated, and left large deposits of alkali salts and water with a high salt concentration. The water is so salty it is undrinkable. A crust that may be 2.5 to 30 centimeters (1 to 12 inches) thick forms over the saltwater.

13-7\. In arid areas, there are salt marshes hundreds of kilometers square. These areas usually support many insects, most of which bite. Avoid salt marshes. This type of terrain is highly corrosive to boots, clothing, and skin. A good example is the Shatt al Arab waterway along the Iran-Iraq border.

**BROKEN TERRAIN**

13-8\. All arid areas contain broken or highly dissected terrain. Rainstorms that erode soft sand and carve out canyons form this terrain. A wadi may range from 3 meters (10 feet) wide and 2 meters (7 feet) deep to several hundred meters wide and deep. The direction it takes varies as much as its width and depth. It twists and turns and forms a mazelike pattern. A wadi will give you good cover and concealment, but do not try to move through it because it is very difficult terrain to negotiate.

### ENVIRONMENTAL FACTORS

13-9\. Surviving and evading the enemy in an arid area depends on what you know and how prepared you are for the environmental conditions you will face. Determine what equipment you will need, the tactics you will use, and the environment's impact on them and you.

13-10\. In a desert area there are seven environmental factors that you must consider—

*  Low rainfall.
*  Intense sunlight and heat.
*  Wide temperature range.
*  Sparse vegetation.
*  High mineral content near ground surface.
*  Sandstorms.
*  Mirages.

**LOW RAINFALL**

13-11\. Low rainfall is the most obvious environmental factor in an arid area. Some desert areas receive less than 10 centimeters (4 inches) of rain annually, and this rain comes in brief torrents that quickly run off the ground surface. You cannot survive long without water in high desert temperatures. In a desert survival situation, you must first consider the amount of water you have and other water sources.

**INTENSE SUNLIGHT AND HEAT**

13-12\. Intense sunlight and heat are present in all arid areas. Air temperature can rise as high as 60 degrees C (140 degrees F) during the day. Heat gain results from direct sunlight, hot blowing sand-laden winds, reflective heat (the sun's rays bouncing off the sand), and conductive heat from direct contact with the desert sand and rock ([Figure 13-1](#fig13-1)).

<a name="fig13-1"></a>![Figure 13-1\. Types of Heat Gain](fig13-01.png)

**Figure 13-1\. Types of Heat Gain**

13-13\. The temperature of desert sand and rock typically range from 16 to 22 degrees C (30 to 40 degrees F) more than that of the air. For instance, when the air temperature is 43 degrees C (110 degrees F), the sand temperature may be 60 degrees C (140 degrees F).

13-14\. Intense sunlight and heat increase the body's need for water. To conserve your body fluids and energy, you will need a shelter to reduce your exposure to the heat of the day. Travel at night to lessen your use of water.

13-15\. Radios and sensitive items of equipment exposed to direct intense sunlight will malfunction.

**WIDE TEMPERATURE RANGE**

13-16\. Temperatures in arid areas may get as high as 55 degrees C (130 degrees F) during the day and as low as 10 degrees C (50 degrees F) during the night. The drop in temperature at night occurs rapidly and will chill a person who lacks warm clothing and is unable to move about. The cool evenings and nights are the best times to work or travel. If your plan is to rest at night, you will find a wool sweater, long underwear, and a wool stocking cap extremely helpful.

**SPARSE VEGETATION**

13-17\. Vegetation is sparse in arid areas. You will therefore have trouble finding shelter and camouflaging your movements. During daylight hours, large areas of terrain are visible and easily controlled by a small opposing force.

13-18\. If traveling in hostile territory, follow the principles of desert camouflage:

*  Hide or seek shelter in dry washes (wadis) with thicker growths of vegetation and cover from oblique observation.
*  Use the shadows cast from brush, rocks, or outcroppings. The temperature in shaded areas will be 11 to 17 degrees C (52 to 63 degrees F) cooler than the air temperature.
*  Cover objects that will reflect the light from the sun.

13-19\. Before moving, survey the area for sites that provide cover and concealment. You will have trouble estimating distance. The emptiness of desert terrain causes most people to underestimate distance by a factor of three: What appears to be 1 kilometer (1/2 mile) away is really 3 kilometers (1 3/4 miles) away.

**HIGH MINERAL CONTENT**

13-20\. All arid regions have areas where the surface soil has a high mineral content (borax, salt, alkali, and lime). Material in contact with this soil wears out quickly, and water in these areas is extremely hard and undrinkable. Wetting your uniform in such water to cool off may cause a skin rash. The Great Salt Lake area in Utah is an example of this type of mineral-laden water and soil. There is little or no plant life; therefore, shelter is hard to find. Avoid these areas if possible.

**SANDSTORMS**

13-21\. Sandstorms (sand-laden winds) occur frequently in most deserts. The _Seistan_ desert wind in Iran and Afghanistan blows constantly for up to 120 days. Within Saudi Arabia, winds typically range from 3.2 to 4.8 kilometers per hour (kph) (2 to 3 miles per hour [mph]) and can reach 112 to 128 kph (67 to 77 mph) in early afternoon. Expect major sandstorms and dust storms at least once a week.

13-22\. The greatest danger is getting lost in a swirling wall of sand. Wear goggles and cover your mouth and nose with cloth. If natural shelter is unavailable, mark your direction of travel, lie down, and sit out the storm.

13-23\. Dust and wind-blown sand interfere with radio transmissions. Therefore, be ready to use other means for signaling, such as pyrotechnics, signal mirrors, or marker panels, if available.

**MIRAGES**

13-24\. Mirages are optical phenomena caused by the refraction of light through heated air rising from a sandy or stony surface. They occur in the interior of the desert about 10 kilometers (6 miles) from the coast. They make objects that are 1.5 kilometers (1 mile) or more away appear to move.

13-25\. This mirage effect makes it difficult for you to identify an object from a distance. It also blurs distant range contours so much that you feel surrounded by a sheet of water from which elevations stand out as "islands."

13-26\. The mirage effect makes it hard for a person to identify targets, estimate range, and see objects clearly. However, if you can get to high ground (3 meters [10 feet] or more above the desert floor), you can get above the superheated air close to the ground and overcome the mirage effect. Mirages make land navigation difficult because they obscure natural features. You can survey the area at dawn, dusk, or by moonlight when there is little likelihood of mirage.

13-27\. Light levels in desert areas are more intense than in other geographic areas. Moonlit nights are usually crystal clear, winds die down, haze and glare disappear, and visibility is excellent. You can see lights, red flashlights, and blackout lights at great distances. Sound carries very far.

13-28\. Conversely, during nights with little moonlight, visibility is extremely poor. Traveling is extremely hazardous. You must avoid getting lost, falling into ravines, or stumbling into enemy positions. Movement during such a night is practical only if you have a compass and have spent the day resting, observing, and memorizing the terrain, and selecting your route.

### NEED FOR WATER

13-29\. The subject of man and water in the desert has generated considerable interest and confusion since the early days of World War II when the U.S. Army was preparing to fight in North Africa. At one time, the U.S. Army thought it could condition men to do with less water by progressively reducing their water supplies during training. They called it water discipline. It caused hundreds of heat casualties.

13-30\. A key factor in desert survival is understanding the relationship between physical activity, air temperature, and water consumption. The body requires a certain amount of water for a certain level of activity at a certain temperature. For example, a person performing hard work in the sun at 43 degrees C (109 degrees F) requires 19 liters (5 gallons) of water daily. Lack of the required amount of water causes a rapid decline in an individual's ability to make decisions and to perform tasks efficiently.

13-31\. Your body's normal temperature is 36.9 degrees C (98.6 degrees F). Your body gets rid of excess heat (cools off) by sweating. The warmer your body becomes—whether caused by work, exercise, or air temperature—the more you sweat. The more you sweat, the more moisture you lose. Sweating is the principal cause of water loss. If you stop sweating during periods of high air temperature and heavy work or exercise, you will quickly develop heat stroke. This is an emergency that requires immediate medical attention.

13-32\. [Figure 13-2](#fig13-2) shows daily water requirements for various levels of work. Understanding how the air temperature and your physical activity affect your water requirements allows you to take measures to get the most from your water supply. These measures are—

*  Find shade! Get out of the sun!
*  Place something between you and the hot ground.
*  Limit your movements!
*  Conserve your sweat. Wear your complete uniform to include T-shirt. Roll the sleeves down, cover your head, and protect your neck with a scarf or similar item. These steps will protect your body from hot-blowing winds and the direct rays of the sun. Your clothing will absorb your sweat, keeping it against your skin so that you gain its full cooling effect. By staying in the shade quietly, fully clothed, not talking, keeping your mouth closed, and breathing through your nose, your water requirement for survival drops dramatically.
*  If water is scarce, do not eat. Food requires water for digestion; therefore, eating food will use water that you need for cooling.

<a name="fig13-2"></a>![Figure 13-2\. Daily Water Requirements for Three Levels of Activity](fig13-02.png)

**Figure 13-2\. Daily Water Requirements for Three Levels of Activity**

13-33\. Thirst is not a reliable guide for your need for water. A person who uses thirst as a guide will drink only two-thirds of his daily water requirement. To prevent this "voluntary" dehydration, use the following guide:

*  At temperatures below 38 degrees C (100 degrees F), drink 0.5 liter of water every hour.
*  At temperatures above 38 degrees C (100 degrees F), drink 1 liter of water every hour.

13-34\. Drinking water at regular intervals helps your body remain cool and decreases sweating. Even when your water supply is low, sipping water constantly will keep your body cooler and reduce water loss through sweating. Conserve your fluids by reducing activity during the heat of day. **Do not** ration your water! If you try to ration water, you stand a good chance of becoming a heat casualty.

### HEAT CASUALTIES

13-35\. Your chances of becoming a heat casualty as a survivor are great, due to injury, stress, and lack of critical items of equipment. Following are the major types of heat casualties and their treatment when **little** water and **no** medical help are available.

**HEAT CRAMPS**

13-36\. The loss of salt due to excessive sweating causes heat cramps. Symptoms are moderate to severe muscle cramps in legs, arms, or abdomen. These symptoms may start as a mild muscular discomfort. You should now stop all activity, get in the shade, and drink water. If you fail to recognize the early symptoms and continue your physical activity, you will have severe muscle cramps and pain. Treat as for heat exhaustion, below.

**HEAT EXHAUSTION**

13-37\. A large loss of body water and salt causes heat exhaustion. Symptoms are headache, mental confusion, irritability, excessive sweating, weakness, dizziness, cramps, and pale, moist, cold (clammy) skin. Immediately get the patient under shade. Make him lie on a stretcher or similar item about 45 centimeters (18 inches) off the ground. Loosen his clothing. Sprinkle him with water and fan him. Have him drink small amounts of water every 3 minutes. Ensure he stays quiet and rests.

**HEAT STROKE**

13-38\. An extreme loss of water and salt and your body's inability to cool itself can cause heat stroke. The patient may die if not cooled immediately. Symptoms are the lack of sweat, hot and dry skin, headache, dizziness, fast pulse, nausea and vomiting, and mental confusion leading to unconsciousness. Immediately get the person to shade. Lay him on a stretcher or similar item about 45 centimeters (18 inches) off the ground. Loosen his clothing. Pour water on him (it does not matter if the water is polluted or brackish) and fan him. Massage his arms, legs, and body. If he regains consciousness, let him drink small amounts of water every 3 minutes.

### PRECAUTIONS

13-39\. In a desert survival and evasion situation, it is unlikely that you will have a medic or medical supplies with you to treat heat injuries. Therefore, take extra care to avoid heat injuries. Rest during the day. Work during the cool evenings and nights. Use the buddy system to watch for heat injury. Observe the following guidelines:

*  Make sure you tell someone where you are going and when you will return.
*  Watch for signs of heat injury. If someone complains of tiredness or wanders away from the group, he may be a heat casualty.
*  Drink water at least once an hour.
*  Get in the shade when resting; do not lie directly on the ground.
*  Do not take off your shirt and work during the day.
*  Check the color of your urine. A light color means you are drinking enough water, a dark color means you need to drink more.

### DESERT HAZARDS

13-40\. There are several hazards unique to desert survival. These include insects, snakes, thorned plants and cacti, contaminated water, sunburn, eye irritation, and climatic stress.

13-41\. Insects of almost every type abound in the desert. Man, as a source of water and food, attracts lice, mites, wasps, and flies. They are extremely unpleasant and may carry diseases. Old buildings, ruins, and caves are favorite habitats of spiders, scorpions, centipedes, lice, and mites. These areas provide protection from the elements and also attract other wildlife. Therefore, take extra care when staying in these areas. Wear gloves at all times in the desert. Do not place your hands anywhere without first looking to see what is there. Visually inspect an area before sitting or lying down. When you get up, shake out and inspect your boots and clothing. All desert areas have snakes. They inhabit ruins, native villages, garbage dumps, caves, and natural rock outcroppings that offer shade. Never go barefoot or walk through these areas without carefully inspecting them for snakes. Pay attention to where you place your feet and hands. Most snakebites result from stepping on or handling snakes. Avoid them. Once you see a snake, give it a wide berth.
