> Some of the best and most frequently given advice, when dealing with the local population, is for you to accept, respect, and adapt to their ways. Thus, "When in Rome, do as the Romans do." This is excellent advice, but there are several considerations involved in putting this advice into practice.

### CONTACT WITH LOCAL PEOPLE

22-1\. You must give serious consideration to dealing with the local people. Do they have a primitive culture? Are they farmers, fishermen, friendly people, or enemy? In a survival situation, "cross-cultural communication" can vary radically from area to area and from people to people. It may mean interaction with people of an extremely primitive culture or contact with people who have a relatively modern culture. A culture is identified by standards of behavior that its members consider proper and acceptable but may or may not conform to your idea of what is proper. No matter who these people are, you can expect they will have laws, social and economic values, and political and religious beliefs that may be radically different from yours. Before deploying into your area of operations, study these different cultural aspects. Prior study and preparation will help you make or avoid contact if you have to deal with the local population.

22-2\. People will be friendly, unfriendly, or they will choose to ignore you. Their attitude may be unknown. If the people are known to be friendly, try to keep them friendly through your courtesy and respect for their religion, politics, social customs, habits, and all other aspects of their culture. If the people are known to be enemies or are unknowns, make every effort to avoid any contact and leave no sign of your presence. A basic knowledge of the daily habits of the local people will be essential in this attempt. If, after careful observation, you determine that an unknown people are friendly, you may contact them if you absolutely need their help.

22-3\. Usually, you have little to fear and much to gain from cautious and respectful contact with local people of friendly or neutral countries. If you become familiar with the local customs, display common decency, and most important, show respect for their customs, you should be able to avoid trouble and possibly gain needed help. To make contact, wait until only one person is near and, if possible, let that person make the initial approach. Most people will be willing to help if you appear to be in need. However, local political attitudes, instruction, or propaganda efforts may change the attitudes of otherwise friendly people. Conversely, in unfriendly countries, many people, especially in remote areas, may feel animosity toward their politicians and may be friendlier toward you.

22-4\. The key to successful contact with local people is to be friendly, courteous, and patient. Displaying fear, showing weapons, and making sudden or threatening movements can cause a local person to fear you. Such actions can prompt a hostile response. When attempting a contact, smile as often as you can. Many local people are shy and seem unapproachable, or they may ignore you. Approach them slowly and do not rush your contact.

### SURVIVAL BEHAVIOR

22-5\. Use salt, tobacco, silver money, and similar items discreetly when trading with local people. Paper money is well-known worldwide. Do not overpay; it may lead to embarrassment and even danger. Always treat people with respect. Do not bully them or laugh at them.

22-6\. Using sign language or acting out needs or questions can be very effective. Many people are used to such language and communicate using nonverbal sign language. Try to learn a few words and phrases of the local language in and around your potential area of operations. Trying to speak someone's language is one of the best ways to show respect for his culture. Since English is widely used, some of the local people may understand a few words of English.

22-7\. Some areas may be taboo. They range from religious or sacred places to diseased or danger areas. In some areas, certain animals must not be killed. Learn the rules and follow them. Watch and learn as much as possible. Such actions will help to strengthen relations and provide new knowledge and skills that may be very important later. Seek advice on local hazards and find out from friendly people where the hostile people are. Always remember that people frequently insist that other people are hostile, simply because they do not understand different cultures and distant people. The people they can usually trust are their immediate neighbors—much the same as in our own neighborhood.

22-8\. Frequently, local people, like ourselves, will suffer from contagious diseases. Build a separate shelter, if possible, and avoid physical contact without giving the impression of doing so. Personally prepare your food and drink, if you can do so without giving offense. Frequently, the local people will accept the use of "personal or religious custom" as an explanation for isolationist behavior.

22-9\. Barter, or trading, is common in more primitive societies. Hard coin is usually good, whether for its exchange value or as jewelry or trinkets. In isolated areas, matches, tobacco, salt, razor blades, empty containers, or cloth may be worth more than any form of money.

22-10\. Be very cautious when touching people. Many people consider "touching" taboo and such actions may be dangerous. Avoid sexual contact.

22-11\. Hospitality among some people is such a strong cultural trait that they may seriously reduce their own supplies to feed a stranger. Accept what they offer and share it equally with all present. Eat in the same way they eat and, most important, try to eat all they offer.

22-12\. If you make any promises, keep them. Respect personal property and local customs and manners, even if they seem odd. Make some kind of payment for food and supplies. Respect privacy. Do not enter a house unless invited.

### CHANGES TO POLITICAL ALLEGIANCE

22-13\. In today's world of fast-paced international politics, political attitudes and commitments within nations are subject to rapid change. The population of many countries, especially politically hostile countries, must not be considered friendly just because they do not demonstrate open hostility. Unless briefed to the contrary, avoid all contact with such people.
