> It takes much more than the knowledge and skills to build shelters, get food, make fires, and travel without the aid of standard navigational devices to live successfully through a survival situation. Some people with little to no survival training have managed to survive life-threatening circumstances, and some people with survival training have not used their skills and died. A key ingredient in any survival situation is the mental attitude of the individual involved. Having survival skills is important; having the will to survive is essential. Without a desire to survive, acquired skills serve little purpose and valuable knowledge goes to waste.
> 
> There is a psychology to survival. You will face many stressors in a survival environment that ultimately will affect your mind. These stressors can produce thoughts and emotions that, if poorly understood, can transform a confident, well-trained person into an indecisive, ineffective individual with questionable ability to survive. Thus, you must be aware of and be able to recognize those stressors commonly associated with survival. It is also imperative that you be aware of your reactions to the wide variety of stressors associated with survival. This chapter identifies and explains the nature of stress, the stressors of survival, and those internal reactions that you will naturally experience when faced with the stressors of a real-world survival situation. The knowledge you gain from this chapter and the remainder of this manual, will prepare you to come through the toughest times **alive**.

## A LOOK AT STRESS

Before we can understand our psychological reactions in a survival setting it is helpful to first know a little bit about stress and it's effects. Stress is not a disease that you cure and eliminate. Instead, it is a condition we all experience. Stress can be described as our reaction to pressure. It is the name given to the experience we have as we physically, mentally, emotionally, and spiritually respond to life's tensions.

### NEED FOR STRESS

We need stress because it has many positive benefits. Stress provides us with challenges; it gives us chances to learn about our values and strengths. Stress can show our ability to handle pressure without breaking. It tests our adaptability and flexibility, and can stimulate us to do our best. Because we usually do not consider unimportant events stressful, stress can also be an excellent indicator of the significance we attach to an event - in other words, it highlights what is important to us.

We need to have *some* stress in our lives, but too much of anything can be bad. The goal is to have stress, but not an *excess* of it. Too much stress can take it's toll on people and organizations. Too much stress leads to distress. Distress causes an uncomfortable tension that we try to escape or, preferably, avoid. Listed below are a few of the common signs of distress that you may encounter when faced with too much stress:

* Difficulty making decisions
* Angry outbursts
* Forgetfulness
* Low energy level
* Constant worrying
* Propensity for mistakes
* Thoughts about death or suicide
* Trouble getting along with others
* Withdrawing from others
* Hiding from responsibilities
* Carelessness

As you can see, stress can be constructive or destructive. It can encourage or discourage, move us along or stop us dead in our tracks, make life meaningful or seemingly meaningless. Stress can inspire you to operate successfully and perform at your maximum efficiency in a survival situation. It can also cause you to panic and forget all your training. The key to survival is your ability to manage the inevitable stresses you will encounter. The person that survives is one who works with her stresses instead of letting her stresses work on her.

### SURVIVAL STRESSORS

Any event can lead to stress and, as everyone has experienced, events don't always come one at a time. Often, stressful events occur simultaneously. These events are not stress, but they produce it and are called "stressors". Stressors are the obvious cause while stress is the response. Once the body recognizes the presence of a stressor, it then begins to act to protect itself.

In response to a stressor, the body prepares either to defend itself or escape, often called our "fight or flight" instinct. This preparation involves an internal 'SOS signal' sent throughout the body. As the body responds to this 'SOS signal', the following actions take place:

* The body releases stored fuels (sugar and fats) to provide quick energy.
* Breathing rate increases to supply more oxygen to the blood.
* Muscle tension increases to prepare for action.
* Blood clotting mechanisms are activated to reduce bleeding from cuts.
* Senses become more acute (hearing becomes more sensitive, pupils dilate, sense of smell becomes sharper) so that you are more aware of your surroundings.
* Heart rate and blood pressure rise to provide more blood to the muscles.

This protective posture lets you cope with potential dangers. However, you cannot maintain this level of alertness indefinitely.

Stressors are not courteous; one stressor does not leave because another one arrives. Stressors add up. The cumulative effect of minor stressors can be a major distress if they all happen too close together. As the body's resistance to stress wears down and the sources of stress continue (or increase), eventually a state of exhaustion occurs. At this point, the ability to resist stress or use it in a positive way gives out and signs of distress appear. Anticipating stressors and developing strategies to cope with them are two ingredients in the effective management of stress. Therefore, it is essential that you be aware of the types of stressors that you will encounter. The following paragraphs explain a few of these.

### Injury, Illness, or Death

Injury, illness, and death are real possibilities that you have to face. Perhaps nothing is more stressful than being alone in an unfamiliar environment where you could die from hostile action, an accident, or from eating something lethal. Illness and injury can also add to stress by limiting your ability to maneuver, get food and drink, find shelter, and defend yourself. Even if illness and injury don't lead to death, they add to stress through the pain and discomfort they generate. It is only by controlling the stress associated with the vulnerability to injury, illness, and death that you can have the courage to take the risks associated with survival tasks.

### Uncertainty and Lack of Control

Some people have trouble operating in settings where everything is not clear-cut. The only guarantee in a survival situation is that nothing is guaranteed. It can be extremely stressful operating on limited information in a setting where you also have limited control of your surroundings. This uncertainty and lack of control also add to the stress of being ill or injured.

### Environment

Even under the most ideal circumstances nature is quite formidable. In survival, you will have to contend with the stressors of weather, terrain, and the variety of creatures inhabiting an area. Extreme temperatures, natural disasters, mountains, swamps, deserts, poisonous flora and fauna, predators, and any other harmful animal are just a few of the challenges that you will encounter while working to survive. Depending on how you handle the stress of your environment, your surroundings can be either a source of shelter and reward, or can be extremely hazardous, leading to injury, illness or death.

### Hunger and Thirst

Without food and water you will weaken and eventually die. Thus, getting and preserving food and water takes on increasing importance as the length of time in a survival setting increases. Foraging can also be a big source of stress since you are used to having your provisions issued.

### Fatigue

Forcing yourself to continue surviving is not easy as you grow more tired. It is possible to become so fatigued that the act of just staying awake is stressful in itself.

### Isolation

There are some advantages to facing adversity with others. Being in contact with others provides a greater sense of security and a feeling that someone is available to help if problems occur. A significant stressor in survival situations is that often you have to rely solely on your own resources.

The survival stressors mentioned in this section are by no means the only ones you may face. Remember: what is stressful to one person may not be stressful to another. Your experiences, training, personal outlook on life, physical and mental conditioning, and level of self-confidence contribute to what you will find stressful in a survival environment. The object is not to avoid stress, but rather to manage the stressors of survival and make them work for you.

We now have a general knowledge of stress and the stressors common to survival. The next step is to examine your reactions to the stressors you may face.

## NATURAL REACTIONS

Humans have been able to survive many shifts in their environment throughout the centuries. The ability to adapt physically and mentally to a changing world kept us alive while other species around us gradually died off. The same survival mechanisms that kept our ancestors alive can help keep you alive as well! However, the survival mechanisms that can help you can also work against you if you do not understand and anticipate their presence.

It is not surprising that the average person will have some psychological reactions in a survival situation. The following paragraphs explain some of the major internal reactions that you or anyone with you might experience with the previously stated survival stressors.

### FEAR

Fear is our emotional response to dangerous circumstances that we believe have the potential to cause death, injury, or illness. This harm is not just limited to physical damage; the threat to your emotional and mental well-being can generate fear as well. If you are trying to survive, fear can have a positive function if it encourages you to be cautious in situations where recklessness could result in injury. Unfortunately, fear can also immobilize you. It can cause you to become so frightened that you fail to perform activities essential for survival. Most people will have some degree of fear when placed in unfamiliar surroundings under adverse conditions. There is no shame in this! You must train yourself not to be overcome by your fears. Ideally, through realistic training, you can acquire the knowledge and skills needed to increase your confidence and thereby manage your fears.

### ANXIETY

Associated with fear is anxiety. Because it is natural for you to be afraid, it is also natural for you to experience anxiety. Anxiety can be an uneasy, apprehensive feeling you get when faced with dangerous situations (physical, mental, and emotional). When used in a healthy way, anxiety can urge you to act to end (or at least master) the dangers that threaten your existence. If you were never anxious there would be little motivation to make changes in your life. In a survival setting, you can reduce your anxiety by performing those tasks that will ensure you come through the ordeal alive. As you reduce your anxiety you also bring under control the source of that anxiety: your fears. In this form anxiety is good; however, anxiety can also have a devastating impact. Anxiety can overwhelm you to the point where you become easily confused and have difficulty thinking. Once this happens, it will become increasingly difficult for you to make good judgements and sound decisions. To survive you must learn techniques to calm your anxieties and keep them in the range where they help, not hurt.

### ANGER AND FRUSTRATION

Frustration arises when you are continually thwarted in your attempts to reach a goal. The goal of survival is to stay alive until you can reach help or until help can reach you. To achieve this goal, you must complete some tasks with minimal resources. It is inevitable, in trying to do these tasks, that something will go wrong; that something will happen beyond your control; and that with your life at stake, every mistake is magnified in terms of it's importance. Thus, eventually, you will have to cope with frustration when a few of your plans run into trouble. One outgrowth of this frustration is anger. There are many events in a survival situation that can frustrate or anger you. Getting lost, damaged or forgotten equipment, the weather, inhospitable terrain, enemy patrols, and physical limitations are just a few sources of frustration and anger. Frustration and anger generate impulsive reactions, irrational behaviour, poorly thought-out decisions, and, in some instances, an "I quit" attitude (people sometimes avoid doing something they can't master). If you can harness and properly channel the emotional intensity associated with anger and frustration, you can productively act as you answer the challenges of survival. If you do not properly focus your angry feelings, you can waste much energy in activities that do little to further either your chances of survival or the chances of those around you.

### DEPRESSION

You would be a rare person indeed if you did not get sad, at least momentarily, when faced with the hardships of survival. As this sadness deepens, it becomes "depression". Depression is closely linked with frustration and anger. Frustration will cause you to become increasingly angry as you fail to reach your goals. If the anger does not help you succeed then the frustration level goes even higher. A destructive cycle between anger and frustration will continue until you become worn down physically, emotionally, and mentally. When you reach this point you start to give up and your focus shifts from "What can I do?" to "There is nothing I can do". Depression is an expression of this hopeless, helpless feeling. There is nothing wrong with being sad as you temporarily think about your loved ones and remember what life is like back in "civilization" or "the world". Such thoughts can, in fact, give you the desire to try harder and live one more day. On the other hand, if you allow yourself to sink into a depressed state, then it can sap all your energy and, more importantly, your will to survive. It is imperative that you resist succumbing to depression.

### LONELINESS AND BOREDOM

Human beings are social animals. Human beings enjoy the company of others. Very few people want to be alone all the time! There is a distinct chance of isolation in a survival setting. Isolation is not bad. Loneliness and boredom can bring to the surface qualities you thought only others had. The extent of your imagination and creativity may surprise you. When required to do so you may discover some hidden talents and abilities. Most of all, you may tap into a reservoir of inner strength and fortitude you never knew you had. Conversely, loneliness and boredom can be another source of depression. Whether surviving alone or with others you must find ways to keep your mind productively occupied. Additionally, you must develop a degree of self-sufficiency. You must have faith in your capability to "go it alone".

### GUILT

The circumstances leading to your being in a survival setting are sometimes dramatic and tragic. It may be the result of an accident or military mission where there was a loss of life. Perhaps you were the only survivor or one of a few survivors. While naturally relieved to be alive, you may be simultaneously mourning the deaths of others who were less fortunate. It is not uncommon for survivors to feel guilty about being spared from death while others were not. This feeling, when used in a positive way, has encouraged people to try harder to survive with the belief they were allowed to live for some greater purpose in life. Sometimes survivors tried to stay alive so that they could carry on the work of those killed. Whatever reason you give yourself, do not let guilty feelings prevent you from living. The living who abandon their chance to survive accomplish nothing. Such an act would be the greatest tragedy.

## PREPARING YOURSELF

Your mission in a survival situation is to stay alive. The assortment of thoughts and emotions you will experience in a survival situation can work for you, or they can work to your downfall. Fear, anxiety, anger, frustration, guilt, depression, and loneliness are all possible reactions to the many stressors common to survival. These reactions, when controlled in a healthy way, help to increase your likelihood of surviving. They prompt you to pay more attention in training, to fight back when scared, to take actions that ensure sustenance and security, to keep faith with your fellow team members, and to strive against large odds. When you cannot control these reactions in a healthy way they can bring you to a standstill. Instead of rallying your internal resources you listen to your internal fears. These fears will cause you to experience psychological defeat long before you physically succumb. Remember: survival is natural to everyone! Being unexpectedly thrust into the life-or-death struggle of survival is not. Do not be afraid of your "natural" reactions to this unnatural situation. Prepare yourself to rule over these reactions so they serve your ultimate interest: staying alive with honour and dignity.

Being prepared involves knowing that your reactions in a survival setting are likely to be productive, not destructive. The challenge of survival has produced countless examples of heroism, courage, and self-sacrifice. These are the qualities a survival situation can bring out in you if you have prepared yourself. Below are a few tips to help prepare yourself psychologically for survival. Through studying this manual and attending survival training you can develop the "survival attitude".

### KNOW YOURSELF

You should take the time to discover who you are on the inside. Strengthen your stronger qualities and develop the areas that you know are necessary to survive.

### ANTICIPATE FEARS

Don't pretend that you will have no fears. Begin thinking about what would frighten you the most if forced to survive alone. Train in those areas of concern to you. The goal is not to eliminate the fear, but to build confidence in your ability to function despite your fears.

### BE REALISTIC

Don't be afraid to make an honest appraisal of situations. See circumstances as they are, not as you want them to be. Keep your hopes and expectations within the estimate of the situation. When you go into a survival setting with unrealistic expectations you may be laying the groundwork for bitter disappointment. Follow the adage: "Hope for the best, prepare for the worst". It is much easier to adjust to pleasant surprises about your unexpected good fortunes than to be upset by your unexpected harsh circumstances.

### ADOPT A POSITIVE ATTITUDE

Learn to see the potential good in everything. Looking for the good not only boosts morale, it also is excellent for exercising your imagination and creativity. This is not only the case in a survival situation but through all of your life.

### REMIND YOURSELF OF WHAT IS AT STAKE

Failure to prepare yourself psychologically to cope with survival leads to reactions such as depression, carelessness, inattention, loss of confidence, poor decision making and giving up before the body gives in. Remember that your life and the lives of others who depend on you are at stake.

### TRAIN

Begin today to prepare yourself to cope with the rigours of survival. Demonstrating your skills in life will give you the confidence to call upon them should the need arise. Remember: the more realistic the training, the less overwhelming an actual survival setting will be.

### LEARN STRESS MANAGEMENT TECHNIQUES

People under stress have a potential to panic if they are not well-trained and not prepared psychologically to face whatever the circumstances may be. While you often cannot control the survival circumstances in which you find yourself, it is within your ability to control your response to those circumstances. Learning stress management techniques can significantly enhance your capability to remain calm and focused as you work to keep yourself and others alive. A few good techniques to develop include relaxation skills, time management skills, assertiveness skills, and cognitive restructuring skills (the ability to control how you view a situation). Remember: **the will to survive** can also be considered **the refusal to give up**.