> Most people think of the tropics as a huge and forbidding tropical rain forest through which every step taken must be hacked out, and where every inch of the way is crawling with danger. Actually, over half of the land in the tropics is cultivated in some way.
> 
> A knowledge of field skills, the ability to improvise, and the application of the principles of survival will increase the prospects of survival. Do not be afraid of being alone in the jungle; fear will lead to panic. Panic will lead to exhaustion and decrease your chance of survival.
> 
> Everything in the jungle thrives, including disease germs and parasites that breed at an alarming rate. Nature will provide water, food, and plenty of materials to build shelters.
> 
> Indigenous peoples have lived for millennia by hunting and gathering. However, it will take an outsider some time to get used to the conditions and the nonstop activity of tropical survival.

### TROPICAL WEATHER

High temperatures, heavy rainfall, and oppressive humidity characterize equatorial and subtropical regions, except at high altitudes. At low altitudes, temperature variation is seldom less than 10 degrees C (50 degrees F) and is often more than 35 degrees C (95 degrees F). At altitudes over 1,500 meters (4,921 feet), ice often forms at night. The rain has a cooling effect, but when it stops, the temperature soars.

Rainfall is heavy, often with thunder and lightning. Sudden rain beats on the tree canopy, turning trickles into raging torrents and causing rivers to rise. Just as suddenly, the rain stops. Violent storms may occur, usually toward the end of the summer months.

Hurricanes, cyclones, and typhoons develop over the sea and rush inland, causing tidal waves and devastation ashore. In choosing campsites, make sure you are above any potential flooding. Prevailing winds vary between winter and summer. The dry season has rain once a day and the monsoon has continuous rain. In Southeast Asia, winds from the Indian Ocean bring the monsoon, but the area is dry when the wind blows from the landmass of China.

Tropical day and night are of equal length. Darkness falls quickly and daybreak is just as sudden.

### JUNGLE TYPES

There is no standard jungle. The tropical area may be any of the following:

* Rain forests.
* Secondary jungles.
* Semievergreen seasonal and monsoon forests.
* Scrub and thorn forests.
* Savannas.
* Saltwater swamps.
* Freshwater swamps.

**TROPICAL RAIN FORESTS**

The climate varies little in rain forests. You find these forests across the equator in the Amazon and Congo basins, parts of Indonesia, and several Pacific islands. Up to 3.5 meters (12 feet) of rain falls throughout the year. Temperatures range from about 32 degrees C (90 degrees F) in the day to 21 degrees C (70 degrees F) at night.

There are five layers of vegetation in this jungle ([Figure 14-1](#fig14-1)). Where untouched by man, jungle trees rise from buttress roots to heights of 60 meters (198 feet). Below them, smaller trees produce a canopy so thick that little light reaches the jungle floor. Seedlings struggle beneath them to reach light, and masses of vines and lianas twine up to the sun. Ferns, mosses, and herbaceous plants push through a thick carpet of leaves, and a great variety of fungi grow on leaves and fallen tree trunks.

<a name="fig14-1"></a>![Figure 14.1\. Five Layers of Tropical Rain Forest Vegetation](fig14-01.png)

**Figure 14-1\. Five Layers of Tropical Rain Forest Vegetation**

Because of the lack of light on the jungle floor, there is little undergrowth to hamper movement, but dense growth limits visibility to about 50 meters (165 feet). You can easily lose your sense of direction in this jungle, and it is extremely hard for aircraft to see you.

**SECONDARY JUNGLES**

Secondary jungle is very similar to rain forest. Prolific growth, where sunlight penetrates to the jungle floor, typifies this type of forest. Such growth happens mainly along riverbanks, on jungle fringes, and where man has cleared rain forest. When abandoned, tangled masses of vegetation quickly reclaim these cultivated areas. You can often find cultivated food plants among this vegetation.

**SEMIEVERGREEN SEASONAL AND MONSOON FORESTS**

The characteristics of the American and African semievergreen seasonal forests correspond with those of the Asian monsoon forests. The characteristics are as follows:

* Their trees fall into two stories of tree strata. Those in the upper story range from 18 to 24 meters (60 to 79 feet); those in the lower story range from 7 to 13 meters (23 to 43 feet).
* The diameter of the trees averages 0.5 meter (2 feet).
* Their leaves fall during a seasonal drought.

Except for the sago, nipa, and coconut palms, the same edible plants grow in these areas as in the tropical rain forests.

You find these forests in portions of Columbia and Venezuela and the Amazon basin in South America; in portions of southeast coastal Kenya, Tanzania, and Mozambique in Africa; in Northeastern India, much of Burma, Thailand, Indochina, Java, and parts of other Indonesian islands in Asia.

**TROPICAL SCRUB AND THORN FORESTS**

The chief characteristics of tropical scrub and thorn forests are as follows:

* There is a definite dry season.
* Trees are leafless during the dry season.
* The ground is bare except for a few tufted plants in bunches; grasses are uncommon.
* Plants with thorns predominate.
* Fires occur frequently.

You find tropical scrub and thorn forests on the west coast of Mexico, the Yucatan peninsula, Venezuela, and Brazil; on the northwest coast and central parts of Africa; and in Turkestan and India in Asia.

Within the tropical scrub and thorn forest areas, you will find it hard to obtain food plants during the dry season. During the rainy season, plants are considerably more abundant.

**TROPICAL SAVANNAS**

General characteristics of the savanna are that it:

* Is found within the tropical zones in South America and Africa.
* Looks like a broad, grassy meadow, with trees spaced at wide intervals.
* Frequently has red soil.
* Grows scattered trees that usually appear stunted and gnarled like apple trees. Palms also occur on savannas.

You find savannas in parts of Venezuela, Brazil, and the Guianas in South America. In Africa, you find them in the southern Sahara (north-central Cameroon and Gabon and southern Sudan), Benin, Togo, most of Nigeria, northeastern Republic of Congo, northern Uganda, western Kenya, part of Malawi, part of Tanzania, southern Zimbabwe, Mozambique, and western Madagascar.

**SALTWATER SWAMPS**

Saltwater swamps are common in coastal areas subject to tidal flooding. Mangrove trees thrive in these swamps. Mangrove trees can reach heights of 12 meters (39 feet). Their tangled roots are an obstacle to movement. Visibility in this type of swamp is poor, and movement is extremely difficult. Sometimes, streams that you can raft form channels, but you usually must travel on foot through this swamp.

You find saltwater swamps in West Africa, Madagascar, Malaysia, the Pacific islands, Central and South America, and at the mouth of the Ganges River in India. The swamps at the mouths of the Orinoco and Amazon rivers and rivers of Guyana consist of mud and trees that offer little shade. Tides in saltwater swamps can vary as much as 12 meters (3 feet).

Everything in a saltwater swamp may appear hostile to you, from leeches and insects to crocodiles and caimans. Avoid the dangerous animals in this swamp.

Avoid this swamp altogether if you can. If there are water channels through it, you may be able to use a raft to escape.

**FRESHWATER SWAMPS**

You find freshwater swamps in low-lying inland areas. Their characteristics are masses of thorny undergrowth, reeds, grasses, and occasional short palms that reduce visibility and make travel difficult. There are often islands that dot these swamps, allowing you to get out of the water. Wildlife is abundant in these swamps.

### TRAVEL THROUGH JUNGLE AREAS

With practice, movement through thick undergrowth and jungle can be done efficiently. Always wear long sleeves to avoid cuts and scratches.

To move easily, you must develop "jungle eye," that is, you should not concentrate on the pattern of bushes and trees to your immediate front. You must focus on the jungle further out and find natural breaks in the foliage. Look _through_ the jungle, not at it. Stop and stoop down occasionally to look along the jungle floor. This action may reveal game trails that you can follow.

Stay alert and move slowly and steadily through dense forest or jungle. Stop periodically to listen and take your bearings. Use a machete to cut through dense vegetation, but do not cut unnecessarily or you will quickly wear yourself out. If using a machete, stroke upward when cutting vines to reduce noise because sound carries long distances in the jungle. Use a stick to part the vegetation. Using a stick will also help dislodge biting ants, spiders, or snakes. **Do not** grasp at brush or vines when climbing slopes; they may have irritating spines or sharp thorns.

Many jungle and forest animals follow game trails. These trails wind and cross, but frequently lead to water or clearings. Use these trails if they lead in your desired direction of travel.

In many countries, electric and telephone lines run for miles through sparsely inhabited areas. Usually, the right-of-way is clear enough to allow easy travel. When traveling along these lines, be careful as you approach transformer and relay stations. In enemy territory, they may be guarded.

Movement through jungles or dense vegetation requires you to constantly be alert and aware of your surroundings. The following travel tips will help you succeed:

* Pinpoint your initial location as accurately as possible to determine a general line of travel to safety. If you do not have a compass, use a field-expedient direction-finding method.
* Take stock of water supplies and equipment.
* Move in one direction, but not necessarily in a straight line. Avoid obstacles. In enemy territory, take advantage of natural cover and concealment.
* Move smoothly through the jungle. Do not blunder through it since you will get many cuts and scratches. Turn your shoulders, shift your hips, bend your body, and shorten or lengthen your stride as necessary to slide between the undergrowth.

### IMMEDIATE CONSIDERATIONS

There is less likelihood of your rescue from beneath a dense jungle canopy than in other survival situations. You will probably have to travel to reach safety.

If you are the victim of an aircraft crash, the most important items to take with you from the crash site are a machete, a compass, a first aid kit, and a parachute or other material for use as mosquito netting and shelter.

Take shelter from tropical rain, sun, and insects. Malaria-carrying mosquitoes and other insects are immediate dangers, so protect yourself against bites.

Do not leave the crash area without carefully blazing or marking your route. Use your compass. Know what direction you are taking.

In the tropics, even the smallest scratch can quickly become dangerously infected. Promptly treat any wound, no matter how minor.

### WATER PROCUREMENT

Although water is abundant in most tropical environments, you may have trouble finding it. If you do find water, it may not be safe to drink. Some of the many sources are vines, roots, palm trees, and condensation. You can sometimes follow animals to water. Often you can get nearly clear water from muddy streams or lakes by digging a hole in sandy soil about 1 meter (3 feet) from the bank. Water will seep into the hole. You must purify any water obtained in this manner.

**ANIMALS—SIGNS OF WATER**

Animals can often lead you to water. Most animals require water regularly. Grazing animals, such as deer, are usually never far from water and usually drink at dawn and dusk. Converging game trails often lead to water. Carnivores (meat eaters) are not reliable indicators of water. They get moisture from the animals they eat and can go without water for long periods.

Birds can sometimes also lead you to water. Grain eaters, such as finches and pigeons, are never far from water. They drink at dawn and dusk. When they fly straight and low, they are heading for water. When returning from water, they are full and will fly from tree to tree, resting frequently. Do not rely on water birds to lead you to water. They fly long distances without stopping. Hawks, eagles, and other birds of prey get liquids from their victims; you cannot use them as a water indicator.

Insects, especially bees, can be good indicators of water. Bees seldom range more than 6 kilometers (4 miles) from their nests or hives. They will usually have a water source in this range. Ants need water. A column of ants marching up a tree is going to a small reservoir of trapped water. You find such reservoirs even in arid areas. Most flies, especially the European mason fly, stay within 100 meters (330 feet) of water. This fly is easily recognized by its iridescent green body.

Human tracks will usually lead to a well, bore hole, or soak. Scrub or rocks may cover it to reduce evaporation. Replace the cover after use.

**WATER—FROM PLANTS**

You will encounter many types of vegetation in a survival situation depending upon your area. Plants such as vines, roots, and palm trees are good sources of water.

**Vines**

Vines with rough bark and shoots about 5 centimeters (2 inches) thick can be a useful source of water. You must learn by experience which are the water-bearing vines, because not all have drinkable water. Some may even have a poisonous sap. The poisonous ones yield a sticky, milky sap when cut. Nonpoisonous vines will give a clear fluid. Some vines cause a skin irritation on contact; therefore let the liquid drip into your mouth, rather than put your mouth to the vine. Preferably, use some type of container. Use the procedure described in [Chapter Water](Water) to obtain water from a vine.

**Roots**

In Australia, the water tree, desert oak, and bloodwood have roots near the surface. Pry these roots out of the ground and cut them into 30-centimeter (1-foot) lengths. Remove the bark and suck out the moisture, or shave the root to a pulp and squeeze it over your mouth.

**Palm Trees**

The buri, coconut, and nipa palms all contain a sugary fluid that is very good to drink. To obtain the liquid, bend a flowering stalk of one of these palms downward, and cut off its tip. If you cut a thin slice off the stalk every 12 hours, the flow will renew, making it possible to collect up to a liter per day. Nipa palm shoots grow from the base, so that you can work at ground level. On grown trees of other species, you may have to climb them to reach a flowering stalk. Milk from coconuts has a large water content, but may contain a strong laxative in ripe nuts. Drinking too much of this milk may cause you to lose more fluid than you drink.

**WATER—FROM CONDENSATION**

Often it requires too much effort to dig for roots containing water. It may be easier to let a plant produce water for you in the form of condensation. Tying a clear plastic bag around a green leafy branch will cause water in the leaves to evaporate and condense in the bag. Placing cut vegetation in a plastic bag will also produce condensation. This is a solar still ([Chapter Water](Water)).

### FOOD

Food is usually abundant in a tropical survival situation. To obtain animal food, use the procedures outlined in [Chapter Food](Food).

In addition to animal food, you will have to supplement your diet with edible plants. The best places to forage are the banks of streams and rivers. Wherever the sun penetrates the jungle, there will be a mass of vegetation, but riverbanks may be the most accessible areas.

If you are weak, do not expend energy climbing or felling a tree for food. There are more easily obtained sources of food nearer the ground. Do not pick more food than you need. Food spoils rapidly in tropical conditions. Leave food on the growing plant until you need it, and eat it fresh.

There are an almost unlimited number of edible plants from which to choose. Unless you can positively identify these plants, it may be safer at first to begin with palms, bamboos, and common fruits.

### POISONOUS PLANTS

The proportion of poisonous plants in tropical regions is no greater than in any other area of the world. However, it may appear that most plants in the tropics are poisonous because of the great density of plant growth in some tropical areas.
