> Water is one of your most urgent needs in a survival situation. You can't live long without it, especially in hot areas where you lose water rapidly through perspiration. Even in cold areas, you need a minimum of 2 liters of water each day to maintain efficiency.
> 
> More than three-fourths of your body is composed of fluids. Your body loses fluid because of heat, cold, stress, and exertion. To function effectively, you must replace the fluid your body loses. So, one of your first goals is to obtain an adequate supply of water.

### WATER SOURCES

Almost any environment has water present to some degree. Possible sources of water in various environments are listed below. Information on how to make the water potable is provided as well.

**NOTE:** If you do not have a canteen, cup, can, or other type of container, improvise one from plastic or water-resistant cloth. Shape the plastic or cloth into a bowl by pleating it. Use pins or other suitable items—even your hands—to hold the pleats.

* **Frigid areas**
  * **Snow and ice**
    * **Means of obtaining and/or making potable:** Melt and purify.
    * **Remarks:** Do not eat without melting! Eating snow or ice can reduce body temperature and lead to more dehydration.
Snow or ice are no purer than the water from which they come.
Sea ice that is gray in color or opaque is salty. Do not use it without desalting it. Sea ice that is crystalline with a bluish cast has littler salt in it.
* **At sea**
  * **Sea**
    * **Means of obtaining and/or making potable:** Use desalinator.
    * **Remarks:** Do not drink seawater without desalting!
  * **Rain**
    * **Means of obtaining and/or making potable:** Catch rain in tarps or in other water-holding containers.
    * **Remarks:** If tarp or water-holding material is coated with salt, wash it in the sea before using (less salt will remain on it).
  * **Sea ice**
    * **Remarks:** See previous remarks for frigid areas.
* **Beach**
  * **Ground**
    * **Means of obtaining and/or making potable:** Dig hole deep enough to allow water to seep in; obtain rocks, build fire, and heat rocks; drop hot rocks in water; hold cloth over hole to absorb steam; wring water from cloth.
    * **Remarks:** Alternate method if a container or bark pot is available: Fill container or pot with seawater; build fire and boil water to produce steam; hold a cloth over the container to absorb steam; wring water from the cloth.
  * **Fresh**
    * **Means of obtaining and/or making potable:** Dig behind the first group of sand dunes. This will allow the collection of freshwater.
* **Desert**
  * **Sources of water:**
    * In valleys and low areas
    * At foot of concave banks of dry rivers
    * At foot of cliffs or rock outcrops
    * At first depression behind first sand dune of dry lakes
    * Wherever you find damp sand surface sand
    * Wherever you find green vegetation
  * **Means of obtaining and/or making potable:** Dig holes deep enough to allow water to seep in.
  * **Remarks:** In a sand dune belt, any available water will be found beneath the original valley floow at the edge of dunes.
* **Desert (extended)**
  * **Cacti**
    * **Means of obtaining and/or making potable:** Cut off the top of a barrel cactus and mash or squeeze the pulp.
**CAUTION: Do not eat pulp. Place pulp in mouth, suck out juice, and discard pulp.**
    * **Remarks:** Without a machete, cutting into a cactus is difficult and takes time since you must get past the long, strong spines and cut through the tough rind.
  * **Depressions or holes in rocks**
    * **Remarks:** Periodic rainfall may collect in pools, seep into fissures, or collect in holes in rocks.
  * **Fissures in rock**
    * **Means of obtaining and/or making potable:** Insert flexible tubing and siphon water. If fissure is large enough, you can lower a container into it.
  * **Porous rock**
    * **Means of obtaining and/or making potable:** Insert flexible tubing and siphon water.
  * **Condensation on metal**
    * **Means of obtaining and/or making potable:** Use cloth to absorb water, then wring water from cloth.
    * **Remarks:** Extreme temperature variations between night and day may cause condensation on metal surfaces. Following are signs to watch for in the desert to help you find water:
      * All trails lead to water. You should follow in the direction in which the trails converge. Signs of camps, campfire ashes, animal droppings, and trampled terrain may mark trails.
      * Flocks of birds will circle over water holes. Some birds fly to water holes at dawn and sunset. Their flight at these times is usually fast and close to the ground. Bird tracks or chirping sounds in the evening or early morning sometimes indicate that water is nearby.

If you do not have a reliable source to replenish your water supply, stay alert for ways in which your environment can help you.

> **CAUTION**
> 
> DO NOT substitute the following harmful fluids for water.

Fluid | Remarks
----- | ------
Alcoholic beverages | Dehydrate the body and cloud judgement.
Urine | Contains harmful body wastes. Is about 2 percent salt.
Blood | Is salty and considered a food; therefore, requires additional body fluids to digest. May transmit disease.
Seawater | Is about 4 percent salt. It takes about 2 liters of body fluids to rid the body of waster from 1 liter of seawater. Therefore, by drinking seawater, you deplete your body's water supply, which can cause death.

Heavy dew can provide water. Tie rags or tufts of fine grass around your ankles and walk through dew-covered grass before sunrise. As the rags or grass tufts absorb the dew, wring the water into a container. Repeat the process until you have a supply of water or until the dew is gone. Australian natives sometimes mop up as much as 1 liter an hour this way.

Bees or ants going into a hole in a tree may point to a water-filled hole. Siphon the water with plastic tubing or scoop it up with an improvised dipper. You can also stuff cloth in the hole to absorb the water and then wring it from the cloth.

Water sometimes gathers in tree crotches or rock crevices. Use the above procedures to get the water. In arid areas, bird droppings around a crack in the rocks may indicate water in or near the crack.

Green bamboo thickets are an excellent source of fresh water. Water from green bamboo is clear and odorless. To get the water, bend a green bamboo stalk, tie it down, and cut off the top ([Figure 6-3](#fig6-3)). The water will drip freely during the night. Old, cracked bamboo may also contain water.

<a name="fig6-3"></a>![Figure 6-3\. Water From Green Bamboo](fig06-03.png)

**Figure 6-3\. Water From Green Bamboo**

> **CAUTION**
> 
> Purify the water before drinking it.

Wherever you find banana trees, plantain trees, or sugarcane, you can get water. Cut down the tree, leaving about a 30-centimeter (12-inch) stump, and scoop out the center of the stump so that the hollow is bowl-shaped. Water from the roots will immediately start to fill the hollow. The first three fillings of water will be bitter, but succeeding fillings will be palatable. The stump ([Figure 6-4](#fig6-4)) will supply water for up to 4 days. Be sure to cover it to keep out insects.

<a name="fig6-4"></a>![Figure 6-4\. Water From Plantain or Banana Tree Stump](fig06-04.png)

**Figure 6-4\. Water From Plantain or Banana Tree Stump**

Some tropical vines can give you water. Cut a notch in the vine as high as you can reach, then cut the vine off close to the ground. Catch the dropping liquid in a container or in your mouth ([Figure 6-5](#fig6-5)).

> **CAUTION**
> 
> Ensure that the vine is not poisonous.

<a name="fig6-5"></a>![Figure 6-5\. Water From a Vine](fig06-05.png)

**Figure 6-5\. Water From a Vine**

The milk from young, green (unripe) coconuts is a good thirst quencher. However, the milk from mature, brown, coconuts contains an oil that acts as a laxative. Drink in moderation only.

> **CAUTION**
> 
> Do not drink the liquid if it is sticky, milky, or bitter tasting.

In the American tropics you may find large trees whose branches support air plants. These air plants may hold a considerable amount of rainwater in their overlapping, thickly growing leaves. Strain the water through a cloth to remove insects and debris.

You can get water from plants with moist pulpy centers. Cut off a section of the plant and squeeze or smash the pulp so that the moisture runs out. Catch the liquid in a container.

Plant roots may provide water. Dig or pry the roots out of the ground, cut them into short pieces, and smash the pulp so that the moisture runs out. Catch the liquid in a container.

Fleshy leaves, stems, or stalks, such as bamboo, contain water. Cut or notch the stalks at the base of a joint to drain out the liquid.

The following trees can also provide water:

* _Palms._ The buri, coconut, sugar, rattan, and nips contain liquid. Bruise a lower frond and pull it down so the tree will "bleed" at the injury.
* _Traveler's tree._ Found in Madagascar, this tree has a cuplike sheath at the base of its leaves in which water collects.
* _Umbrella tree._ The leaf bases and roots of this tree of western tropical Africa can provide water.
* _Baobab tree._ This tree of the sandy plains of northern Australia and Africa collects water in its bottlelike trunk during the wet season. Frequently, you can find clear, fresh water in these trees after weeks of dry weather.

> **CAUTION**
> 
> Do not keep the sap from plants longer than 24 hours. It begins fermenting, becoming dangerous as a water source.

### STILL CONSTRUCTION

You can use stills in various areas of the world. They draw moisture from the ground and from plant material. You need certain materials to build a still, and you need time to let it collect the water. It takes about 24 hours to get 0.5 to 1 liter of water.

**ABOVEGROUND STILLS**

You can construct two types of aboveground stills. To make the **vegetation bag still**, you need a sunny slope on which to place the still, a clear plastic bag, green leafy vegetation, and a small rock ([Figure 6-6](#fig6-6)).

<a name="fig6-6"></a>![Figure 6-6\. Vegetation Bag Still](fig06-06.png)

**Figure 6-6\. Vegetation Bag Still**

To make the still, you should:

* Fill the bag with air by turning the opening into the breeze or by "scooping" air into the bag.
* Fill the plastic bag one-half to three-fourths full of green leafy vegetation. Be sure to remove all hard sticks or sharp spines that might puncture the bag.
* Place a small rock or similar item in the bag.
* Close the bag and tie the mouth securely as close to the end of the bag as possible to keep the maximum amount of air space. If you have a piece of tubing, a small straw, or a hollow reed, insert one end in the mouth of the bag before you tie it securely. Then tie off or plug the tubing so that air will not escape. This tubing will allow you to drain out condensed water without untying the bag.

> **CAUTION**
> 
> Do not use poisonous vegetation. It will provide poisonous liquid.

* Place the bag, mouth downhill, on a slope in full sunlight. Position the mouth of the bag slightly higher than the low point in the bag.
* Settle the bag in place so that the rock works itself into the low point in the bag.

To get the condensed water from the still, loosen the tie around the bag's mouth and tip the bag so that the water collected around the rock will drain out. Then retie the mouth securely and reposition the still to allow further condensation.

Change the vegetation in the bag after extracting most of the water from it. This will ensure maximum output of water.

Making a **transpiration bag still** is similar to the vegetation bag, only easier. Simply tie the plastic bag over a leafy tree limb with a tube inserted, and tie the mouth of the bag off tightly around the branch to form an airtight seal. Tie the end of the limb so that it hangs below the level of the mouth of the bag. The water will collect there ([Figure 6-7](#fig6-7)).

<a name="fig6-7"></a>![Figure 6-7\. Water Transpiration Bag](fig06-07.png)

**Figure 6-7\. Water Transpiration Bag**

The same limb may be used for 3 to 5 days without causing long-term harm to the limb. It will heal itself within a few hours of removing the bag.

**BELOWGROUND STILL**

To make a belowground still, you need a digging tool, a container, a clear plastic sheet, a drinking tube, and a rock ([Figure 6-8](#fig6-8)).

<a name="fig6-8"></a>![Figure 6-8\. Belowground Still](fig06-08.png)

**Figure 6-8\. Belowground Still**

Select a site where you believe the soil will contain moisture (such as a dry streambed or a low spot where rainwater has collected). The soil at this site should be easy to dig, and sunlight must hit the site most of the day.

To construct the still, you should:

* Dig a bowl-shaped hole about 1 meter (3 feet) across and 60 centimeters (24 inches) deep.
* Dig a sump in the center of the hole. The sump's depth and perimeter will depend on the size of the container that you have to place in it. The bottom of the sump should allow the container to stand upright.
* Anchor the tubing to the container's bottom by forming a loose overhand knot in the tubing.
* Place the container upright in the sump.
* Extend the unanchored end of the tubing up, over, and beyond the lip of the hole.
* Place the plastic sheet over the hole, covering its edges with soil to hold it in place.
* Place a rock in the center of the plastic sheet.
* Lower the plastic sheet into the hole until it is about 40 centimeters (16 inches) below ground level. It now forms an inverted cone with the rock at its apex. Make sure that the cone's apex is directly over your container. Also make sure the plastic cone does not touch the sides of the hole because the earth will absorb the condensed water.
* Put more soil on the edges of the plastic to hold it securely in place and to prevent the loss of moisture.
* Plug the tube when not in use to keep the moisture from evaporating and to keep insects out.

You can drink water without disturbing the still by using the tube as a straw. By opening the still, you release the moist, warm air that has accumulated.

You may want to use plants in the hole as a moisture source. If so, dig out additional soil from the sides of the hole to form a slope on which to place the plants. Then proceed as above.

If polluted water is your only moisture source, dig a small trough outside the hole about 25 centimeters (10 inches) from the still's lip ([Figure 6-9](#fig6-9)). Dig the trough about 25 centimeters (10 inches) deep and 8 centimeters (3 inches) wide. Pour the polluted water in the trough. Be sure you do not spill any polluted water around the rim of the hole where the plastic sheet touches the soil. The trough holds the polluted water and the soil filters it as the still draws it. The water then condenses on the plastic and drains into the container. This process works extremely well when your only water source is salt water.

<a name="fig6-9"></a>![Figure 6-9\. Belowground Still to Get Potable Water From Polluted Water](fig06-09.png)

**Figure 6-9\. Belowground Still to Get Potable Water From Polluted Water**

You will need at least three stills to meet your individual daily water intake needs. In comparison to the belowground still and the water transpiration bag still, the vegetation bag produces the best yield of water.

### WATER PURIFICATION

Rainwater collected in clean containers or in plants is usually safe for drinking. However, purify water from lakes, ponds, swamps, springs, or streams, especially the water near human settlements or in the tropics.

When possible, purify all water you get from vegetation or from the ground by boiling or using iodine or chlorine. After purifying a canteen of water, you must partially unscrew the cap and turn the canteen upside down to rinse unpurified water from the threads of the canteen where your mouth touches.

Purify water by the following methods:

* If you are lucky you packed a filter like [the LifeStraw](LifeStraw) as part of [your Kit](Kits)
* Use water purification tablets. (Follow the directions provided.)
* Place 5 drops of 2 percent tincture of iodine in a canteen full of clear water. If the canteen is full of cloudy or cold water, use 10 drops. (Let the canteen of water stand for 30 minutes before drinking.)
* Use 2 drops of 10 percent (military strength) povidone-iodine or 1 percent titrated povidone-iodine. The civilian equivalent is usually 2 percent strength, so 10 drops will be needed. Let stand for 30 minutes. If the water is cold and clear, wait 60 minutes. If it's very cold or cloudy, add 4 drops and wait 60 minutes.
* Place 2 drops of chlorine bleach (5.25 percent sodium hypochlorite) in a canteen of water. Let stand 30 minutes. If the water is cold or cloudy, wait 60 minutes. Remember that not all bleach is the same around the world; check the available level of sodium hypochlorite.
* Use potassium permanganate, commonly marketed as Condy's Crystals, for a number of applications, including emergency disinfection of water. The crystals are of a nonuniform size, so you must judge the actual dosage by the color of the water after adding the crystals. Add three small crystals to 1 liter (1 quart) of water. If the water turns a bright pink after waiting 30 minutes, the water is considered purified. If the water turns a dark pink, there is too much potassium permanganate to drink safely. Either add more water to dilute the mixture or save it for use as an antiseptic solution. If the water becomes a full red, like the color of cranberry juice, the solution may be used as an antifungal solution.
* Boil your drinking water. This is the safest method of purifying your drinking water. By achieving a rolling boil, you can ensure that you are destroying all living waterborne pathogens.

By drinking nonpotable water you may contract diseases or swallow organisms that can harm you and may easily lead to potentially fatal waterborne illnesses.

Two of the most prevalent pathogens found in most water sources throughout the world are:

* Giardia, which causes Giardiasis (beaver fever). It is characterized by an explosive, watery diarrhea accompanied by severe cramps lasting 7 to 14 days.
* Cryptosporidium, which causes Cryptosporidiosis. It is much like Giardiasis, only more severe and prolonged, and there is no known cure but time. Diarrhea may be mild and can last from 3 days to 2 weeks.

**NOTE:** The only effective means of neutralizing Cryptosporidium is by boiling or by using a commercial microfilter or reverse-osmosis filtration system. Chemical disinfectants such as iodine tablets or bleach have not shown to be 100 percent effective in eliminating Cryptosporidium.

Examples of other diseases or organisms are:

* _Dysentery._ You may experience severe, prolonged diarrhea with bloody stools, fever, and weakness.
* _Cholera and typhoid._ You may be susceptible to these diseases regardless of inoculations. Cholera can cause profuse, watery diarrhea, vomiting, and leg cramps. Typhoid symptoms include fever, headache, loss of appetite, constipation, and bleeding in the bowel.
* _Hepatitis A._ Symptoms include diarrhea, abdominal pain, jaundice, and dark urine. This infection can spread through close person-to-person contact or ingestion of contaminated water or food.
* _Flukes._ Stagnant, polluted water—especially in tropical areas—often contains blood flukes. If you swallow flukes, they will bore into the bloodstream, live as parasites, and cause disease.
* _Leeches._ If you swallow a leech, it can hook onto the throat passage or inside the nose. It will suck blood, create a wound, and move to another area. Each bleeding wound may become infected.

### WATER FILTRATION DEVICES

If the water you find is also muddy, stagnant, and foul-smelling, you can clear the water:

* By placing it in a container and letting it stand for 12 hours.
* By pouring it through a filtering system.

**NOTE:** These procedures only clear the water and make it more palatable. You will have to purify it.

To make a filtering system, place several centimeters or layers of filtering material such as sand, crushed rock, charcoal, or cloth in bamboo, a hollow log, or an article of clothing ([Figure 6-10](#fig6-10)).

<a name="fig6-10"></a>![Figure 6-10\. Water Filtering Systems](fig06-10.png)

**Figure 6-10\. Water Filtering Systems**

Remove the odor from water by adding charcoal from your fire. Charcoal is also helpful in absorbing some agricultural and industrial chemicals. Let the water stand for 45 minutes before drinking it.
