> Successful use of plants in a survival situation depends on positive identification. Knowing poisonous plants is as important to you as knowing edible plants. Knowing the poisonous plants will help you avoid sustaining injuries from them.

### HOW PLANTS POISON

10-1\. Plants generally poison by—
*  _Contact._ This contact with a poisonous plant causes any type of skin irritation or dermatitis.
*  _Ingestion._ This occurs when a person eats a part of a poisonous plant.
*  _Absorption or inhalation._ This happens when a person either absorbs the poison through the skin or inhales it into the respiratory system.

10-2\. Plant poisoning ranges from minor irritation to death. A common question asked is, "How poisonous is this plant?" It is difficult to say how poisonous plants are because—
*  Some plants require a large amount of contact before you notice any adverse reaction although others will cause death with only a small amount.
*  Every plant will vary in the amount of toxins it contains due to different growing conditions and slight variations in subspecies.
*  Every person has a different level of resistance to toxic substances.
*  Some persons may be more sensitive to a particular plant.

10-3\. Some common **misconceptions** about poisonous plants are—
*  _Watch the animals and eat what they eat._ Most of the time this statement is true, but some animals can eat plants that are poisonous to humans.
*  _Boil the plant in water and any poisons will be removed._ Boiling removes many poisons, but not all.
*  _Plants with a red color are poisonous._ Some plants that are red are poisonous, but not all.

10-4\. The point is there is no one rule to aid in identifying poisonous plants. You must make an effort to learn as much about them as possible.

### ALL ABOUT PLANTS

10-5\. Many poisonous plants look like their edible relatives or like other edible plants. For example, poison hemlock appears very similar to wild carrot. Certain plants are safe to eat in certain seasons or stages of growth but poisonous in other stages. For example, the leaves of the pokeweed are edible when it first starts to grow, but they soon become poisonous. You can eat some plants and their fruits only when they are ripe. For example, the ripe fruit of May apple is edible, but all other parts and the green fruit are poisonous. Some plants contain both edible and poisonous parts; potatoes and tomatoes are common plant foods, but their green parts are poisonous.

10-6\. Some plants become toxic after wilting. For example, when the black cherry starts to wilt, hydrocyanic acid develops. Specific preparation methods make some plants edible that are poisonous raw. You can eat the thinly sliced and thoroughly dried (drying may take a year) corms of the jack-in-the-pulpit, but they are poisonous if not thoroughly dried.

10-7\. Learn to identify and use plants before a survival situation. Some sources of information about plants are pamphlets, books, films, nature trails, botanical gardens, local markets, and local natives. Gather and cross-reference information from as many sources as possible, because many sources will not contain all the information needed.

### RULES FOR AVOIDING POISONOUS PLANTS

10-8\. Your best policy is to be able to positively identify plants by sight and to know their uses or dangers. Many times absolute certainty is not possible. If you have little or no knowledge of the local vegetation, use the rules to select plants for the Universal Edibility Test. Remember, **avoid**—
*  All mushrooms. Mushroom identification is very difficult and must be precise—even more so than with other plants. Some mushrooms cause death very quickly. Some mushrooms have no known antidote. Two general types of mushroom poisoning are gastrointestinal and central nervous system.
*  Contact with or touching plants unnecessarily.

### CONTACT DERMATITIS

10-9\. Contact dermatitis from plants will usually cause the most trouble in the field. The effects may be persistent, spread by scratching, and particularly dangerous if there is contact in or around the eyes.

10-10\. The principal toxin of these plants is usually an oil that gets on the skin upon contact with the plant. The oil can also get on equipment and then infect whoever touches the equipment. Never burn a contact poisonous plant because the smoke may be as harmful as the plant. You have a greater danger of being affected when you are overheated and sweating. The infection may be local or it may spread over the body.

10-11\. Symptoms may take from a few hours to several days to appear. Symptoms can include burning, reddening, itching, swelling, and blisters.

10-12\. When you first contact the poisonous plants or when the first symptoms appear, try to remove the oil by washing with soap and cold water. If water is not available, wipe your skin repeatedly with dirt or sand. Do not use dirt if you have blisters. The dirt may break open the blisters and leave the body open to infection. After you have removed the oil, dry the area. You can wash with a tannic acid solution and crush and rub jewelweed on the affected area to treat plant-caused rashes. You can make tannic acid from oak bark.

10-13\. Poisonous plants that cause contact dermatitis are—
*  Cowhage.
*  Poison ivy.
*  Poison oak.
*  Poison sumac.
*  Rengas tree.
*  Trumpet vine.

### INGESTION POISONING

10-14\. Ingestion poisoning can be very serious and could lead to death very quickly. Do not eat any plant unless you have positively identified it first. Keep a log of all plants eaten.

10-15\. Symptoms of ingestion poisoning can include nausea, vomiting, diarrhea, abdominal cramps, depressed heartbeat and respiration, headaches, hallucinations, dry mouth, unconsciousness, coma, and death.

10-16\. If you suspect plant poisoning, try to remove the poisonous material from the victim's mouth and stomach as soon as possible. If the victim is conscious, induce vomiting by tickling the back of his throat or by giving him warm saltwater. If the victim is conscious, dilute the poison by administering large quantities of water or milk.

10-17\. The following plants can cause ingestion poisoning if eaten:
*  Castor bean.
*  Chinaberry.
*  Death camas.
*  Lantana.
*  Manchineel.
*  Oleander.
*  Pangi.
*  Physic nut.
*  Poison and water hemlocks.
*  Rosary pea.
*  Strychnine tree.

10-18\. [Appendix C]() provides photographs and descriptions of these plants.
