> The threat from animals is less than from other parts of the environment. However, common sense tells you to avoid encounters with lions, bears, and other large or dangerous animals. You should also avoid large grazing animals with horns, hooves, and great weight. Move carefully through their environment. Caution may prevent unexpected meetings. Do not attract large predators by leaving food lying around your camp. Carefully survey the scene before entering water or forests.
> 
> Smaller animals actually present more of a threat to you than large animals. To compensate for their size, nature has given many small animals weapons such as fangs and stingers to defend themselves. Each year, a few people are bitten by sharks, mauled by alligators, and attacked by bears. Most of these incidents were in some way the victim's fault. However, each year more victims die from bites by relatively small venomous snakes than by large dangerous animals. Even more victims die from allergic reactions to bee stings. These smaller animals are the ones you are more likely to meet as you unwittingly move into their habitat, or they slip into your environment unnoticed.
> 
> Keeping a level head and an awareness of your surroundings will keep you alive if you use a few simple safety procedures. Do not let curiosity and carelessness kill or injure you.

### INSECTS AND OTHER ARTHROPODS

Insects are part of the arthropod family (creatures with exoskeleton and articulated legs) so do the arachnids and the centipedes. Insects have six legs, arachnids eight and centipedes and millipedes many more. All these small creatures become pests when they bite, sting, or irritate you.

Although their venom can be quite painful, bee, wasp, and hornet stings rarely kill a person who is not allergic to that particular toxin. Even the most dangerous spiders rarely kill, and the effects of tick-borne diseases are very slow-acting. However, in all cases, avoidance is the best defense. In environments known to have spiders and scorpions, check your footgear and clothing every morning. Also check your bedding and shelter. Use care when turning over rocks and logs. See [Appendix](DangerousArthropods) for examples of dangerous insects and arachnids.

**SCORPIONS**

You find scorpions (_Buthotus_ species) in deserts, jungles, and forests of tropical, subtropical, and warm temperate areas of the world. They are mostly nocturnal. Desert scorpions range from below sea level in Death Valley to elevations as high as 3,600 meters (12,000 feet) in the Andes. Typically brown or black in moist areas, they may be yellow or light green in the desert. Their average size is about 2.5 centimeters (1 inch). However, there are 20-centimeter (8-inch) giants in the jungles of Central America, New Guinea, and southern Africa. Fatalities from scorpion stings are rare, but do occur with children, the elderly, and ill persons. Scorpions resemble small lobsters with raised, jointed tails bearing a stinger in the tip. Nature mimics the scorpions with whip scorpions or vinegarroons. These are harmless and have a tail like a wire or whip, rather than the jointed tail and stinger of true scorpions.

**SPIDERS**

The brown recluse, or fiddleback spider, of North America (_Loxosceles reclusa_) is recognized by a prominent violin-shaped light spot on the back of its body. As its name suggests, this spider likes to hide in dark places. Though its bite is rarely fatal, it can cause excessive tissue degeneration around the wound, leading to amputation of the digits if left untreated.

Members of the widow family (_Latrodectus_ species) may be found worldwide, though the black widow of North America is perhaps the most well-known. Found in warmer areas of the world, the widows are small, dark spiders with often hourglass-shaped white, red, or orange spots on their abdomens.

Funnelwebs (_Atrax_ species) are large, gray or brown Australian spiders. Chunky, with short legs, they are able to move easily up and down the cone-shaped webs from which they get their name. The local populace considers them deadly. Avoid them as they move about, usually at night, in search of prey. Symptoms of their bite are similar to those of the widow's—severe pain accompanied by sweating and shivering, weakness, and disabling episodes that can last a week.

Tarantulas are large, hairy spiders (_Theraphosidae_ and _Lycosa_ species) best known because they are often sold in pet stores. There is one species in Europe, but most come from tropical America. Some South American species do inject a dangerous toxin, but most simply produce a painful bite. Some tarantulas can be as large as a dinner plate. They all have large fangs for capturing food such as birds, mice, and lizards. If bitten by a tarantula, pain and bleeding are certain, and infection is likely.

**CENTIPEDES AND MILLIPEDES**

Centipedes and millipedes are mostly small and harmless, although some tropical and desert species may reach 25 centimeters (10 inches). A few varieties of centipedes have a poisonous bite, but infection is the greatest danger, as their sharp claws dig in and puncture the skin. To prevent skin punctures, brush them off in the direction they are traveling.

**BEES, WASPS, AND HORNETS**

Bees, wasps, and hornets come in many varieties and have a wide diversity of habits and habitats. You recognize bees by their hairy and usually thick body, while the wasps, hornets, and yellow jackets have more slender, nearly hairless bodies. Some bees, such as honeybees, live in colonies. They may be either domesticated or living wild in caves or hollow trees. You may find other bees, such as carpenter bees, in individual nest holes in wood or in the ground like bumblebees. The main danger from bees is the barbed stinger located on their abdomens. When a bee stings you, it rips its stinger out of its abdomen along with the venom sac, and dies. Except for killer bees, most bees tend to be more docile than wasps, hornets, and yellow jackets, which have smooth stingers and are capable of repeated attacks.

 voidance is the best tactic for self-protection. Watch out for flowers or fruit where bees may be feeding. Be careful of meat-eating yellow jackets when cleaning fish or game. The average person has a relatively minor and temporary reaction to bee stings and recovers in a couple of hours when the pain and headache go away. Those who are allergic to bee venom have severe reactions including anaphylactic shock, coma, and death. If antihistamine medicine is not available and you cannot find a substitute, an allergy sufferer in a survival situation is in grave danger.

**TICKS**

Ticks are common in the tropics and temperate regions. They are familiar to most of us. Ticks are small, round arachnids. They can have either a soft or hard body. Ticks require a blood host to survive and reproduce. This makes them dangerous because they spread diseases like Lyme disease, Rocky Mountain spotted fever, encephalitis, and others that can ultimately be disabling or fatal. There is little you can do to treat these diseases once they are contracted, but time is your ally since it takes at least 6 hours of attachment to the host for the tick to transmit the disease organisms. Thus, you have time to thoroughly inspect your body for their presence. Beware of ticks when passing through the thick vegetation they cling to, when cleaning host animals for food, and when gathering natural materials to construct a shelter. Always use insect repellents, if possible.

### LEECHES

Leeches are bloodsucking creatures with a wormlike appearance. You find them in the tropics and in temperate zones. You will certainly encounter them when swimming in infested waters or making expedient water crossings. You can find them when passing through swampy, tropical vegetation and bogs. You can also find them while cleaning food animals, such as turtles, found in fresh water. Leeches can crawl into small openings; therefore, avoid camping in their habitats when possible. Keep your trousers tucked in your boots. Check yourself frequently for leeches. Swallowed or eaten, leeches can be a great hazard. It is therefore essential to treat water from questionable sources by boiling or using chemical water treatments. Survivors have developed severe infections from wounds inside the throat or nose when sores from swallowed leeches became infected.

### BATS

Despite the legends, bats (_Desmodus_ species) are a relatively small hazard to you. There are many bat varieties worldwide, but you find the true vampire bats only in Central and South America. They are small, agile fliers that land on their sleeping victims, mostly cows and horses, to lap a blood meal after biting their victim. Their saliva contains an anticoagulant that keeps the blood slowly flowing while they feed. All bats are considered to carry rabies. Any physical contact is considered to be a rabies risk. They can carry other diseases and infections and will bite readily when handled. However, taking shelter in a cave occupied by bats presents the much greater hazard of inhaling powdered bat dung, or guano. Bat dung carries many organisms that can cause diseases. Eating thoroughly cooked flying foxes or other bats presents no danger from rabies and other diseases, but again, the emphasis is on thorough cooking.

### VENOMOUS SNAKES

There are no infallible rules for expedient identification of venomous snakes in the field, because the guidelines all require close observation or manipulation of the snake's body. The best strategy is to leave all snakes alone. Where snakes are plentiful and venomous species are present, the risk of their bites negates their food value. Apply the following safety rules when traveling in areas where there are venomous snakes:

* Walk carefully and watch where you step. Step onto logs rather than over them in a survival situation. During evasion, always step over or go around logs to leave fewer signs for trackers.
* Look closely when picking fruit or moving around water.
* Do not tease, molest, or harass snakes. Snakes cannot close their eyes. Therefore, you cannot tell if they are asleep. Some snakes, such as mambas, cobras, and bushmasters, will attack aggressively when cornered or guarding a nest.
* Use sticks to turn logs and rocks.
* Wear proper footgear, particularly at night.
* Carefully check bedding, shelter, and clothing.
* Be calm when you encounter serpents. Snakes cannot hear and you can occasionally surprise them when they are sleeping or sunning. Normally, they will flee if given the opportunity.
* Use extreme care if you must kill snakes for food or safety. Although it is not common, warm, sleeping human bodies occasionally attract snakes.

<center><a name="fig11-1"></a>

<table cellspacing="0" cellpadding="7" border="1" width="426">

<tbody>

<tr>

<td valign="top" bgcolor="#000000">

**<font color="#ffffff">The Americas</font>**

</td>

</tr>

<tr>

<td valign="top">
*  American Copperhead (_Agkistrodon contortrix_)
*  Bushmaster (_Lachesis muta_)
*  Coral snake (_Micrurus fulvius_)
*  Cottonmouth (_Agkistrodon piscivorus_)
*  Fer-de-lance (_Bothrops atrox_)
*  Rattlesnake (_Crotalus_ species)

</td>

</tr>

<tr>

<td valign="top" bgcolor="#000000">

**<font color="#ffffff">Europe</font>**

</td>

</tr>

<tr>

<td valign="top">
*  Common adder _(Vipers berus)_
*  Pallas' viper _(Agkistrodon halys)_

</td>

</tr>

<tr>

<td valign="top" bgcolor="#000000">

**<font color="#ffffff">Africa and Asia</font>**

</td>

</tr>

<tr>

<td valign="top">
*  Boomslang (_Dispholidus typus_)
*  Cobra (_Naja_ species)

</td>

</tr>

</tbody>

</table>

**Figure 11-1\. Venomous Snakes of the World**

<table cellspacing="0" cellpadding="7" border="1" width="426">

<tbody>

<tr>

<td valign="top" bgcolor="#000000">

**<font color="#ffffff">Africa and Asia (Continued)</font>**

</td>

</tr>

<tr>

<td valign="top">
*  Gaboon viper (_Bitis gabonica_)
*  Green tree pit viper (_Trimeresurus gramineus_)
*  Habu pit viper (_Trimeresurus flavoviridis_)
*  Krait (_Bungarus caeruleus_)
*  Malayan pit viper (_Callaselasma rhodostoma_)
*  Mamba (_Dendraspis_ species)
*  Puff adder (_Bitis arietans_)
*  Rhinoceros viper (_Bitis nasicornis_)
*  Russell's viper (_Vipera russellii_)
*  Sand viper (_Cerastes vipera_)
*  Saw-scaled viper (_Echis carinatus_)
*  Wagler's pit viper (_Trimeresurus wagleri_)

</td>

</tr>

<tr>

<td valign="top" bgcolor="#000000">

**<font color="#ffffff">Australia</font>**

</td>

</tr>

<tr>

<td valign="top">
*  Death adder (_Acanthophis antarcticus_)
*  Taipan (_Oxyuranus scutellatus_)
*  Tiger snake (_Notechis scutatus_)
*  Yellow-bellied sea snake (_Pelamis platurus)_

</td>

</tr>

</tbody>

</table>

</center>

**Figure 11-1\. Venomous Snakes of the World (Continued)**

### SNAKE-FREE AREAS

The polar regions are free of snakes due to their inhospitable environments. Other areas considered to be free of venomous snakes are New Zealand, Cuba, Haiti, Jamaica, Puerto Rico, Ireland, Polynesia, and Hawaii.

### DANGEROUS LIZARDS

The Gila monster (_Heloderma suspectrum_) of the American Southwest and Mexico is a dangerous and poisonous lizard with dark, highly textured skin marked by pinkish mottling. It is typically 35 to 45 centimeters (14 to 18 inches) in length and has a thick, stumpy tail. The Gila monster is unlikely to bite unless molested but has a poisonous bite.

The Mexican beaded lizard (_Heloderma horridum_) resembles its relative, the Gila monster. However, it has more uniform spots rather than bands of color. It also is poisonous and has a docile nature. You may find it from Mexico to Central America.

The komodo dragon is a giant lizard (_Varanus komodoensis_) that grows to more than 3 meters (10 feet) in length. It can be dangerous if you try to capture it. This Indonesian lizard can weigh more than 135 kilograms (300 pounds).

### DANGERS IN RIVERS

Common sense will tell you to avoid confrontations with hippopotami, alligators, crocodiles, and other large river creatures. However, there are also the following smaller river creatures with which you should be cautious.

Electric eels (_Electrophorus electricus_) may reach 2 meters (7 feet) in length and 20 centimeters (8 inches) in diameter. Avoid them. They are capable of generating up to 500 volts of electricity in certain organs of their body. They use this shock to stun prey and enemies. Normally, you find these eels in the Orinoco and Amazon River systems in South America. They seem to prefer shallow waters that are more highly oxygenated and provide more food. They are bulkier than American eels. Their upper body is dark gray or black with a lighter-colored underbelly.

Piranhas (_Serrasalmo_ species) are another hazard of the Orinoco and Amazon River systems, as well as the Paraguay River Basin, where they are native. These fish vary greatly in size and coloration, but usually have a combination of orange undersides and dark tops. They have white, razor-sharp teeth that are clearly visible. They may be as long as 50 centimeters (20 inches). Use great care when crossing waters where they live. Blood attracts them. They are most dangerous in shallow waters during the dry season.

Be careful when handling and capturing large freshwater turtles, such as the snapping turtles and soft-shelled turtles of North America and the matamata and other turtles of South America. All of these turtles will bite in self-defense and can amputate fingers and toes.

The platypus or duckbill (_Ornithorhyncus anatinus_) is the only member of its family and is easily recognized. It has a long body covered with grayish, short hair, a tail like a beaver, and a bill like a duck. Growing up to 60 centimeters (24 inches) in length, it may appear to be a good food source, but this egg-laying mammal, the only one in the world, is very dangerous. The male has a poisonous spur on each hind foot that can inflict intensely painful wounds. You find the platypus only in Australia, mainly along mud banks on waterways.

### DANGERS IN BAYS AND ESTUARIES

In areas where seas and rivers come together, there are dangers associated with both freshwater and saltwater. In shallow saltwaters, there are many creatures that can inflict pain and cause infection to develop. Stepping on sea urchins, for example, can produce pain and infection. When moving about in shallow water, wear some form of footgear and shuffle your feet along the bottom, rather than picking up your feet and stepping.

Stingrays (_Dasyatidae_ species) are a real hazard in shallow waters, especially tropical waters. The type of bottom appears to be irrelevant. There is a great variance between species, but all have a sharp spike in their tail that may be venomous and can cause extremely painful wounds if stepped on. All rays have a typical shape that resembles a kite. You find them along the coasts of the Americas, Africa, and Australia.

### SALTWATER DANGERS

There are several fish that you should not handle, touch, or contact. There are also others that you should not eat. These fish are described below.

Sharks are the most feared animal in the sea. Usually, shark attacks cannot be avoided and are considered accidents. You should take every precaution to avoid any contact with sharks. There are many shark species, but in general, dangerous sharks have wide mouths and visible teeth, while relatively harmless ones have small mouths on the underside of their heads. However, any shark can inflict painful and often fatal injuries, either through bites or through abrasions from their rough skin.

Rabbitfish or spinefoot (_Siganidae_ species) live mainly on coral reefs in the Indian and Pacific oceans. They have very sharp, possibly venomous spines in their fins. Handle them with care, if at all. This fish, like many others of the dangerous fish in this section, is considered edible by native peoples where the fish are found, but deaths occur from careless handling. Seek other nonpoisonous fish to eat if possible.

Tang or surgeonfish (_Acanthuridae_ species) average 20 to 25 centimeters (8 to 10 inches) in length and often are beautifully colored. They are called surgeonfish because of the scalpel-like spines located in the tail. The wounds inflicted by these spines can bring about death through infection, envenomation, and loss of blood, which may incidentally attract sharks.

Toadfish (_Batrachoididae_ species) live in tropical waters off the Gulf Coast of the United States and along both coasts of Central and South America. These dully-colored fish average 18 to 25 centimeters (7 to 10 inches) in length. They typically bury themselves in the sand to await fish and other prey. They have sharp, very toxic spines along their backs.

Poisonous scorpion fish or zebra fish (_Scorpaenidae_ species) are mostly around reefs in the tropical Indian and Pacific oceans and occasionally in the Mediterranean and Aegean seas. They average 30 to 75 centimeters (12 to 29 inches) in length. Their coloration is highly variable, from reddish brown to almost purple or brownish yellow. They have long, wavy fins and spines and their sting is intensely painful. Less poisonous relatives live in the Atlantic Ocean.

Stonefish (_Synanceja_ species) are in the Pacific and Indian oceans. They can inject a painful venom from their dorsal spines when stepped on or handled carelessly. They are almost impossible to see because of their lumpy shape and drab colors. They range in size up to 40 centimeters (16 inches).

Weever fish (_Trachinidae_ species) average 30 centimeters (12 inches) long. They are hard to see as they lie buried in the sand off the coasts of Europe, Africa, and the Mediterranean. Their color is usually a dull brown. They have venomous spines on the back and gills.

**NOTE:** The [Appendix](FishAndMollusks) provides more details on these venomous fish and toxic mollusks.

The livers of polar bears are considered toxic due to high concentrations of vitamin A. There is a chance of death after eating this organ. Another toxic meat is the flesh of the hawksbill turtle. These animals are distinguished by a down-turned bill and yellow polka dots on their neck and front flippers. They weigh more than 275 kilograms (605 pounds) and are unlikely to be captured.

Many fish living in lagoons, estuaries, or reefs near shore are poisonous to eat, though some are only seasonally dangerous. Although the majority are tropical fish; be wary of eating any unidentifiable fish wherever you are. Some predatory fish, such as barracuda and snapper, may become toxic if the fish they feed on in shallow waters are poisonous. The most poisonous types appear to have parrotlike beaks and hard shell-like skins with spines and can often inflate their bodies like balloons. However, at certain times of the year, indigenous populations consider the puffer a delicacy.

The blowfish or puffer (_Tetraodontidae_ species) are more tolerant of cold water. They live along tropical and temperate coasts worldwide, even in some of the rivers of Southeast Asia and Africa. Stout-bodied and round, many of these fish have short spines and can inflate themselves into a ball when alarmed or agitated. Their blood, liver, and gonads are so toxic that as little as 28 milligrams (0.001 ounce) can be fatal. These fish vary in color and size, growing up to 75 centimeters (29 inches) in length.

The triggerfish (_Balistidae_ species) occur in great variety, mostly in tropical seas. They are deep-bodied and compressed, resembling a seagoing pancake up to 60 centimeters (24 inches) in length, with large and sharp dorsal spines. Avoid them all, as many have poisonous flesh.

Although most people avoid them because of their ferocity, they occasionally eat barracuda (_Sphyraena barracuda_). These predators of mostly tropical seas can reach almost 1.5 meters (5 feet) in length and have attacked humans without provocation. They occasionally carry the poison ciguatera in their flesh, making them deadly if consumed.

### OTHER DANGEROUS SEA CREATURES

The blue-ringed octopus, jellyfish, and the cone and auger shells are other dangerous sea creatures. Therefore, you should always be alert and move carefully in any body of water.

Most octopi are excellent when properly prepared. However, the blue-ringed octopus (_Hapalochlaena lunulata_) can inflict a deadly bite from its parrotlike beak. Fortunately, it is restricted to the Great Barrier Reef of Australia and is very small. It is easily recognized by its grayish white overall color and irridescent blue rings. Authorities warn that all tropical octopus species should be treated with caution because of their poisonous bites, although their flesh is edible.

Deaths related to jellyfish are rare, but the sting they inflict is extremely painful. The Portuguese man-of-war resembles a large pink or purple balloon floating on the sea. It has poisonous tentacles hanging up to 12 meters (40 feet) below its body. The huge tentacles are actually colonies of stinging cells. Most known deaths from jellyfish are attributed to the man-of-war. Other jellyfish can inflict very painful stings as well. Avoid the long tentacles of any jellyfish, even those washed up on the beach and apparently dead.

The subtropical and tropical cone shells (_Conidae_ species) have a venomous harpoonlike barb. All have a fine netlike pattern on the shell. A membrane may possibly obscure this coloration. There are some very poisonous cone shells, even some lethal ones in the Indian and Pacific oceans. Avoid any shell shaped like an ice cream cone.

The auger shell or terebra (_Terebridae_ species) are much longer and thinner than the cone shells, but can be nearly as deadly. They are found in temperate and tropical seas. Those in the Indian and Pacific oceans have a more toxic venom in their stinging barb. Do not eat these snails, as their flesh may be poisonous.
