> A phone can be a versatile tool when you install and use the right apps. 
**Make sure you check that the apps work offline, since you probably won't have internet connection.**

### Angles

A majority of phones are fitted with a tilt sensor. The [Angulo](https://www.domob.eu/projects/angulo.php) app can take advantage of these sensors to measure angles, which you can then convert into distances using a calculator app.

### Appstore / F-Droid

The Google Play store may not work. [F-Droid.org](https://f-droid.org) allows you to point to alternative repositories. While using the default repository, you can be pretty sure the app is libre/[FOSS](https://en.wikipedia.org/wiki/Free_and_open-source_software) - as are all apps mentioned here.  Also, learn how to "sideload", or install apps without going through an app store directly. Using F-Droid, for example, people can exchange their installed apps via Bluetooth.

### Barcode scanner

In a more day-to-day approach, one can stumble upon a fragment of barcode without the human readable cipher part and can use a smartphone to get the information back.

Barcodes are also used in their two dimensional form (like QR codes) to easily import cryptographic public keys or URLs into smartphones using the camera.

[Barcode scanner](https://github.com/zxing/zxing) or [Binary Eye](https://f-droid.org/en/packages/de.markusfisch.android.binaryeye/) are libre apps available on F-Droid.org that will read barcodes.

### Calculators

Every Android phone comes standard with a calculator app. These calculator apps have several modes, and can be used to make complicated scientific computations.

### Camera

Your phone's camera can help you take quick pictures of signs, allowing you to capture large chunks of text in an instant. **Doing so with a camera rather than your mind will allow you access to true information that has not been altered by time and space in your brain - especially easily done under stressful conditions.** [OpenNoteScanner](https://github.com/ctodobom/OpenNoteScanner) is a camera app dedicated to processing pictures to improve the readability of text.

You can also take pictures of the place you are, to help find your way back to it later. Or you can take pictures of your findings far from a site, to help inform others about them.

### Compass

Directions can be useful, learn how to read a compass and how to navigate using it. It may be easier to learn with a real compass and then reproduce it with your phone. A compass is included in [Trailsense](https://github.com/ligi/SurvivalManual/wiki/Apps#trailsense)

### Cryptocurrency 

In a situation where fiat money/banks are no longer a viable option, it may be best to have a [cryptocurrency wallet like WallETH](https://walleth.org) or [Electrum](https://electrum.org/) already set up. Transfer a small amount onto it now and learn how to use it for later. For even better security, utilize a hardware wallet like the [TREZOR](https://shop.trezor.io?a=walleth.org). You can also use the TREZOR (including the new model T) together with WallETH on your phone. If you are concerned about the volatility of crypto-currencies, you may want to research stable coins like [DAI](https://dai.makerdao.com).

### Games

Have a game app to fight boredom and keep the mind stimulated.

I recommend [gobandroid](https://github.com/ligi/gobandroid) [full disclosure: I made this app] to play the ancient game of Go, which has simple rules but is still immensely deep.

[Sokoban](https://github.com/mobilepearls/com.mobilepearls.sokoban) is an ancient Japanese puzzle game in which you push jewels into target zones through different maps. Be careful that you don't corner yourself or the jewels! The game provides 354 levels, sorted by difficulty, and may provide mental stimulation for years.

[Shattered Pixel Dungeon](https://f-droid.org/en/packages/com.shatteredpixel.shatteredpixeldungeon) is a mobile dungeon crawler roguelike with very good pixel art graphics. "Every game is unique, with four different playable characters, randomized levels
and enemies, and over 150 items to collect and use." It's also updated frequently!

[Minetest](https://f-droid.org/en/packages/net.minetest.minetest) is "a near infinite world block sandbox game and a game engine, inspired
by InfiniMiner, Minecraft and the like." The default Minetest game that comes with Minetest is rather bland, be sure to download some mods (such as Mesecons, mobs, and hunger) and/or some games (such as [Mineclone 2](https://content.minetest.net/packages/Wuzzy/mineclone2/): a clone of Minecraft gameplay in the Minetest engine, with libre code and graphics, or [Nodecore](https://content.minetest.net/packages/Warr1024/nodecore/): a voxel sandbox game with no fancy GUI and a limited inventory, where crafting takes place in-world instead of on a crafting table in a menu, and furnaces have to be designed and constructed.)

[Lichess](https://lichess.org/mobile) isn't on F-droid yet, but it's open source and the APK can be downloaded from their website. A lot of functionality is online, but when the app is in offline mode it can be used to play chess against the computer or against a friend by using your phone as a chess board.

[Space Trader](https://f-droid.org/en/packages/com.brucelet.spacetrader/) is a game that's all about traveling to different star systems and making money trading stuff, in space. There's no 3D graphics, though, you just choose a star system and trade stuff. It hasn't been updated since 2019-02-05, but it's pretty fun.

**Make sure that the games work offline. Also, be careful not to run out of battery when you really need it.**

### Light 

A phone's flashlight can bring light into the dark when you do not have a real flashlight on you. There are many flashlight apps on f-droid. Including [Trail Sense](https://github.com/ligi/SurvivalManual/wiki/Apps#trailsense)

### Maps / Navigation

Have a mapping and navigation solution that can work offline like [OsmAnd](http://osmand.net). Download the data for your area and any other areas that you may need. Try it out offline (enable airplane mode). It may take a little longer to acquire GPS signal, but you want to make sure it works now, in advance of the need for it to work later.

### Morse signal

Morse signal is easy to transmit, even without special gear. It can be transmitted in different ways, including:
* The reflected light of a mirror (or a tilted smartphone screen)
* The sound of strikes on a large piece of metal
* A horn

You can broadcast a Morse signal farther than you can project your voice, and likely using less energy.

The famous SOS distress signal is ubiquitous, and indicates that you need to be rescued: dot dot dot, dash, dash, dash, dot dot dot (... - - - ...). But beyond this knowledge, Morse code could be useful for exchanging further information about your situation. For instance, if you are trapped in a cave: what do you need first? Are there people in your group that need special assistance?

This exchange could be achieved using a Morse signal generator app, like the libre [Androidomatic-Keyer (AKA)](https://github.com/sussman/androidomatic-keyer). Andromatic-Keyer allows you to type your message (English is the International Morse tradition, but broken English works fine, as well) and the app will play the corresponding sound using the loudspeaker of the phone. 

I submitted a [feature request](https://github.com/sussman/androidomatic-keyer/issues/31) to have AKA play the code using the flashlight, but this feature request may need your help to gain traction. This feature is available on [Trailsense](https://f-droid.org/en/packages/com.kylecorry.trail_sense/)


### Music

Have a Music app that is not a streaming solution, as well as some uplifting music. I suggest DUB or reggae - like [PANDA DUB / LION'S DEN](PandaDubLionsDen), but download whatever works best for you.

[VLC](https://www.videolan.org/vlc/download-android.html) is a libre media player supporting a wide variety of music and video formats (.MP3, .FLAC, .OGG, .MKV, MP4…).

[Dogmazic](http://www.dogmazic.net/?lang=en) (website, mobile app) provides archives of freely downloadable music.

### Pass app

I recommend [PassAndroid](https://github.com/ligi/PassAndroid) for your Pass app. Imagine how frustrating it would be if you get a ticket to a rescue ship in [esPass](https://espass.it) format and are unable to display it. (Full disclosure: I am the developer of PassAndroid.)

### Offline dictionary and translation dictionaries

Install an offline working dictionary, along with the languages that you are most likely to face.

[QuickDic](https://github.com/rdoeffinger/Dictionary) is a libre offline translation dictionary available on F-Droid.org fitted with a wide variety of languages.


### Offline encyclopedia

Smartphones allow you to carry not just one book, but your entire library. So why not bringing a full encyclopedia, just in case.

This is what [Aard 2](https://aarddict.org) allows you to do. It's a libre app available on F-Droid.org. You'll have to separately download the Wikipedia copies you want. They are available in many languages.

### Radio

A lot of Android phones come stock with an FM radio receiver. Many governments have broadcasting plans in case of emergency. Your phone can receive this information using a pair of headphones plugged in to the phone, as it typically uses the headphone cable as an antenna to receive the signal. You can also use any other 3.5mm jack component such as:

* A microphone
* Computer loudspeakers
* A jack extension cord
* Even just a broken version of the above

Be sure to have the radio app redirect the sound towards the phone integrated loudspeaker if you plug something that can't actually produce sound, as the default behavior is to direct the sound to the plugged headphones.

### Readers

Install PDF or eBook readers and download some books or manuals.

[Document Viewer](https://github.com/PrivacyApps/document-viewer) is a libre app available from F-Droid.org for reading PDF documents, as well as OpenXPS, ComicBook CBZ, FictionBook FB, etc.

Every phone is equipped with enough storage memory to hold thousands of text books, and many are already in the public domain. The [Gutenberg Project](https://www.gutenberg.org/) has gathered over 56,000 of them, and there's a top 100 selection to help you make your choice.

### Recorder

In survival situations, as stated in the [Psycology](Psychology) chapter, you will get yourself in a stable situation more easily by keeping the willpower to fight on. To keep going, many people in a survival situation write diaries to combat loneliness and keep track of their life and its unexpected events. If you have a power source, your smartphone can be a reliable Dictaphone if you lack paper to write on. Be aware, however, that you should remove any password or lock codes from your phone if you want others to access it later.

### Tea app

I recommend [Material Tea timer](https://github.com/ligi/MaterialTeaTimer) (Full disclosure: I am the developer of Material Tea Timer). Tea or infusions in general will be useful in many dire situations.

### Trailsense
Navigation - The compass can be used to determine the direction to North, and when combined with the GPS it can be used to navigate to predefined locations. The predefined locations, known as beacons, can be created while at a location and at any point you can use the compass to navigate back to where the beacon was placed.

Weather - The barometer can be used to determine if the weather will change soon and if a storm is likely to occur. The barometric pressure history (last 48 hours) is displayed as a graph and an interpretation of the current reading is shown. If the pressure suddenly drops, a storm alert notification is sent.

[Trail sense](https://f-droid.org/en/packages/com.kylecorry.trail_sense/)