> You might have to cross hostile areas to get into safety and survive.


The movement portion of returning to safety is the most dangerous as you are now most vulnerable. 
It is usually better to move at night because of the concealment darkness offers. Exceptions to such movement would be when moving through hazardous terrain or dense vegetation (for example, jungle or mountainous terrain). When moving, avoid the following even if it takes more time and energy to bypass:

* Obstacles and barriers.
* Roads and trails.
* Inhabited areas.
* Waterways and bridges.
* Natural lines of drift.
* Man-made structures.
* All civilian and military personnel.

Movement in hostile areas is a very slow and deliberate process.
The slower you move and the more careful you are, the better.
Your best security will be using your senses. Use your eyes and ears to detect people before they detect you. Make frequent listening halts. In daylight, observe a section of your route before you move along it. The distance you travel before you hide will depend on the enemy situation, your health, the terrain, the availability of cover and concealment for hiding, and the amount of darkness left.

Once you have moved into the area in which you want to hide (hide area), select a hide site. Keep the word BLISS in mind when selecting a hide site:

* *B*lends in with the surroundings.
* *L*ow in silhouette.
* *I*rregular in shape.
* *S*mall in size.
* *S*ecluded.

Avoid the use of existing buildings or shelters. Usually, your best option will be to crawl into the thickest vegetation you can find. Construct any type of shelter within the hide area only in cold weather and desert environments. If you build a shelter, follow the BLISS formula.

**HIDE SITE ACTIVITIES**

After you have located your hide site, do not move straight into it. Use a buttonhook or other deceptive technique to move to a position outside of the hide site. Conduct a listening halt before moving individually into the hide site. Be careful not to disturb or cut any vegetation. Once you have occupied the hide site, limit your activities to maintaining security, resting, camouflaging, and planning your next moves.

Maintain your security through visual scanning and listening. Upon detection of the enemy, the security personnel alert all personnel, even if the team's plan is to stay hidden and not move upon sighting the enemy. Take this action so that everyone is aware of the danger and ready to react.

If any team member leaves the team, give him a five-point contingency plan. It should include—Who is going? Where are they going? How long will they be gone? What to do if they are hit or don't return on time? Where to go if anyone is hit?

It is extremely important to stay healthy and alert when trying to avoid capture. Take every opportunity to rest, but do not sacrifice security. Rotate security so that all members of your movement team can rest. Treat all injuries, no matter how minor. Loss of your health will mean loss of your ability to continue to avoid capture.

Camouflage is an important aspect of both moving and securing a hide site. Always use a buddy system to ensure that camouflage is complete. Ensure that team members blend with the hide site. Use natural or man-made materials. If you add any additional camouflage material to the hide site, do not cut vegetation in the immediate area.

Plan your next actions while at the hide site. Start your planning process immediately upon occupying the hide site. Inform all team members of their current location and designate an alternate hide site location. Once this is done, start planning for the team's next movement.

Planning the team's movement begins with a map reconnaissance. Choose the next hide area first. Then choose a primary and an alternate route to the hide area. In choosing the routes, do not use straight lines. Use one or two radical changes in direction. Pick the routes that offer the best cover and concealment, the fewest obstacles, and the least likelihood of contact with humans. There should be locations along the route where the team can get water. To aid team navigation, use azimuths, distances, checkpoints or steering marks, and corridors. Plan rally points and rendezvous points at intervals along the route.

Other planning considerations may fall under what the team already has in the team SOP. Examples are immediate action drills, actions on sighting the enemy, and hand-and-arm signals.

Once planning is complete, ensure everyone knows and memorizes the entire plan. The team members should know the distances and azimuths for the entire route to the next hide area. They should study the map and know the various terrain they will be moving across so that they can move without using the map.

Do not occupy a hide site for more than 24 hours. In most situations, hide during the day and move at night. Limit your actions in the hide site to those discussed above. Once in the hide site, restrict all movement to less than 45 centimeters (18 inches) above the ground. Do not build fires or prepare food. Smoke and food odors will reveal your location. Before leaving the hide site, sterilize it to prevent tracking.

**HOLE-UP AREAS**

After moving and hiding for several days, usually three or four, you or the movement team will have to move into a hole-up area. This is an area where you can rest, recuperate, and get and prepare food. Choose an area near a water source. You then have a place to get water, to place fishing devices, and to trap game. Since waterways are a line of communication, locate your hide site well away from the water.

A hole-up area should offer plenty of cover and concealment for movement in and around the area. Always maintain security while in the hole-up area. Always man the hole-up area. Actions in the hole-up area are the same as in the hide site, except that you can move away from the hole-up area to get and prepare food. While in the hole-up area, you can:
 
* Select and occupy the next hide site (remember you are still in a dangerous situation; this is not a friendly area).
* Reconnoiter the area for resources and potential concealed movement routes to the alternate hide site.
* Gather food (nuts, berries, vegetables). When moving around the area for food, maintain security and avoid leaving tracks or other signs. When setting traps and snares, keep them well-camouflaged and in areas where people are not likely to discover them. Remember, the local population sometimes heavily travels trails near water sources.
* Get water from sources within the hide area. Be careful not to leave tracks of signs along the banks of water sources when getting water. Moving on hard rocks or logs along the banks to get water will reduce the signs you leave.
* Set clandestine fishing devices, such as stakeouts, below the surface of the water to avoid detection.
* Locate a fire site well away from the hide site. Use this site to prepare food or boil water. Camouflage and sterilize the fire site after each use. Be careful that smoke and light from the fire does not compromise the hole-up area.

While in the hole-up area, security is still your primary concern. Designate team members to perform specific tasks. To limit movement around the area, you may have a two-man team perform more than one task. For example, the team getting water could also set the fishing devices. Do not occupy the hole-up area longer than 72 hours.

### RETURN TO SAFETY

Establishing contact with friendly lines or patrols is the most crucial part of movement and return to friendly control. All your patience, planning, and hardships will be in vain if you do not exercise caution when contacting friendly frontline forces. Friendly patrols have killed personnel operating behind enemy lines because they did not make contact properly. Most of the casualties could have been avoided if caution had been exercised and a few simple procedures followed. The normal tendency is to throw caution to the wind when in sight of friendly forces. You must overcome this tendency and understand that linkup is a very sensitive situation.

**BORDER CROSSINGS**

If you have made your way to a friendly or neutral country, use the following procedures to cross the border and link up with friendly forces on the other side:

* Occupy a hide site on the near side of the border and send a team out to reconnoiter the potential crossing site.
* Surveil the crossing site for at least 24 hours, depending on the situation.
* Make a sketch of the site, taking note of terrain, obstacles, guard routines and rotations, and any sensor devices or trip wires. Once the reconnaissance is complete, the team moves to the hide site, briefs the rest of the team, and plans to cross the border at night.
* After crossing the border, set up a hide site on the far side of the border and try to locate friendly positions. Do not reveal your presence.
* Depending on the size of your movement team, have two men surveil the potential linkup site with friendly forces until satisfied that the personnel are indeed friendly.
* Make contact with the friendly forces during daylight. Personnel chosen to make contact should be unarmed, have no equipment, and have positive identification readily available. The person who actually makes the linkup should be someone who looks least like the enemy.
* During the actual contact, have only one person make the contact. The other person provides the security and observes the link-up area from a safe distance. The observer should be far enough away so that he can warn the rest of the movement team if something goes wrong.
* Wait until the party he is contacting looks in his direction so that he does not surprise the contact. He stands up from behind cover, with hands overhead and states that he is an American. After this, he follows any instructions given him. He avoids answering any tactical questions and does not give any indication that there are other team members.
* Reveal that there are other personnel with him only after verifying his identity and satisfying himself he has made contact with friendly forces.

Language problems or difficulties confirming identities may arise. The movement team should maintain security, be patient, and have a contingency plan.

**NOTE:** If you are moving to a neutral country, you are surrendering to that power and become a detained person.

**LINKUP AT THE FORWARD EDGE OF THE BATTLE AREA OR FORWARD LINE OF OWN TROOPS**

If caught between friendly and enemy forces and there is heavy fighting in the area, you may choose to hide and let the friendly lines pass over you. If overrun by friendly forces, you may try to link up from their rear during daylight hours. If overrun by enemy forces, you may move further to the enemy rear, try to move to the forward edge of the battle area or forward line of own troops during a lull in the fighting, or move to another area along the front.

The actual linkup will be done as for linkup during a border crossing. The only difference is that you must be more careful on the initial contact. Frontline personnel are more likely to shoot first and ask questions later, especially in areas of heavy fighting. You should be near or behind cover before trying to make contact.

**LINKUP WITH FRIENDLY PATROLS**

If friendly lines are a circular perimeter or an isolated camp, for example, any direction you approach from will be considered enemy territory. You do not have the option of moving behind the lines and trying to link up. This move makes the linkup extremely dangerous. One option you have is to place the perimeter under observation and wait for a friendly patrol to move out in your direction, providing a chance for a linkup. You may also occupy a position outside of the perimeter and call out to get the attention of the friendly forces. Ideally, display anything that is white while making contact. If nothing else is available, use any article of clothing. The idea is to draw attention while staying behind cover. Once you have drawn attention to your signal and called out, follow instructions given to you.

Be constantly on the alert for friendly patrols because these provide a means for return to friendly control. Find a concealed position that allows you maximum visual coverage of the area. Try to memorize every terrain feature so that, if necessary, you can infiltrate to friendly positions under the cover of darkness. Remember, trying to infiltrate in darkness is extremely dangerous.

Because of the missions of combat and reconnaissance patrols and where they are operating, making contact can be dangerous. If you decide not to make contact, you can observe their route and approach friendly lines at about the same location. Such observation will enable you to avoid mines and booby traps.

Once you have spotted a patrol, remain in position and, if possible, allow the patrol to move toward you. When the patrol is 25 to 50 meters (83 to 165 feet) from your position, signal them and call out a greeting that is clearly and unmistakably of American origin.

If you have nothing white, an article of clothing will suffice to draw attention. If the distance is greater than 50 meters (165 feet), a reconnaissance patrol may avoid contact and bypass your position. If the distance is less than 25 meters (83 feet), a patrol member may react instantly by firing a fatal shot.

It is crucial, at the time of contact, that there is enough light for the patrol to identify you as an American.

Whatever linkup technique you decide to use, use extreme caution. From the perspective of the friendly patrol or friendly personnel occupying a perimeter, you are hostile until they make positive identification.
