> After having solved the problems of finding water, shelter, and animal food, you will have to consider the use of plants you can eat. In a survival situation you should always be on the lookout for familiar wild foods and live off the land whenever possible.
> 
> You must not count on being able to go for days without food as some sources would suggest. Even in the most static survival situation, maintaining health through a complete and nutritious diet is essential to maintaining strength and peace of mind.
> 
> Nature can provide you with food that will let you survive almost any ordeal, if you don't eat the wrong plant. You must therefore learn as much as possible beforehand about the flora of the region where you will be operating. Plants can provide you with medicines in a survival situation. Plants can supply you with weapons and raw materials to construct shelters and build fires. Plants can even provide you with chemicals for poisoning fish, preserving animal hides, and for camouflaging yourself and your equipment.
> 
> **NOTE:** You will find illustrations of the plants described in this chapter in the Appendix.

### EDIBILITY OF PLANTS

Plants are valuable sources of food because they are widely available, easily procured, and, in the proper combinations, can meet all your nutritional needs.

> **WARNING**
> 
> The critical factor in using plants for food is to avoid accidental poisoning. Eat only those plants you can positively identify and you know are safe to eat.

Absolutely identify plants before using them as food. Poison hemlock has killed people who mistook it for its relatives, wild carrots and wild parsnips.

You may find yourself in a situation where you not have had the chance to learn the plant life of the region in which you must survive. In this case you can use the Universal Edibility Test to determine which plants you can eat and which to avoid.

It is important to be able to recognize both cultivated and wild edible plants in a survival situation. Most of the information in this chapter is directed toward identifying wild plants because information relating to cultivated plants is more readily available.

Consider the following when collecting wild plants for food:

*  Plants growing near homes and occupied buildings or along roadsides may have been sprayed with pesticides. Wash these plants thoroughly. In more highly developed countries with many automobiles, avoid roadside plants, if possible, due to contamination from exhaust emissions.
*  Plants growing in contaminated water or in water containing _Giardia lamblia_ and other parasites are contaminated themselves. Boil or disinfect them.
*  Some plants develop extremely dangerous fungal toxins. To lessen the chance of accidental poisoning, do not eat any fruit that is starting to spoil or is showing signs of mildew or fungus.
*  Plants of the same species may differ in their toxic or subtoxic compounds content because of genetic or environmental factors. One example of this is the foliage of the common chokecherry. Some chokecherry plants have high concentrations of deadly cyanide compounds but others have low concentrations or none. Horses have died from eating wilted wild cherry leaves. Avoid any weed, leaves, or seeds with an almondlike scent, a characteristic of the cyanide compounds.
*  Some people are more susceptible to gastric distress (from plants) than others. If you are sensitive in this way, avoid unknown wild plants. If you are extremely sensitive to poison ivy, avoid products from this family, including any parts from sumacs, mangoes, and cashews.
*  Some edible wild plants, such as acorns and water lily rhizomes, are bitter. These bitter substances, usually tannin compounds, make them unpalatable. Boiling them in several changes of water will usually remove these bitter properties.
*  Many valuable wild plants have high concentrations of oxalate compounds, also known as oxalic acid. Oxalates produce a sharp burning sensation in your mouth and throat and damage the kidneys. Baking, roasting, or drying usually destroys these oxalate crystals. The corm (bulb) of the jack-in-the-pulpit is known as the "Indian turnip," but you can eat it only after removing these crystals by slow baking or by drying.

> **WARNING**
>
> Do not eat mushrooms in a survival situation! The only way to tell if a mushroom is edible is by positive identification. There is no room for experimentation. Symptoms caused by the most dangerous mushrooms affecting the central nervous system may not show up until several days after ingestion. By that time, it is too late to reverse their effects.

**PLANT IDENTIFICATION**

You identify plants, other than by memorizing particular varieties through familiarity, by using such factors as leaf shape and margin, leaf arrangements, and root structure.

The basic leaf margins ([Figure 9-1](#fig9-1)) are toothed, lobed, and toothless or smooth.

<a name="fig9-1"></a>![Figure 9-1\. Leaf Margins](fig09-01.png)

**Figure 9-1\. Leaf Margins**

These leaves may be lance-shaped, elliptical, egg-shaped, oblong, wedge-shaped, triangular, long-pointed, or top-shaped ([Figure 9-2](#fig9-2)).

<a name="fig9-2"></a>![Figure 9-2\. Leaf Shapes](fig09-02.png)

**Figure 9-2\. Leaf Shapes**

The basic types of leaf arrangements ([Figure 9-3](#fig9-3)) are opposite, alternate, compound, simple, and basal rosette.

<a name="fig9-3"></a>![Figure 9-3\. Leaf Arrangements](fig09-03.png)

**Figure 9-3\. Leaf Arrangements**

The basic types of root structures are the taproot, tuber, bulb, rhizome, clove, corm, and crown ([Figure 9-4](#fig9-4)). Bulbs are familiar to us as onions and, when sliced in half, will show concentric rings. Cloves are those bulblike structures that remind us of garlic and will separate into small pieces when broken apart. This characteristic separates wild onions from wild garlic. Taproots resemble carrots and may be single-rooted or branched, but usually only one plant stalk arises from each root. Tubers are like potatoes and daylilies. You will find these structures either on strings or in clusters underneath the parent plants. Rhizomes are large creeping rootstock or underground stems. Many plants arise from the "eyes" of these roots. Corms are similar to bulbs but are solid when cut rather than possessing rings. A crown is the type of root structure found on plants such as asparagus. Crowns look much like a mophead under the soil's surface.

<a name="fig9-4"></a>![Figure 9-4\. Root Structures](fig09-04.png)

**Figure 9-4\. Root Structures**

Learn as much as possible about the unique characteristics of plants you intend to use for food. Some plants have both edible and poisonous parts. Many are edible only at certain times of the year. Others may have poisonous relatives that look very similar to the varieties you can eat or use for medicine.

**UNIVERSAL EDIBILITY TEST**

There are many plants throughout the world. Tasting or swallowing even a small portion of some can cause severe discomfort, extreme internal disorders, and even death. Therefore, if you have the slightest doubt about a plant's edibility, apply the Universal Edibility Test before eating any portion of it.

1. Test only one part of a potential food plant at a time.

2. Separate the plant into its basic components: leaves, stems, roots, buds, and flowers.

3. Smell the food for strong or acid odors. Remember, smell alone does not indicate a plant is edible or inedible.

4. Do not eat for 8 hours before starting the test.

5. During the 8 hours you abstain from eating, test for contact poisoning by placing a piece of the plant part you are testing on the inside of your elbow or wrist. Usually 15 minutes is enough time to allow for a reaction.

6. During the test period, take nothing by mouth except purified water and the plant part you are testing.

7. Select a small portion of a single part and prepare it the way you plan to eat it.

8. Before placing the prepared plant part in your mouth, touch a small portion (a pinch) to the outer surface of your lip to test for burning or itching.

9. If after 3 minutes there is no reaction on your lip, place the plant part on your tongue, holding it there for 15 minutes.

10. If there is no reaction, thoroughly chew a pinch and hold it in your mouth for 15 minutes. Do not swallow.

11. If no burning, itching, numbing, stinging, or other irritation occurs during the 15 minutes, swallow the food.

12. Wait 8 hours. If any ill effects occur during this period, induce vomiting and drink a lot of water.

13. If no ill effects occur, eat 0.25 cup of the same plant part prepared the same way. Wait another 8 hours. If no ill effects occur, the plant part as prepared is safe for eating.


> **CAUTION**
>
> Test all parts of the plant for edibility, as some plants have both edible and inedible parts. Do not assume that a part that proved edible when cooked is also edible when raw. Test the part raw to ensure edibility before eating raw. The same part or plant may produce varying reactions in different individuals.

Before testing a plant for edibility, make sure there are enough plants to make the testing worth your time and effort. Each part of a plant (roots, leaves, flowers, and so on) requires more than 24 hours to test. Do not waste time testing a plant that is not relatively abundant in the area.

Remember, eating large portions of plant food on an empty stomach may cause diarrhea, nausea, or cramps. Two good examples of this are such familiar foods as green apples and wild onions. Even after testing plant food and finding it safe, eat it in moderation.

You can see from the steps and time involved in testing for edibility just how important it is to be able to identify edible plants.

To avoid potentially poisonous plants, stay away from any wild or unknown plants that have:

* Milky or discolored sap.
* Beans, bulbs, or seeds inside pods.
* A bitter or soapy taste.
* Spines, fine hairs, or thorns.
* Foliage that resembles dill, carrot, parsnip, or parsley.
* An almond scent in woody parts and leaves.
* Grain heads with pink, purplish, or black spurs.
* A three-leafed growth pattern.

Using the above criteria as eliminators when choosing plants for the Universal Edibility Test will cause you to avoid some edible plants. More important, these criteria will often help you avoid plants that are potentially toxic to eat or touch.

An entire encyclopedia of edible wild plants could be written, but space limits the number of plants presented here. Learn as much as possible about the plant life of the areas where you train regularly and where you expect to be traveling or working. [Figure 9-6](#fig9-6) list some of the most common edible and medicinal plants.

## Temperate Zone

* Amaranth (_Amaranths retroflex_ and other species)
* Arrowroot (_Sagittarius_ species)
* Asparagus (_Asparagus officials_)
* Beechnut (_Fags_ species)
* Blackberries (_Rubes_ species)
* Blueberries (_Vaccinium_ species)
* Burdock (_Arctium_ _lappa_)
* Cattail (_Typha_ species)
* Chestnut (_Castanea_ species)
* Chicory (_Cichorium intybus_)
* Chufa (_Cyperus esculentus_)
* Dandelion (_Taraxacum officinale_)
* Daylily (_Hemerocallis fulva)_
* Nettle (_Urtica_ species)
* Oaks (_Quercus_ species)
* Persimmon (_Diospyros virginiana_)
* Plantain (_Plantago_ species)
* Pokeweed (_Phytolacca americana_)
* Prickly pear cactus (_Opuntia_ species)
* Purslane (_Portulaca oleracea_)
* Sassafras (_Sassafras albidum_)
* Sheep sorrel (_Rumex acetosella_)
* Strawberries (_Fragaria_ species)
* Thistle (_Cirsium_ species)
* Water lily and lotus (_Nuphar, Nelumbo_, and other species)
* Wild onion and garlic (_Allium_ species)
* Wild rose (_Rosa_ species)
* Wood sorrel (_Oxalis_ species)

## Tropical Zone

* Bamboo (_Bambusa_ and other species)
* Bananas (_Musa_ species)
* Breadfruit (_Artocarpus incisa_)
* Cashew nut (_Anacardium occidental_)
* Coconut (_Cocoa nucifera)_
* Mango (_Mangifera indica_)
* Palms (various species)
* Papaya (_Carica_ species)
* Sugarcane (_Saccharum officinarum_)
* Taro (_Colocasia_ species)

## Desert Zone

* Acacia (_Acacia farnesiana_)
* Agave (_Agave_ species)
* Cactus (various species)
* Date palm (_Phoenix dactylifera_)
* Desert amaranth (_Amaranths palmer_)

**SEAWEEDS**

One plant you should never overlook is seaweed. It is a form of marine algae found on or near ocean shores. There are also some edible freshwater varieties. Seaweed is a valuable source of iodine, other minerals, and vitamin C. Large quantities of seaweed in an unaccustomed stomach can produce a severe laxative effect. These are various types of edible seaweed:

* Dulse (_Rhodymenia palmata_)
* Green seaweed (_Ulva lactuca_)
* Irish moss (_Chondrus crispus_)
* Kelp (_Alaria esculenta_)
* Laver (_Porphyra_ species)
* Mojaban (_Sargassum fulvellum_)
* Sugar wrack (_Laminaria saccharina_)

When gathering seaweed for food, find living plants attached to rocks or floating free. Seaweed washed onshore any length of time may be spoiled or decayed. You can dry freshly harvested seaweed for later use.

Different types of seaweed should be prepared in different ways. You can dry thin and tender varieties in the sun or over a fire until crisp. Crush and add these to soups or broths. Boil thick, leathery seaweeds for a short time to soften them. Eat them as a vegetable or with other foods. You can eat some varieties raw after testing for edibility.

**PREPARATION OF PLANT FOOD**

Although some plants or plant parts are edible raw, you must cook others for them to be edible or palatable. Edible means that a plant or food will provide you with necessary nutrients; palatable means that it is pleasing to eat. Many wild plants are edible but barely palatable. It is a good idea to learn to identify, prepare, and eat wild foods.

Methods used to improve the taste of plant food include soaking, boiling, cooking, or leaching. Leaching is done by crushing the food (for example, acorns), placing it in a strainer, and pouring boiling water through it or immersing it in running water.

Boil leaves, stems, and buds until tender, changing the water, if necessary, to remove any bitterness.

Boil, bake, or roast tubers and roots. Drying helps to remove caustic oxalates from some roots like those in the _Arum_ family.

Leach acorns in water, if necessary, to remove the bitterness. Some nuts, such as chestnuts, are good raw, but taste better roasted.

You can eat many grains and seeds raw until they mature. When they are hard or dry, you may have to boil or grind them into meal or flour.

The sap from many trees, such as maples, birches, walnuts, and sycamores, contains sugar. You may boil these saps down to a syrup for sweetening. It takes about 35 liters of maple sap to make 1 liter of maple syrup!

### PLANTS FOR MEDICINE

In using plants for medical treatment, positive identification of the plants involved is as critical as when using them for food. Proper use of these plants is equally important.

**TERMS AND DEFINITIONS**

The following terms and their definitions are associated with medicinal plant use:

* _Poultice._ This is crushed leaves or other plant parts, possibly heated, that are applied to a wound or sore either directly or wrapped in cloth or paper. Poultices, when hot, increase the circulation in the affected area and help healing through the chemicals present in the plants. As the poultice dries out, it draws the toxins out of a wound. A poultice should be prepared to a "mashed potatoes-like" consistency and applied as warm as the patient can stand.
* _Infusion or tisane or tea._ This blend is the preparation of medicinal herbs for internal or external application. You place a small quantity of a herb in a container, pour hot water over it, and let it steep (covered or uncovered) before use. Care must always be taken to not drink too much of a tea in the beginning of treatment as it may have adverse reactions on an empty stomach.
* _Decoction._ This is the extract of a boiled-down or simmered herb leaf or root. You add herb leaf or root to water. You bring them to a sustained boil or simmer them to draw their chemicals into the water. The average ratio is about 28 to 56 grams (1 to 2 ounces) of herb to 0.5 liter of water.
* _Expressed juice._ These are liquids or saps squeezed from plant material and either applied to the wound or made into another medicine.

Many natural remedies work slower than the medicines you know. Therefore, start with smaller doses and allow more time for them to take effect. Naturally, some will act more rapidly than others. Many of these treatments are addressed in more detail in [Medicine](Medicine).

**SPECIFIC REMEDIES**

The following remedies are for use only in a survival situation. Do not use them routinely as some can be potentially toxic and have serious long- term effects (for example, cancer).

* _Antidiarrheals for diarrhea._ This can be one of the most debilitating illnesses for a survivor or prisoner of war. Drink tea made from the roots of blackberries and their relatives to stop diarrhea. White oak bark and other barks containing tannin are also effective when made into a strong tea. However, because of possible negative effects on the kidneys, use them with caution and only when nothing else is available. Clay, ashes, charcoal, powdered chalk, powdered bones, and pectin can be consumed or mixed in a tannic acid tea with good results. These powdered mixtures should be taken in a dose of two tablespoons every 2 hours. Clay and pectin can be mixed together to give a crude form of Kaopectate. Pectin is obtainable from the inner part of citrus fruit rinds or from apple pomace. Tea made from cowberry, cranberry, or hazel leaves works, too. Because of its inherent danger to an already under-nourished survivor, several of these methods may need to be tried simultaneously to stop debilitating diarrhea, which can quickly dehydrate even a healthy individual.
* _Antihemorrhagics for bleeding._ Make medications to stop bleeding from plantain leaves, or, most effectively, from the leaves of the common yarrow or woundwort _(Achillea millefolium)._ These mostly give a physical barrier to the bleeding. Prickly pear (the raw, peeled part) or witch hazel can be applied to wounds. Both are good for their astringent properties (they shrink blood vessels). For bleeding gums or mouth sores, sweet gum can be chewed or used as a toothpick. This provides some chemical and antiseptic properties as well.
* _Antiseptics to clean infections._ Use antiseptics to cleanse wounds, snake bites, sores, or rashes. You can make antiseptics from the expressed juice of wild onion or garlic, the expressed juice from chickweed leaves, or the crushed leaves of dock. You can also make antiseptics from a decoction of burdock root, mallow leaves or roots, or white oak bark (tannic acid). Prickly pear, slippery elm, yarrow, and sweet gum are all good antiseptics as well. All these medications are for external use only. Two of the best antiseptics are sugar and honey. Sugar should be applied to the wound until it becomes syrupy, then washed off and reapplied. Honey should be applied three times daily (see [Medicine](Medicine)). Honey is by far the best of the antiseptics for open wounds and burns, with sugar being second.
* _Antipyretics for fevers._ Treat a fever with a tea made from willow bark, an infusion of elder flowers or fruit, linden flower tea, and aspen or slippery elm bark decoction. Yarrow tea is also good. Peppermint tea is reportedly good for fevers.
* _Colds and sore throats._ Treat these illnesses with a decoction made from either plantain leaves or willow bark. You can also use a tea made from burdock roots, mallow or mullein flowers or roots, and yarrow or mint leaves.
* _Analgesics for aches, pains, and sprains._ Treat these conditions with externally applied poultices of dock, plantain, chickweed, willow bark, garlic, or sorrel. Sweet gum has some analgesic (pain relief) properties. Chewing the willow bark or making a tea from it is the best for pain relief as it contains the raw component of aspirin. You can also use salves made by mixing the expressed juices of these plants in animal fat or vegetable oils.
* _Antihistamines and astringents for itching or contact dermatitis._ Relieve the itch from insect bites, sunburn, or plant poisoning rashes by applying a poultice of jewelweed _(Impatiens biflora)_ or witch hazel, which give a cooling relief and dry out the weeping _(Hamamelis virginiana)_ leaves. The jewelweed juice will help when applied to poison ivy, rashes, or insect stings. Jewelweed and aloe vera help relieve sunburn. In addition, dandelion sap, crushed cloves of garlic, and sweet gum have been used. Crushed leaves of burdock have received only so-so reports of success, but crushed, green plantain leaves show relief over a few days. Jewelweed is probably the best of these plants. Tobacco will deaden the nerve endings and can also be used to treat toothaches.
* _Sedatives._ Get help in falling asleep by brewing a tea made from mint leaves or passionflower leaves.
* _Hemorrhoids._ Treat them with external washes from elm bark or oak bark tea, from the expressed juice of plantain leaves, or from a Solomon's seal root decoction. Tannic acid or witch hazel will provide soothing relief because of their astringent properties.
* _Heat rash._ Tannic acid or witch hazel will provide soothing relief because of their astringent properties but cornstarch or any crushed and powdered, nonpoisonous plant should help to dry out the rash after a thorough cleansing.
* _Constipation._ Relieve constipation by drinking decoctions from dandelion leaves, rose hips, or walnut bark. Eating raw daylily flowers will also help. Large amounts of water in any form are critical to relieving constipation.
* _Antihelminthics for worms or intestinal parasites._ Most treatment for worms or parasites are toxicjust more so for the worms or parasites than for humans. Therefore, all treatments should be used in moderation. Treatments include tea made from tansy _(Tanacetum vulgare)_ or from wild carrot (poisonous) leaves. Very strong tannic acid can also be used with caution as it is very hard on the liver. See [Medicine](Medicine) for more deworming techniques.
* _Antiflatulents for gas and cramps._ Use a tea made from carrot seeds; use tea made from mint leaves to settle the stomach.
* _Antifungal washes._ Make a decoction of walnut leaves, oak bark, or acorns to treat ringworm and athlete's foot. Apply it frequently to the site, alternating with exposure to direct sunlight. Broad-leaf plantain has also been used with success but any treatment should be used in addition to sunlight if possible. Jewelweed and vinegar make excellent washes but are sometimes difficult to find.
* _Burns._ Tannic acid, sugar, and honey can be used as explained in [Medicine](Medicine).
* _Dentifrices for teeth._ See [Medicine](Medicine) for other techniques in addition to using twigs of sweet gum for its anti-inflammatory, analgesic, and antiseptic properties.
* _Insect repellents._ Garlic and onions can be eaten and the raw plant juice rubbed on the skin to repel some insects. Sassafras leaves can be rubbed on the skin. Cedar chips may help repel insects around your shelter.
* _Tannic acid._ Because tannic acid is used for so many treatments (burns, antihemorrhagics, antihelminthics, antiseptics, antidiarrheals, antifungals, bronchitis, skin inflammation, lice), a note as to its preparation is in order. All thready plants, especially trees, contain tannic acid. Hardwood trees generally contain more than softwood trees. Of the hardwoods, oakespecially red and chestnutcontain the highest amount. The warty looking knots in oak trees can contain as much as 28 percent tannic acid. This knot, the inner bark of trees, and pine needles (cut into 2-centimeter [1-inch] strips), can all be boiled down to extract tannic acid. Boiling can be done in as little as 15 minutes (very weak), to 2 hours (moderate), through 12 hours to 3 days (very strong). The stronger concoctions will have a dark color that will vary depending on the type of tree. All will have an increasingly vile taste in relation to their concentration.

### MISCELLANEOUS USES OF PLANTS

Plants can be your ally as long as you use them cautiously. Be sure that you know the plant and how to use it. Some additional uses of plants are as follows:

* Make dyes from various plants to color clothing or to camouflage your skin. Usually, you will have to boil the plants to get the best results. Onionskins produce yellow, walnut hulls produce brown, and pokeberries provide purple dye.
* Make fibers and cordage from plant fibers. Most commonly used are the stems from nettles and milkweeds, yucca plants, and the inner bark of trees like the linden.
* Make tinder for starting fires from cattail fluff, cedar bark, lighter knot wood from pine trees, or hardened sap from resinous wood trees.
* Make insulation by fluffing up female cattail heads or milkweed down.
* Make insect repellents by placing sassafras leaves in your shelter or by burning or smudging cattail seed hair fibers.

Whether you use plants for food, medicine, or the construction of shelters or equipment, the **key** to their safe use is **positive identification**.
