
# What you should understand about self-defense in the first place
First of all, self-defense is not about beating your opponent to death, it’s about all you need to do to get as less harm as possible.
## Levels of force
As mentioned, to figure things out you rarely have to appeal to violence just because no one actually wants to get hurt (except for some maniacs and other crazy people). Whether it’s a “tough guy”, who wants to show you who’s boss of this gym, or a robber they don’t want to fight, they want to get whatever they want. In the first case, the guy wants status, in the second, the man wants your purse, simple as that. So the first thing you’re actually interested in is showing that it would be hard to fight you (or so simple that it won’t get much status to anybody). The robbery situation is a bit more complex, because although criminals don’t want the extra risk to spend half a life in a jail it’s not very smart to let down your guard in any second because it’s also pretty logical that killing you without leaving any traces would, on the other hand, decrease the risk. The thing is to understand that there’s no universal strategy and you’ll have to train yourself to quickly apply logic, knowledge, and experience to increase your chances of staying alive in tough situations and not getting into prison. That’s why you should bear in mind these 6 levels of force and might be able to escalate to any real fast.
### Level 1 – presence.
How you look and behave plays a big role in “victim evaluation”. That is if you seem foolish and inattentive then it’s a sign that it’s easy to rob you if you behave cocky and disrespectful – that you need an “educational beat down” etc.
If you suspect anything, at least a snitch, carefully look around as you go. Your facial expression and your whole body should send a message to everyone that you’re serious, prepared and know what to do in case something happens. That might scare off a lot more assailants than you think. You should also reconsider your style (clothing).
### Level 2 – voice.
You should really understand what things to say and how in different situations. For example, there’s a technique that’s based on one of our social instincts – conforming. When someone’s angry and his speech is very loud and fast address a few words or a small sentence to him with the same voice and then start to speak calm and slow. Also, when you’re attacked use your voice to attract other people’s attention. When in a crowd and someone wants to show how “tough” he is say something like “Hey, I don’t want any trouble” out loud. That not only may help you when things get jurisdictional, but also have a higher chance of someone from the crowd to react (interesting thing, if someone intrudes that doesn’t “hurt” the attacker’s status, you know, “hey, if not that stupid grandpa, I would have beaten that guy for sure”). Plus, you might remind the guy that you (actually both of you), obviously, don’t want to fight. Again, every situation is different, this info may just give you a better understanding of what logic to apply when you’re trying to get out of sketchy circumstances. Just explore human interaction either by reading specific books or practicing. Practicing is better, but that doesn’t mean you should go and search for some trouble to solve.
### Level 3 – touch.
The goal of this technique is to make body contact with the person (usually combined with some calming words). For instance, tap him on his shoulder and say that everything is okay. If you want to be more careful try contacting the hand so you don’t open to the person that much and also have a little bit of control when suddenly the potential threat tries to use his arms with bad intentions. But be careful! You shouldn't try to use that technique every time you face aggressive behavior. Here’s why. To touch someone in a friendly way (if not, then it’s not the right section) you should approach the person very close and become unprotected to show your friendly intentions. And it’s pretty dangerous. You can do that only if you’re really sure you’re not gonna get hit. You can use that technique on your close friends, family members – people you know really well. If you’re trying to friend up with a street thug when things get intense that might turn out terrible. Again, practice it on your friends when they’re upset or angry. Read or listen to other people’s stories about this kind of interaction so you know better what to do.
### Levels 4 to 6 (restraint, non-lethal force, lethal force)
From level 4 to level 6 you’re supposed to apply actual physical force. Now, even if you’ve been intuitively practicing levels 1-3 for your whole life and you can easily solve a tough situation on these levels just having some knowledge, levels 4 to 6 need training. If you don’t go practicing in a dojo (special fighting hall) or, what’s way more efficient, real-life drills then you’re pretty much screwed. One of the issues is to control yourself when you’re full of adrenaline. You barely can. So, the best tactic is to make your self-defense fully intuitive when it comes to quick action. That’s why, further, there will be no extended information on that, cause if it makes sense to go training then it makes sense to learn different techniques (you can’t learn much from what’s written in this article), hire specialists, take special self-defense courses etc. Here's what is simple enough to be prepared without spending too much time and effort on things that, let’s be honest, happen really rarely if you avoid troublesome places and people. The main advice is to take one or a few friends and make a “drill” – simulated assault situation where everyone starts doing slow motions turn by turn gradually increasing speed as you get more and more confident in your moves. Just be creative, an assault doesn’t have a special sequence. Try different positions, places (environment), matchups. Also before training, you may look up on the internet (or in THE book) different takedown techniques, the nature of taking-down itself, videos, body maps, but be careful not to start swinging around and taking down your partner as you’d do in a real fight. You’re training to feel, analyze and remember, so no need to apply too much force or be as fast as lightning.
### Level 4 – restraint.
Simply, it’s pressure points and joint locks (pain and movement restriction). You better find body maps for pressure points, but as for joint locks – the better strategy is to understand how they actually work. The secret is hyperextension – try bending your wrist with one arm and applying force in the opposite direction with the muscles of the locked joint. Yeah, it’s painful and really hard. The thing is that all mechanisms in our body work on the muscle contraction principle. When you extend the muscle the force applied to contract it back actually extends it even more causing hyperextension. So all you need to do is to extend the muscles that make the joint work. There are 3 types of joints: ball-and-socket (shoulder, the base of the fingers, hip), hinge (finger, elbow, knee), gliding joint (wrist). With ball-and-socket, you should rotate an arm around the axis (as if locking a joystick movement by pushing the stick to the edge). A hinge may be bent or straightened. In the first case, you put something inside an elbow, knee or finger an object (that might be a part of your body, but it better be some other object, maybe even a part of the attacker’s body!) and bend it over the object. In the second case, you simply straighten the hinge (i.e. rotate out). Now wrist, simple as that, twist and bend, no matter which way (accept bending to the sides, in that case, bones meet and you can’t bend any further). Now, a little bit about efficiency. First, it’s obvious, but you need basing, without it the person can easily escape the lock by moving towards the force you’re applying. So what you do is block the way of this movement. One, you lock the axis (joint) in one place so you can rotate the arm. Second, you lock the movement of the person, so there’s no way to turn the rest of the body instead of tensing the muscles you’re extending. To lock the axis you just push somewhere near it. To lock the person you push it against something. Other details you should figure out yourself when training or taking courses.
### Level 5,6 – non-lethal/lethal force.
That is tricky. If you don’t know where and how hard you’re hitting you might easily apply level 6 at level 5 and the other way around. In both cases, you might be in real trouble. That means I cannot give any short advice on these two levels. If you’re seriously thinking about it then read the book, consult with professionals etc. If you want to base your knowledge and experience only on this article the only thing that's recommended about level 5 is that, since the best option is to run, it makes sense to disable the threat from chasing you. That is when in a fight or before it’s, clearly, about to start a very good target to hit is outside or inside a knee. It’s especially effective when the threat is moving thus shifting all weight to one leg. Even if standing on both legs, kicking in the out/inside of a knee knocks the attacker off balance and gravity does the rest of the job. Not only you buy some time by knocking down, but it is also probable that the threat is not able to run. Very good technique.  
## Summary
With all that being said, if you’re going to stay out of trouble then it won’t be that easy for trouble to find you. Still, you need to be prepared. Whether it is an article, book or self-defense classes you should understand what self-defense is all about and think how much experience and knowledge is enough to keep yourself safe or not.
