/*
 *				Twidere - Twitter client for Android
 * 
 * Copyright (C) 2012 Mariotaku Lee <mariotaku.lee@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.mariotaku.twidere.util;

import java.io.File;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Environment;

public final class EnvironmentAccessor {

	public static File getExternalCacheDir(final Context context) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.FROYO)
			return GetExternalCacheDirAccessorFroyo.getExternalCacheDir(context);
		final File ext_storage_dir = Environment.getExternalStorageDirectory();
		if (ext_storage_dir != null && ext_storage_dir.isDirectory()) {
			final String ext_cache_path = ext_storage_dir.getAbsolutePath() + "/Android/data/"
					+ context.getPackageName() + "/cache/";
			final File ext_cache_dir = new File(ext_cache_path);
			if (ext_cache_dir.isDirectory() || ext_cache_dir.mkdirs()) return ext_cache_dir;
		}
		return null;
	}

	@TargetApi(Build.VERSION_CODES.FROYO)
	private static class GetExternalCacheDirAccessorFroyo {

		@TargetApi(Build.VERSION_CODES.FROYO)
		private static File getExternalCacheDir(final Context context) {
			return context.getExternalCacheDir();
		}
	}
}
