/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;

public class xmlgen {
    private static File[] images;
    private static String dir;
    private static StringBuilder icon;
    private static StringBuilder drawable;
    private static StringBuilder appfilter;
    private static StringBuilder appmap;
    private static StringBuilder theme_resources;

    public static void main(String[] stringArray) {
        dir = new File(xmlgen.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        dir = dir.replace("%20", " ");
        System.out.println("\nDirectory: " + dir + "\nScanning...");
        images = xmlgen.Scan4Images();
        if (images.length > 0) {
            System.out.println("Found " + images.length + " images");
            xmlgen.writeXML();
            xmlgen.saveFiles();
            System.out.print("Finished!");
        } else {
            System.out.print("Could not find any .png image files. :(");
        }
    }

    private static File[] Scan4Images() {
        File file = new File(dir);
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".png") || string.endsWith(".PNG");
            }
        });
    }

    private static void writeXML() {
        icon = new StringBuilder();
        drawable = new StringBuilder();
        appfilter = new StringBuilder();
        appmap = new StringBuilder();
        theme_resources = new StringBuilder();
        icon.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        icon.append("<resources>\n\n");
        icon.append("\t<string-array name=\"icon_pack\" translatable=\"true\">\n");
        drawable.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        drawable.append("<resources>\n\n");
        drawable.append("\t<version>1</version>\n\n");
        appfilter.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        appfilter.append("<resources>\n\n");
        appmap.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        appmap.append("<appmap>\n\n");
        theme_resources.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        theme_resources.append("<Theme version=\"1\">\n");
        theme_resources.append("\t<Label value=\"Your Icon Pack name\" />\n");
        theme_resources.append("\t<Wallpaper image=\"wallpaper_01\" />\n");
        theme_resources.append("\t<LockScreenWallpaper image=\"wallpaper_02\" />\n");
        theme_resources.append("\t<ThemePreview image=\"preview1\" />\n");
        theme_resources.append("\t<ThemePreviewWork image=\"preview1\" />\n");
        theme_resources.append("\t<ThemePreviewMenu image=\"preview1\" />\n");
        theme_resources.append("\t<DockMenuAppIcon selector=\"drawer_icon\" />\n\n");
        theme_resources.append("\t<!-- Themed Apps -->\n");
        for (File file : images) {
            icon.append("\t<item>" + file.getName().replace(".png", "").replace(".PNG", "") + "</item>\n");
            drawable.append("\t<item drawable=\"" + file.getName().replace(".png", "").replace(".PNG", "") + "\"/>\n");
            appfilter.append("\t<item component=\"ComponentInfo{}\" drawable=\"" + file.getName().replace(".png", "").replace(".PNG", "") + "\"/>\n");
            appmap.append("\t<item name=\"" + file.getName().replace(".png", "").replace(".PNG", "") + "\" class=\"" + "\"/>\n");
            theme_resources.append("\t<AppIcon name=\"\" image=\"" + file.getName().replace(".png", "").replace(".PNG", "") + "\"/>\n");
        }
        icon.append("\t</string-array>\n\n");
        icon.append("</resources>");
        drawable.append("\n</resources>");
        appfilter.append("\n</resources>");
        appmap.append("\n</appmap>");
        theme_resources.append("\n</Theme>");
    }

    private static void saveFiles() {
        FileOutputStream fileOutputStream;
        File file;
        try {
            file = new File(dir, "icon_pack.xml");
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(icon.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Oops, an error occured while writing icon_pack.xml");
        }
        try {
            file = new File(dir, "drawable.xml");
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(drawable.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Oops, an error occured while writing drawable.xml");
        }
        try {
            file = new File(dir, "appfilter.xml");
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(appfilter.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Oops, an error occured while writing appfilter.xml");
        }
        try {
            file = new File(dir, "appmap.xml");
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(appmap.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Oops, an error occured while writing appmap.xml");
        }
        try {
            file = new File(dir, "theme_resources.xml");
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(theme_resources.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Oops, an error occured while writing theme_resources.xml");
        }
    }
}

