/*
 * Decompiled with CFR 0.152.
 */
package com.pkmmte.requestmanager;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import com.pkmmte.requestmanager.AppFilterListener;
import com.pkmmte.requestmanager.AppInfo;
import com.pkmmte.requestmanager.AppLoadListener;
import com.pkmmte.requestmanager.InstalledAppLoadListener;
import com.pkmmte.requestmanager.RequestSettings;
import com.pkmmte.requestmanager.SendRequestListener;
import com.pkmmte.requestmanager.Static;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PkRequestManager
extends Static {
    public static final Bitmap.CompressFormat PNG = Bitmap.CompressFormat.PNG;
    public static final Bitmap.CompressFormat JPEG = Bitmap.CompressFormat.JPEG;
    public static final Bitmap.CompressFormat WEBP = Bitmap.CompressFormat.WEBP;
    public static final String PLAY_LINK_BASE = "https://play.google.com/store/apps/details?id=";
    public static final int MAX_PROGRESS = 100;
    public static final int STATUS_PRELOAD = 0;
    public static final int STATUS_LOADING_INSTALLED = 1;
    public static final int STATUS_LOADING_APPFILTER = 2;
    public static final int STATUS_FILTERING = 3;
    public static final int STATUS_LOADED = 4;
    private static PkRequestManager mInstance = null;
    private boolean debugEnabled = false;
    private static final String LOG_TAG = "RequestManager";
    private RequestSettings mSettings = new RequestSettings();
    private Context mContext;
    private Activity mActivity;
    private int numRequestsSent;
    private List<AppInfo> mApps;
    private List<AppInfo> mInstalledApps;
    private List<String> mDefinedApps;
    private AsyncTask<Void, Void, Void> loadTask;
    private AsyncTask<Void, Void, Void> sendTask;
    private AsyncTask<Void, Void, Void> autoTask;
    private List<InstalledAppLoadListener> mInstalledAppLoadListeners;
    private List<AppFilterListener> mAppFilterListeners;
    private List<AppLoadListener> mAppLoadListeners;
    private List<SendRequestListener> mSendRequestListeners;

    public static void createInstance(Context context) {
        if (mInstance == null) {
            mInstance = new PkRequestManager(context.getApplicationContext());
        }
    }

    public static PkRequestManager getInstance() {
        return mInstance;
    }

    public static PkRequestManager getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new PkRequestManager(context.getApplicationContext());
        }
        return mInstance;
    }

    public PkRequestManager(Context context) {
        this.mContext = context;
        this.numRequestsSent = 0;
        this.mApps = new ArrayList<AppInfo>();
        this.mInstalledApps = new ArrayList<AppInfo>();
        this.mDefinedApps = new ArrayList<String>();
        this.mInstalledAppLoadListeners = new ArrayList<InstalledAppLoadListener>();
        this.mAppFilterListeners = new ArrayList<AppFilterListener>();
        this.mAppLoadListeners = new ArrayList<AppLoadListener>();
        this.mSendRequestListeners = new ArrayList<SendRequestListener>();
        this.initLoadingTask();
        this.initSendTask();
        this.initAutomaticTask();
    }

    public void loadApps() {
        this.loadInstalledAppInfo();
        if (this.mSettings.getFilterDefined()) {
            this.loadDefinedAppInfo();
            this.filterAppInfo();
        }
    }

    public void loadAppsAsync() {
        this.loadAppsAsync(true);
    }

    public void loadAppsAsync(boolean parallel) {
        if (this.loadTask.getStatus() == AsyncTask.Status.PENDING) {
            this.loadTask.executeOnExecutor(parallel ? AsyncTask.THREAD_POOL_EXECUTOR : AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
        } else if (this.loadTask.getStatus() == AsyncTask.Status.RUNNING && this.debugEnabled) {
            Log.d((String)LOG_TAG, (String)"Task is already running...");
        } else if (this.loadTask.getStatus() == AsyncTask.Status.FINISHED) {
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)"Uh oh, it appears the task has finished without being reset. Resetting task...");
            }
            this.initLoadingTask();
            this.loadAppsAsync(parallel);
        }
    }

    public void loadAppsIfEmpty() {
        if (!this.appsLoaded()) {
            this.loadApps();
        }
    }

    public void loadAppsIfEmptyAsync() {
        if (!this.appsLoaded()) {
            this.loadAppsAsync();
        }
    }

    public void sendRequest() {
        this.sendRequest(false, false);
    }

    public void sendRequest(boolean selectAll, boolean automatic) {
        boolean intentSuccessful;
        Uri uri;
        StringBuilder emailBuilder;
        boolean createZip;
        boolean createAppfilter;
        String saveLoc2;
        String saveLoc;
        String emailSubject;
        String[] emailAddresses;
        block42: {
            int numSelected;
            StringBuilder xmlBuilder;
            block41: {
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)"Sending request...");
                }
                List<AppInfo> mAppList = automatic ? this.getAutomaticApps() : this.getApps();
                emailAddresses = this.mSettings.getEmailAddresses();
                emailSubject = this.mSettings.getEmailSubject();
                String emailPrecontent = this.mSettings.getEmailPrecontent();
                saveLoc = this.mSettings.getSaveLocation();
                saveLoc2 = this.mSettings.getSaveLocation2();
                Bitmap.CompressFormat compressFormat = this.mSettings.getCompressFormat();
                boolean appendInformation = this.mSettings.getAppendInformation();
                createAppfilter = this.mSettings.getCreateAppfilter();
                createZip = this.mSettings.getCreateZip();
                int compressQuality = this.mSettings.getCompressQuality();
                if (mAppList == null || mAppList.size() == 0) {
                    if (this.debugEnabled) {
                        Log.d((String)LOG_TAG, (String)"App List is either null or empty! Canceling send request...");
                    }
                    return;
                }
                if (emailAddresses == null) {
                    if (this.debugEnabled) {
                        Log.d((String)LOG_TAG, (String)"No proper email addresses were set! Canceling send request...");
                    }
                    return;
                }
                for (SendRequestListener mListener : this.mSendRequestListeners) {
                    mListener.onRequestStart(automatic);
                }
                File saveLocation = new File(saveLoc);
                File saveLocation2 = new File(saveLoc2);
                this.deleteDirectory(saveLocation);
                this.deleteDirectory(saveLocation2);
                saveLocation.mkdirs();
                saveLocation2.mkdirs();
                emailBuilder = new StringBuilder();
                xmlBuilder = new StringBuilder();
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)("Appending email precontent" + (appendInformation ? " and device information" : "")));
                }
                emailBuilder.append(emailPrecontent);
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)"Generating data...");
                }
                int numApps = mAppList.size();
                numSelected = 0;
                int progress = 0;
                for (AppInfo mAppInfo : mAppList) {
                    block40: {
                        progress = mAppList.indexOf(mAppInfo) * 100 / numApps;
                        for (SendRequestListener mListener : this.mSendRequestListeners) {
                            mListener.onRequestBuild(automatic, progress);
                        }
                        if (!selectAll && !mAppInfo.isSelected()) continue;
                        emailBuilder.append("Name: " + mAppInfo.getName() + "\n");
                        emailBuilder.append("Code: " + mAppInfo.getCode() + "\n");
                        emailBuilder.append("Link: https://play.google.com/store/apps/details?id=" + mAppInfo.getCode().split("/")[0] + "\n");
                        emailBuilder.append("\n\n");
                        if (createAppfilter) {
                            xmlBuilder.append("<!-- " + mAppInfo.getName() + " -->\n");
                            xmlBuilder.append("<item component=\"ComponentInfo{" + mAppInfo.getCode() + "}\" drawable=\"" + this.convertDrawableName(mAppInfo.getName()) + "\"/>" + "\n");
                        }
                        if (createZip) {
                            Drawable appImage = this.getHighResDrawable(mAppInfo);
                            if (appImage == null) {
                                appImage = mAppInfo.getImage();
                            }
                            Bitmap bitmap = this.drawableToBitmap(appImage);
                            try {
                                String bmDir = String.valueOf(saveLoc2) + "/" + mAppInfo.getCode().split("/")[0] + "_" + mAppInfo.getCode().split("/")[1] + ".png";
                                new File(bmDir).getParentFile().mkdirs();
                                FileOutputStream fOut = new FileOutputStream(bmDir);
                                bitmap.compress(compressFormat, compressQuality, (OutputStream)fOut);
                                fOut.flush();
                                fOut.close();
                            }
                            catch (FileNotFoundException e) {
                                if (this.debugEnabled) {
                                    Log.e((String)LOG_TAG, (String)"FileNotFoundException! Make sure the file isn't open in another app and you have writing permissions in your manifest.");
                                    e.printStackTrace();
                                }
                            }
                            catch (IOException e) {
                                if (!this.debugEnabled) break block40;
                                Log.e((String)LOG_TAG, (String)"IOException! Make sure you have the appropriate permissions.");
                                e.printStackTrace();
                            }
                        }
                    }
                    ++numSelected;
                }
                if (appendInformation) {
                    emailBuilder.append("\nOS Version: " + System.getProperty("os.version") + "(" + Build.VERSION.INCREMENTAL + ")");
                    emailBuilder.append("\nOS API Level: " + Build.VERSION.SDK_INT);
                    emailBuilder.append("\nDevice: " + Build.DEVICE);
                    emailBuilder.append("\nManufacturer: " + Build.MANUFACTURER);
                    emailBuilder.append("\nModel (and Product): " + Build.MODEL + " (" + Build.PRODUCT + ")");
                    try {
                        PackageInfo appInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
                        emailBuilder.append("\nApp Version Name: " + appInfo.versionName);
                        emailBuilder.append("\nApp Version Code: " + appInfo.versionCode);
                    }
                    catch (Exception e) {
                        if (!this.debugEnabled) break block41;
                        Log.d((String)LOG_TAG, (String)"Unable to append app version name/code...");
                    }
                }
            }
            if (numSelected == 0) {
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)"No apps were selected. Can't send request data without any data!");
                }
                return;
            }
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)("Successfully collected data for " + numSelected + " apps!"));
            }
            if (createAppfilter) {
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)"Writing appfilter.xml...");
                }
                try {
                    new File(String.valueOf(saveLoc2) + "/appfilter.xml").getParentFile().mkdirs();
                    FileWriter fstream = new FileWriter(String.valueOf(saveLoc2) + "/appfilter.xml");
                    BufferedWriter out = new BufferedWriter(fstream);
                    out.write(xmlBuilder.toString());
                    out.close();
                    if (this.debugEnabled) {
                        Log.d((String)LOG_TAG, (String)("Succesfully wrote appfilter.xml to " + saveLoc2 + "/appfilter.xml!"));
                    }
                }
                catch (Exception e) {
                    if (!this.debugEnabled) break block42;
                    Log.d((String)LOG_TAG, (String)"Error writing generated appfilter.xml! Make sure you have writing permissions in your AndroidManifest.xml");
                    e.printStackTrace();
                }
            }
        }
        String zipName = "mZip";
        if (createZip) {
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)"Zipping files...");
            }
            SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd_hhmmss", Locale.getDefault());
            zipName = date.format(new Date());
            this.createZipFile(saveLoc2, true, String.valueOf(saveLoc) + "/" + zipName + ".zip");
        }
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.EMAIL", emailAddresses);
        intent.putExtra("android.intent.extra.SUBJECT", emailSubject);
        intent.putExtra("android.intent.extra.TEXT", emailBuilder.toString());
        if (createZip) {
            intent.setType("application/zip");
            uri = Uri.parse((String)("file://" + saveLoc + "/" + zipName + ".zip"));
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        } else if (createAppfilter) {
            intent.setType("text/plain");
            uri = Uri.parse((String)("file://" + saveLoc2 + "/appfilter.xml"));
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        }
        intent.setFlags(0x10000000);
        if (this.debugEnabled) {
            Log.d((String)LOG_TAG, (String)"Successfully collected data!");
        }
        try {
            this.mActivity.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Send Email"));
            intentSuccessful = true;
        }
        catch (ActivityNotFoundException localActivityNotFoundException) {
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)"No email app has been found!");
            }
            intentSuccessful = false;
        }
        catch (Exception e) {
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)"There was an error starting the intent!");
                e.printStackTrace();
            }
            intentSuccessful = false;
        }
        ++this.numRequestsSent;
        for (SendRequestListener mListener : this.mSendRequestListeners) {
            mListener.onRequestFinished(automatic, intentSuccessful, intent);
        }
    }

    public void sendRequestAsync() {
        this.sendRequestAsync(true);
    }

    public void sendRequestAsync(boolean parallel) {
        if (this.sendTask.getStatus() == AsyncTask.Status.PENDING) {
            this.sendTask.executeOnExecutor(parallel ? AsyncTask.THREAD_POOL_EXECUTOR : AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
        } else if (this.sendTask.getStatus() == AsyncTask.Status.RUNNING && this.debugEnabled) {
            Log.d((String)LOG_TAG, (String)"Task is already running...");
        } else if (this.sendTask.getStatus() == AsyncTask.Status.FINISHED) {
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)"Uh oh, it appears the task has finished without being reset. Resetting task...");
            }
            this.initSendTask();
            this.sendRequestAsync(parallel);
        }
    }

    public void sendAutomaticRequest() {
        if (this.mInstalledApps.size() == 0 || this.mSettings.getFilterAutomatic() && (this.mApps.size() == 0 || this.mDefinedApps.size() == 0)) {
            this.loadInstalledAppInfo();
            if (this.mSettings.getFilterAutomatic()) {
                this.loadDefinedAppInfo();
                this.filterAppInfo();
            }
        }
        this.sendRequest(true, true);
    }

    public void sendAutomaticRequestAsync() {
        this.sendAutomaticRequestAsync(true);
    }

    public void sendAutomaticRequestAsync(boolean parallel) {
        if (this.autoTask.getStatus() == AsyncTask.Status.PENDING) {
            this.autoTask.executeOnExecutor(parallel ? AsyncTask.THREAD_POOL_EXECUTOR : AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
        } else if (this.autoTask.getStatus() == AsyncTask.Status.RUNNING && this.debugEnabled) {
            Log.d((String)LOG_TAG, (String)"Task is already running...");
        } else if (this.autoTask.getStatus() == AsyncTask.Status.FINISHED) {
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)"Uh oh, it appears the task has finished without being reset. Resetting task...");
            }
            this.initAutomaticTask();
            this.sendAutomaticRequestAsync(parallel);
        }
    }

    public void addInstalledAppLoadListener(InstalledAppLoadListener listener) {
        this.mInstalledAppLoadListeners.add(listener);
    }

    public void removeInstalledAppLoadListener(InstalledAppLoadListener listener) {
        this.mInstalledAppLoadListeners.remove(listener);
    }

    public void removeAllInstalledAppLoadListeners() {
        this.mInstalledAppLoadListeners.clear();
    }

    public void addAppFilterListener(AppFilterListener listener) {
        this.mAppFilterListeners.add(listener);
    }

    public void removeAppFilterListener(AppFilterListener listener) {
        this.mAppFilterListeners.remove(listener);
    }

    public void removeAllAppFilterListeners() {
        this.mAppFilterListeners.clear();
    }

    public void addAppLoadListener(AppLoadListener listener) {
        this.mAppLoadListeners.add(listener);
    }

    public void removeAppLoadListener(AppLoadListener listener) {
        this.mAppLoadListeners.remove(listener);
    }

    public void removeAllAppInfoLoadListeners() {
        this.mAppLoadListeners.clear();
    }

    public void addSendRequestListener(SendRequestListener listener) {
        this.mSendRequestListeners.add(listener);
    }

    public void removeSendRequestListener(SendRequestListener listener) {
        this.mSendRequestListeners.remove(listener);
    }

    public void removeAllSendRequestListeners() {
        this.mSendRequestListeners.clear();
    }

    public void removeAllListeners() {
        this.mInstalledAppLoadListeners.clear();
        this.mAppFilterListeners.clear();
        this.mAppLoadListeners.clear();
        this.mSendRequestListeners.clear();
    }

    public void deleteRequestData() {
        File saveLocation = new File(this.mSettings.getSaveLocation());
        File saveLocation2 = new File(this.mSettings.getSaveLocation2());
        this.deleteDirectory(saveLocation);
        this.deleteDirectory(saveLocation2);
    }

    public void cancelLoadingTask(boolean mayInterruptIfRunning) {
        this.loadTask.cancel(mayInterruptIfRunning);
        this.initLoadingTask();
    }

    public void cancelSendTask(boolean mayInterruptIfRunning) {
        this.sendTask.cancel(mayInterruptIfRunning);
        this.initSendTask();
    }

    public void cancelAutomaticTask(boolean mayInterruptIfRunning) {
        this.autoTask.cancel(mayInterruptIfRunning);
        this.initAutomaticTask();
    }

    public boolean appsLoaded() {
        return this.mInstalledApps.size() != 0 && (!this.mSettings.getFilterDefined() || this.mApps.size() != 0 && this.mDefinedApps.size() != 0);
    }

    public List<AppInfo> getApps() {
        if (this.mApps.size() == 0 || !this.mSettings.getFilterDefined()) {
            return this.mInstalledApps;
        }
        return this.mApps;
    }

    public List<AppInfo> getAutomaticApps() {
        if (this.mApps.size() == 0 || !this.mSettings.getFilterAutomatic()) {
            return this.mInstalledApps;
        }
        return this.mApps;
    }

    public List<AppInfo> getInstalledApps() {
        return this.mInstalledApps;
    }

    public List<String> getDefinedApps() {
        return this.mDefinedApps;
    }

    public int getNumRequestSent() {
        return this.numRequestsSent;
    }

    public int getNumSelected() {
        int count = 0;
        List<AppInfo> mAppList = this.getApps();
        for (AppInfo mApp : mAppList) {
            if (!mApp.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public void selectAll() {
        List<AppInfo> mAppList = this.getApps();
        for (AppInfo mApp : mAppList) {
            mApp.setSelected(true);
        }
    }

    public void deselectAll() {
        List<AppInfo> mAppList = this.getApps();
        for (AppInfo mApp : mAppList) {
            mApp.setSelected(false);
        }
    }

    public RequestSettings getSettings() {
        return this.mSettings;
    }

    public void setSettings(RequestSettings settings) {
        this.mSettings = settings;
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public void setDebugging(boolean debug) {
        this.debugEnabled = debug;
    }

    private void loadDefinedAppInfo() {
        block16: {
            try {
                int numElements;
                XmlPullParser mParser;
                block14: {
                    XmlPullParserFactory xmlFactoryObject = XmlPullParserFactory.newInstance();
                    mParser = xmlFactoryObject.newPullParser();
                    AssetManager assManager = this.mContext.getAssets();
                    InputStream inputStream = assManager.open(this.mSettings.getAppfilterName());
                    mParser.setInput(inputStream, null);
                    for (AppFilterListener mListener : this.mAppFilterListeners) {
                        mListener.onAppPrefilter();
                    }
                    numElements = 0;
                    try {
                        InputStream testStream = assManager.open(this.mSettings.getAppfilterName());
                        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                        Document doc = docBuilder.parse(testStream);
                        NodeList list = doc.getElementsByTagName("item");
                        numElements = list.getLength();
                    }
                    catch (Exception e) {
                        if (!this.debugEnabled) break block14;
                        Log.d((String)LOG_TAG, (String)"Error finding the number of appfilter elements!");
                        e.printStackTrace();
                    }
                }
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)(numElements + " items found in appfilter."));
                }
                this.mDefinedApps.clear();
                String mAppCode = null;
                int eventType = mParser.getEventType();
                int count = 0;
                int progress = 0;
                while (eventType != 1) {
                    block15: {
                        String elementName;
                        if (eventType == 2 && (elementName = mParser.getName()).equals("item")) {
                            progress = ++count * 100 / numElements;
                            for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
                                appLoadListener.onAppLoading(2, 33 + progress / 3);
                            }
                            for (AppFilterListener appFilterListener : this.mAppFilterListeners) {
                                appFilterListener.onAppFiltering(progress, 0);
                            }
                            try {
                                mAppCode = mParser.getAttributeValue(null, "component");
                                mAppCode = mAppCode.substring(14, mAppCode.length() - 1);
                                this.mDefinedApps.add(mAppCode);
                                mAppCode = null;
                            }
                            catch (Exception exception) {
                                if (!this.debugEnabled) break block15;
                                Log.e((String)LOG_TAG, (String)"Error adding parsed appfilter item!");
                                exception.printStackTrace();
                            }
                        }
                    }
                    eventType = mParser.next();
                }
            }
            catch (IOException eIO) {
                if (this.debugEnabled) {
                    Log.e((String)LOG_TAG, (String)"Unable to read appfilter.xml! Are you sure you have in it your assets folder?");
                }
            }
            catch (XmlPullParserException eXPPE) {
                if (!this.debugEnabled) break block16;
                Log.e((String)LOG_TAG, (String)"Unknown XmlPullParserException! This may be caused by a malformed appfilter.xml. Make sure it's fine.");
                eXPPE.printStackTrace();
            }
        }
    }

    private void loadInstalledAppInfo() {
        PackageManager pm = this.mContext.getPackageManager();
        List packages = pm.getInstalledApplications(128);
        Collections.sort(packages, new ApplicationInfo.DisplayNameComparator(pm));
        for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
            appLoadListener.onAppLoading(0, 0);
        }
        for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
            appLoadListener.onAppPreload();
        }
        for (InstalledAppLoadListener installedAppLoadListener : this.mInstalledAppLoadListeners) {
            installedAppLoadListener.onInstalledAppsPreload();
        }
        this.mInstalledApps.clear();
        Object var3_9 = null;
        Intent launchIntent = null;
        String launchStr = null;
        String appCode = null;
        String[] splitCode = null;
        boolean filterDefined = this.mSettings.getFilterDefined();
        int numPackages = packages.size();
        int progress = 0;
        for (ApplicationInfo applicationInfo : packages) {
            launchIntent = pm.getLaunchIntentForPackage(applicationInfo.packageName);
            if (launchIntent == null || launchIntent.equals("")) continue;
            progress = packages.indexOf(applicationInfo) * 100 / numPackages;
            for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
                appLoadListener.onAppLoading(1, filterDefined ? progress / 3 : progress);
            }
            for (InstalledAppLoadListener installedAppLoadListener : this.mInstalledAppLoadListeners) {
                installedAppLoadListener.onInstalledAppsLoading(progress);
            }
            AppInfo appInfo = new AppInfo();
            appInfo.setImage(applicationInfo.loadIcon(pm));
            appInfo.setName(applicationInfo.loadLabel(pm).toString());
            launchStr = launchIntent.toString().split("cmp=")[1];
            appCode = launchStr.substring(0, launchStr.length() - 1);
            splitCode = appCode.split("/");
            if (splitCode[1].startsWith(".")) {
                appCode = String.valueOf(splitCode[0]) + "/" + splitCode[0] + splitCode[1];
            }
            appCode = appCode.trim();
            appInfo.setCode(appCode);
            this.mInstalledApps.add(appInfo);
            Object var3_12 = null;
            launchStr = null;
            appCode = null;
            splitCode = null;
        }
        for (InstalledAppLoadListener installedAppLoadListener : this.mInstalledAppLoadListeners) {
            installedAppLoadListener.onInstalledAppsLoaded();
        }
        if (!filterDefined) {
            for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
                appLoadListener.onAppLoading(4, 100);
            }
        }
    }

    private void filterAppInfo() {
        this.mApps.clear();
        int numApps = this.mInstalledApps.size();
        int progress = 0;
        for (AppInfo appInfo : this.mInstalledApps) {
            progress = this.mInstalledApps.indexOf(appInfo) * 100 / numApps;
            for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
                appLoadListener.onAppLoading(3, 66 + progress / 3);
            }
            for (AppFilterListener appFilterListener : this.mAppFilterListeners) {
                appFilterListener.onAppFiltering(100, progress);
            }
            if (this.mDefinedApps.contains(appInfo.getCode())) continue;
            this.mApps.add(appInfo);
        }
        if (this.debugEnabled) {
            Log.d((String)LOG_TAG, (String)"Finished filtering apps!");
        }
        for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
            appLoadListener.onAppLoading(4, 100);
        }
        for (AppLoadListener appLoadListener : this.mAppLoadListeners) {
            appLoadListener.onAppLoaded();
        }
        for (AppFilterListener appFilterListener : this.mAppFilterListeners) {
            appFilterListener.onAppFiltered();
        }
    }

    private boolean createZipFile(String path, boolean keepDirectoryStructure, String outputFile) {
        File f = new File(path);
        if (!f.canRead() || !f.canWrite()) {
            if (this.debugEnabled) {
                Log.d((String)LOG_TAG, (String)(String.valueOf(path) + " cannot be compressed due to file permissions!"));
            }
            return false;
        }
        try {
            ZipOutputStream zip_out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), this.mSettings.getByteBuffer()));
            if (keepDirectoryStructure) {
                this.zipFile(path, zip_out, "");
            } else {
                File[] files;
                File[] fileArray = files = f.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.zipFolder(file, zip_out);
                    ++n2;
                }
            }
            zip_out.close();
        }
        catch (FileNotFoundException e) {
            if (this.debugEnabled) {
                Log.e((String)"File not found: ", (String)e.getMessage());
            }
            return false;
        }
        catch (IOException e) {
            if (this.debugEnabled) {
                Log.e((String)"IOException: ", (String)e.getMessage());
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zipFile(String path, ZipOutputStream out, String relPath) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            if (!this.debugEnabled) return;
            Log.d((String)LOG_TAG, (String)(String.valueOf(file.getName()) + " does NOT exist!"));
            return;
        }
        byte[] buffer = new byte[this.mSettings.getByteBuffer()];
        String[] files = file.list();
        if (file.isFile()) {
            FileInputStream in = new FileInputStream(file.getAbsolutePath());
            try {
                try {
                    int len;
                    out.putNextEntry(new ZipEntry(String.valueOf(relPath) + file.getName()));
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                    return;
                }
                catch (ZipException zipE) {
                    if (this.debugEnabled) {
                        Log.e((String)LOG_TAG, (String)zipE.getMessage());
                    }
                    if (out != null) {
                        out.closeEntry();
                    }
                    if (in == null) return;
                    in.close();
                }
                return;
            }
            finally {
                if (out != null) {
                    out.closeEntry();
                }
                if (in != null) {
                    in.close();
                }
            }
        } else {
            if (files.length <= 0) return;
            int i = 0;
            int length = files.length;
            while (i < length) {
                this.zipFile(String.valueOf(path) + "/" + files[i], out, String.valueOf(relPath) + file.getName() + "/");
                ++i;
            }
        }
    }

    private void zipFolder(File file, ZipOutputStream zout) throws IOException {
        byte[] data = new byte[this.mSettings.getByteBuffer()];
        if (file.isFile()) {
            int read;
            ZipEntry entry = new ZipEntry(file.getName());
            zout.putNextEntry(entry);
            BufferedInputStream instream = new BufferedInputStream(new FileInputStream(file));
            while ((read = instream.read(data, 0, this.mSettings.getByteBuffer())) != -1) {
                zout.write(data, 0, read);
            }
            zout.closeEntry();
            instream.close();
        } else if (file.isDirectory()) {
            String[] list = file.list();
            int len = list.length;
            int i = 0;
            while (i < len) {
                this.zipFolder(new File(String.valueOf(file.getPath()) + "/" + list[i]), zout);
                ++i;
            }
        }
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    @SuppressLint(value={"InlinedApi"})
    private Drawable getHighResDrawable(AppInfo app) {
        int iconId;
        Resources mRes;
        block8: {
            ActivityInfo info;
            PackageManager mPackageManager = this.mContext.getPackageManager();
            try {
                info = mPackageManager.getActivityInfo(new ComponentName(app.getCode().split("/")[0], app.getCode().split("/")[1]), 128);
                mRes = mPackageManager.getResourcesForApplication(info.applicationInfo);
            }
            catch (Exception e) {
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)("Unable to retrieve ActivityInfo for app " + app.getName()));
                }
                return null;
            }
            if (mRes == null) {
                return null;
            }
            try {
                iconId = info.getIconResource();
                if (iconId != 0) break block8;
                return null;
            }
            catch (Exception e) {
                if (this.debugEnabled) {
                    Log.d((String)LOG_TAG, (String)("Unable trying to get density drawable for app" + app.getName()));
                }
                return null;
            }
        }
        return mRes.getDrawableForDensity(iconId, 640);
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private String convertDrawableName(String appName) {
        return appName.replaceAll("[^a-zA-Z0-9\\p{Z}]", "").replaceFirst("^[0-9]+(?!$)", "").toLowerCase(Locale.US).replaceAll("\\p{Z}", "_");
    }

    private void initLoadingTask() {
        this.loadTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                PkRequestManager.this.loadApps();
                return null;
            }

            protected void onPostExecute(Void p) {
                PkRequestManager.this.initLoadingTask();
            }
        };
    }

    private void initSendTask() {
        this.sendTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                PkRequestManager.this.sendRequest();
                return null;
            }

            protected void onPostExecute(Void p) {
                PkRequestManager.this.initSendTask();
            }
        };
    }

    private void initAutomaticTask() {
        this.autoTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                PkRequestManager.this.sendAutomaticRequest();
                return null;
            }

            protected void onPostExecute(Void p) {
                PkRequestManager.this.initAutomaticTask();
            }
        };
    }
}

