/*
 * Decompiled with CFR 0.152.
 */
package com.pkmmte.requestmanager;

import android.graphics.Bitmap;
import android.os.Environment;
import java.util.ArrayList;
import java.util.List;

public class RequestSettings {
    private String[] emailAddresses;
    private String emailSubject;
    private String emailPrecontent;
    private String saveLocation;
    private String saveLocation2;
    private String appfilterName;
    private Bitmap.CompressFormat compressFormat;
    private boolean appendInformation;
    private boolean createAppfilter;
    private boolean createZip;
    private boolean filterAutomatic;
    private boolean filterDefined;
    private int byteBuffer;
    private int compressQuality;

    public RequestSettings() {
        this.emailAddresses = null;
        this.emailSubject = "No Subject";
        this.emailPrecontent = "";
        this.saveLocation = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/.icon_request";
        this.saveLocation2 = String.valueOf(this.saveLocation) + "/files";
        this.appfilterName = "appfilter.xml";
        this.compressFormat = Bitmap.CompressFormat.PNG;
        this.appendInformation = true;
        this.createAppfilter = true;
        this.createZip = true;
        this.filterAutomatic = true;
        this.filterDefined = true;
        this.byteBuffer = 2048;
        this.compressQuality = 100;
    }

    private RequestSettings(Builder builder) {
        this.emailAddresses = builder.emailAddresses.toArray(new String[builder.emailAddresses.size()]);
        this.emailSubject = builder.emailSubject;
        this.emailPrecontent = builder.emailPrecontent;
        this.saveLocation = builder.saveLocation;
        this.saveLocation2 = builder.saveLocation2;
        this.appfilterName = builder.appfilterName;
        this.compressFormat = builder.compressFormat;
        this.appendInformation = builder.appendInformation;
        this.createAppfilter = builder.createAppfilter;
        this.createZip = builder.createZip;
        this.filterAutomatic = builder.filterAutomatic;
        this.filterDefined = builder.filterDefined;
        this.byteBuffer = builder.byteBuffer;
        this.compressQuality = builder.compressQuality;
    }

    public void setEmailAddresses(String[] emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public void setEmailPrecontent(String emailPrecontent) {
        this.emailPrecontent = emailPrecontent;
    }

    public void setSaveLocation(String saveLocation) {
        this.saveLocation = saveLocation;
        this.saveLocation2 = String.valueOf(this.saveLocation) + "/files";
    }

    public void setAppfilterName(String appfilterName) {
        this.appfilterName = appfilterName;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setAppendInformation(boolean appendInformation) {
        this.appendInformation = appendInformation;
    }

    public void setCreateAppsfilter(boolean createAppfilter) {
        this.createAppfilter = createAppfilter;
    }

    public void setCreateZip(boolean createZip) {
        this.createZip = createZip;
    }

    public void setFilterAutomatic(boolean filterAutomatic) {
        this.filterAutomatic = filterAutomatic;
    }

    public void setFilterDefined(boolean filterDefined) {
        this.filterDefined = filterDefined;
    }

    public void setByteBuffer(int byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setCompressQuality(int compressQuality) {
        this.compressQuality = compressQuality;
    }

    public String[] getEmailAddresses() {
        return this.emailAddresses;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getEmailPrecontent() {
        return this.emailPrecontent;
    }

    public String getSaveLocation() {
        return this.saveLocation;
    }

    public String getSaveLocation2() {
        return this.saveLocation2;
    }

    public String getAppfilterName() {
        return this.appfilterName;
    }

    public Bitmap.CompressFormat getCompressFormat() {
        return this.compressFormat;
    }

    public boolean getAppendInformation() {
        return this.appendInformation;
    }

    public boolean getCreateAppfilter() {
        return this.createAppfilter;
    }

    public boolean getCreateZip() {
        return this.createZip;
    }

    public boolean getFilterAutomatic() {
        return this.filterAutomatic;
    }

    public boolean getFilterDefined() {
        return this.filterDefined;
    }

    public int getByteBuffer() {
        return this.byteBuffer;
    }

    public int getCompressQuality() {
        return this.compressQuality;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Email Addresses: " + (this.emailAddresses == null ? "null" : this.emailAddresses.toString()) + "\n");
        builder.append("Email Subject: " + this.emailSubject + "\n");
        builder.append("Email Precontent: " + this.emailPrecontent + "\n");
        builder.append("Save Location: " + this.saveLocation + "\n");
        builder.append("Save Location 2: " + this.saveLocation2 + "\n");
        builder.append("Appfilter Name: " + this.appfilterName + "\n");
        builder.append("Compress Format: " + this.compressFormat.toString() + "\n");
        builder.append("Append Information: " + this.appendInformation + "\n");
        builder.append("Create Appfilter: " + this.createAppfilter + "\n");
        builder.append("Create Zip: " + this.createZip + "\n");
        builder.append("Filter Automatic: " + this.filterAutomatic + "\n");
        builder.append("Filter Defined: " + this.filterDefined + "\n");
        builder.append("Byte Buffer: " + this.byteBuffer + "\n");
        builder.append("Compress Quality: " + this.compressQuality + "\n");
        return builder.toString();
    }

    /* synthetic */ RequestSettings(Builder builder, RequestSettings requestSettings) {
        this(builder);
    }

    public static class Builder {
        private List<String> emailAddresses = new ArrayList<String>();
        private String emailSubject = "No Subject";
        private String emailPrecontent = "";
        private String saveLocation = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/.icon_request";
        private String saveLocation2 = String.valueOf(this.saveLocation) + "/files";
        private String appfilterName = "appfilter.xml";
        private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
        private boolean appendInformation = true;
        private boolean createAppfilter = true;
        private boolean createZip = true;
        private boolean filterAutomatic = true;
        private boolean filterDefined = true;
        private int byteBuffer = 2048;
        private int compressQuality = 100;

        public Builder addEmailAddress(String emailAddress) {
            this.emailAddresses.add(emailAddress);
            return this;
        }

        public Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public Builder emailPrecontent(String emailPrecontent) {
            this.emailPrecontent = emailPrecontent;
            return this;
        }

        public Builder saveLocation(String saveLocation) {
            this.saveLocation = saveLocation;
            this.saveLocation2 = String.valueOf(this.saveLocation) + "/files";
            return this;
        }

        public Builder appfilterName(String appfilterName) {
            this.appfilterName = appfilterName;
            return this;
        }

        public Builder compressFormat(Bitmap.CompressFormat compressFormat) {
            this.compressFormat = compressFormat;
            return this;
        }

        public Builder appendInformation(boolean appendInformation) {
            this.appendInformation = appendInformation;
            return this;
        }

        public Builder createAppfilter(boolean createAppfilter) {
            this.createAppfilter = createAppfilter;
            return this;
        }

        public Builder createZip(boolean createZip) {
            this.createZip = createZip;
            return this;
        }

        public Builder filterAutomatic(boolean filterAutomatic) {
            this.filterAutomatic = filterAutomatic;
            return this;
        }

        public Builder filterDefined(boolean filterDefined) {
            this.filterDefined = filterDefined;
            return this;
        }

        public Builder byteBuffer(int byteBuffer) {
            this.byteBuffer = byteBuffer;
            return this;
        }

        public Builder compressQuality(int compressQuality) {
            this.compressQuality = compressQuality;
            return this;
        }

        public RequestSettings build() {
            return new RequestSettings(this, null);
        }
    }
}

