/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.utils.CommonUtils;

public class AIFunctionDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "com.dbeaver.ai.function";
    private final IConfigurationElement contributorConfig;
    private final AbstractDescriptor.ObjectType objectType;
    private final String id;
    private final String name;
    private final DBPImage icon;
    private final boolean global;
    private final AIFunctionResult.FunctionType type;
    private final String categoryId;
    private final Parameter[] parameters;

    public AIFunctionDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.contributorConfig = config;
        this.objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config, "class");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.global = CommonUtils.toBoolean((Object)config.getAttribute("global"));
        this.categoryId = config.getAttribute("categoryId");
        this.type = (AIFunctionResult.FunctionType)CommonUtils.valueOf(AIFunctionResult.FunctionType.class, (String)config.getAttribute("type"), (Enum)AIFunctionResult.FunctionType.INFORMATION);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("parameter");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pe = iConfigurationElementArray[n2];
            params.add(new Parameter(pe));
            ++n2;
        }
        this.parameters = params.toArray(new Parameter[0]);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public AIFunctionResult.FunctionType getType() {
        return this.type;
    }

    @Nullable
    public String getDescription() {
        return this.contributorConfig.getAttribute("description");
    }

    public boolean isGlobal() {
        return this.global;
    }

    @NotNull
    public Parameter[] getParameters() {
        return this.parameters;
    }

    @NotNull
    public AIFunction createInstance() throws DBException {
        try {
            return (AIFunction)this.objectType.createInstance(AIFunction.class);
        }
        catch (Exception e) {
            throw new DBException("Error creating AI function " + this.getId(), (Throwable)e);
        }
    }

    public boolean isApplicable(@NotNull AIEngineDescriptor engine, @NotNull AIPromptGenerator prompt) {
        return false;
    }

    public String toString() {
        return "AI function: " + this.getId();
    }

    @NotNull
    public String getSignature() {
        return this.getId();
    }

    @Nullable
    public String getCategoryId() {
        return this.categoryId;
    }

    public class Parameter {
        private static final Log log = Log.getLog(Parameter.class);
        private final IConfigurationElement config;

        Parameter(IConfigurationElement config) {
            this.config = config;
        }

        @NotNull
        public String getName() {
            return this.config.getAttribute("name");
        }

        @NotNull
        public String getType() {
            return this.config.getAttribute("type");
        }

        @Nullable
        public String getDescription() {
            return this.config.getAttribute("description");
        }

        public boolean isRequired() {
            return CommonUtils.getBoolean((String)this.config.getAttribute("required"));
        }

        @Nullable
        public String[] getValidValues() {
            String validValues = this.config.getAttribute("validValues");
            if (CommonUtils.isEmpty((String)validValues) && CommonUtils.isNotEmpty((String)this.config.getAttribute("validValuesProvider"))) {
                AbstractDescriptor.ObjectType validValuesProvider = new AbstractDescriptor.ObjectType((AbstractDescriptor)AIFunctionDescriptor.this, this.config, "validValuesProvider");
                try {
                    IPropertyValueListProvider provider = (IPropertyValueListProvider)validValuesProvider.createInstance(IPropertyValueListProvider.class);
                    Object[] validObjects = provider.getPossibleValues((Object)this);
                    return (String[])validObjects;
                }
                catch (DBException e) {
                    log.error((Object)"Error on getting valid values from provider", (Throwable)e);
                }
            }
            return CommonUtils.isEmpty((String)validValues) ? null : validValues.split(",");
        }
    }
}

