package apimanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// QuotaByCounterKeysClient is the client for the QuotaByCounterKeys methods of the Apimanagement service.
type QuotaByCounterKeysClient struct {
	BaseClient
}

// NewQuotaByCounterKeysClient creates an instance of the QuotaByCounterKeysClient client.
func NewQuotaByCounterKeysClient() QuotaByCounterKeysClient {
	return QuotaByCounterKeysClient{New()}
}

// List lists a collection of current quota counter periods associated with the counter-key configured in the policy on
// the specified service instance. The api does not support paging yet.
// Parameters:
// apimBaseURL - the management endpoint of the API Management service, for example
// https://myapimservice.management.azure-api.net.
// quotaCounterKey - quota counter key identifier.This is the result of expression defined in counter-key
// attribute of the quota-by-key policy.For Example, if you specify counter-key="boo" in the policy, then it’s
// accessible by "boo" counter key. But if it’s defined as counter-key="@("b"+"a")" then it will be accessible
// by "ba" key
func (client QuotaByCounterKeysClient) List(ctx context.Context, apimBaseURL string, quotaCounterKey string) (result QuotaCounterCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaByCounterKeysClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, apimBaseURL, quotaCounterKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.QuotaByCounterKeysClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "apimanagement.QuotaByCounterKeysClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.QuotaByCounterKeysClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client QuotaByCounterKeysClient) ListPreparer(ctx context.Context, apimBaseURL string, quotaCounterKey string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"apimBaseUrl": apimBaseURL,
	}

	pathParameters := map[string]interface{}{
		"quotaCounterKey": autorest.Encode("path", quotaCounterKey),
	}

	const APIVersion = "2017-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{apimBaseUrl}", urlParameters),
		autorest.WithPathParameters("/quotas/{quotaCounterKey}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client QuotaByCounterKeysClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client QuotaByCounterKeysClient) ListResponder(resp *http.Response) (result QuotaCounterCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update updates all the quota counter values specified with the existing quota counter key to a value in the
// specified service instance. This should be used for reset of the quota counter values.
// Parameters:
// apimBaseURL - the management endpoint of the API Management service, for example
// https://myapimservice.management.azure-api.net.
// quotaCounterKey - quota counter key identifier.This is the result of expression defined in counter-key
// attribute of the quota-by-key policy.For Example, if you specify counter-key="boo" in the policy, then it’s
// accessible by "boo" counter key. But if it’s defined as counter-key="@("b"+"a")" then it will be accessible
// by "ba" key
// parameters - the value of the quota counter to be applied to all quota counter periods.
func (client QuotaByCounterKeysClient) Update(ctx context.Context, apimBaseURL string, quotaCounterKey string, parameters QuotaCounterValueContractProperties) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaByCounterKeysClient.Update")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, apimBaseURL, quotaCounterKey, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.QuotaByCounterKeysClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "apimanagement.QuotaByCounterKeysClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.QuotaByCounterKeysClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client QuotaByCounterKeysClient) UpdatePreparer(ctx context.Context, apimBaseURL string, quotaCounterKey string, parameters QuotaCounterValueContractProperties) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"apimBaseUrl": apimBaseURL,
	}

	pathParameters := map[string]interface{}{
		"quotaCounterKey": autorest.Encode("path", quotaCounterKey),
	}

	const APIVersion = "2017-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{apimBaseUrl}", urlParameters),
		autorest.WithPathParameters("/quotas/{quotaCounterKey}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client QuotaByCounterKeysClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client QuotaByCounterKeysClient) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
