// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package supplychain_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/supplychain"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Invoke CreateBillOfMaterialsImportJob
//

func ExampleSupplyChain_CreateBillOfMaterialsImportJob_shared00() {
	svc := supplychain.New(session.New())
	input := &supplychain.CreateBillOfMaterialsImportJobInput{
		ClientToken: aws.String("550e8400-e29b-41d4-a716-446655440000"),
		InstanceId:  aws.String("60f82bbd-71f7-4fcd-a941-472f574c5243"),
		S3uri:       aws.String("s3://mybucketname/pathelemene/file.csv"),
	}

	result, err := svc.CreateBillOfMaterialsImportJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Invoke GetBillOfMaterialsImportJob for a successful job
//

func ExampleSupplyChain_GetBillOfMaterialsImportJob_shared00() {
	svc := supplychain.New(session.New())
	input := &supplychain.GetBillOfMaterialsImportJobInput{
		InstanceId: aws.String("60f82bbd-71f7-4fcd-a941-472f574c5243"),
		JobId:      aws.String("f79b359b-1515-4436-a3bf-bae7b33e47b4"),
	}

	result, err := svc.GetBillOfMaterialsImportJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Invoke GetBillOfMaterialsImportJob for an in-progress job
//

func ExampleSupplyChain_GetBillOfMaterialsImportJob_shared01() {
	svc := supplychain.New(session.New())
	input := &supplychain.GetBillOfMaterialsImportJobInput{
		InstanceId: aws.String("60f82bbd-71f7-4fcd-a941-472f574c5243"),
		JobId:      aws.String("f79b359b-1515-4436-a3bf-bae7b33e47b4"),
	}

	result, err := svc.GetBillOfMaterialsImportJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for inboundorder event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared00() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"id\": \"inbound-order-id-test-123\", \"tpartner_id\": \"partner-id-test-123\" }"),
		EventGroupId:   aws.String("inboundOrderId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.inboundorder"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for inboundorderline event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared01() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"id\": \"inbound-order-line-id-test-123\", \"order_id\": \"order-id-test-123\", \"tpartner_id\": \"partner-id-test-123\", \"product_id\": \"product-id-test-123\", \"quantity_submitted\": \"100.0\" }"),
		EventGroupId:   aws.String("inboundOrderLineId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.inboundorderline"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for inboundorderlineschedule event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared02() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"id\": \"inbound-order-line-schedule-id-test-123\", \"order_id\": \"order-id-test-123\", \"order_line_id\": \"order-line-id-test-123\", \"product_id\": \"product-id-test-123\"}"),
		EventGroupId:   aws.String("inboundOrderLineScheduleId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.inboundorderlineschedule"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for forecast event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared03() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"snapshot_date\": \"1672470400000\", \"product_id\": \"product-id-test-123\", \"site_id\": \"site-id-test-123\", \"region_id\": \"region-id-test-123\", \"product_group_id\": \"product-group-id-test-123\", \"forecast_start_dttm\": \"1672470400000\", \"forecast_end_dttm\": \"1672470400000\" }"),
		EventGroupId:   aws.String("forecastId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.forecast"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for inventorylevel event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared04() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"snapshot_date\": \"1672470400000\", \"site_id\": \"site-id-test-123\", \"product_id\": \"product-id-test-123\", \"on_hand_inventory\": \"100.0\", \"inv_condition\": \"good\", \"lot_number\": \"lot-number-test-123\"}"),
		EventGroupId:   aws.String("inventoryLevelId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.inventorylevel"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for outboundorderline event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared05() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"id\": \"outbound-orderline-id-test-123\", \"cust_order_id\": \"cust-order-id-test-123\", \"product_id\": \"product-id-test-123\" }"),
		EventGroupId:   aws.String("outboundOrderLineId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.outboundorderline"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for outboundshipment event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared06() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"id\": \"outbound-shipment-id-test-123\", \"cust_order_id\": \"cust-order-id-test-123\", \"cust_order_line_id\": \"cust-order-line-id-test-123\", \"product_id\": \"product-id-test-123\" }"),
		EventGroupId:   aws.String("outboundShipmentId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.outboundshipment"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for processheader event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared07() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"process_id\": \"process-id-test-123\" }"),
		EventGroupId:   aws.String("processHeaderId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.processheader"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for processoperation event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared08() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"process_operation_id\": \"process-operation-id-test-123\", \"process_id\": \"process-id-test-123\" }"),
		EventGroupId:   aws.String("processOperationId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.processoperation"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for processproduct event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared09() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"process_product_id\": \"process-product-id-test-123\", \"process_id\": \"process-id-test-123\" }"),
		EventGroupId:   aws.String("processProductId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.processproduct"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for reservation event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared10() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"reservation_id\": \"reservation-id-test-123\", \"reservation_detail_id\": \"reservation-detail-id-test-123\" }"),
		EventGroupId:   aws.String("reservationId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.reservation"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for shipment event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared11() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"id\": \"shipment-id-test-123\", \"supplier_tpartner_id\": \"supplier-tpartner-id-test-123\", \"product_id\": \"product-id-test-123\", \"order_id\": \"order-id-test-123\", \"order_line_id\": \"order-line-id-test-123\", \"package_id\": \"package-id-test-123\" }"),
		EventGroupId:   aws.String("shipmentId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.shipment"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for shipmentstop event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared12() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"shipment_stop_id\": \"shipment-stop-id-test-123\", \"shipment_id\": \"shipment-id-test-123\" }"),
		EventGroupId:   aws.String("shipmentStopId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.shipmentstop"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for shipmentstoporder event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared13() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"shipment_stop_order_id\": \"shipment-stop-order-id-test-123\", \"shipment_stop_id\": \"shipment-stop-id-test-123\", \"shipment_id\": \"shipment-id-test-123\" }"),
		EventGroupId:   aws.String("shipmentStopOrderId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.shipmentstoporder"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Successful SendDataIntegrationEvent for supplyplan event type
//

func ExampleSupplyChain_SendDataIntegrationEvent_shared14() {
	svc := supplychain.New(session.New())
	input := &supplychain.SendDataIntegrationEventInput{
		Data:           aws.String("{\"supply_plan_id\": \"supply-plan-id-test-123\" }"),
		EventGroupId:   aws.String("supplyPlanId"),
		EventTimestamp: parseTime("2006-01-02T15:04:05.999999999Z", "1515531081.123000"),
		EventType:      aws.String("scn.data.supplyplan"),
		InstanceId:     aws.String("8928ae12-15e5-4441-825d-ec2184f0a43a"),
	}

	result, err := svc.SendDataIntegrationEvent(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case supplychain.ErrCodeServiceQuotaExceededException:
				fmt.Println(supplychain.ErrCodeServiceQuotaExceededException, aerr.Error())
			case supplychain.ErrCodeResourceNotFoundException:
				fmt.Println(supplychain.ErrCodeResourceNotFoundException, aerr.Error())
			case supplychain.ErrCodeThrottlingException:
				fmt.Println(supplychain.ErrCodeThrottlingException, aerr.Error())
			case supplychain.ErrCodeAccessDeniedException:
				fmt.Println(supplychain.ErrCodeAccessDeniedException, aerr.Error())
			case supplychain.ErrCodeValidationException:
				fmt.Println(supplychain.ErrCodeValidationException, aerr.Error())
			case supplychain.ErrCodeInternalServerException:
				fmt.Println(supplychain.ErrCodeInternalServerException, aerr.Error())
			case supplychain.ErrCodeConflictException:
				fmt.Println(supplychain.ErrCodeConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
