// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspacesweb

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateBrowserSettings = "AssociateBrowserSettings"

// AssociateBrowserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateBrowserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateBrowserSettings for more information on using the AssociateBrowserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateBrowserSettingsRequest method.
//	req, resp := client.AssociateBrowserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings
func (c *WorkSpacesWeb) AssociateBrowserSettingsRequest(input *AssociateBrowserSettingsInput) (req *request.Request, output *AssociateBrowserSettingsOutput) {
	op := &request.Operation{
		Name:       opAssociateBrowserSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalArn+}/browserSettings",
	}

	if input == nil {
		input = &AssociateBrowserSettingsInput{}
	}

	output = &AssociateBrowserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateBrowserSettings API operation for Amazon WorkSpaces Web.
//
// Associates a browser settings resource with a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation AssociateBrowserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings
func (c *WorkSpacesWeb) AssociateBrowserSettings(input *AssociateBrowserSettingsInput) (*AssociateBrowserSettingsOutput, error) {
	req, out := c.AssociateBrowserSettingsRequest(input)
	return out, req.Send()
}

// AssociateBrowserSettingsWithContext is the same as AssociateBrowserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateBrowserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) AssociateBrowserSettingsWithContext(ctx aws.Context, input *AssociateBrowserSettingsInput, opts ...request.Option) (*AssociateBrowserSettingsOutput, error) {
	req, out := c.AssociateBrowserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIpAccessSettings = "AssociateIpAccessSettings"

// AssociateIpAccessSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIpAccessSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIpAccessSettings for more information on using the AssociateIpAccessSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateIpAccessSettingsRequest method.
//	req, resp := client.AssociateIpAccessSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateIpAccessSettings
func (c *WorkSpacesWeb) AssociateIpAccessSettingsRequest(input *AssociateIpAccessSettingsInput) (req *request.Request, output *AssociateIpAccessSettingsOutput) {
	op := &request.Operation{
		Name:       opAssociateIpAccessSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalArn+}/ipAccessSettings",
	}

	if input == nil {
		input = &AssociateIpAccessSettingsInput{}
	}

	output = &AssociateIpAccessSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIpAccessSettings API operation for Amazon WorkSpaces Web.
//
// Associates an IP access settings resource with a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation AssociateIpAccessSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateIpAccessSettings
func (c *WorkSpacesWeb) AssociateIpAccessSettings(input *AssociateIpAccessSettingsInput) (*AssociateIpAccessSettingsOutput, error) {
	req, out := c.AssociateIpAccessSettingsRequest(input)
	return out, req.Send()
}

// AssociateIpAccessSettingsWithContext is the same as AssociateIpAccessSettings with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIpAccessSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) AssociateIpAccessSettingsWithContext(ctx aws.Context, input *AssociateIpAccessSettingsInput, opts ...request.Option) (*AssociateIpAccessSettingsOutput, error) {
	req, out := c.AssociateIpAccessSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateNetworkSettings = "AssociateNetworkSettings"

// AssociateNetworkSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateNetworkSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateNetworkSettings for more information on using the AssociateNetworkSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateNetworkSettingsRequest method.
//	req, resp := client.AssociateNetworkSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings
func (c *WorkSpacesWeb) AssociateNetworkSettingsRequest(input *AssociateNetworkSettingsInput) (req *request.Request, output *AssociateNetworkSettingsOutput) {
	op := &request.Operation{
		Name:       opAssociateNetworkSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalArn+}/networkSettings",
	}

	if input == nil {
		input = &AssociateNetworkSettingsInput{}
	}

	output = &AssociateNetworkSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateNetworkSettings API operation for Amazon WorkSpaces Web.
//
// Associates a network settings resource with a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation AssociateNetworkSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings
func (c *WorkSpacesWeb) AssociateNetworkSettings(input *AssociateNetworkSettingsInput) (*AssociateNetworkSettingsOutput, error) {
	req, out := c.AssociateNetworkSettingsRequest(input)
	return out, req.Send()
}

// AssociateNetworkSettingsWithContext is the same as AssociateNetworkSettings with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateNetworkSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) AssociateNetworkSettingsWithContext(ctx aws.Context, input *AssociateNetworkSettingsInput, opts ...request.Option) (*AssociateNetworkSettingsOutput, error) {
	req, out := c.AssociateNetworkSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTrustStore = "AssociateTrustStore"

// AssociateTrustStoreRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTrustStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTrustStore for more information on using the AssociateTrustStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateTrustStoreRequest method.
//	req, resp := client.AssociateTrustStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore
func (c *WorkSpacesWeb) AssociateTrustStoreRequest(input *AssociateTrustStoreInput) (req *request.Request, output *AssociateTrustStoreOutput) {
	op := &request.Operation{
		Name:       opAssociateTrustStore,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalArn+}/trustStores",
	}

	if input == nil {
		input = &AssociateTrustStoreInput{}
	}

	output = &AssociateTrustStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTrustStore API operation for Amazon WorkSpaces Web.
//
// Associates a trust store with a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation AssociateTrustStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore
func (c *WorkSpacesWeb) AssociateTrustStore(input *AssociateTrustStoreInput) (*AssociateTrustStoreOutput, error) {
	req, out := c.AssociateTrustStoreRequest(input)
	return out, req.Send()
}

// AssociateTrustStoreWithContext is the same as AssociateTrustStore with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTrustStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) AssociateTrustStoreWithContext(ctx aws.Context, input *AssociateTrustStoreInput, opts ...request.Option) (*AssociateTrustStoreOutput, error) {
	req, out := c.AssociateTrustStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateUserAccessLoggingSettings = "AssociateUserAccessLoggingSettings"

// AssociateUserAccessLoggingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateUserAccessLoggingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateUserAccessLoggingSettings for more information on using the AssociateUserAccessLoggingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateUserAccessLoggingSettingsRequest method.
//	req, resp := client.AssociateUserAccessLoggingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings
func (c *WorkSpacesWeb) AssociateUserAccessLoggingSettingsRequest(input *AssociateUserAccessLoggingSettingsInput) (req *request.Request, output *AssociateUserAccessLoggingSettingsOutput) {
	op := &request.Operation{
		Name:       opAssociateUserAccessLoggingSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalArn+}/userAccessLoggingSettings",
	}

	if input == nil {
		input = &AssociateUserAccessLoggingSettingsInput{}
	}

	output = &AssociateUserAccessLoggingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateUserAccessLoggingSettings API operation for Amazon WorkSpaces Web.
//
// Associates a user access logging settings resource with a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation AssociateUserAccessLoggingSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings
func (c *WorkSpacesWeb) AssociateUserAccessLoggingSettings(input *AssociateUserAccessLoggingSettingsInput) (*AssociateUserAccessLoggingSettingsOutput, error) {
	req, out := c.AssociateUserAccessLoggingSettingsRequest(input)
	return out, req.Send()
}

// AssociateUserAccessLoggingSettingsWithContext is the same as AssociateUserAccessLoggingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateUserAccessLoggingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) AssociateUserAccessLoggingSettingsWithContext(ctx aws.Context, input *AssociateUserAccessLoggingSettingsInput, opts ...request.Option) (*AssociateUserAccessLoggingSettingsOutput, error) {
	req, out := c.AssociateUserAccessLoggingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateUserSettings = "AssociateUserSettings"

// AssociateUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateUserSettings for more information on using the AssociateUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateUserSettingsRequest method.
//	req, resp := client.AssociateUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings
func (c *WorkSpacesWeb) AssociateUserSettingsRequest(input *AssociateUserSettingsInput) (req *request.Request, output *AssociateUserSettingsOutput) {
	op := &request.Operation{
		Name:       opAssociateUserSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalArn+}/userSettings",
	}

	if input == nil {
		input = &AssociateUserSettingsInput{}
	}

	output = &AssociateUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateUserSettings API operation for Amazon WorkSpaces Web.
//
// Associates a user settings resource with a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation AssociateUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings
func (c *WorkSpacesWeb) AssociateUserSettings(input *AssociateUserSettingsInput) (*AssociateUserSettingsOutput, error) {
	req, out := c.AssociateUserSettingsRequest(input)
	return out, req.Send()
}

// AssociateUserSettingsWithContext is the same as AssociateUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) AssociateUserSettingsWithContext(ctx aws.Context, input *AssociateUserSettingsInput, opts ...request.Option) (*AssociateUserSettingsOutput, error) {
	req, out := c.AssociateUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBrowserSettings = "CreateBrowserSettings"

// CreateBrowserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateBrowserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBrowserSettings for more information on using the CreateBrowserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBrowserSettingsRequest method.
//	req, resp := client.CreateBrowserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings
func (c *WorkSpacesWeb) CreateBrowserSettingsRequest(input *CreateBrowserSettingsInput) (req *request.Request, output *CreateBrowserSettingsOutput) {
	op := &request.Operation{
		Name:       opCreateBrowserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/browserSettings",
	}

	if input == nil {
		input = &CreateBrowserSettingsInput{}
	}

	output = &CreateBrowserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBrowserSettings API operation for Amazon WorkSpaces Web.
//
// Creates a browser settings resource that can be associated with a web portal.
// Once associated with a web portal, browser settings control how the browser
// will behave once a user starts a streaming session for the web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreateBrowserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings
func (c *WorkSpacesWeb) CreateBrowserSettings(input *CreateBrowserSettingsInput) (*CreateBrowserSettingsOutput, error) {
	req, out := c.CreateBrowserSettingsRequest(input)
	return out, req.Send()
}

// CreateBrowserSettingsWithContext is the same as CreateBrowserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBrowserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreateBrowserSettingsWithContext(ctx aws.Context, input *CreateBrowserSettingsInput, opts ...request.Option) (*CreateBrowserSettingsOutput, error) {
	req, out := c.CreateBrowserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIdentityProvider = "CreateIdentityProvider"

// CreateIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdentityProvider for more information on using the CreateIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIdentityProviderRequest method.
//	req, resp := client.CreateIdentityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider
func (c *WorkSpacesWeb) CreateIdentityProviderRequest(input *CreateIdentityProviderInput) (req *request.Request, output *CreateIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opCreateIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/identityProviders",
	}

	if input == nil {
		input = &CreateIdentityProviderInput{}
	}

	output = &CreateIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdentityProvider API operation for Amazon WorkSpaces Web.
//
// Creates an identity provider resource that is then associated with a web
// portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreateIdentityProvider for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider
func (c *WorkSpacesWeb) CreateIdentityProvider(input *CreateIdentityProviderInput) (*CreateIdentityProviderOutput, error) {
	req, out := c.CreateIdentityProviderRequest(input)
	return out, req.Send()
}

// CreateIdentityProviderWithContext is the same as CreateIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreateIdentityProviderWithContext(ctx aws.Context, input *CreateIdentityProviderInput, opts ...request.Option) (*CreateIdentityProviderOutput, error) {
	req, out := c.CreateIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpAccessSettings = "CreateIpAccessSettings"

// CreateIpAccessSettingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpAccessSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpAccessSettings for more information on using the CreateIpAccessSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIpAccessSettingsRequest method.
//	req, resp := client.CreateIpAccessSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIpAccessSettings
func (c *WorkSpacesWeb) CreateIpAccessSettingsRequest(input *CreateIpAccessSettingsInput) (req *request.Request, output *CreateIpAccessSettingsOutput) {
	op := &request.Operation{
		Name:       opCreateIpAccessSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/ipAccessSettings",
	}

	if input == nil {
		input = &CreateIpAccessSettingsInput{}
	}

	output = &CreateIpAccessSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpAccessSettings API operation for Amazon WorkSpaces Web.
//
// Creates an IP access settings resource that can be associated with a web
// portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreateIpAccessSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIpAccessSettings
func (c *WorkSpacesWeb) CreateIpAccessSettings(input *CreateIpAccessSettingsInput) (*CreateIpAccessSettingsOutput, error) {
	req, out := c.CreateIpAccessSettingsRequest(input)
	return out, req.Send()
}

// CreateIpAccessSettingsWithContext is the same as CreateIpAccessSettings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpAccessSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreateIpAccessSettingsWithContext(ctx aws.Context, input *CreateIpAccessSettingsInput, opts ...request.Option) (*CreateIpAccessSettingsOutput, error) {
	req, out := c.CreateIpAccessSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkSettings = "CreateNetworkSettings"

// CreateNetworkSettingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkSettings for more information on using the CreateNetworkSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkSettingsRequest method.
//	req, resp := client.CreateNetworkSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings
func (c *WorkSpacesWeb) CreateNetworkSettingsRequest(input *CreateNetworkSettingsInput) (req *request.Request, output *CreateNetworkSettingsOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/networkSettings",
	}

	if input == nil {
		input = &CreateNetworkSettingsInput{}
	}

	output = &CreateNetworkSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkSettings API operation for Amazon WorkSpaces Web.
//
// Creates a network settings resource that can be associated with a web portal.
// Once associated with a web portal, network settings define how streaming
// instances will connect with your specified VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreateNetworkSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings
func (c *WorkSpacesWeb) CreateNetworkSettings(input *CreateNetworkSettingsInput) (*CreateNetworkSettingsOutput, error) {
	req, out := c.CreateNetworkSettingsRequest(input)
	return out, req.Send()
}

// CreateNetworkSettingsWithContext is the same as CreateNetworkSettings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreateNetworkSettingsWithContext(ctx aws.Context, input *CreateNetworkSettingsInput, opts ...request.Option) (*CreateNetworkSettingsOutput, error) {
	req, out := c.CreateNetworkSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePortal = "CreatePortal"

// CreatePortalRequest generates a "aws/request.Request" representing the
// client's request for the CreatePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePortal for more information on using the CreatePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePortalRequest method.
//	req, resp := client.CreatePortalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal
func (c *WorkSpacesWeb) CreatePortalRequest(input *CreatePortalInput) (req *request.Request, output *CreatePortalOutput) {
	op := &request.Operation{
		Name:       opCreatePortal,
		HTTPMethod: "POST",
		HTTPPath:   "/portals",
	}

	if input == nil {
		input = &CreatePortalInput{}
	}

	output = &CreatePortalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePortal API operation for Amazon WorkSpaces Web.
//
// Creates a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreatePortal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal
func (c *WorkSpacesWeb) CreatePortal(input *CreatePortalInput) (*CreatePortalOutput, error) {
	req, out := c.CreatePortalRequest(input)
	return out, req.Send()
}

// CreatePortalWithContext is the same as CreatePortal with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreatePortalWithContext(ctx aws.Context, input *CreatePortalInput, opts ...request.Option) (*CreatePortalOutput, error) {
	req, out := c.CreatePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrustStore = "CreateTrustStore"

// CreateTrustStoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrustStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrustStore for more information on using the CreateTrustStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrustStoreRequest method.
//	req, resp := client.CreateTrustStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore
func (c *WorkSpacesWeb) CreateTrustStoreRequest(input *CreateTrustStoreInput) (req *request.Request, output *CreateTrustStoreOutput) {
	op := &request.Operation{
		Name:       opCreateTrustStore,
		HTTPMethod: "POST",
		HTTPPath:   "/trustStores",
	}

	if input == nil {
		input = &CreateTrustStoreInput{}
	}

	output = &CreateTrustStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrustStore API operation for Amazon WorkSpaces Web.
//
// Creates a trust store that can be associated with a web portal. A trust store
// contains certificate authority (CA) certificates. Once associated with a
// web portal, the browser in a streaming session will recognize certificates
// that have been issued using any of the CAs in the trust store. If your organization
// has internal websites that use certificates issued by private CAs, you should
// add the private CA certificate to the trust store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreateTrustStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore
func (c *WorkSpacesWeb) CreateTrustStore(input *CreateTrustStoreInput) (*CreateTrustStoreOutput, error) {
	req, out := c.CreateTrustStoreRequest(input)
	return out, req.Send()
}

// CreateTrustStoreWithContext is the same as CreateTrustStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrustStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreateTrustStoreWithContext(ctx aws.Context, input *CreateTrustStoreInput, opts ...request.Option) (*CreateTrustStoreOutput, error) {
	req, out := c.CreateTrustStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserAccessLoggingSettings = "CreateUserAccessLoggingSettings"

// CreateUserAccessLoggingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserAccessLoggingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserAccessLoggingSettings for more information on using the CreateUserAccessLoggingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserAccessLoggingSettingsRequest method.
//	req, resp := client.CreateUserAccessLoggingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings
func (c *WorkSpacesWeb) CreateUserAccessLoggingSettingsRequest(input *CreateUserAccessLoggingSettingsInput) (req *request.Request, output *CreateUserAccessLoggingSettingsOutput) {
	op := &request.Operation{
		Name:       opCreateUserAccessLoggingSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/userAccessLoggingSettings",
	}

	if input == nil {
		input = &CreateUserAccessLoggingSettingsInput{}
	}

	output = &CreateUserAccessLoggingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserAccessLoggingSettings API operation for Amazon WorkSpaces Web.
//
// Creates a user access logging settings resource that can be associated with
// a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreateUserAccessLoggingSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings
func (c *WorkSpacesWeb) CreateUserAccessLoggingSettings(input *CreateUserAccessLoggingSettingsInput) (*CreateUserAccessLoggingSettingsOutput, error) {
	req, out := c.CreateUserAccessLoggingSettingsRequest(input)
	return out, req.Send()
}

// CreateUserAccessLoggingSettingsWithContext is the same as CreateUserAccessLoggingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserAccessLoggingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreateUserAccessLoggingSettingsWithContext(ctx aws.Context, input *CreateUserAccessLoggingSettingsInput, opts ...request.Option) (*CreateUserAccessLoggingSettingsOutput, error) {
	req, out := c.CreateUserAccessLoggingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserSettings = "CreateUserSettings"

// CreateUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserSettings for more information on using the CreateUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserSettingsRequest method.
//	req, resp := client.CreateUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings
func (c *WorkSpacesWeb) CreateUserSettingsRequest(input *CreateUserSettingsInput) (req *request.Request, output *CreateUserSettingsOutput) {
	op := &request.Operation{
		Name:       opCreateUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/userSettings",
	}

	if input == nil {
		input = &CreateUserSettingsInput{}
	}

	output = &CreateUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserSettings API operation for Amazon WorkSpaces Web.
//
// Creates a user settings resource that can be associated with a web portal.
// Once associated with a web portal, user settings control how users can transfer
// data between a streaming session and the their local devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation CreateUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings
func (c *WorkSpacesWeb) CreateUserSettings(input *CreateUserSettingsInput) (*CreateUserSettingsOutput, error) {
	req, out := c.CreateUserSettingsRequest(input)
	return out, req.Send()
}

// CreateUserSettingsWithContext is the same as CreateUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) CreateUserSettingsWithContext(ctx aws.Context, input *CreateUserSettingsInput, opts ...request.Option) (*CreateUserSettingsOutput, error) {
	req, out := c.CreateUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBrowserSettings = "DeleteBrowserSettings"

// DeleteBrowserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBrowserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBrowserSettings for more information on using the DeleteBrowserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBrowserSettingsRequest method.
//	req, resp := client.DeleteBrowserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings
func (c *WorkSpacesWeb) DeleteBrowserSettingsRequest(input *DeleteBrowserSettingsInput) (req *request.Request, output *DeleteBrowserSettingsOutput) {
	op := &request.Operation{
		Name:       opDeleteBrowserSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/browserSettings/{browserSettingsArn+}",
	}

	if input == nil {
		input = &DeleteBrowserSettingsInput{}
	}

	output = &DeleteBrowserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBrowserSettings API operation for Amazon WorkSpaces Web.
//
// Deletes browser settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeleteBrowserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings
func (c *WorkSpacesWeb) DeleteBrowserSettings(input *DeleteBrowserSettingsInput) (*DeleteBrowserSettingsOutput, error) {
	req, out := c.DeleteBrowserSettingsRequest(input)
	return out, req.Send()
}

// DeleteBrowserSettingsWithContext is the same as DeleteBrowserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBrowserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeleteBrowserSettingsWithContext(ctx aws.Context, input *DeleteBrowserSettingsInput, opts ...request.Option) (*DeleteBrowserSettingsOutput, error) {
	req, out := c.DeleteBrowserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentityProvider = "DeleteIdentityProvider"

// DeleteIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentityProvider for more information on using the DeleteIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdentityProviderRequest method.
//	req, resp := client.DeleteIdentityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider
func (c *WorkSpacesWeb) DeleteIdentityProviderRequest(input *DeleteIdentityProviderInput) (req *request.Request, output *DeleteIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityProvider,
		HTTPMethod: "DELETE",
		HTTPPath:   "/identityProviders/{identityProviderArn+}",
	}

	if input == nil {
		input = &DeleteIdentityProviderInput{}
	}

	output = &DeleteIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdentityProvider API operation for Amazon WorkSpaces Web.
//
// Deletes the identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeleteIdentityProvider for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider
func (c *WorkSpacesWeb) DeleteIdentityProvider(input *DeleteIdentityProviderInput) (*DeleteIdentityProviderOutput, error) {
	req, out := c.DeleteIdentityProviderRequest(input)
	return out, req.Send()
}

// DeleteIdentityProviderWithContext is the same as DeleteIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeleteIdentityProviderWithContext(ctx aws.Context, input *DeleteIdentityProviderInput, opts ...request.Option) (*DeleteIdentityProviderOutput, error) {
	req, out := c.DeleteIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpAccessSettings = "DeleteIpAccessSettings"

// DeleteIpAccessSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpAccessSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpAccessSettings for more information on using the DeleteIpAccessSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIpAccessSettingsRequest method.
//	req, resp := client.DeleteIpAccessSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIpAccessSettings
func (c *WorkSpacesWeb) DeleteIpAccessSettingsRequest(input *DeleteIpAccessSettingsInput) (req *request.Request, output *DeleteIpAccessSettingsOutput) {
	op := &request.Operation{
		Name:       opDeleteIpAccessSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ipAccessSettings/{ipAccessSettingsArn+}",
	}

	if input == nil {
		input = &DeleteIpAccessSettingsInput{}
	}

	output = &DeleteIpAccessSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIpAccessSettings API operation for Amazon WorkSpaces Web.
//
// Deletes IP access settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeleteIpAccessSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIpAccessSettings
func (c *WorkSpacesWeb) DeleteIpAccessSettings(input *DeleteIpAccessSettingsInput) (*DeleteIpAccessSettingsOutput, error) {
	req, out := c.DeleteIpAccessSettingsRequest(input)
	return out, req.Send()
}

// DeleteIpAccessSettingsWithContext is the same as DeleteIpAccessSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpAccessSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeleteIpAccessSettingsWithContext(ctx aws.Context, input *DeleteIpAccessSettingsInput, opts ...request.Option) (*DeleteIpAccessSettingsOutput, error) {
	req, out := c.DeleteIpAccessSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkSettings = "DeleteNetworkSettings"

// DeleteNetworkSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkSettings for more information on using the DeleteNetworkSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkSettingsRequest method.
//	req, resp := client.DeleteNetworkSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings
func (c *WorkSpacesWeb) DeleteNetworkSettingsRequest(input *DeleteNetworkSettingsInput) (req *request.Request, output *DeleteNetworkSettingsOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/networkSettings/{networkSettingsArn+}",
	}

	if input == nil {
		input = &DeleteNetworkSettingsInput{}
	}

	output = &DeleteNetworkSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkSettings API operation for Amazon WorkSpaces Web.
//
// Deletes network settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeleteNetworkSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings
func (c *WorkSpacesWeb) DeleteNetworkSettings(input *DeleteNetworkSettingsInput) (*DeleteNetworkSettingsOutput, error) {
	req, out := c.DeleteNetworkSettingsRequest(input)
	return out, req.Send()
}

// DeleteNetworkSettingsWithContext is the same as DeleteNetworkSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeleteNetworkSettingsWithContext(ctx aws.Context, input *DeleteNetworkSettingsInput, opts ...request.Option) (*DeleteNetworkSettingsOutput, error) {
	req, out := c.DeleteNetworkSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePortal = "DeletePortal"

// DeletePortalRequest generates a "aws/request.Request" representing the
// client's request for the DeletePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePortal for more information on using the DeletePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePortalRequest method.
//	req, resp := client.DeletePortalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal
func (c *WorkSpacesWeb) DeletePortalRequest(input *DeletePortalInput) (req *request.Request, output *DeletePortalOutput) {
	op := &request.Operation{
		Name:       opDeletePortal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalArn+}",
	}

	if input == nil {
		input = &DeletePortalInput{}
	}

	output = &DeletePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePortal API operation for Amazon WorkSpaces Web.
//
// Deletes a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeletePortal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal
func (c *WorkSpacesWeb) DeletePortal(input *DeletePortalInput) (*DeletePortalOutput, error) {
	req, out := c.DeletePortalRequest(input)
	return out, req.Send()
}

// DeletePortalWithContext is the same as DeletePortal with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeletePortalWithContext(ctx aws.Context, input *DeletePortalInput, opts ...request.Option) (*DeletePortalOutput, error) {
	req, out := c.DeletePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrustStore = "DeleteTrustStore"

// DeleteTrustStoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrustStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrustStore for more information on using the DeleteTrustStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrustStoreRequest method.
//	req, resp := client.DeleteTrustStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore
func (c *WorkSpacesWeb) DeleteTrustStoreRequest(input *DeleteTrustStoreInput) (req *request.Request, output *DeleteTrustStoreOutput) {
	op := &request.Operation{
		Name:       opDeleteTrustStore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/trustStores/{trustStoreArn+}",
	}

	if input == nil {
		input = &DeleteTrustStoreInput{}
	}

	output = &DeleteTrustStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrustStore API operation for Amazon WorkSpaces Web.
//
// Deletes the trust store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeleteTrustStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore
func (c *WorkSpacesWeb) DeleteTrustStore(input *DeleteTrustStoreInput) (*DeleteTrustStoreOutput, error) {
	req, out := c.DeleteTrustStoreRequest(input)
	return out, req.Send()
}

// DeleteTrustStoreWithContext is the same as DeleteTrustStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrustStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeleteTrustStoreWithContext(ctx aws.Context, input *DeleteTrustStoreInput, opts ...request.Option) (*DeleteTrustStoreOutput, error) {
	req, out := c.DeleteTrustStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserAccessLoggingSettings = "DeleteUserAccessLoggingSettings"

// DeleteUserAccessLoggingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserAccessLoggingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserAccessLoggingSettings for more information on using the DeleteUserAccessLoggingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserAccessLoggingSettingsRequest method.
//	req, resp := client.DeleteUserAccessLoggingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings
func (c *WorkSpacesWeb) DeleteUserAccessLoggingSettingsRequest(input *DeleteUserAccessLoggingSettingsInput) (req *request.Request, output *DeleteUserAccessLoggingSettingsOutput) {
	op := &request.Operation{
		Name:       opDeleteUserAccessLoggingSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/userAccessLoggingSettings/{userAccessLoggingSettingsArn+}",
	}

	if input == nil {
		input = &DeleteUserAccessLoggingSettingsInput{}
	}

	output = &DeleteUserAccessLoggingSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserAccessLoggingSettings API operation for Amazon WorkSpaces Web.
//
// Deletes user access logging settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeleteUserAccessLoggingSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings
func (c *WorkSpacesWeb) DeleteUserAccessLoggingSettings(input *DeleteUserAccessLoggingSettingsInput) (*DeleteUserAccessLoggingSettingsOutput, error) {
	req, out := c.DeleteUserAccessLoggingSettingsRequest(input)
	return out, req.Send()
}

// DeleteUserAccessLoggingSettingsWithContext is the same as DeleteUserAccessLoggingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserAccessLoggingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeleteUserAccessLoggingSettingsWithContext(ctx aws.Context, input *DeleteUserAccessLoggingSettingsInput, opts ...request.Option) (*DeleteUserAccessLoggingSettingsOutput, error) {
	req, out := c.DeleteUserAccessLoggingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserSettings = "DeleteUserSettings"

// DeleteUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserSettings for more information on using the DeleteUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserSettingsRequest method.
//	req, resp := client.DeleteUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings
func (c *WorkSpacesWeb) DeleteUserSettingsRequest(input *DeleteUserSettingsInput) (req *request.Request, output *DeleteUserSettingsOutput) {
	op := &request.Operation{
		Name:       opDeleteUserSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/userSettings/{userSettingsArn+}",
	}

	if input == nil {
		input = &DeleteUserSettingsInput{}
	}

	output = &DeleteUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserSettings API operation for Amazon WorkSpaces Web.
//
// Deletes user settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DeleteUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings
func (c *WorkSpacesWeb) DeleteUserSettings(input *DeleteUserSettingsInput) (*DeleteUserSettingsOutput, error) {
	req, out := c.DeleteUserSettingsRequest(input)
	return out, req.Send()
}

// DeleteUserSettingsWithContext is the same as DeleteUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DeleteUserSettingsWithContext(ctx aws.Context, input *DeleteUserSettingsInput, opts ...request.Option) (*DeleteUserSettingsOutput, error) {
	req, out := c.DeleteUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateBrowserSettings = "DisassociateBrowserSettings"

// DisassociateBrowserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateBrowserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateBrowserSettings for more information on using the DisassociateBrowserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateBrowserSettingsRequest method.
//	req, resp := client.DisassociateBrowserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings
func (c *WorkSpacesWeb) DisassociateBrowserSettingsRequest(input *DisassociateBrowserSettingsInput) (req *request.Request, output *DisassociateBrowserSettingsOutput) {
	op := &request.Operation{
		Name:       opDisassociateBrowserSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalArn+}/browserSettings",
	}

	if input == nil {
		input = &DisassociateBrowserSettingsInput{}
	}

	output = &DisassociateBrowserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateBrowserSettings API operation for Amazon WorkSpaces Web.
//
// Disassociates browser settings from a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DisassociateBrowserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings
func (c *WorkSpacesWeb) DisassociateBrowserSettings(input *DisassociateBrowserSettingsInput) (*DisassociateBrowserSettingsOutput, error) {
	req, out := c.DisassociateBrowserSettingsRequest(input)
	return out, req.Send()
}

// DisassociateBrowserSettingsWithContext is the same as DisassociateBrowserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateBrowserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DisassociateBrowserSettingsWithContext(ctx aws.Context, input *DisassociateBrowserSettingsInput, opts ...request.Option) (*DisassociateBrowserSettingsOutput, error) {
	req, out := c.DisassociateBrowserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateIpAccessSettings = "DisassociateIpAccessSettings"

// DisassociateIpAccessSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateIpAccessSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateIpAccessSettings for more information on using the DisassociateIpAccessSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateIpAccessSettingsRequest method.
//	req, resp := client.DisassociateIpAccessSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateIpAccessSettings
func (c *WorkSpacesWeb) DisassociateIpAccessSettingsRequest(input *DisassociateIpAccessSettingsInput) (req *request.Request, output *DisassociateIpAccessSettingsOutput) {
	op := &request.Operation{
		Name:       opDisassociateIpAccessSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalArn+}/ipAccessSettings",
	}

	if input == nil {
		input = &DisassociateIpAccessSettingsInput{}
	}

	output = &DisassociateIpAccessSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateIpAccessSettings API operation for Amazon WorkSpaces Web.
//
// Disassociates IP access settings from a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DisassociateIpAccessSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateIpAccessSettings
func (c *WorkSpacesWeb) DisassociateIpAccessSettings(input *DisassociateIpAccessSettingsInput) (*DisassociateIpAccessSettingsOutput, error) {
	req, out := c.DisassociateIpAccessSettingsRequest(input)
	return out, req.Send()
}

// DisassociateIpAccessSettingsWithContext is the same as DisassociateIpAccessSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateIpAccessSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DisassociateIpAccessSettingsWithContext(ctx aws.Context, input *DisassociateIpAccessSettingsInput, opts ...request.Option) (*DisassociateIpAccessSettingsOutput, error) {
	req, out := c.DisassociateIpAccessSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateNetworkSettings = "DisassociateNetworkSettings"

// DisassociateNetworkSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateNetworkSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateNetworkSettings for more information on using the DisassociateNetworkSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateNetworkSettingsRequest method.
//	req, resp := client.DisassociateNetworkSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings
func (c *WorkSpacesWeb) DisassociateNetworkSettingsRequest(input *DisassociateNetworkSettingsInput) (req *request.Request, output *DisassociateNetworkSettingsOutput) {
	op := &request.Operation{
		Name:       opDisassociateNetworkSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalArn+}/networkSettings",
	}

	if input == nil {
		input = &DisassociateNetworkSettingsInput{}
	}

	output = &DisassociateNetworkSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateNetworkSettings API operation for Amazon WorkSpaces Web.
//
// Disassociates network settings from a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DisassociateNetworkSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings
func (c *WorkSpacesWeb) DisassociateNetworkSettings(input *DisassociateNetworkSettingsInput) (*DisassociateNetworkSettingsOutput, error) {
	req, out := c.DisassociateNetworkSettingsRequest(input)
	return out, req.Send()
}

// DisassociateNetworkSettingsWithContext is the same as DisassociateNetworkSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateNetworkSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DisassociateNetworkSettingsWithContext(ctx aws.Context, input *DisassociateNetworkSettingsInput, opts ...request.Option) (*DisassociateNetworkSettingsOutput, error) {
	req, out := c.DisassociateNetworkSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTrustStore = "DisassociateTrustStore"

// DisassociateTrustStoreRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTrustStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateTrustStore for more information on using the DisassociateTrustStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateTrustStoreRequest method.
//	req, resp := client.DisassociateTrustStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore
func (c *WorkSpacesWeb) DisassociateTrustStoreRequest(input *DisassociateTrustStoreInput) (req *request.Request, output *DisassociateTrustStoreOutput) {
	op := &request.Operation{
		Name:       opDisassociateTrustStore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalArn+}/trustStores",
	}

	if input == nil {
		input = &DisassociateTrustStoreInput{}
	}

	output = &DisassociateTrustStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateTrustStore API operation for Amazon WorkSpaces Web.
//
// Disassociates a trust store from a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DisassociateTrustStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore
func (c *WorkSpacesWeb) DisassociateTrustStore(input *DisassociateTrustStoreInput) (*DisassociateTrustStoreOutput, error) {
	req, out := c.DisassociateTrustStoreRequest(input)
	return out, req.Send()
}

// DisassociateTrustStoreWithContext is the same as DisassociateTrustStore with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTrustStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DisassociateTrustStoreWithContext(ctx aws.Context, input *DisassociateTrustStoreInput, opts ...request.Option) (*DisassociateTrustStoreOutput, error) {
	req, out := c.DisassociateTrustStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateUserAccessLoggingSettings = "DisassociateUserAccessLoggingSettings"

// DisassociateUserAccessLoggingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateUserAccessLoggingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateUserAccessLoggingSettings for more information on using the DisassociateUserAccessLoggingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateUserAccessLoggingSettingsRequest method.
//	req, resp := client.DisassociateUserAccessLoggingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings
func (c *WorkSpacesWeb) DisassociateUserAccessLoggingSettingsRequest(input *DisassociateUserAccessLoggingSettingsInput) (req *request.Request, output *DisassociateUserAccessLoggingSettingsOutput) {
	op := &request.Operation{
		Name:       opDisassociateUserAccessLoggingSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalArn+}/userAccessLoggingSettings",
	}

	if input == nil {
		input = &DisassociateUserAccessLoggingSettingsInput{}
	}

	output = &DisassociateUserAccessLoggingSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateUserAccessLoggingSettings API operation for Amazon WorkSpaces Web.
//
// Disassociates user access logging settings from a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DisassociateUserAccessLoggingSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings
func (c *WorkSpacesWeb) DisassociateUserAccessLoggingSettings(input *DisassociateUserAccessLoggingSettingsInput) (*DisassociateUserAccessLoggingSettingsOutput, error) {
	req, out := c.DisassociateUserAccessLoggingSettingsRequest(input)
	return out, req.Send()
}

// DisassociateUserAccessLoggingSettingsWithContext is the same as DisassociateUserAccessLoggingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateUserAccessLoggingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DisassociateUserAccessLoggingSettingsWithContext(ctx aws.Context, input *DisassociateUserAccessLoggingSettingsInput, opts ...request.Option) (*DisassociateUserAccessLoggingSettingsOutput, error) {
	req, out := c.DisassociateUserAccessLoggingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateUserSettings = "DisassociateUserSettings"

// DisassociateUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateUserSettings for more information on using the DisassociateUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateUserSettingsRequest method.
//	req, resp := client.DisassociateUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings
func (c *WorkSpacesWeb) DisassociateUserSettingsRequest(input *DisassociateUserSettingsInput) (req *request.Request, output *DisassociateUserSettingsOutput) {
	op := &request.Operation{
		Name:       opDisassociateUserSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalArn+}/userSettings",
	}

	if input == nil {
		input = &DisassociateUserSettingsInput{}
	}

	output = &DisassociateUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateUserSettings API operation for Amazon WorkSpaces Web.
//
// Disassociates user settings from a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation DisassociateUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings
func (c *WorkSpacesWeb) DisassociateUserSettings(input *DisassociateUserSettingsInput) (*DisassociateUserSettingsOutput, error) {
	req, out := c.DisassociateUserSettingsRequest(input)
	return out, req.Send()
}

// DisassociateUserSettingsWithContext is the same as DisassociateUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) DisassociateUserSettingsWithContext(ctx aws.Context, input *DisassociateUserSettingsInput, opts ...request.Option) (*DisassociateUserSettingsOutput, error) {
	req, out := c.DisassociateUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBrowserSettings = "GetBrowserSettings"

// GetBrowserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetBrowserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBrowserSettings for more information on using the GetBrowserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBrowserSettingsRequest method.
//	req, resp := client.GetBrowserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings
func (c *WorkSpacesWeb) GetBrowserSettingsRequest(input *GetBrowserSettingsInput) (req *request.Request, output *GetBrowserSettingsOutput) {
	op := &request.Operation{
		Name:       opGetBrowserSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/browserSettings/{browserSettingsArn+}",
	}

	if input == nil {
		input = &GetBrowserSettingsInput{}
	}

	output = &GetBrowserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBrowserSettings API operation for Amazon WorkSpaces Web.
//
// Gets browser settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetBrowserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings
func (c *WorkSpacesWeb) GetBrowserSettings(input *GetBrowserSettingsInput) (*GetBrowserSettingsOutput, error) {
	req, out := c.GetBrowserSettingsRequest(input)
	return out, req.Send()
}

// GetBrowserSettingsWithContext is the same as GetBrowserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetBrowserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetBrowserSettingsWithContext(ctx aws.Context, input *GetBrowserSettingsInput, opts ...request.Option) (*GetBrowserSettingsOutput, error) {
	req, out := c.GetBrowserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityProvider = "GetIdentityProvider"

// GetIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityProvider for more information on using the GetIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityProviderRequest method.
//	req, resp := client.GetIdentityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider
func (c *WorkSpacesWeb) GetIdentityProviderRequest(input *GetIdentityProviderInput) (req *request.Request, output *GetIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opGetIdentityProvider,
		HTTPMethod: "GET",
		HTTPPath:   "/identityProviders/{identityProviderArn+}",
	}

	if input == nil {
		input = &GetIdentityProviderInput{}
	}

	output = &GetIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityProvider API operation for Amazon WorkSpaces Web.
//
// Gets the identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetIdentityProvider for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider
func (c *WorkSpacesWeb) GetIdentityProvider(input *GetIdentityProviderInput) (*GetIdentityProviderOutput, error) {
	req, out := c.GetIdentityProviderRequest(input)
	return out, req.Send()
}

// GetIdentityProviderWithContext is the same as GetIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetIdentityProviderWithContext(ctx aws.Context, input *GetIdentityProviderInput, opts ...request.Option) (*GetIdentityProviderOutput, error) {
	req, out := c.GetIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIpAccessSettings = "GetIpAccessSettings"

// GetIpAccessSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetIpAccessSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIpAccessSettings for more information on using the GetIpAccessSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIpAccessSettingsRequest method.
//	req, resp := client.GetIpAccessSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIpAccessSettings
func (c *WorkSpacesWeb) GetIpAccessSettingsRequest(input *GetIpAccessSettingsInput) (req *request.Request, output *GetIpAccessSettingsOutput) {
	op := &request.Operation{
		Name:       opGetIpAccessSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/ipAccessSettings/{ipAccessSettingsArn+}",
	}

	if input == nil {
		input = &GetIpAccessSettingsInput{}
	}

	output = &GetIpAccessSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIpAccessSettings API operation for Amazon WorkSpaces Web.
//
// Gets the IP access settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetIpAccessSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIpAccessSettings
func (c *WorkSpacesWeb) GetIpAccessSettings(input *GetIpAccessSettingsInput) (*GetIpAccessSettingsOutput, error) {
	req, out := c.GetIpAccessSettingsRequest(input)
	return out, req.Send()
}

// GetIpAccessSettingsWithContext is the same as GetIpAccessSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetIpAccessSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetIpAccessSettingsWithContext(ctx aws.Context, input *GetIpAccessSettingsInput, opts ...request.Option) (*GetIpAccessSettingsOutput, error) {
	req, out := c.GetIpAccessSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNetworkSettings = "GetNetworkSettings"

// GetNetworkSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetNetworkSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNetworkSettings for more information on using the GetNetworkSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetNetworkSettingsRequest method.
//	req, resp := client.GetNetworkSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings
func (c *WorkSpacesWeb) GetNetworkSettingsRequest(input *GetNetworkSettingsInput) (req *request.Request, output *GetNetworkSettingsOutput) {
	op := &request.Operation{
		Name:       opGetNetworkSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/networkSettings/{networkSettingsArn+}",
	}

	if input == nil {
		input = &GetNetworkSettingsInput{}
	}

	output = &GetNetworkSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNetworkSettings API operation for Amazon WorkSpaces Web.
//
// Gets the network settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetNetworkSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings
func (c *WorkSpacesWeb) GetNetworkSettings(input *GetNetworkSettingsInput) (*GetNetworkSettingsOutput, error) {
	req, out := c.GetNetworkSettingsRequest(input)
	return out, req.Send()
}

// GetNetworkSettingsWithContext is the same as GetNetworkSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetNetworkSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetNetworkSettingsWithContext(ctx aws.Context, input *GetNetworkSettingsInput, opts ...request.Option) (*GetNetworkSettingsOutput, error) {
	req, out := c.GetNetworkSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPortal = "GetPortal"

// GetPortalRequest generates a "aws/request.Request" representing the
// client's request for the GetPortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPortal for more information on using the GetPortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPortalRequest method.
//	req, resp := client.GetPortalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal
func (c *WorkSpacesWeb) GetPortalRequest(input *GetPortalInput) (req *request.Request, output *GetPortalOutput) {
	op := &request.Operation{
		Name:       opGetPortal,
		HTTPMethod: "GET",
		HTTPPath:   "/portals/{portalArn+}",
	}

	if input == nil {
		input = &GetPortalInput{}
	}

	output = &GetPortalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPortal API operation for Amazon WorkSpaces Web.
//
// Gets the web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetPortal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal
func (c *WorkSpacesWeb) GetPortal(input *GetPortalInput) (*GetPortalOutput, error) {
	req, out := c.GetPortalRequest(input)
	return out, req.Send()
}

// GetPortalWithContext is the same as GetPortal with the addition of
// the ability to pass a context and additional request options.
//
// See GetPortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetPortalWithContext(ctx aws.Context, input *GetPortalInput, opts ...request.Option) (*GetPortalOutput, error) {
	req, out := c.GetPortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPortalServiceProviderMetadata = "GetPortalServiceProviderMetadata"

// GetPortalServiceProviderMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetPortalServiceProviderMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPortalServiceProviderMetadata for more information on using the GetPortalServiceProviderMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPortalServiceProviderMetadataRequest method.
//	req, resp := client.GetPortalServiceProviderMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata
func (c *WorkSpacesWeb) GetPortalServiceProviderMetadataRequest(input *GetPortalServiceProviderMetadataInput) (req *request.Request, output *GetPortalServiceProviderMetadataOutput) {
	op := &request.Operation{
		Name:       opGetPortalServiceProviderMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/portalIdp/{portalArn+}",
	}

	if input == nil {
		input = &GetPortalServiceProviderMetadataInput{}
	}

	output = &GetPortalServiceProviderMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPortalServiceProviderMetadata API operation for Amazon WorkSpaces Web.
//
// Gets the service provider metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetPortalServiceProviderMetadata for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata
func (c *WorkSpacesWeb) GetPortalServiceProviderMetadata(input *GetPortalServiceProviderMetadataInput) (*GetPortalServiceProviderMetadataOutput, error) {
	req, out := c.GetPortalServiceProviderMetadataRequest(input)
	return out, req.Send()
}

// GetPortalServiceProviderMetadataWithContext is the same as GetPortalServiceProviderMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetPortalServiceProviderMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetPortalServiceProviderMetadataWithContext(ctx aws.Context, input *GetPortalServiceProviderMetadataInput, opts ...request.Option) (*GetPortalServiceProviderMetadataOutput, error) {
	req, out := c.GetPortalServiceProviderMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrustStore = "GetTrustStore"

// GetTrustStoreRequest generates a "aws/request.Request" representing the
// client's request for the GetTrustStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrustStore for more information on using the GetTrustStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTrustStoreRequest method.
//	req, resp := client.GetTrustStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore
func (c *WorkSpacesWeb) GetTrustStoreRequest(input *GetTrustStoreInput) (req *request.Request, output *GetTrustStoreOutput) {
	op := &request.Operation{
		Name:       opGetTrustStore,
		HTTPMethod: "GET",
		HTTPPath:   "/trustStores/{trustStoreArn+}",
	}

	if input == nil {
		input = &GetTrustStoreInput{}
	}

	output = &GetTrustStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrustStore API operation for Amazon WorkSpaces Web.
//
// Gets the trust store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetTrustStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore
func (c *WorkSpacesWeb) GetTrustStore(input *GetTrustStoreInput) (*GetTrustStoreOutput, error) {
	req, out := c.GetTrustStoreRequest(input)
	return out, req.Send()
}

// GetTrustStoreWithContext is the same as GetTrustStore with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrustStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetTrustStoreWithContext(ctx aws.Context, input *GetTrustStoreInput, opts ...request.Option) (*GetTrustStoreOutput, error) {
	req, out := c.GetTrustStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrustStoreCertificate = "GetTrustStoreCertificate"

// GetTrustStoreCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetTrustStoreCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrustStoreCertificate for more information on using the GetTrustStoreCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTrustStoreCertificateRequest method.
//	req, resp := client.GetTrustStoreCertificateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate
func (c *WorkSpacesWeb) GetTrustStoreCertificateRequest(input *GetTrustStoreCertificateInput) (req *request.Request, output *GetTrustStoreCertificateOutput) {
	op := &request.Operation{
		Name:       opGetTrustStoreCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/trustStores/{trustStoreArn+}/certificate",
	}

	if input == nil {
		input = &GetTrustStoreCertificateInput{}
	}

	output = &GetTrustStoreCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrustStoreCertificate API operation for Amazon WorkSpaces Web.
//
// Gets the trust store certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetTrustStoreCertificate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate
func (c *WorkSpacesWeb) GetTrustStoreCertificate(input *GetTrustStoreCertificateInput) (*GetTrustStoreCertificateOutput, error) {
	req, out := c.GetTrustStoreCertificateRequest(input)
	return out, req.Send()
}

// GetTrustStoreCertificateWithContext is the same as GetTrustStoreCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrustStoreCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetTrustStoreCertificateWithContext(ctx aws.Context, input *GetTrustStoreCertificateInput, opts ...request.Option) (*GetTrustStoreCertificateOutput, error) {
	req, out := c.GetTrustStoreCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserAccessLoggingSettings = "GetUserAccessLoggingSettings"

// GetUserAccessLoggingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserAccessLoggingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserAccessLoggingSettings for more information on using the GetUserAccessLoggingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUserAccessLoggingSettingsRequest method.
//	req, resp := client.GetUserAccessLoggingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings
func (c *WorkSpacesWeb) GetUserAccessLoggingSettingsRequest(input *GetUserAccessLoggingSettingsInput) (req *request.Request, output *GetUserAccessLoggingSettingsOutput) {
	op := &request.Operation{
		Name:       opGetUserAccessLoggingSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/userAccessLoggingSettings/{userAccessLoggingSettingsArn+}",
	}

	if input == nil {
		input = &GetUserAccessLoggingSettingsInput{}
	}

	output = &GetUserAccessLoggingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserAccessLoggingSettings API operation for Amazon WorkSpaces Web.
//
// Gets user access logging settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetUserAccessLoggingSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings
func (c *WorkSpacesWeb) GetUserAccessLoggingSettings(input *GetUserAccessLoggingSettingsInput) (*GetUserAccessLoggingSettingsOutput, error) {
	req, out := c.GetUserAccessLoggingSettingsRequest(input)
	return out, req.Send()
}

// GetUserAccessLoggingSettingsWithContext is the same as GetUserAccessLoggingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserAccessLoggingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetUserAccessLoggingSettingsWithContext(ctx aws.Context, input *GetUserAccessLoggingSettingsInput, opts ...request.Option) (*GetUserAccessLoggingSettingsOutput, error) {
	req, out := c.GetUserAccessLoggingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserSettings = "GetUserSettings"

// GetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserSettings for more information on using the GetUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUserSettingsRequest method.
//	req, resp := client.GetUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings
func (c *WorkSpacesWeb) GetUserSettingsRequest(input *GetUserSettingsInput) (req *request.Request, output *GetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opGetUserSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/userSettings/{userSettingsArn+}",
	}

	if input == nil {
		input = &GetUserSettingsInput{}
	}

	output = &GetUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserSettings API operation for Amazon WorkSpaces Web.
//
// Gets user settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation GetUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings
func (c *WorkSpacesWeb) GetUserSettings(input *GetUserSettingsInput) (*GetUserSettingsOutput, error) {
	req, out := c.GetUserSettingsRequest(input)
	return out, req.Send()
}

// GetUserSettingsWithContext is the same as GetUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) GetUserSettingsWithContext(ctx aws.Context, input *GetUserSettingsInput, opts ...request.Option) (*GetUserSettingsOutput, error) {
	req, out := c.GetUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBrowserSettings = "ListBrowserSettings"

// ListBrowserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ListBrowserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBrowserSettings for more information on using the ListBrowserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBrowserSettingsRequest method.
//	req, resp := client.ListBrowserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings
func (c *WorkSpacesWeb) ListBrowserSettingsRequest(input *ListBrowserSettingsInput) (req *request.Request, output *ListBrowserSettingsOutput) {
	op := &request.Operation{
		Name:       opListBrowserSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/browserSettings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBrowserSettingsInput{}
	}

	output = &ListBrowserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBrowserSettings API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of browser settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListBrowserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings
func (c *WorkSpacesWeb) ListBrowserSettings(input *ListBrowserSettingsInput) (*ListBrowserSettingsOutput, error) {
	req, out := c.ListBrowserSettingsRequest(input)
	return out, req.Send()
}

// ListBrowserSettingsWithContext is the same as ListBrowserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ListBrowserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListBrowserSettingsWithContext(ctx aws.Context, input *ListBrowserSettingsInput, opts ...request.Option) (*ListBrowserSettingsOutput, error) {
	req, out := c.ListBrowserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBrowserSettingsPages iterates over the pages of a ListBrowserSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBrowserSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBrowserSettings operation.
//	pageNum := 0
//	err := client.ListBrowserSettingsPages(params,
//	    func(page *workspacesweb.ListBrowserSettingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListBrowserSettingsPages(input *ListBrowserSettingsInput, fn func(*ListBrowserSettingsOutput, bool) bool) error {
	return c.ListBrowserSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBrowserSettingsPagesWithContext same as ListBrowserSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListBrowserSettingsPagesWithContext(ctx aws.Context, input *ListBrowserSettingsInput, fn func(*ListBrowserSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBrowserSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBrowserSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBrowserSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentityProviders = "ListIdentityProviders"

// ListIdentityProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityProviders for more information on using the ListIdentityProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentityProvidersRequest method.
//	req, resp := client.ListIdentityProvidersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders
func (c *WorkSpacesWeb) ListIdentityProvidersRequest(input *ListIdentityProvidersInput) (req *request.Request, output *ListIdentityProvidersOutput) {
	op := &request.Operation{
		Name:       opListIdentityProviders,
		HTTPMethod: "GET",
		HTTPPath:   "/portals/{portalArn+}/identityProviders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentityProvidersInput{}
	}

	output = &ListIdentityProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityProviders API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of identity providers for a specific web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListIdentityProviders for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders
func (c *WorkSpacesWeb) ListIdentityProviders(input *ListIdentityProvidersInput) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	return out, req.Send()
}

// ListIdentityProvidersWithContext is the same as ListIdentityProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListIdentityProvidersWithContext(ctx aws.Context, input *ListIdentityProvidersInput, opts ...request.Option) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentityProvidersPages iterates over the pages of a ListIdentityProviders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentityProviders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdentityProviders operation.
//	pageNum := 0
//	err := client.ListIdentityProvidersPages(params,
//	    func(page *workspacesweb.ListIdentityProvidersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListIdentityProvidersPages(input *ListIdentityProvidersInput, fn func(*ListIdentityProvidersOutput, bool) bool) error {
	return c.ListIdentityProvidersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentityProvidersPagesWithContext same as ListIdentityProvidersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListIdentityProvidersPagesWithContext(ctx aws.Context, input *ListIdentityProvidersInput, fn func(*ListIdentityProvidersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentityProvidersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentityProvidersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdentityProvidersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIpAccessSettings = "ListIpAccessSettings"

// ListIpAccessSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ListIpAccessSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIpAccessSettings for more information on using the ListIpAccessSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIpAccessSettingsRequest method.
//	req, resp := client.ListIpAccessSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings
func (c *WorkSpacesWeb) ListIpAccessSettingsRequest(input *ListIpAccessSettingsInput) (req *request.Request, output *ListIpAccessSettingsOutput) {
	op := &request.Operation{
		Name:       opListIpAccessSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/ipAccessSettings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIpAccessSettingsInput{}
	}

	output = &ListIpAccessSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIpAccessSettings API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of IP access settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListIpAccessSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings
func (c *WorkSpacesWeb) ListIpAccessSettings(input *ListIpAccessSettingsInput) (*ListIpAccessSettingsOutput, error) {
	req, out := c.ListIpAccessSettingsRequest(input)
	return out, req.Send()
}

// ListIpAccessSettingsWithContext is the same as ListIpAccessSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ListIpAccessSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListIpAccessSettingsWithContext(ctx aws.Context, input *ListIpAccessSettingsInput, opts ...request.Option) (*ListIpAccessSettingsOutput, error) {
	req, out := c.ListIpAccessSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIpAccessSettingsPages iterates over the pages of a ListIpAccessSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIpAccessSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIpAccessSettings operation.
//	pageNum := 0
//	err := client.ListIpAccessSettingsPages(params,
//	    func(page *workspacesweb.ListIpAccessSettingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListIpAccessSettingsPages(input *ListIpAccessSettingsInput, fn func(*ListIpAccessSettingsOutput, bool) bool) error {
	return c.ListIpAccessSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIpAccessSettingsPagesWithContext same as ListIpAccessSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListIpAccessSettingsPagesWithContext(ctx aws.Context, input *ListIpAccessSettingsInput, fn func(*ListIpAccessSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIpAccessSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIpAccessSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIpAccessSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNetworkSettings = "ListNetworkSettings"

// ListNetworkSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ListNetworkSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNetworkSettings for more information on using the ListNetworkSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNetworkSettingsRequest method.
//	req, resp := client.ListNetworkSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings
func (c *WorkSpacesWeb) ListNetworkSettingsRequest(input *ListNetworkSettingsInput) (req *request.Request, output *ListNetworkSettingsOutput) {
	op := &request.Operation{
		Name:       opListNetworkSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/networkSettings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNetworkSettingsInput{}
	}

	output = &ListNetworkSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNetworkSettings API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of network settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListNetworkSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings
func (c *WorkSpacesWeb) ListNetworkSettings(input *ListNetworkSettingsInput) (*ListNetworkSettingsOutput, error) {
	req, out := c.ListNetworkSettingsRequest(input)
	return out, req.Send()
}

// ListNetworkSettingsWithContext is the same as ListNetworkSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ListNetworkSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListNetworkSettingsWithContext(ctx aws.Context, input *ListNetworkSettingsInput, opts ...request.Option) (*ListNetworkSettingsOutput, error) {
	req, out := c.ListNetworkSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNetworkSettingsPages iterates over the pages of a ListNetworkSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNetworkSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNetworkSettings operation.
//	pageNum := 0
//	err := client.ListNetworkSettingsPages(params,
//	    func(page *workspacesweb.ListNetworkSettingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListNetworkSettingsPages(input *ListNetworkSettingsInput, fn func(*ListNetworkSettingsOutput, bool) bool) error {
	return c.ListNetworkSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNetworkSettingsPagesWithContext same as ListNetworkSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListNetworkSettingsPagesWithContext(ctx aws.Context, input *ListNetworkSettingsInput, fn func(*ListNetworkSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNetworkSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNetworkSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNetworkSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPortals = "ListPortals"

// ListPortalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPortals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPortals for more information on using the ListPortals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPortalsRequest method.
//	req, resp := client.ListPortalsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals
func (c *WorkSpacesWeb) ListPortalsRequest(input *ListPortalsInput) (req *request.Request, output *ListPortalsOutput) {
	op := &request.Operation{
		Name:       opListPortals,
		HTTPMethod: "GET",
		HTTPPath:   "/portals",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPortalsInput{}
	}

	output = &ListPortalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPortals API operation for Amazon WorkSpaces Web.
//
// Retrieves a list or web portals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListPortals for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals
func (c *WorkSpacesWeb) ListPortals(input *ListPortalsInput) (*ListPortalsOutput, error) {
	req, out := c.ListPortalsRequest(input)
	return out, req.Send()
}

// ListPortalsWithContext is the same as ListPortals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPortals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListPortalsWithContext(ctx aws.Context, input *ListPortalsInput, opts ...request.Option) (*ListPortalsOutput, error) {
	req, out := c.ListPortalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPortalsPages iterates over the pages of a ListPortals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPortals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPortals operation.
//	pageNum := 0
//	err := client.ListPortalsPages(params,
//	    func(page *workspacesweb.ListPortalsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListPortalsPages(input *ListPortalsInput, fn func(*ListPortalsOutput, bool) bool) error {
	return c.ListPortalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPortalsPagesWithContext same as ListPortalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListPortalsPagesWithContext(ctx aws.Context, input *ListPortalsInput, fn func(*ListPortalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPortalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPortalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPortalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource
func (c *WorkSpacesWeb) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn+}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource
func (c *WorkSpacesWeb) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrustStoreCertificates = "ListTrustStoreCertificates"

// ListTrustStoreCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTrustStoreCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrustStoreCertificates for more information on using the ListTrustStoreCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrustStoreCertificatesRequest method.
//	req, resp := client.ListTrustStoreCertificatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates
func (c *WorkSpacesWeb) ListTrustStoreCertificatesRequest(input *ListTrustStoreCertificatesInput) (req *request.Request, output *ListTrustStoreCertificatesOutput) {
	op := &request.Operation{
		Name:       opListTrustStoreCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/trustStores/{trustStoreArn+}/certificates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrustStoreCertificatesInput{}
	}

	output = &ListTrustStoreCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrustStoreCertificates API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of trust store certificates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListTrustStoreCertificates for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates
func (c *WorkSpacesWeb) ListTrustStoreCertificates(input *ListTrustStoreCertificatesInput) (*ListTrustStoreCertificatesOutput, error) {
	req, out := c.ListTrustStoreCertificatesRequest(input)
	return out, req.Send()
}

// ListTrustStoreCertificatesWithContext is the same as ListTrustStoreCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrustStoreCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListTrustStoreCertificatesWithContext(ctx aws.Context, input *ListTrustStoreCertificatesInput, opts ...request.Option) (*ListTrustStoreCertificatesOutput, error) {
	req, out := c.ListTrustStoreCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrustStoreCertificatesPages iterates over the pages of a ListTrustStoreCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrustStoreCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrustStoreCertificates operation.
//	pageNum := 0
//	err := client.ListTrustStoreCertificatesPages(params,
//	    func(page *workspacesweb.ListTrustStoreCertificatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListTrustStoreCertificatesPages(input *ListTrustStoreCertificatesInput, fn func(*ListTrustStoreCertificatesOutput, bool) bool) error {
	return c.ListTrustStoreCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrustStoreCertificatesPagesWithContext same as ListTrustStoreCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListTrustStoreCertificatesPagesWithContext(ctx aws.Context, input *ListTrustStoreCertificatesInput, fn func(*ListTrustStoreCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrustStoreCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrustStoreCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrustStoreCertificatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrustStores = "ListTrustStores"

// ListTrustStoresRequest generates a "aws/request.Request" representing the
// client's request for the ListTrustStores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrustStores for more information on using the ListTrustStores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrustStoresRequest method.
//	req, resp := client.ListTrustStoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores
func (c *WorkSpacesWeb) ListTrustStoresRequest(input *ListTrustStoresInput) (req *request.Request, output *ListTrustStoresOutput) {
	op := &request.Operation{
		Name:       opListTrustStores,
		HTTPMethod: "GET",
		HTTPPath:   "/trustStores",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrustStoresInput{}
	}

	output = &ListTrustStoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrustStores API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of trust stores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListTrustStores for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores
func (c *WorkSpacesWeb) ListTrustStores(input *ListTrustStoresInput) (*ListTrustStoresOutput, error) {
	req, out := c.ListTrustStoresRequest(input)
	return out, req.Send()
}

// ListTrustStoresWithContext is the same as ListTrustStores with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrustStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListTrustStoresWithContext(ctx aws.Context, input *ListTrustStoresInput, opts ...request.Option) (*ListTrustStoresOutput, error) {
	req, out := c.ListTrustStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrustStoresPages iterates over the pages of a ListTrustStores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrustStores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrustStores operation.
//	pageNum := 0
//	err := client.ListTrustStoresPages(params,
//	    func(page *workspacesweb.ListTrustStoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListTrustStoresPages(input *ListTrustStoresInput, fn func(*ListTrustStoresOutput, bool) bool) error {
	return c.ListTrustStoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrustStoresPagesWithContext same as ListTrustStoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListTrustStoresPagesWithContext(ctx aws.Context, input *ListTrustStoresInput, fn func(*ListTrustStoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrustStoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrustStoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrustStoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserAccessLoggingSettings = "ListUserAccessLoggingSettings"

// ListUserAccessLoggingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserAccessLoggingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserAccessLoggingSettings for more information on using the ListUserAccessLoggingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUserAccessLoggingSettingsRequest method.
//	req, resp := client.ListUserAccessLoggingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings
func (c *WorkSpacesWeb) ListUserAccessLoggingSettingsRequest(input *ListUserAccessLoggingSettingsInput) (req *request.Request, output *ListUserAccessLoggingSettingsOutput) {
	op := &request.Operation{
		Name:       opListUserAccessLoggingSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/userAccessLoggingSettings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserAccessLoggingSettingsInput{}
	}

	output = &ListUserAccessLoggingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserAccessLoggingSettings API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of user access logging settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListUserAccessLoggingSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings
func (c *WorkSpacesWeb) ListUserAccessLoggingSettings(input *ListUserAccessLoggingSettingsInput) (*ListUserAccessLoggingSettingsOutput, error) {
	req, out := c.ListUserAccessLoggingSettingsRequest(input)
	return out, req.Send()
}

// ListUserAccessLoggingSettingsWithContext is the same as ListUserAccessLoggingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserAccessLoggingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListUserAccessLoggingSettingsWithContext(ctx aws.Context, input *ListUserAccessLoggingSettingsInput, opts ...request.Option) (*ListUserAccessLoggingSettingsOutput, error) {
	req, out := c.ListUserAccessLoggingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserAccessLoggingSettingsPages iterates over the pages of a ListUserAccessLoggingSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserAccessLoggingSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUserAccessLoggingSettings operation.
//	pageNum := 0
//	err := client.ListUserAccessLoggingSettingsPages(params,
//	    func(page *workspacesweb.ListUserAccessLoggingSettingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListUserAccessLoggingSettingsPages(input *ListUserAccessLoggingSettingsInput, fn func(*ListUserAccessLoggingSettingsOutput, bool) bool) error {
	return c.ListUserAccessLoggingSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserAccessLoggingSettingsPagesWithContext same as ListUserAccessLoggingSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListUserAccessLoggingSettingsPagesWithContext(ctx aws.Context, input *ListUserAccessLoggingSettingsInput, fn func(*ListUserAccessLoggingSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserAccessLoggingSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserAccessLoggingSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserAccessLoggingSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserSettings = "ListUserSettings"

// ListUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserSettings for more information on using the ListUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUserSettingsRequest method.
//	req, resp := client.ListUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings
func (c *WorkSpacesWeb) ListUserSettingsRequest(input *ListUserSettingsInput) (req *request.Request, output *ListUserSettingsOutput) {
	op := &request.Operation{
		Name:       opListUserSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/userSettings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserSettingsInput{}
	}

	output = &ListUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserSettings API operation for Amazon WorkSpaces Web.
//
// Retrieves a list of user settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation ListUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings
func (c *WorkSpacesWeb) ListUserSettings(input *ListUserSettingsInput) (*ListUserSettingsOutput, error) {
	req, out := c.ListUserSettingsRequest(input)
	return out, req.Send()
}

// ListUserSettingsWithContext is the same as ListUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListUserSettingsWithContext(ctx aws.Context, input *ListUserSettingsInput, opts ...request.Option) (*ListUserSettingsOutput, error) {
	req, out := c.ListUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserSettingsPages iterates over the pages of a ListUserSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUserSettings operation.
//	pageNum := 0
//	err := client.ListUserSettingsPages(params,
//	    func(page *workspacesweb.ListUserSettingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpacesWeb) ListUserSettingsPages(input *ListUserSettingsInput, fn func(*ListUserSettingsOutput, bool) bool) error {
	return c.ListUserSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserSettingsPagesWithContext same as ListUserSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) ListUserSettingsPagesWithContext(ctx aws.Context, input *ListUserSettingsInput, fn func(*ListUserSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource
func (c *WorkSpacesWeb) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn+}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon WorkSpaces Web.
//
// Adds or overwrites one or more tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - TooManyTagsException
//     There are too many tags.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource
func (c *WorkSpacesWeb) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource
func (c *WorkSpacesWeb) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn+}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon WorkSpaces Web.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource
func (c *WorkSpacesWeb) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBrowserSettings = "UpdateBrowserSettings"

// UpdateBrowserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBrowserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBrowserSettings for more information on using the UpdateBrowserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBrowserSettingsRequest method.
//	req, resp := client.UpdateBrowserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings
func (c *WorkSpacesWeb) UpdateBrowserSettingsRequest(input *UpdateBrowserSettingsInput) (req *request.Request, output *UpdateBrowserSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateBrowserSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/browserSettings/{browserSettingsArn+}",
	}

	if input == nil {
		input = &UpdateBrowserSettingsInput{}
	}

	output = &UpdateBrowserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBrowserSettings API operation for Amazon WorkSpaces Web.
//
// Updates browser settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdateBrowserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings
func (c *WorkSpacesWeb) UpdateBrowserSettings(input *UpdateBrowserSettingsInput) (*UpdateBrowserSettingsOutput, error) {
	req, out := c.UpdateBrowserSettingsRequest(input)
	return out, req.Send()
}

// UpdateBrowserSettingsWithContext is the same as UpdateBrowserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBrowserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdateBrowserSettingsWithContext(ctx aws.Context, input *UpdateBrowserSettingsInput, opts ...request.Option) (*UpdateBrowserSettingsOutput, error) {
	req, out := c.UpdateBrowserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentityProvider = "UpdateIdentityProvider"

// UpdateIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentityProvider for more information on using the UpdateIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIdentityProviderRequest method.
//	req, resp := client.UpdateIdentityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider
func (c *WorkSpacesWeb) UpdateIdentityProviderRequest(input *UpdateIdentityProviderInput) (req *request.Request, output *UpdateIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateIdentityProvider,
		HTTPMethod: "PATCH",
		HTTPPath:   "/identityProviders/{identityProviderArn+}",
	}

	if input == nil {
		input = &UpdateIdentityProviderInput{}
	}

	output = &UpdateIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdentityProvider API operation for Amazon WorkSpaces Web.
//
// Updates the identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdateIdentityProvider for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider
func (c *WorkSpacesWeb) UpdateIdentityProvider(input *UpdateIdentityProviderInput) (*UpdateIdentityProviderOutput, error) {
	req, out := c.UpdateIdentityProviderRequest(input)
	return out, req.Send()
}

// UpdateIdentityProviderWithContext is the same as UpdateIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdateIdentityProviderWithContext(ctx aws.Context, input *UpdateIdentityProviderInput, opts ...request.Option) (*UpdateIdentityProviderOutput, error) {
	req, out := c.UpdateIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIpAccessSettings = "UpdateIpAccessSettings"

// UpdateIpAccessSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIpAccessSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIpAccessSettings for more information on using the UpdateIpAccessSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIpAccessSettingsRequest method.
//	req, resp := client.UpdateIpAccessSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings
func (c *WorkSpacesWeb) UpdateIpAccessSettingsRequest(input *UpdateIpAccessSettingsInput) (req *request.Request, output *UpdateIpAccessSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateIpAccessSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/ipAccessSettings/{ipAccessSettingsArn+}",
	}

	if input == nil {
		input = &UpdateIpAccessSettingsInput{}
	}

	output = &UpdateIpAccessSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIpAccessSettings API operation for Amazon WorkSpaces Web.
//
// Updates IP access settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdateIpAccessSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings
func (c *WorkSpacesWeb) UpdateIpAccessSettings(input *UpdateIpAccessSettingsInput) (*UpdateIpAccessSettingsOutput, error) {
	req, out := c.UpdateIpAccessSettingsRequest(input)
	return out, req.Send()
}

// UpdateIpAccessSettingsWithContext is the same as UpdateIpAccessSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIpAccessSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdateIpAccessSettingsWithContext(ctx aws.Context, input *UpdateIpAccessSettingsInput, opts ...request.Option) (*UpdateIpAccessSettingsOutput, error) {
	req, out := c.UpdateIpAccessSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNetworkSettings = "UpdateNetworkSettings"

// UpdateNetworkSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNetworkSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNetworkSettings for more information on using the UpdateNetworkSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateNetworkSettingsRequest method.
//	req, resp := client.UpdateNetworkSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings
func (c *WorkSpacesWeb) UpdateNetworkSettingsRequest(input *UpdateNetworkSettingsInput) (req *request.Request, output *UpdateNetworkSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateNetworkSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/networkSettings/{networkSettingsArn+}",
	}

	if input == nil {
		input = &UpdateNetworkSettingsInput{}
	}

	output = &UpdateNetworkSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNetworkSettings API operation for Amazon WorkSpaces Web.
//
// Updates network settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdateNetworkSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings
func (c *WorkSpacesWeb) UpdateNetworkSettings(input *UpdateNetworkSettingsInput) (*UpdateNetworkSettingsOutput, error) {
	req, out := c.UpdateNetworkSettingsRequest(input)
	return out, req.Send()
}

// UpdateNetworkSettingsWithContext is the same as UpdateNetworkSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNetworkSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdateNetworkSettingsWithContext(ctx aws.Context, input *UpdateNetworkSettingsInput, opts ...request.Option) (*UpdateNetworkSettingsOutput, error) {
	req, out := c.UpdateNetworkSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePortal = "UpdatePortal"

// UpdatePortalRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePortal for more information on using the UpdatePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePortalRequest method.
//	req, resp := client.UpdatePortalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal
func (c *WorkSpacesWeb) UpdatePortalRequest(input *UpdatePortalInput) (req *request.Request, output *UpdatePortalOutput) {
	op := &request.Operation{
		Name:       opUpdatePortal,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalArn+}",
	}

	if input == nil {
		input = &UpdatePortalInput{}
	}

	output = &UpdatePortalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePortal API operation for Amazon WorkSpaces Web.
//
// Updates a web portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdatePortal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
//   - ConflictException
//     There is a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal
func (c *WorkSpacesWeb) UpdatePortal(input *UpdatePortalInput) (*UpdatePortalOutput, error) {
	req, out := c.UpdatePortalRequest(input)
	return out, req.Send()
}

// UpdatePortalWithContext is the same as UpdatePortal with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdatePortalWithContext(ctx aws.Context, input *UpdatePortalInput, opts ...request.Option) (*UpdatePortalOutput, error) {
	req, out := c.UpdatePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrustStore = "UpdateTrustStore"

// UpdateTrustStoreRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrustStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrustStore for more information on using the UpdateTrustStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTrustStoreRequest method.
//	req, resp := client.UpdateTrustStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore
func (c *WorkSpacesWeb) UpdateTrustStoreRequest(input *UpdateTrustStoreInput) (req *request.Request, output *UpdateTrustStoreOutput) {
	op := &request.Operation{
		Name:       opUpdateTrustStore,
		HTTPMethod: "PATCH",
		HTTPPath:   "/trustStores/{trustStoreArn+}",
	}

	if input == nil {
		input = &UpdateTrustStoreInput{}
	}

	output = &UpdateTrustStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrustStore API operation for Amazon WorkSpaces Web.
//
// Updates the trust store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdateTrustStore for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore
func (c *WorkSpacesWeb) UpdateTrustStore(input *UpdateTrustStoreInput) (*UpdateTrustStoreOutput, error) {
	req, out := c.UpdateTrustStoreRequest(input)
	return out, req.Send()
}

// UpdateTrustStoreWithContext is the same as UpdateTrustStore with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrustStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdateTrustStoreWithContext(ctx aws.Context, input *UpdateTrustStoreInput, opts ...request.Option) (*UpdateTrustStoreOutput, error) {
	req, out := c.UpdateTrustStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserAccessLoggingSettings = "UpdateUserAccessLoggingSettings"

// UpdateUserAccessLoggingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserAccessLoggingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserAccessLoggingSettings for more information on using the UpdateUserAccessLoggingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserAccessLoggingSettingsRequest method.
//	req, resp := client.UpdateUserAccessLoggingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings
func (c *WorkSpacesWeb) UpdateUserAccessLoggingSettingsRequest(input *UpdateUserAccessLoggingSettingsInput) (req *request.Request, output *UpdateUserAccessLoggingSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateUserAccessLoggingSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/userAccessLoggingSettings/{userAccessLoggingSettingsArn+}",
	}

	if input == nil {
		input = &UpdateUserAccessLoggingSettingsInput{}
	}

	output = &UpdateUserAccessLoggingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserAccessLoggingSettings API operation for Amazon WorkSpaces Web.
//
// Updates the user access logging settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdateUserAccessLoggingSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings
func (c *WorkSpacesWeb) UpdateUserAccessLoggingSettings(input *UpdateUserAccessLoggingSettingsInput) (*UpdateUserAccessLoggingSettingsOutput, error) {
	req, out := c.UpdateUserAccessLoggingSettingsRequest(input)
	return out, req.Send()
}

// UpdateUserAccessLoggingSettingsWithContext is the same as UpdateUserAccessLoggingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserAccessLoggingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdateUserAccessLoggingSettingsWithContext(ctx aws.Context, input *UpdateUserAccessLoggingSettingsInput, opts ...request.Option) (*UpdateUserAccessLoggingSettingsOutput, error) {
	req, out := c.UpdateUserAccessLoggingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserSettings = "UpdateUserSettings"

// UpdateUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserSettings for more information on using the UpdateUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserSettingsRequest method.
//	req, resp := client.UpdateUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings
func (c *WorkSpacesWeb) UpdateUserSettingsRequest(input *UpdateUserSettingsInput) (req *request.Request, output *UpdateUserSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateUserSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/userSettings/{userSettingsArn+}",
	}

	if input == nil {
		input = &UpdateUserSettingsInput{}
	}

	output = &UpdateUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserSettings API operation for Amazon WorkSpaces Web.
//
// Updates the user settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces Web's
// API operation UpdateUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is an internal server error.
//
//   - ResourceNotFoundException
//     The resource cannot be found.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     There is a throttling error.
//
//   - ValidationException
//     There is a validation error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings
func (c *WorkSpacesWeb) UpdateUserSettings(input *UpdateUserSettingsInput) (*UpdateUserSettingsOutput, error) {
	req, out := c.UpdateUserSettingsRequest(input)
	return out, req.Send()
}

// UpdateUserSettingsWithContext is the same as UpdateUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpacesWeb) UpdateUserSettingsWithContext(ctx aws.Context, input *UpdateUserSettingsInput, opts ...request.Option) (*UpdateUserSettingsOutput, error) {
	req, out := c.UpdateUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access is denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateBrowserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the browser settings.
	//
	// BrowserSettingsArn is a required field
	BrowserSettingsArn *string `location:"querystring" locationName:"browserSettingsArn" min:"20" type:"string" required:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBrowserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBrowserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateBrowserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateBrowserSettingsInput"}
	if s.BrowserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BrowserSettingsArn"))
	}
	if s.BrowserSettingsArn != nil && len(*s.BrowserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BrowserSettingsArn", 20))
	}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *AssociateBrowserSettingsInput) SetBrowserSettingsArn(v string) *AssociateBrowserSettingsInput {
	s.BrowserSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateBrowserSettingsInput) SetPortalArn(v string) *AssociateBrowserSettingsInput {
	s.PortalArn = &v
	return s
}

type AssociateBrowserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the browser settings.
	//
	// BrowserSettingsArn is a required field
	BrowserSettingsArn *string `locationName:"browserSettingsArn" min:"20" type:"string" required:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBrowserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBrowserSettingsOutput) GoString() string {
	return s.String()
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *AssociateBrowserSettingsOutput) SetBrowserSettingsArn(v string) *AssociateBrowserSettingsOutput {
	s.BrowserSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateBrowserSettingsOutput) SetPortalArn(v string) *AssociateBrowserSettingsOutput {
	s.PortalArn = &v
	return s
}

type AssociateIpAccessSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the IP access settings.
	//
	// IpAccessSettingsArn is a required field
	IpAccessSettingsArn *string `location:"querystring" locationName:"ipAccessSettingsArn" min:"20" type:"string" required:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpAccessSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpAccessSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIpAccessSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateIpAccessSettingsInput"}
	if s.IpAccessSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAccessSettingsArn"))
	}
	if s.IpAccessSettingsArn != nil && len(*s.IpAccessSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IpAccessSettingsArn", 20))
	}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *AssociateIpAccessSettingsInput) SetIpAccessSettingsArn(v string) *AssociateIpAccessSettingsInput {
	s.IpAccessSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateIpAccessSettingsInput) SetPortalArn(v string) *AssociateIpAccessSettingsInput {
	s.PortalArn = &v
	return s
}

type AssociateIpAccessSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IP access settings resource.
	//
	// IpAccessSettingsArn is a required field
	IpAccessSettingsArn *string `locationName:"ipAccessSettingsArn" min:"20" type:"string" required:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpAccessSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpAccessSettingsOutput) GoString() string {
	return s.String()
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *AssociateIpAccessSettingsOutput) SetIpAccessSettingsArn(v string) *AssociateIpAccessSettingsOutput {
	s.IpAccessSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateIpAccessSettingsOutput) SetPortalArn(v string) *AssociateIpAccessSettingsOutput {
	s.PortalArn = &v
	return s
}

type AssociateNetworkSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the network settings.
	//
	// NetworkSettingsArn is a required field
	NetworkSettingsArn *string `location:"querystring" locationName:"networkSettingsArn" min:"20" type:"string" required:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateNetworkSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateNetworkSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateNetworkSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateNetworkSettingsInput"}
	if s.NetworkSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSettingsArn"))
	}
	if s.NetworkSettingsArn != nil && len(*s.NetworkSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkSettingsArn", 20))
	}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *AssociateNetworkSettingsInput) SetNetworkSettingsArn(v string) *AssociateNetworkSettingsInput {
	s.NetworkSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateNetworkSettingsInput) SetPortalArn(v string) *AssociateNetworkSettingsInput {
	s.PortalArn = &v
	return s
}

type AssociateNetworkSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the network settings.
	//
	// NetworkSettingsArn is a required field
	NetworkSettingsArn *string `locationName:"networkSettingsArn" min:"20" type:"string" required:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateNetworkSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateNetworkSettingsOutput) GoString() string {
	return s.String()
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *AssociateNetworkSettingsOutput) SetNetworkSettingsArn(v string) *AssociateNetworkSettingsOutput {
	s.NetworkSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateNetworkSettingsOutput) SetPortalArn(v string) *AssociateNetworkSettingsOutput {
	s.PortalArn = &v
	return s
}

type AssociateTrustStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The ARN of the trust store.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `location:"querystring" locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrustStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrustStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTrustStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTrustStoreInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}
	if s.TrustStoreArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustStoreArn"))
	}
	if s.TrustStoreArn != nil && len(*s.TrustStoreArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrustStoreArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateTrustStoreInput) SetPortalArn(v string) *AssociateTrustStoreInput {
	s.PortalArn = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *AssociateTrustStoreInput) SetTrustStoreArn(v string) *AssociateTrustStoreInput {
	s.TrustStoreArn = &v
	return s
}

type AssociateTrustStoreOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The ARN of the trust store.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrustStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrustStoreOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateTrustStoreOutput) SetPortalArn(v string) *AssociateTrustStoreOutput {
	s.PortalArn = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *AssociateTrustStoreOutput) SetTrustStoreArn(v string) *AssociateTrustStoreOutput {
	s.TrustStoreArn = &v
	return s
}

type AssociateUserAccessLoggingSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The ARN of the user access logging settings.
	//
	// UserAccessLoggingSettingsArn is a required field
	UserAccessLoggingSettingsArn *string `location:"querystring" locationName:"userAccessLoggingSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserAccessLoggingSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserAccessLoggingSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateUserAccessLoggingSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateUserAccessLoggingSettingsInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}
	if s.UserAccessLoggingSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAccessLoggingSettingsArn"))
	}
	if s.UserAccessLoggingSettingsArn != nil && len(*s.UserAccessLoggingSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserAccessLoggingSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateUserAccessLoggingSettingsInput) SetPortalArn(v string) *AssociateUserAccessLoggingSettingsInput {
	s.PortalArn = &v
	return s
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *AssociateUserAccessLoggingSettingsInput) SetUserAccessLoggingSettingsArn(v string) *AssociateUserAccessLoggingSettingsInput {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

type AssociateUserAccessLoggingSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The ARN of the user access logging settings.
	//
	// UserAccessLoggingSettingsArn is a required field
	UserAccessLoggingSettingsArn *string `locationName:"userAccessLoggingSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserAccessLoggingSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserAccessLoggingSettingsOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateUserAccessLoggingSettingsOutput) SetPortalArn(v string) *AssociateUserAccessLoggingSettingsOutput {
	s.PortalArn = &v
	return s
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *AssociateUserAccessLoggingSettingsOutput) SetUserAccessLoggingSettingsArn(v string) *AssociateUserAccessLoggingSettingsOutput {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

type AssociateUserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The ARN of the user settings.
	//
	// UserSettingsArn is a required field
	UserSettingsArn *string `location:"querystring" locationName:"userSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateUserSettingsInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}
	if s.UserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserSettingsArn"))
	}
	if s.UserSettingsArn != nil && len(*s.UserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateUserSettingsInput) SetPortalArn(v string) *AssociateUserSettingsInput {
	s.PortalArn = &v
	return s
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *AssociateUserSettingsInput) SetUserSettingsArn(v string) *AssociateUserSettingsInput {
	s.UserSettingsArn = &v
	return s
}

type AssociateUserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The ARN of the user settings.
	//
	// UserSettingsArn is a required field
	UserSettingsArn *string `locationName:"userSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserSettingsOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *AssociateUserSettingsOutput) SetPortalArn(v string) *AssociateUserSettingsOutput {
	s.PortalArn = &v
	return s
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *AssociateUserSettingsOutput) SetUserSettingsArn(v string) *AssociateUserSettingsOutput {
	s.UserSettingsArn = &v
	return s
}

// The browser settings resource that can be associated with a web portal. Once
// associated with a web portal, browser settings control how the browser will
// behave once a user starts a streaming session for the web portal.
type BrowserSettings struct {
	_ struct{} `type:"structure"`

	// A list of web portal ARNs that this browser settings is associated with.
	AssociatedPortalArns []*string `locationName:"associatedPortalArns" type:"list"`

	// A JSON string containing Chrome Enterprise policies that will be applied
	// to all streaming sessions.
	//
	// BrowserPolicy is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BrowserSettings's
	// String and GoString methods.
	BrowserPolicy *string `locationName:"browserPolicy" min:"2" type:"string" sensitive:"true"`

	// The ARN of the browser settings.
	//
	// BrowserSettingsArn is a required field
	BrowserSettingsArn *string `locationName:"browserSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrowserSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrowserSettings) GoString() string {
	return s.String()
}

// SetAssociatedPortalArns sets the AssociatedPortalArns field's value.
func (s *BrowserSettings) SetAssociatedPortalArns(v []*string) *BrowserSettings {
	s.AssociatedPortalArns = v
	return s
}

// SetBrowserPolicy sets the BrowserPolicy field's value.
func (s *BrowserSettings) SetBrowserPolicy(v string) *BrowserSettings {
	s.BrowserPolicy = &v
	return s
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *BrowserSettings) SetBrowserSettingsArn(v string) *BrowserSettings {
	s.BrowserSettingsArn = &v
	return s
}

// The summary for browser settings.
type BrowserSettingsSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the browser settings.
	BrowserSettingsArn *string `locationName:"browserSettingsArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrowserSettingsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrowserSettingsSummary) GoString() string {
	return s.String()
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *BrowserSettingsSummary) SetBrowserSettingsArn(v string) *BrowserSettingsSummary {
	s.BrowserSettingsArn = &v
	return s
}

// The certificate.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The body of the certificate.
	// Body is automatically base64 encoded/decoded by the SDK.
	Body []byte `locationName:"body" type:"blob"`

	// The entity that issued the certificate.
	Issuer *string `locationName:"issuer" min:"1" type:"string"`

	// The certificate is not valid after this date.
	NotValidAfter *time.Time `locationName:"notValidAfter" type:"timestamp"`

	// The certificate is not valid before this date.
	NotValidBefore *time.Time `locationName:"notValidBefore" type:"timestamp"`

	// The entity the certificate belongs to.
	Subject *string `locationName:"subject" min:"1" type:"string"`

	// A hexadecimal identifier for the certificate.
	Thumbprint *string `locationName:"thumbprint" min:"64" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *Certificate) SetBody(v []byte) *Certificate {
	s.Body = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *Certificate) SetIssuer(v string) *Certificate {
	s.Issuer = &v
	return s
}

// SetNotValidAfter sets the NotValidAfter field's value.
func (s *Certificate) SetNotValidAfter(v time.Time) *Certificate {
	s.NotValidAfter = &v
	return s
}

// SetNotValidBefore sets the NotValidBefore field's value.
func (s *Certificate) SetNotValidBefore(v time.Time) *Certificate {
	s.NotValidBefore = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Certificate) SetSubject(v string) *Certificate {
	s.Subject = &v
	return s
}

// SetThumbprint sets the Thumbprint field's value.
func (s *Certificate) SetThumbprint(v string) *Certificate {
	s.Thumbprint = &v
	return s
}

// The summary of the certificate.
type CertificateSummary struct {
	_ struct{} `type:"structure"`

	// The entity that issued the certificate.
	Issuer *string `locationName:"issuer" min:"1" type:"string"`

	// The certificate is not valid after this date.
	NotValidAfter *time.Time `locationName:"notValidAfter" type:"timestamp"`

	// The certificate is not valid before this date.
	NotValidBefore *time.Time `locationName:"notValidBefore" type:"timestamp"`

	// The entity the certificate belongs to.
	Subject *string `locationName:"subject" min:"1" type:"string"`

	// A hexadecimal identifier for the certificate.
	Thumbprint *string `locationName:"thumbprint" min:"64" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateSummary) GoString() string {
	return s.String()
}

// SetIssuer sets the Issuer field's value.
func (s *CertificateSummary) SetIssuer(v string) *CertificateSummary {
	s.Issuer = &v
	return s
}

// SetNotValidAfter sets the NotValidAfter field's value.
func (s *CertificateSummary) SetNotValidAfter(v time.Time) *CertificateSummary {
	s.NotValidAfter = &v
	return s
}

// SetNotValidBefore sets the NotValidBefore field's value.
func (s *CertificateSummary) SetNotValidBefore(v time.Time) *CertificateSummary {
	s.NotValidBefore = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *CertificateSummary) SetSubject(v string) *CertificateSummary {
	s.Subject = &v
	return s
}

// SetThumbprint sets the Thumbprint field's value.
func (s *CertificateSummary) SetThumbprint(v string) *CertificateSummary {
	s.Thumbprint = &v
	return s
}

// There is a conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the resource affected.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Type of the resource affected.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateBrowserSettingsInput struct {
	_ struct{} `type:"structure"`

	// Additional encryption context of the browser settings.
	AdditionalEncryptionContext map[string]*string `locationName:"additionalEncryptionContext" type:"map"`

	// A JSON string containing Chrome Enterprise policies that will be applied
	// to all streaming sessions.
	//
	// BrowserPolicy is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBrowserSettingsInput's
	// String and GoString methods.
	//
	// BrowserPolicy is a required field
	BrowserPolicy *string `locationName:"browserPolicy" min:"2" type:"string" required:"true" sensitive:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The custom managed key of the browser settings.
	CustomerManagedKey *string `locationName:"customerManagedKey" min:"20" type:"string"`

	// The tags to add to the browser settings resource. A tag is a key-value pair.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBrowserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBrowserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBrowserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBrowserSettingsInput"}
	if s.BrowserPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("BrowserPolicy"))
	}
	if s.BrowserPolicy != nil && len(*s.BrowserPolicy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BrowserPolicy", 2))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.CustomerManagedKey != nil && len(*s.CustomerManagedKey) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerManagedKey", 20))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalEncryptionContext sets the AdditionalEncryptionContext field's value.
func (s *CreateBrowserSettingsInput) SetAdditionalEncryptionContext(v map[string]*string) *CreateBrowserSettingsInput {
	s.AdditionalEncryptionContext = v
	return s
}

// SetBrowserPolicy sets the BrowserPolicy field's value.
func (s *CreateBrowserSettingsInput) SetBrowserPolicy(v string) *CreateBrowserSettingsInput {
	s.BrowserPolicy = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateBrowserSettingsInput) SetClientToken(v string) *CreateBrowserSettingsInput {
	s.ClientToken = &v
	return s
}

// SetCustomerManagedKey sets the CustomerManagedKey field's value.
func (s *CreateBrowserSettingsInput) SetCustomerManagedKey(v string) *CreateBrowserSettingsInput {
	s.CustomerManagedKey = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBrowserSettingsInput) SetTags(v []*Tag) *CreateBrowserSettingsInput {
	s.Tags = v
	return s
}

type CreateBrowserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the browser settings.
	//
	// BrowserSettingsArn is a required field
	BrowserSettingsArn *string `locationName:"browserSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBrowserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBrowserSettingsOutput) GoString() string {
	return s.String()
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *CreateBrowserSettingsOutput) SetBrowserSettingsArn(v string) *CreateBrowserSettingsOutput {
	s.BrowserSettingsArn = &v
	return s
}

type CreateIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The identity provider details. The following list describes the provider
	// detail keys for each identity provider type.
	//
	//    * For Google and Login with Amazon: client_id client_secret authorize_scopes
	//
	//    * For Facebook: client_id client_secret authorize_scopes api_version
	//
	//    * For Sign in with Apple: client_id team_id key_id private_key authorize_scopes
	//
	//    * For OIDC providers: client_id client_secret attributes_request_method
	//    oidc_issuer authorize_scopes authorize_url if not available from discovery
	//    URL specified by oidc_issuer key token_url if not available from discovery
	//    URL specified by oidc_issuer key attributes_url if not available from
	//    discovery URL specified by oidc_issuer key jwks_uri if not available from
	//    discovery URL specified by oidc_issuer key
	//
	//    * For SAML providers: MetadataFile OR MetadataURL IDPSignout (boolean)
	//    optional
	//
	// IdentityProviderDetails is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateIdentityProviderInput's
	// String and GoString methods.
	//
	// IdentityProviderDetails is a required field
	IdentityProviderDetails map[string]*string `locationName:"identityProviderDetails" type:"map" required:"true" sensitive:"true"`

	// The identity provider name.
	//
	// IdentityProviderName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateIdentityProviderInput's
	// String and GoString methods.
	//
	// IdentityProviderName is a required field
	IdentityProviderName *string `locationName:"identityProviderName" min:"1" type:"string" required:"true" sensitive:"true"`

	// The identity provider type.
	//
	// IdentityProviderType is a required field
	IdentityProviderType *string `locationName:"identityProviderType" type:"string" required:"true" enum:"IdentityProviderType"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdentityProviderInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IdentityProviderDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderDetails"))
	}
	if s.IdentityProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderName"))
	}
	if s.IdentityProviderName != nil && len(*s.IdentityProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityProviderName", 1))
	}
	if s.IdentityProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderType"))
	}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIdentityProviderInput) SetClientToken(v string) *CreateIdentityProviderInput {
	s.ClientToken = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *CreateIdentityProviderInput) SetIdentityProviderDetails(v map[string]*string) *CreateIdentityProviderInput {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderName sets the IdentityProviderName field's value.
func (s *CreateIdentityProviderInput) SetIdentityProviderName(v string) *CreateIdentityProviderInput {
	s.IdentityProviderName = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *CreateIdentityProviderInput) SetIdentityProviderType(v string) *CreateIdentityProviderInput {
	s.IdentityProviderType = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *CreateIdentityProviderInput) SetPortalArn(v string) *CreateIdentityProviderInput {
	s.PortalArn = &v
	return s
}

type CreateIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the identity provider.
	//
	// IdentityProviderArn is a required field
	IdentityProviderArn *string `locationName:"identityProviderArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderArn sets the IdentityProviderArn field's value.
func (s *CreateIdentityProviderOutput) SetIdentityProviderArn(v string) *CreateIdentityProviderOutput {
	s.IdentityProviderArn = &v
	return s
}

type CreateIpAccessSettingsInput struct {
	_ struct{} `type:"structure"`

	// Additional encryption context of the IP access settings.
	AdditionalEncryptionContext map[string]*string `locationName:"additionalEncryptionContext" type:"map"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The custom managed key of the IP access settings.
	CustomerManagedKey *string `locationName:"customerManagedKey" min:"20" type:"string"`

	// The description of the IP access settings.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateIpAccessSettingsInput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The display name of the IP access settings.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateIpAccessSettingsInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The IP rules of the IP access settings.
	//
	// IpRules is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateIpAccessSettingsInput's
	// String and GoString methods.
	//
	// IpRules is a required field
	IpRules []*IpRule `locationName:"ipRules" min:"1" type:"list" required:"true" sensitive:"true"`

	// The tags to add to the browser settings resource. A tag is a key-value pair.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpAccessSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpAccessSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIpAccessSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIpAccessSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.CustomerManagedKey != nil && len(*s.CustomerManagedKey) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerManagedKey", 20))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IpRules == nil {
		invalidParams.Add(request.NewErrParamRequired("IpRules"))
	}
	if s.IpRules != nil && len(s.IpRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpRules", 1))
	}
	if s.IpRules != nil {
		for i, v := range s.IpRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IpRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalEncryptionContext sets the AdditionalEncryptionContext field's value.
func (s *CreateIpAccessSettingsInput) SetAdditionalEncryptionContext(v map[string]*string) *CreateIpAccessSettingsInput {
	s.AdditionalEncryptionContext = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIpAccessSettingsInput) SetClientToken(v string) *CreateIpAccessSettingsInput {
	s.ClientToken = &v
	return s
}

// SetCustomerManagedKey sets the CustomerManagedKey field's value.
func (s *CreateIpAccessSettingsInput) SetCustomerManagedKey(v string) *CreateIpAccessSettingsInput {
	s.CustomerManagedKey = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIpAccessSettingsInput) SetDescription(v string) *CreateIpAccessSettingsInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateIpAccessSettingsInput) SetDisplayName(v string) *CreateIpAccessSettingsInput {
	s.DisplayName = &v
	return s
}

// SetIpRules sets the IpRules field's value.
func (s *CreateIpAccessSettingsInput) SetIpRules(v []*IpRule) *CreateIpAccessSettingsInput {
	s.IpRules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIpAccessSettingsInput) SetTags(v []*Tag) *CreateIpAccessSettingsInput {
	s.Tags = v
	return s
}

type CreateIpAccessSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IP access settings resource.
	//
	// IpAccessSettingsArn is a required field
	IpAccessSettingsArn *string `locationName:"ipAccessSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpAccessSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpAccessSettingsOutput) GoString() string {
	return s.String()
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *CreateIpAccessSettingsOutput) SetIpAccessSettingsArn(v string) *CreateIpAccessSettingsOutput {
	s.IpAccessSettingsArn = &v
	return s
}

type CreateNetworkSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// One or more security groups used to control access from streaming instances
	// to your VPC.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// The subnets in which network interfaces are created to connect streaming
	// instances to your VPC. At least two of these subnets must be in different
	// availability zones.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" min:"2" type:"list" required:"true"`

	// The tags to add to the network settings resource. A tag is a key-value pair.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The VPC that streaming instances will connect to.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 2))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNetworkSettingsInput) SetClientToken(v string) *CreateNetworkSettingsInput {
	s.ClientToken = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateNetworkSettingsInput) SetSecurityGroupIds(v []*string) *CreateNetworkSettingsInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateNetworkSettingsInput) SetSubnetIds(v []*string) *CreateNetworkSettingsInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkSettingsInput) SetTags(v []*Tag) *CreateNetworkSettingsInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateNetworkSettingsInput) SetVpcId(v string) *CreateNetworkSettingsInput {
	s.VpcId = &v
	return s
}

type CreateNetworkSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the network settings.
	//
	// NetworkSettingsArn is a required field
	NetworkSettingsArn *string `locationName:"networkSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSettingsOutput) GoString() string {
	return s.String()
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *CreateNetworkSettingsOutput) SetNetworkSettingsArn(v string) *CreateNetworkSettingsOutput {
	s.NetworkSettingsArn = &v
	return s
}

type CreatePortalInput struct {
	_ struct{} `type:"structure"`

	// The additional encryption context of the portal.
	AdditionalEncryptionContext map[string]*string `locationName:"additionalEncryptionContext" type:"map"`

	// The type of authentication integration points used when signing into the
	// web portal. Defaults to Standard.
	//
	// Standard web portals are authenticated directly through your identity provider.
	// You need to call CreateIdentityProvider to integrate your identity provider
	// with your web portal. User and group access to your web portal is controlled
	// through your identity provider.
	//
	// IAM_Identity_Center web portals are authenticated through AWS IAM Identity
	// Center (successor to AWS Single Sign-On). They provide additional features,
	// such as IdP-initiated authentication. Identity sources (including external
	// identity provider integration), plus user and group access to your web portal,
	// can be configured in the IAM Identity Center.
	AuthenticationType *string `locationName:"authenticationType" type:"string" enum:"AuthenticationType"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The customer managed key of the web portal.
	CustomerManagedKey *string `locationName:"customerManagedKey" min:"20" type:"string"`

	// The name of the web portal. This is not visible to users who log into the
	// web portal.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePortalInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The tags to add to the web portal. A tag is a key-value pair.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.CustomerManagedKey != nil && len(*s.CustomerManagedKey) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerManagedKey", 20))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalEncryptionContext sets the AdditionalEncryptionContext field's value.
func (s *CreatePortalInput) SetAdditionalEncryptionContext(v map[string]*string) *CreatePortalInput {
	s.AdditionalEncryptionContext = v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *CreatePortalInput) SetAuthenticationType(v string) *CreatePortalInput {
	s.AuthenticationType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePortalInput) SetClientToken(v string) *CreatePortalInput {
	s.ClientToken = &v
	return s
}

// SetCustomerManagedKey sets the CustomerManagedKey field's value.
func (s *CreatePortalInput) SetCustomerManagedKey(v string) *CreatePortalInput {
	s.CustomerManagedKey = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreatePortalInput) SetDisplayName(v string) *CreatePortalInput {
	s.DisplayName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePortalInput) SetTags(v []*Tag) *CreatePortalInput {
	s.Tags = v
	return s
}

type CreatePortalOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The endpoint URL of the web portal that users access in order to start streaming
	// sessions.
	//
	// PortalEndpoint is a required field
	PortalEndpoint *string `locationName:"portalEndpoint" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePortalOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *CreatePortalOutput) SetPortalArn(v string) *CreatePortalOutput {
	s.PortalArn = &v
	return s
}

// SetPortalEndpoint sets the PortalEndpoint field's value.
func (s *CreatePortalOutput) SetPortalEndpoint(v string) *CreatePortalOutput {
	s.PortalEndpoint = &v
	return s
}

type CreateTrustStoreInput struct {
	_ struct{} `type:"structure"`

	// A list of CA certificates to be added to the trust store.
	//
	// CertificateList is a required field
	CertificateList [][]byte `locationName:"certificateList" type:"list" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The tags to add to the trust store. A tag is a key-value pair.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrustStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrustStoreInput"}
	if s.CertificateList == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateList"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateList sets the CertificateList field's value.
func (s *CreateTrustStoreInput) SetCertificateList(v [][]byte) *CreateTrustStoreInput {
	s.CertificateList = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTrustStoreInput) SetClientToken(v string) *CreateTrustStoreInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrustStoreInput) SetTags(v []*Tag) *CreateTrustStoreInput {
	s.Tags = v
	return s
}

type CreateTrustStoreOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the trust store.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustStoreOutput) GoString() string {
	return s.String()
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *CreateTrustStoreOutput) SetTrustStoreArn(v string) *CreateTrustStoreOutput {
	s.TrustStoreArn = &v
	return s
}

type CreateUserAccessLoggingSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the Kinesis stream.
	//
	// KinesisStreamArn is a required field
	KinesisStreamArn *string `locationName:"kinesisStreamArn" min:"20" type:"string" required:"true"`

	// The tags to add to the user settings resource. A tag is a key-value pair.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserAccessLoggingSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserAccessLoggingSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserAccessLoggingSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserAccessLoggingSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.KinesisStreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KinesisStreamArn"))
	}
	if s.KinesisStreamArn != nil && len(*s.KinesisStreamArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KinesisStreamArn", 20))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateUserAccessLoggingSettingsInput) SetClientToken(v string) *CreateUserAccessLoggingSettingsInput {
	s.ClientToken = &v
	return s
}

// SetKinesisStreamArn sets the KinesisStreamArn field's value.
func (s *CreateUserAccessLoggingSettingsInput) SetKinesisStreamArn(v string) *CreateUserAccessLoggingSettingsInput {
	s.KinesisStreamArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserAccessLoggingSettingsInput) SetTags(v []*Tag) *CreateUserAccessLoggingSettingsInput {
	s.Tags = v
	return s
}

type CreateUserAccessLoggingSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user access logging settings.
	//
	// UserAccessLoggingSettingsArn is a required field
	UserAccessLoggingSettingsArn *string `locationName:"userAccessLoggingSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserAccessLoggingSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserAccessLoggingSettingsOutput) GoString() string {
	return s.String()
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *CreateUserAccessLoggingSettingsOutput) SetUserAccessLoggingSettingsArn(v string) *CreateUserAccessLoggingSettingsOutput {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

type CreateUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Specifies whether the user can copy text from the streaming session to the
	// local device.
	//
	// CopyAllowed is a required field
	CopyAllowed *string `locationName:"copyAllowed" type:"string" required:"true" enum:"EnabledType"`

	// The amount of time that a streaming session remains active after users disconnect.
	DisconnectTimeoutInMinutes *int64 `locationName:"disconnectTimeoutInMinutes" min:"1" type:"integer"`

	// Specifies whether the user can download files from the streaming session
	// to the local device.
	//
	// DownloadAllowed is a required field
	DownloadAllowed *string `locationName:"downloadAllowed" type:"string" required:"true" enum:"EnabledType"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the disconnect timeout interval begins.
	IdleDisconnectTimeoutInMinutes *int64 `locationName:"idleDisconnectTimeoutInMinutes" type:"integer"`

	// Specifies whether the user can paste text from the local device to the streaming
	// session.
	//
	// PasteAllowed is a required field
	PasteAllowed *string `locationName:"pasteAllowed" type:"string" required:"true" enum:"EnabledType"`

	// Specifies whether the user can print to the local device.
	//
	// PrintAllowed is a required field
	PrintAllowed *string `locationName:"printAllowed" type:"string" required:"true" enum:"EnabledType"`

	// The tags to add to the user settings resource. A tag is a key-value pair.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	//
	// UploadAllowed is a required field
	UploadAllowed *string `locationName:"uploadAllowed" type:"string" required:"true" enum:"EnabledType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.CopyAllowed == nil {
		invalidParams.Add(request.NewErrParamRequired("CopyAllowed"))
	}
	if s.DisconnectTimeoutInMinutes != nil && *s.DisconnectTimeoutInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DisconnectTimeoutInMinutes", 1))
	}
	if s.DownloadAllowed == nil {
		invalidParams.Add(request.NewErrParamRequired("DownloadAllowed"))
	}
	if s.PasteAllowed == nil {
		invalidParams.Add(request.NewErrParamRequired("PasteAllowed"))
	}
	if s.PrintAllowed == nil {
		invalidParams.Add(request.NewErrParamRequired("PrintAllowed"))
	}
	if s.UploadAllowed == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadAllowed"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateUserSettingsInput) SetClientToken(v string) *CreateUserSettingsInput {
	s.ClientToken = &v
	return s
}

// SetCopyAllowed sets the CopyAllowed field's value.
func (s *CreateUserSettingsInput) SetCopyAllowed(v string) *CreateUserSettingsInput {
	s.CopyAllowed = &v
	return s
}

// SetDisconnectTimeoutInMinutes sets the DisconnectTimeoutInMinutes field's value.
func (s *CreateUserSettingsInput) SetDisconnectTimeoutInMinutes(v int64) *CreateUserSettingsInput {
	s.DisconnectTimeoutInMinutes = &v
	return s
}

// SetDownloadAllowed sets the DownloadAllowed field's value.
func (s *CreateUserSettingsInput) SetDownloadAllowed(v string) *CreateUserSettingsInput {
	s.DownloadAllowed = &v
	return s
}

// SetIdleDisconnectTimeoutInMinutes sets the IdleDisconnectTimeoutInMinutes field's value.
func (s *CreateUserSettingsInput) SetIdleDisconnectTimeoutInMinutes(v int64) *CreateUserSettingsInput {
	s.IdleDisconnectTimeoutInMinutes = &v
	return s
}

// SetPasteAllowed sets the PasteAllowed field's value.
func (s *CreateUserSettingsInput) SetPasteAllowed(v string) *CreateUserSettingsInput {
	s.PasteAllowed = &v
	return s
}

// SetPrintAllowed sets the PrintAllowed field's value.
func (s *CreateUserSettingsInput) SetPrintAllowed(v string) *CreateUserSettingsInput {
	s.PrintAllowed = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserSettingsInput) SetTags(v []*Tag) *CreateUserSettingsInput {
	s.Tags = v
	return s
}

// SetUploadAllowed sets the UploadAllowed field's value.
func (s *CreateUserSettingsInput) SetUploadAllowed(v string) *CreateUserSettingsInput {
	s.UploadAllowed = &v
	return s
}

type CreateUserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user settings.
	//
	// UserSettingsArn is a required field
	UserSettingsArn *string `locationName:"userSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserSettingsOutput) GoString() string {
	return s.String()
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *CreateUserSettingsOutput) SetUserSettingsArn(v string) *CreateUserSettingsOutput {
	s.UserSettingsArn = &v
	return s
}

type DeleteBrowserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the browser settings.
	//
	// BrowserSettingsArn is a required field
	BrowserSettingsArn *string `location:"uri" locationName:"browserSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBrowserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBrowserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBrowserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBrowserSettingsInput"}
	if s.BrowserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BrowserSettingsArn"))
	}
	if s.BrowserSettingsArn != nil && len(*s.BrowserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BrowserSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *DeleteBrowserSettingsInput) SetBrowserSettingsArn(v string) *DeleteBrowserSettingsInput {
	s.BrowserSettingsArn = &v
	return s
}

type DeleteBrowserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBrowserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBrowserSettingsOutput) GoString() string {
	return s.String()
}

type DeleteIdentityProviderInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the identity provider.
	//
	// IdentityProviderArn is a required field
	IdentityProviderArn *string `location:"uri" locationName:"identityProviderArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityProviderInput"}
	if s.IdentityProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderArn"))
	}
	if s.IdentityProviderArn != nil && len(*s.IdentityProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityProviderArn sets the IdentityProviderArn field's value.
func (s *DeleteIdentityProviderInput) SetIdentityProviderArn(v string) *DeleteIdentityProviderInput {
	s.IdentityProviderArn = &v
	return s
}

type DeleteIdentityProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderOutput) GoString() string {
	return s.String()
}

type DeleteIpAccessSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the IP access settings.
	//
	// IpAccessSettingsArn is a required field
	IpAccessSettingsArn *string `location:"uri" locationName:"ipAccessSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpAccessSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpAccessSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIpAccessSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIpAccessSettingsInput"}
	if s.IpAccessSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAccessSettingsArn"))
	}
	if s.IpAccessSettingsArn != nil && len(*s.IpAccessSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IpAccessSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *DeleteIpAccessSettingsInput) SetIpAccessSettingsArn(v string) *DeleteIpAccessSettingsInput {
	s.IpAccessSettingsArn = &v
	return s
}

type DeleteIpAccessSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpAccessSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpAccessSettingsOutput) GoString() string {
	return s.String()
}

type DeleteNetworkSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the network settings.
	//
	// NetworkSettingsArn is a required field
	NetworkSettingsArn *string `location:"uri" locationName:"networkSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkSettingsInput"}
	if s.NetworkSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSettingsArn"))
	}
	if s.NetworkSettingsArn != nil && len(*s.NetworkSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *DeleteNetworkSettingsInput) SetNetworkSettingsArn(v string) *DeleteNetworkSettingsInput {
	s.NetworkSettingsArn = &v
	return s
}

type DeleteNetworkSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSettingsOutput) GoString() string {
	return s.String()
}

type DeletePortalInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePortalInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *DeletePortalInput) SetPortalArn(v string) *DeletePortalInput {
	s.PortalArn = &v
	return s
}

type DeletePortalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePortalOutput) GoString() string {
	return s.String()
}

type DeleteTrustStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the trust store.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `location:"uri" locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrustStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrustStoreInput"}
	if s.TrustStoreArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustStoreArn"))
	}
	if s.TrustStoreArn != nil && len(*s.TrustStoreArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrustStoreArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *DeleteTrustStoreInput) SetTrustStoreArn(v string) *DeleteTrustStoreInput {
	s.TrustStoreArn = &v
	return s
}

type DeleteTrustStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustStoreOutput) GoString() string {
	return s.String()
}

type DeleteUserAccessLoggingSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user access logging settings.
	//
	// UserAccessLoggingSettingsArn is a required field
	UserAccessLoggingSettingsArn *string `location:"uri" locationName:"userAccessLoggingSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAccessLoggingSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAccessLoggingSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserAccessLoggingSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserAccessLoggingSettingsInput"}
	if s.UserAccessLoggingSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAccessLoggingSettingsArn"))
	}
	if s.UserAccessLoggingSettingsArn != nil && len(*s.UserAccessLoggingSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserAccessLoggingSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *DeleteUserAccessLoggingSettingsInput) SetUserAccessLoggingSettingsArn(v string) *DeleteUserAccessLoggingSettingsInput {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

type DeleteUserAccessLoggingSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAccessLoggingSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAccessLoggingSettingsOutput) GoString() string {
	return s.String()
}

type DeleteUserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user settings.
	//
	// UserSettingsArn is a required field
	UserSettingsArn *string `location:"uri" locationName:"userSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserSettingsInput"}
	if s.UserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserSettingsArn"))
	}
	if s.UserSettingsArn != nil && len(*s.UserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *DeleteUserSettingsInput) SetUserSettingsArn(v string) *DeleteUserSettingsInput {
	s.UserSettingsArn = &v
	return s
}

type DeleteUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserSettingsOutput) GoString() string {
	return s.String()
}

type DisassociateBrowserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateBrowserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateBrowserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateBrowserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateBrowserSettingsInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *DisassociateBrowserSettingsInput) SetPortalArn(v string) *DisassociateBrowserSettingsInput {
	s.PortalArn = &v
	return s
}

type DisassociateBrowserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateBrowserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateBrowserSettingsOutput) GoString() string {
	return s.String()
}

type DisassociateIpAccessSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpAccessSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpAccessSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateIpAccessSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateIpAccessSettingsInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *DisassociateIpAccessSettingsInput) SetPortalArn(v string) *DisassociateIpAccessSettingsInput {
	s.PortalArn = &v
	return s
}

type DisassociateIpAccessSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpAccessSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpAccessSettingsOutput) GoString() string {
	return s.String()
}

type DisassociateNetworkSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateNetworkSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateNetworkSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateNetworkSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateNetworkSettingsInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *DisassociateNetworkSettingsInput) SetPortalArn(v string) *DisassociateNetworkSettingsInput {
	s.PortalArn = &v
	return s
}

type DisassociateNetworkSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateNetworkSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateNetworkSettingsOutput) GoString() string {
	return s.String()
}

type DisassociateTrustStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrustStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrustStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTrustStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateTrustStoreInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *DisassociateTrustStoreInput) SetPortalArn(v string) *DisassociateTrustStoreInput {
	s.PortalArn = &v
	return s
}

type DisassociateTrustStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrustStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrustStoreOutput) GoString() string {
	return s.String()
}

type DisassociateUserAccessLoggingSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserAccessLoggingSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserAccessLoggingSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateUserAccessLoggingSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateUserAccessLoggingSettingsInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *DisassociateUserAccessLoggingSettingsInput) SetPortalArn(v string) *DisassociateUserAccessLoggingSettingsInput {
	s.PortalArn = &v
	return s
}

type DisassociateUserAccessLoggingSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserAccessLoggingSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserAccessLoggingSettingsOutput) GoString() string {
	return s.String()
}

type DisassociateUserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateUserSettingsInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *DisassociateUserSettingsInput) SetPortalArn(v string) *DisassociateUserSettingsInput {
	s.PortalArn = &v
	return s
}

type DisassociateUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserSettingsOutput) GoString() string {
	return s.String()
}

type GetBrowserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the browser settings.
	//
	// BrowserSettingsArn is a required field
	BrowserSettingsArn *string `location:"uri" locationName:"browserSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBrowserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBrowserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBrowserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBrowserSettingsInput"}
	if s.BrowserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BrowserSettingsArn"))
	}
	if s.BrowserSettingsArn != nil && len(*s.BrowserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BrowserSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *GetBrowserSettingsInput) SetBrowserSettingsArn(v string) *GetBrowserSettingsInput {
	s.BrowserSettingsArn = &v
	return s
}

type GetBrowserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The browser settings.
	BrowserSettings *BrowserSettings `locationName:"browserSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBrowserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBrowserSettingsOutput) GoString() string {
	return s.String()
}

// SetBrowserSettings sets the BrowserSettings field's value.
func (s *GetBrowserSettingsOutput) SetBrowserSettings(v *BrowserSettings) *GetBrowserSettingsOutput {
	s.BrowserSettings = v
	return s
}

type GetIdentityProviderInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the identity provider.
	//
	// IdentityProviderArn is a required field
	IdentityProviderArn *string `location:"uri" locationName:"identityProviderArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityProviderInput"}
	if s.IdentityProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderArn"))
	}
	if s.IdentityProviderArn != nil && len(*s.IdentityProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityProviderArn sets the IdentityProviderArn field's value.
func (s *GetIdentityProviderInput) SetIdentityProviderArn(v string) *GetIdentityProviderInput {
	s.IdentityProviderArn = &v
	return s
}

type GetIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider.
	IdentityProvider *IdentityProvider `locationName:"identityProvider" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *GetIdentityProviderOutput) SetIdentityProvider(v *IdentityProvider) *GetIdentityProviderOutput {
	s.IdentityProvider = v
	return s
}

type GetIpAccessSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the IP access settings.
	//
	// IpAccessSettingsArn is a required field
	IpAccessSettingsArn *string `location:"uri" locationName:"ipAccessSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIpAccessSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIpAccessSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIpAccessSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIpAccessSettingsInput"}
	if s.IpAccessSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAccessSettingsArn"))
	}
	if s.IpAccessSettingsArn != nil && len(*s.IpAccessSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IpAccessSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *GetIpAccessSettingsInput) SetIpAccessSettingsArn(v string) *GetIpAccessSettingsInput {
	s.IpAccessSettingsArn = &v
	return s
}

type GetIpAccessSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The IP access settings.
	IpAccessSettings *IpAccessSettings `locationName:"ipAccessSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIpAccessSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIpAccessSettingsOutput) GoString() string {
	return s.String()
}

// SetIpAccessSettings sets the IpAccessSettings field's value.
func (s *GetIpAccessSettingsOutput) SetIpAccessSettings(v *IpAccessSettings) *GetIpAccessSettingsOutput {
	s.IpAccessSettings = v
	return s
}

type GetNetworkSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the network settings.
	//
	// NetworkSettingsArn is a required field
	NetworkSettingsArn *string `location:"uri" locationName:"networkSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNetworkSettingsInput"}
	if s.NetworkSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSettingsArn"))
	}
	if s.NetworkSettingsArn != nil && len(*s.NetworkSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *GetNetworkSettingsInput) SetNetworkSettingsArn(v string) *GetNetworkSettingsInput {
	s.NetworkSettingsArn = &v
	return s
}

type GetNetworkSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The network settings.
	NetworkSettings *NetworkSettings `locationName:"networkSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSettingsOutput) GoString() string {
	return s.String()
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *GetNetworkSettingsOutput) SetNetworkSettings(v *NetworkSettings) *GetNetworkSettingsOutput {
	s.NetworkSettings = v
	return s
}

type GetPortalInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPortalInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *GetPortalInput) SetPortalArn(v string) *GetPortalInput {
	s.PortalArn = &v
	return s
}

type GetPortalOutput struct {
	_ struct{} `type:"structure"`

	// The web portal.
	Portal *Portal `locationName:"portal" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalOutput) GoString() string {
	return s.String()
}

// SetPortal sets the Portal field's value.
func (s *GetPortalOutput) SetPortal(v *Portal) *GetPortalOutput {
	s.Portal = v
	return s
}

type GetPortalServiceProviderMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalServiceProviderMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalServiceProviderMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPortalServiceProviderMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPortalServiceProviderMetadataInput"}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalArn sets the PortalArn field's value.
func (s *GetPortalServiceProviderMetadataInput) SetPortalArn(v string) *GetPortalServiceProviderMetadataInput {
	s.PortalArn = &v
	return s
}

type GetPortalServiceProviderMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"20" type:"string" required:"true"`

	// The service provider SAML metadata.
	ServiceProviderSamlMetadata *string `locationName:"serviceProviderSamlMetadata" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalServiceProviderMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPortalServiceProviderMetadataOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *GetPortalServiceProviderMetadataOutput) SetPortalArn(v string) *GetPortalServiceProviderMetadataOutput {
	s.PortalArn = &v
	return s
}

// SetServiceProviderSamlMetadata sets the ServiceProviderSamlMetadata field's value.
func (s *GetPortalServiceProviderMetadataOutput) SetServiceProviderSamlMetadata(v string) *GetPortalServiceProviderMetadataOutput {
	s.ServiceProviderSamlMetadata = &v
	return s
}

type GetTrustStoreCertificateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The thumbprint of the trust store certificate.
	//
	// Thumbprint is a required field
	Thumbprint *string `location:"querystring" locationName:"thumbprint" min:"64" type:"string" required:"true"`

	// The ARN of the trust store certificate.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `location:"uri" locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrustStoreCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrustStoreCertificateInput"}
	if s.Thumbprint == nil {
		invalidParams.Add(request.NewErrParamRequired("Thumbprint"))
	}
	if s.Thumbprint != nil && len(*s.Thumbprint) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("Thumbprint", 64))
	}
	if s.TrustStoreArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustStoreArn"))
	}
	if s.TrustStoreArn != nil && len(*s.TrustStoreArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrustStoreArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThumbprint sets the Thumbprint field's value.
func (s *GetTrustStoreCertificateInput) SetThumbprint(v string) *GetTrustStoreCertificateInput {
	s.Thumbprint = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *GetTrustStoreCertificateInput) SetTrustStoreArn(v string) *GetTrustStoreCertificateInput {
	s.TrustStoreArn = &v
	return s
}

type GetTrustStoreCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The certificate of the trust store certificate.
	Certificate *Certificate `locationName:"certificate" type:"structure"`

	// The ARN of the trust store certificate.
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetTrustStoreCertificateOutput) SetCertificate(v *Certificate) *GetTrustStoreCertificateOutput {
	s.Certificate = v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *GetTrustStoreCertificateOutput) SetTrustStoreArn(v string) *GetTrustStoreCertificateOutput {
	s.TrustStoreArn = &v
	return s
}

type GetTrustStoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the trust store.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `location:"uri" locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrustStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrustStoreInput"}
	if s.TrustStoreArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustStoreArn"))
	}
	if s.TrustStoreArn != nil && len(*s.TrustStoreArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrustStoreArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *GetTrustStoreInput) SetTrustStoreArn(v string) *GetTrustStoreInput {
	s.TrustStoreArn = &v
	return s
}

type GetTrustStoreOutput struct {
	_ struct{} `type:"structure"`

	// The trust store.
	TrustStore *TrustStore `locationName:"trustStore" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustStoreOutput) GoString() string {
	return s.String()
}

// SetTrustStore sets the TrustStore field's value.
func (s *GetTrustStoreOutput) SetTrustStore(v *TrustStore) *GetTrustStoreOutput {
	s.TrustStore = v
	return s
}

type GetUserAccessLoggingSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user access logging settings.
	//
	// UserAccessLoggingSettingsArn is a required field
	UserAccessLoggingSettingsArn *string `location:"uri" locationName:"userAccessLoggingSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAccessLoggingSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAccessLoggingSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserAccessLoggingSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserAccessLoggingSettingsInput"}
	if s.UserAccessLoggingSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAccessLoggingSettingsArn"))
	}
	if s.UserAccessLoggingSettingsArn != nil && len(*s.UserAccessLoggingSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserAccessLoggingSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *GetUserAccessLoggingSettingsInput) SetUserAccessLoggingSettingsArn(v string) *GetUserAccessLoggingSettingsInput {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

type GetUserAccessLoggingSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The user access logging settings.
	UserAccessLoggingSettings *UserAccessLoggingSettings `locationName:"userAccessLoggingSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAccessLoggingSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAccessLoggingSettingsOutput) GoString() string {
	return s.String()
}

// SetUserAccessLoggingSettings sets the UserAccessLoggingSettings field's value.
func (s *GetUserAccessLoggingSettingsOutput) SetUserAccessLoggingSettings(v *UserAccessLoggingSettings) *GetUserAccessLoggingSettingsOutput {
	s.UserAccessLoggingSettings = v
	return s
}

type GetUserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user settings.
	//
	// UserSettingsArn is a required field
	UserSettingsArn *string `location:"uri" locationName:"userSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserSettingsInput"}
	if s.UserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserSettingsArn"))
	}
	if s.UserSettingsArn != nil && len(*s.UserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *GetUserSettingsInput) SetUserSettingsArn(v string) *GetUserSettingsInput {
	s.UserSettingsArn = &v
	return s
}

type GetUserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The user settings.
	UserSettings *UserSettings `locationName:"userSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserSettingsOutput) GoString() string {
	return s.String()
}

// SetUserSettings sets the UserSettings field's value.
func (s *GetUserSettingsOutput) SetUserSettings(v *UserSettings) *GetUserSettingsOutput {
	s.UserSettings = v
	return s
}

// The identity provider.
type IdentityProvider struct {
	_ struct{} `type:"structure"`

	// The ARN of the identity provider.
	//
	// IdentityProviderArn is a required field
	IdentityProviderArn *string `locationName:"identityProviderArn" min:"20" type:"string" required:"true"`

	// The identity provider details. The following list describes the provider
	// detail keys for each identity provider type.
	//
	//    * For Google and Login with Amazon: client_id client_secret authorize_scopes
	//
	//    * For Facebook: client_id client_secret authorize_scopes api_version
	//
	//    * For Sign in with Apple: client_id team_id key_id private_key authorize_scopes
	//
	//    * For OIDC providers: client_id client_secret attributes_request_method
	//    oidc_issuer authorize_scopes authorize_url if not available from discovery
	//    URL specified by oidc_issuer key token_url if not available from discovery
	//    URL specified by oidc_issuer key attributes_url if not available from
	//    discovery URL specified by oidc_issuer key jwks_uri if not available from
	//    discovery URL specified by oidc_issuer key
	//
	//    * For SAML providers: MetadataFile OR MetadataURL IDPSignout optional
	//
	// IdentityProviderDetails is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IdentityProvider's
	// String and GoString methods.
	IdentityProviderDetails map[string]*string `locationName:"identityProviderDetails" type:"map" sensitive:"true"`

	// The identity provider name.
	//
	// IdentityProviderName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IdentityProvider's
	// String and GoString methods.
	IdentityProviderName *string `locationName:"identityProviderName" min:"1" type:"string" sensitive:"true"`

	// The identity provider type.
	IdentityProviderType *string `locationName:"identityProviderType" type:"string" enum:"IdentityProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProvider) GoString() string {
	return s.String()
}

// SetIdentityProviderArn sets the IdentityProviderArn field's value.
func (s *IdentityProvider) SetIdentityProviderArn(v string) *IdentityProvider {
	s.IdentityProviderArn = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *IdentityProvider) SetIdentityProviderDetails(v map[string]*string) *IdentityProvider {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderName sets the IdentityProviderName field's value.
func (s *IdentityProvider) SetIdentityProviderName(v string) *IdentityProvider {
	s.IdentityProviderName = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *IdentityProvider) SetIdentityProviderType(v string) *IdentityProvider {
	s.IdentityProviderType = &v
	return s
}

// The summary of the identity provider.
type IdentityProviderSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the identity provider.
	IdentityProviderArn *string `locationName:"identityProviderArn" min:"20" type:"string"`

	// The identity provider name.
	//
	// IdentityProviderName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IdentityProviderSummary's
	// String and GoString methods.
	IdentityProviderName *string `locationName:"identityProviderName" min:"1" type:"string" sensitive:"true"`

	// The identity provider type.
	IdentityProviderType *string `locationName:"identityProviderType" type:"string" enum:"IdentityProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderSummary) GoString() string {
	return s.String()
}

// SetIdentityProviderArn sets the IdentityProviderArn field's value.
func (s *IdentityProviderSummary) SetIdentityProviderArn(v string) *IdentityProviderSummary {
	s.IdentityProviderArn = &v
	return s
}

// SetIdentityProviderName sets the IdentityProviderName field's value.
func (s *IdentityProviderSummary) SetIdentityProviderName(v string) *IdentityProviderSummary {
	s.IdentityProviderName = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *IdentityProviderSummary) SetIdentityProviderType(v string) *IdentityProviderSummary {
	s.IdentityProviderType = &v
	return s
}

// There is an internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The IP access settings resource that can be associated with a web portal.
type IpAccessSettings struct {
	_ struct{} `type:"structure"`

	// A list of web portal ARNs that this IP access settings resource is associated
	// with.
	AssociatedPortalArns []*string `locationName:"associatedPortalArns" type:"list"`

	// The creation date timestamp of the IP access settings.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The description of the IP access settings.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpAccessSettings's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The display name of the IP access settings.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpAccessSettings's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The ARN of the IP access settings resource.
	//
	// IpAccessSettingsArn is a required field
	IpAccessSettingsArn *string `locationName:"ipAccessSettingsArn" min:"20" type:"string" required:"true"`

	// The IP rules of the IP access settings.
	//
	// IpRules is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpAccessSettings's
	// String and GoString methods.
	IpRules []*IpRule `locationName:"ipRules" min:"1" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAccessSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAccessSettings) GoString() string {
	return s.String()
}

// SetAssociatedPortalArns sets the AssociatedPortalArns field's value.
func (s *IpAccessSettings) SetAssociatedPortalArns(v []*string) *IpAccessSettings {
	s.AssociatedPortalArns = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *IpAccessSettings) SetCreationDate(v time.Time) *IpAccessSettings {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IpAccessSettings) SetDescription(v string) *IpAccessSettings {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *IpAccessSettings) SetDisplayName(v string) *IpAccessSettings {
	s.DisplayName = &v
	return s
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *IpAccessSettings) SetIpAccessSettingsArn(v string) *IpAccessSettings {
	s.IpAccessSettingsArn = &v
	return s
}

// SetIpRules sets the IpRules field's value.
func (s *IpAccessSettings) SetIpRules(v []*IpRule) *IpAccessSettings {
	s.IpRules = v
	return s
}

// The summary of IP access settings.
type IpAccessSettingsSummary struct {
	_ struct{} `type:"structure"`

	// The creation date timestamp of the IP access settings.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The description of the IP access settings.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpAccessSettingsSummary's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The display name of the IP access settings.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpAccessSettingsSummary's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The ARN of IP access settings.
	IpAccessSettingsArn *string `locationName:"ipAccessSettingsArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAccessSettingsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAccessSettingsSummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *IpAccessSettingsSummary) SetCreationDate(v time.Time) *IpAccessSettingsSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IpAccessSettingsSummary) SetDescription(v string) *IpAccessSettingsSummary {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *IpAccessSettingsSummary) SetDisplayName(v string) *IpAccessSettingsSummary {
	s.DisplayName = &v
	return s
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *IpAccessSettingsSummary) SetIpAccessSettingsArn(v string) *IpAccessSettingsSummary {
	s.IpAccessSettingsArn = &v
	return s
}

// The IP rules of the IP access settings.
type IpRule struct {
	_ struct{} `type:"structure"`

	// The description of the IP rule.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpRule's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The IP range of the IP rule.
	//
	// IpRange is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpRule's
	// String and GoString methods.
	//
	// IpRange is a required field
	IpRange *string `locationName:"ipRange" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpRule"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.IpRange == nil {
		invalidParams.Add(request.NewErrParamRequired("IpRange"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *IpRule) SetDescription(v string) *IpRule {
	s.Description = &v
	return s
}

// SetIpRange sets the IpRange field's value.
func (s *IpRule) SetIpRange(v string) *IpRule {
	s.IpRange = &v
	return s
}

type ListBrowserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBrowserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBrowserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBrowserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBrowserSettingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBrowserSettingsInput) SetMaxResults(v int64) *ListBrowserSettingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBrowserSettingsInput) SetNextToken(v string) *ListBrowserSettingsInput {
	s.NextToken = &v
	return s
}

type ListBrowserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The browser settings.
	BrowserSettings []*BrowserSettingsSummary `locationName:"browserSettings" type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBrowserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBrowserSettingsOutput) GoString() string {
	return s.String()
}

// SetBrowserSettings sets the BrowserSettings field's value.
func (s *ListBrowserSettingsOutput) SetBrowserSettings(v []*BrowserSettingsSummary) *ListBrowserSettingsOutput {
	s.BrowserSettings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBrowserSettingsOutput) SetNextToken(v string) *ListBrowserSettingsOutput {
	s.NextToken = &v
	return s
}

type ListIdentityProvidersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityProvidersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityProvidersInput) SetMaxResults(v int64) *ListIdentityProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersInput) SetNextToken(v string) *ListIdentityProvidersInput {
	s.NextToken = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *ListIdentityProvidersInput) SetPortalArn(v string) *ListIdentityProvidersInput {
	s.PortalArn = &v
	return s
}

type ListIdentityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The identity providers.
	IdentityProviders []*IdentityProviderSummary `locationName:"identityProviders" type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersOutput) GoString() string {
	return s.String()
}

// SetIdentityProviders sets the IdentityProviders field's value.
func (s *ListIdentityProvidersOutput) SetIdentityProviders(v []*IdentityProviderSummary) *ListIdentityProvidersOutput {
	s.IdentityProviders = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersOutput) SetNextToken(v string) *ListIdentityProvidersOutput {
	s.NextToken = &v
	return s
}

type ListIpAccessSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIpAccessSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIpAccessSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIpAccessSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIpAccessSettingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIpAccessSettingsInput) SetMaxResults(v int64) *ListIpAccessSettingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIpAccessSettingsInput) SetNextToken(v string) *ListIpAccessSettingsInput {
	s.NextToken = &v
	return s
}

type ListIpAccessSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The IP access settings.
	IpAccessSettings []*IpAccessSettingsSummary `locationName:"ipAccessSettings" type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIpAccessSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIpAccessSettingsOutput) GoString() string {
	return s.String()
}

// SetIpAccessSettings sets the IpAccessSettings field's value.
func (s *ListIpAccessSettingsOutput) SetIpAccessSettings(v []*IpAccessSettingsSummary) *ListIpAccessSettingsOutput {
	s.IpAccessSettings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIpAccessSettingsOutput) SetNextToken(v string) *ListIpAccessSettingsOutput {
	s.NextToken = &v
	return s
}

type ListNetworkSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNetworkSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNetworkSettingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNetworkSettingsInput) SetMaxResults(v int64) *ListNetworkSettingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworkSettingsInput) SetNextToken(v string) *ListNetworkSettingsInput {
	s.NextToken = &v
	return s
}

type ListNetworkSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The network settings.
	NetworkSettings []*NetworkSettingsSummary `locationName:"networkSettings" type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSettingsOutput) GoString() string {
	return s.String()
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *ListNetworkSettingsOutput) SetNetworkSettings(v []*NetworkSettingsSummary) *ListNetworkSettingsOutput {
	s.NetworkSettings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworkSettingsOutput) SetNextToken(v string) *ListNetworkSettingsOutput {
	s.NextToken = &v
	return s
}

type ListPortalsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPortalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPortalsInput) SetMaxResults(v int64) *ListPortalsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPortalsInput) SetNextToken(v string) *ListPortalsInput {
	s.NextToken = &v
	return s
}

type ListPortalsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The portals in the list.
	Portals []*PortalSummary `locationName:"portals" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPortalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPortalsOutput) SetNextToken(v string) *ListPortalsOutput {
	s.NextToken = &v
	return s
}

// SetPortals sets the Portals field's value.
func (s *ListPortalsOutput) SetPortals(v []*PortalSummary) *ListPortalsOutput {
	s.Portals = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags of the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTrustStoreCertificatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ARN of the trust store
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `location:"uri" locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoreCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoreCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrustStoreCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrustStoreCertificatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TrustStoreArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustStoreArn"))
	}
	if s.TrustStoreArn != nil && len(*s.TrustStoreArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrustStoreArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrustStoreCertificatesInput) SetMaxResults(v int64) *ListTrustStoreCertificatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustStoreCertificatesInput) SetNextToken(v string) *ListTrustStoreCertificatesInput {
	s.NextToken = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *ListTrustStoreCertificatesInput) SetTrustStoreArn(v string) *ListTrustStoreCertificatesInput {
	s.TrustStoreArn = &v
	return s
}

type ListTrustStoreCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The certificate list.
	CertificateList []*CertificateSummary `locationName:"certificateList" type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.>
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ARN of the trust store.
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoreCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoreCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificateList sets the CertificateList field's value.
func (s *ListTrustStoreCertificatesOutput) SetCertificateList(v []*CertificateSummary) *ListTrustStoreCertificatesOutput {
	s.CertificateList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustStoreCertificatesOutput) SetNextToken(v string) *ListTrustStoreCertificatesOutput {
	s.NextToken = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *ListTrustStoreCertificatesOutput) SetTrustStoreArn(v string) *ListTrustStoreCertificatesOutput {
	s.TrustStoreArn = &v
	return s
}

type ListTrustStoresInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrustStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrustStoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrustStoresInput) SetMaxResults(v int64) *ListTrustStoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustStoresInput) SetNextToken(v string) *ListTrustStoresInput {
	s.NextToken = &v
	return s
}

type ListTrustStoresOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The trust stores.
	TrustStores []*TrustStoreSummary `locationName:"trustStores" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustStoresOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustStoresOutput) SetNextToken(v string) *ListTrustStoresOutput {
	s.NextToken = &v
	return s
}

// SetTrustStores sets the TrustStores field's value.
func (s *ListTrustStoresOutput) SetTrustStores(v []*TrustStoreSummary) *ListTrustStoresOutput {
	s.TrustStores = v
	return s
}

type ListUserAccessLoggingSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAccessLoggingSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAccessLoggingSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserAccessLoggingSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserAccessLoggingSettingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserAccessLoggingSettingsInput) SetMaxResults(v int64) *ListUserAccessLoggingSettingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserAccessLoggingSettingsInput) SetNextToken(v string) *ListUserAccessLoggingSettingsInput {
	s.NextToken = &v
	return s
}

type ListUserAccessLoggingSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The user access logging settings.
	UserAccessLoggingSettings []*UserAccessLoggingSettingsSummary `locationName:"userAccessLoggingSettings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAccessLoggingSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAccessLoggingSettingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserAccessLoggingSettingsOutput) SetNextToken(v string) *ListUserAccessLoggingSettingsOutput {
	s.NextToken = &v
	return s
}

// SetUserAccessLoggingSettings sets the UserAccessLoggingSettings field's value.
func (s *ListUserAccessLoggingSettingsOutput) SetUserAccessLoggingSettings(v []*UserAccessLoggingSettingsSummary) *ListUserAccessLoggingSettingsOutput {
	s.UserAccessLoggingSettings = v
	return s
}

type ListUserSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserSettingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserSettingsInput) SetMaxResults(v int64) *ListUserSettingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserSettingsInput) SetNextToken(v string) *ListUserSettingsInput {
	s.NextToken = &v
	return s
}

type ListUserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token used to retrieve the next page of results for this operation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The user settings.
	UserSettings []*UserSettingsSummary `locationName:"userSettings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserSettingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserSettingsOutput) SetNextToken(v string) *ListUserSettingsOutput {
	s.NextToken = &v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *ListUserSettingsOutput) SetUserSettings(v []*UserSettingsSummary) *ListUserSettingsOutput {
	s.UserSettings = v
	return s
}

// A network settings resource that can be associated with a web portal. Once
// associated with a web portal, network settings define how streaming instances
// will connect with your specified VPC.
type NetworkSettings struct {
	_ struct{} `type:"structure"`

	// A list of web portal ARNs that this network settings is associated with.
	AssociatedPortalArns []*string `locationName:"associatedPortalArns" type:"list"`

	// The ARN of the network settings.
	//
	// NetworkSettingsArn is a required field
	NetworkSettingsArn *string `locationName:"networkSettingsArn" min:"20" type:"string" required:"true"`

	// One or more security groups used to control access from streaming instances
	// to your VPC.
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list"`

	// The subnets in which network interfaces are created to connect streaming
	// instances to your VPC. At least two of these subnets must be in different
	// availability zones.
	SubnetIds []*string `locationName:"subnetIds" min:"2" type:"list"`

	// The VPC that streaming instances will connect to.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkSettings) GoString() string {
	return s.String()
}

// SetAssociatedPortalArns sets the AssociatedPortalArns field's value.
func (s *NetworkSettings) SetAssociatedPortalArns(v []*string) *NetworkSettings {
	s.AssociatedPortalArns = v
	return s
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *NetworkSettings) SetNetworkSettingsArn(v string) *NetworkSettings {
	s.NetworkSettingsArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *NetworkSettings) SetSecurityGroupIds(v []*string) *NetworkSettings {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *NetworkSettings) SetSubnetIds(v []*string) *NetworkSettings {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkSettings) SetVpcId(v string) *NetworkSettings {
	s.VpcId = &v
	return s
}

// The summary of network settings.
type NetworkSettingsSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the network settings.
	NetworkSettingsArn *string `locationName:"networkSettingsArn" min:"20" type:"string"`

	// The VPC ID of the network settings.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkSettingsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkSettingsSummary) GoString() string {
	return s.String()
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *NetworkSettingsSummary) SetNetworkSettingsArn(v string) *NetworkSettingsSummary {
	s.NetworkSettingsArn = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkSettingsSummary) SetVpcId(v string) *NetworkSettingsSummary {
	s.VpcId = &v
	return s
}

// The web portal.
type Portal struct {
	_ struct{} `type:"structure"`

	// The type of authentication integration points used when signing into the
	// web portal. Defaults to Standard.
	//
	// Standard web portals are authenticated directly through your identity provider.
	// You need to call CreateIdentityProvider to integrate your identity provider
	// with your web portal. User and group access to your web portal is controlled
	// through your identity provider.
	//
	// IAM_Identity_Center web portals are authenticated through AWS IAM Identity
	// Center (successor to AWS Single Sign-On). They provide additional features,
	// such as IdP-initiated authentication. Identity sources (including external
	// identity provider integration), plus user and group access to your web portal,
	// can be configured in the IAM Identity Center.
	AuthenticationType *string `locationName:"authenticationType" type:"string" enum:"AuthenticationType"`

	// The ARN of the browser settings that is associated with this web portal.
	BrowserSettingsArn *string `locationName:"browserSettingsArn" min:"20" type:"string"`

	// The browser that users see when using a streaming session.
	BrowserType *string `locationName:"browserType" type:"string" enum:"BrowserType"`

	// The creation date of the web portal.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The name of the web portal.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Portal's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The ARN of the IP access settings.
	IpAccessSettingsArn *string `locationName:"ipAccessSettingsArn" min:"20" type:"string"`

	// The ARN of the network settings that is associated with the web portal.
	NetworkSettingsArn *string `locationName:"networkSettingsArn" min:"20" type:"string"`

	// The ARN of the web portal.
	PortalArn *string `locationName:"portalArn" min:"20" type:"string"`

	// The endpoint URL of the web portal that users access in order to start streaming
	// sessions.
	PortalEndpoint *string `locationName:"portalEndpoint" min:"1" type:"string"`

	// The status of the web portal.
	PortalStatus *string `locationName:"portalStatus" type:"string" enum:"PortalStatus"`

	// The renderer that is used in streaming sessions.
	RendererType *string `locationName:"rendererType" type:"string" enum:"RendererType"`

	// A message that explains why the web portal is in its current status.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// The ARN of the trust store that is associated with the web portal.
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string"`

	// The ARN of the user access logging settings that is associated with the web
	// portal.
	UserAccessLoggingSettingsArn *string `locationName:"userAccessLoggingSettingsArn" min:"20" type:"string"`

	// The ARN of the user settings that is associated with the web portal.
	UserSettingsArn *string `locationName:"userSettingsArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Portal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Portal) GoString() string {
	return s.String()
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *Portal) SetAuthenticationType(v string) *Portal {
	s.AuthenticationType = &v
	return s
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *Portal) SetBrowserSettingsArn(v string) *Portal {
	s.BrowserSettingsArn = &v
	return s
}

// SetBrowserType sets the BrowserType field's value.
func (s *Portal) SetBrowserType(v string) *Portal {
	s.BrowserType = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Portal) SetCreationDate(v time.Time) *Portal {
	s.CreationDate = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Portal) SetDisplayName(v string) *Portal {
	s.DisplayName = &v
	return s
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *Portal) SetIpAccessSettingsArn(v string) *Portal {
	s.IpAccessSettingsArn = &v
	return s
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *Portal) SetNetworkSettingsArn(v string) *Portal {
	s.NetworkSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *Portal) SetPortalArn(v string) *Portal {
	s.PortalArn = &v
	return s
}

// SetPortalEndpoint sets the PortalEndpoint field's value.
func (s *Portal) SetPortalEndpoint(v string) *Portal {
	s.PortalEndpoint = &v
	return s
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *Portal) SetPortalStatus(v string) *Portal {
	s.PortalStatus = &v
	return s
}

// SetRendererType sets the RendererType field's value.
func (s *Portal) SetRendererType(v string) *Portal {
	s.RendererType = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Portal) SetStatusReason(v string) *Portal {
	s.StatusReason = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *Portal) SetTrustStoreArn(v string) *Portal {
	s.TrustStoreArn = &v
	return s
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *Portal) SetUserAccessLoggingSettingsArn(v string) *Portal {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *Portal) SetUserSettingsArn(v string) *Portal {
	s.UserSettingsArn = &v
	return s
}

// The summary of the portal.
type PortalSummary struct {
	_ struct{} `type:"structure"`

	// The type of authentication integration points used when signing into the
	// web portal. Defaults to Standard.
	//
	// Standard web portals are authenticated directly through your identity provider.
	// You need to call CreateIdentityProvider to integrate your identity provider
	// with your web portal. User and group access to your web portal is controlled
	// through your identity provider.
	//
	// IAM_Identity_Center web portals are authenticated through AWS IAM Identity
	// Center (successor to AWS Single Sign-On). They provide additional features,
	// such as IdP-initiated authentication. Identity sources (including external
	// identity provider integration), plus user and group access to your web portal,
	// can be configured in the IAM Identity Center.
	AuthenticationType *string `locationName:"authenticationType" type:"string" enum:"AuthenticationType"`

	// The ARN of the browser settings that is associated with the web portal.
	BrowserSettingsArn *string `locationName:"browserSettingsArn" min:"20" type:"string"`

	// The browser type of the web portal.
	BrowserType *string `locationName:"browserType" type:"string" enum:"BrowserType"`

	// The creation date of the web portal.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The name of the web portal.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PortalSummary's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The ARN of the IP access settings.
	IpAccessSettingsArn *string `locationName:"ipAccessSettingsArn" min:"20" type:"string"`

	// The ARN of the network settings that is associated with the web portal.
	NetworkSettingsArn *string `locationName:"networkSettingsArn" min:"20" type:"string"`

	// The ARN of the web portal.
	PortalArn *string `locationName:"portalArn" min:"20" type:"string"`

	// The endpoint URL of the web portal that users access in order to start streaming
	// sessions.
	PortalEndpoint *string `locationName:"portalEndpoint" min:"1" type:"string"`

	// The status of the web portal.
	PortalStatus *string `locationName:"portalStatus" type:"string" enum:"PortalStatus"`

	// The renderer that is used in streaming sessions.
	RendererType *string `locationName:"rendererType" type:"string" enum:"RendererType"`

	// The ARN of the trust that is associated with this web portal.
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string"`

	// The ARN of the user access logging settings that is associated with the web
	// portal.
	UserAccessLoggingSettingsArn *string `locationName:"userAccessLoggingSettingsArn" min:"20" type:"string"`

	// The ARN of the user settings that is associated with the web portal.
	UserSettingsArn *string `locationName:"userSettingsArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalSummary) GoString() string {
	return s.String()
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *PortalSummary) SetAuthenticationType(v string) *PortalSummary {
	s.AuthenticationType = &v
	return s
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *PortalSummary) SetBrowserSettingsArn(v string) *PortalSummary {
	s.BrowserSettingsArn = &v
	return s
}

// SetBrowserType sets the BrowserType field's value.
func (s *PortalSummary) SetBrowserType(v string) *PortalSummary {
	s.BrowserType = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *PortalSummary) SetCreationDate(v time.Time) *PortalSummary {
	s.CreationDate = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *PortalSummary) SetDisplayName(v string) *PortalSummary {
	s.DisplayName = &v
	return s
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *PortalSummary) SetIpAccessSettingsArn(v string) *PortalSummary {
	s.IpAccessSettingsArn = &v
	return s
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *PortalSummary) SetNetworkSettingsArn(v string) *PortalSummary {
	s.NetworkSettingsArn = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *PortalSummary) SetPortalArn(v string) *PortalSummary {
	s.PortalArn = &v
	return s
}

// SetPortalEndpoint sets the PortalEndpoint field's value.
func (s *PortalSummary) SetPortalEndpoint(v string) *PortalSummary {
	s.PortalEndpoint = &v
	return s
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *PortalSummary) SetPortalStatus(v string) *PortalSummary {
	s.PortalStatus = &v
	return s
}

// SetRendererType sets the RendererType field's value.
func (s *PortalSummary) SetRendererType(v string) *PortalSummary {
	s.RendererType = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *PortalSummary) SetTrustStoreArn(v string) *PortalSummary {
	s.TrustStoreArn = &v
	return s
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *PortalSummary) SetUserAccessLoggingSettingsArn(v string) *PortalSummary {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *PortalSummary) SetUserSettingsArn(v string) *PortalSummary {
	s.UserSettingsArn = &v
	return s
}

// The resource cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Hypothetical identifier of the resource affected.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Hypothetical type of the resource affected.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service quota has been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The originating quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Identifier of the resource affected.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Type of the resource affected.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The originating service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The tag.
type Tag struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The key of the tag.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The value of the tag
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token returns the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tags of the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *TagResourceInput) SetClientToken(v string) *TagResourceInput {
	s.ClientToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// There is a throttling error.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The originating quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The originating service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There are too many tags.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Name of the resource affected.
	ResourceName *string `locationName:"resourceName" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A trust store that can be associated with a web portal. A trust store contains
// certificate authority (CA) certificates. Once associated with a web portal,
// the browser in a streaming session will recognize certificates that have
// been issued using any of the CAs in the trust store. If your organization
// has internal websites that use certificates issued by private CAs, you should
// add the private CA certificate to the trust store.
type TrustStore struct {
	_ struct{} `type:"structure"`

	// A list of web portal ARNs that this trust store is associated with.
	AssociatedPortalArns []*string `locationName:"associatedPortalArns" type:"list"`

	// The ARN of the trust store.
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustStore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustStore) GoString() string {
	return s.String()
}

// SetAssociatedPortalArns sets the AssociatedPortalArns field's value.
func (s *TrustStore) SetAssociatedPortalArns(v []*string) *TrustStore {
	s.AssociatedPortalArns = v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *TrustStore) SetTrustStoreArn(v string) *TrustStore {
	s.TrustStoreArn = &v
	return s
}

// The summary of the trust store.
type TrustStoreSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the trust store.
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustStoreSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustStoreSummary) GoString() string {
	return s.String()
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *TrustStoreSummary) SetTrustStoreArn(v string) *TrustStoreSummary {
	s.TrustStoreArn = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateBrowserSettingsInput struct {
	_ struct{} `type:"structure"`

	// A JSON string containing Chrome Enterprise policies that will be applied
	// to all streaming sessions.
	//
	// BrowserPolicy is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateBrowserSettingsInput's
	// String and GoString methods.
	BrowserPolicy *string `locationName:"browserPolicy" min:"2" type:"string" sensitive:"true"`

	// The ARN of the browser settings.
	//
	// BrowserSettingsArn is a required field
	BrowserSettingsArn *string `location:"uri" locationName:"browserSettingsArn" min:"20" type:"string" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token return the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrowserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrowserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBrowserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBrowserSettingsInput"}
	if s.BrowserPolicy != nil && len(*s.BrowserPolicy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BrowserPolicy", 2))
	}
	if s.BrowserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BrowserSettingsArn"))
	}
	if s.BrowserSettingsArn != nil && len(*s.BrowserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BrowserSettingsArn", 20))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrowserPolicy sets the BrowserPolicy field's value.
func (s *UpdateBrowserSettingsInput) SetBrowserPolicy(v string) *UpdateBrowserSettingsInput {
	s.BrowserPolicy = &v
	return s
}

// SetBrowserSettingsArn sets the BrowserSettingsArn field's value.
func (s *UpdateBrowserSettingsInput) SetBrowserSettingsArn(v string) *UpdateBrowserSettingsInput {
	s.BrowserSettingsArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateBrowserSettingsInput) SetClientToken(v string) *UpdateBrowserSettingsInput {
	s.ClientToken = &v
	return s
}

type UpdateBrowserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The browser settings.
	//
	// BrowserSettings is a required field
	BrowserSettings *BrowserSettings `locationName:"browserSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrowserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBrowserSettingsOutput) GoString() string {
	return s.String()
}

// SetBrowserSettings sets the BrowserSettings field's value.
func (s *UpdateBrowserSettingsOutput) SetBrowserSettings(v *BrowserSettings) *UpdateBrowserSettingsOutput {
	s.BrowserSettings = v
	return s
}

type UpdateIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token return the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the identity provider.
	//
	// IdentityProviderArn is a required field
	IdentityProviderArn *string `location:"uri" locationName:"identityProviderArn" min:"20" type:"string" required:"true"`

	// The details of the identity provider. The following list describes the provider
	// detail keys for each identity provider type.
	//
	//    * For Google and Login with Amazon: client_id client_secret authorize_scopes
	//
	//    * For Facebook: client_id client_secret authorize_scopes api_version
	//
	//    * For Sign in with Apple: client_id team_id key_id private_key authorize_scopes
	//
	//    * For OIDC providers: client_id client_secret attributes_request_method
	//    oidc_issuer authorize_scopes authorize_url if not available from discovery
	//    URL specified by oidc_issuer key token_url if not available from discovery
	//    URL specified by oidc_issuer key attributes_url if not available from
	//    discovery URL specified by oidc_issuer key jwks_uri if not available from
	//    discovery URL specified by oidc_issuer key
	//
	//    * For SAML providers: MetadataFile OR MetadataURL IDPSignout (boolean)
	//    optional
	//
	// IdentityProviderDetails is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateIdentityProviderInput's
	// String and GoString methods.
	IdentityProviderDetails map[string]*string `locationName:"identityProviderDetails" type:"map" sensitive:"true"`

	// The name of the identity provider.
	//
	// IdentityProviderName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateIdentityProviderInput's
	// String and GoString methods.
	IdentityProviderName *string `locationName:"identityProviderName" min:"1" type:"string" sensitive:"true"`

	// The type of the identity provider.
	IdentityProviderType *string `locationName:"identityProviderType" type:"string" enum:"IdentityProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdentityProviderInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IdentityProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderArn"))
	}
	if s.IdentityProviderArn != nil && len(*s.IdentityProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityProviderArn", 20))
	}
	if s.IdentityProviderName != nil && len(*s.IdentityProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateIdentityProviderInput) SetClientToken(v string) *UpdateIdentityProviderInput {
	s.ClientToken = &v
	return s
}

// SetIdentityProviderArn sets the IdentityProviderArn field's value.
func (s *UpdateIdentityProviderInput) SetIdentityProviderArn(v string) *UpdateIdentityProviderInput {
	s.IdentityProviderArn = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *UpdateIdentityProviderInput) SetIdentityProviderDetails(v map[string]*string) *UpdateIdentityProviderInput {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderName sets the IdentityProviderName field's value.
func (s *UpdateIdentityProviderInput) SetIdentityProviderName(v string) *UpdateIdentityProviderInput {
	s.IdentityProviderName = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *UpdateIdentityProviderInput) SetIdentityProviderType(v string) *UpdateIdentityProviderInput {
	s.IdentityProviderType = &v
	return s
}

type UpdateIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `locationName:"identityProvider" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *UpdateIdentityProviderOutput) SetIdentityProvider(v *IdentityProvider) *UpdateIdentityProviderOutput {
	s.IdentityProvider = v
	return s
}

type UpdateIpAccessSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token return the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the IP access settings.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateIpAccessSettingsInput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The display name of the IP access settings.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateIpAccessSettingsInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The ARN of the IP access settings.
	//
	// IpAccessSettingsArn is a required field
	IpAccessSettingsArn *string `location:"uri" locationName:"ipAccessSettingsArn" min:"20" type:"string" required:"true"`

	// The updated IP rules of the IP access settings.
	//
	// IpRules is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateIpAccessSettingsInput's
	// String and GoString methods.
	IpRules []*IpRule `locationName:"ipRules" min:"1" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIpAccessSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIpAccessSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIpAccessSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIpAccessSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IpAccessSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAccessSettingsArn"))
	}
	if s.IpAccessSettingsArn != nil && len(*s.IpAccessSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IpAccessSettingsArn", 20))
	}
	if s.IpRules != nil && len(s.IpRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpRules", 1))
	}
	if s.IpRules != nil {
		for i, v := range s.IpRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IpRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateIpAccessSettingsInput) SetClientToken(v string) *UpdateIpAccessSettingsInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateIpAccessSettingsInput) SetDescription(v string) *UpdateIpAccessSettingsInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateIpAccessSettingsInput) SetDisplayName(v string) *UpdateIpAccessSettingsInput {
	s.DisplayName = &v
	return s
}

// SetIpAccessSettingsArn sets the IpAccessSettingsArn field's value.
func (s *UpdateIpAccessSettingsInput) SetIpAccessSettingsArn(v string) *UpdateIpAccessSettingsInput {
	s.IpAccessSettingsArn = &v
	return s
}

// SetIpRules sets the IpRules field's value.
func (s *UpdateIpAccessSettingsInput) SetIpRules(v []*IpRule) *UpdateIpAccessSettingsInput {
	s.IpRules = v
	return s
}

type UpdateIpAccessSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The IP access settings.
	//
	// IpAccessSettings is a required field
	IpAccessSettings *IpAccessSettings `locationName:"ipAccessSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIpAccessSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIpAccessSettingsOutput) GoString() string {
	return s.String()
}

// SetIpAccessSettings sets the IpAccessSettings field's value.
func (s *UpdateIpAccessSettingsOutput) SetIpAccessSettings(v *IpAccessSettings) *UpdateIpAccessSettingsOutput {
	s.IpAccessSettings = v
	return s
}

type UpdateNetworkSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token return the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the network settings.
	//
	// NetworkSettingsArn is a required field
	NetworkSettingsArn *string `location:"uri" locationName:"networkSettingsArn" min:"20" type:"string" required:"true"`

	// One or more security groups used to control access from streaming instances
	// to your VPC.
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list"`

	// The subnets in which network interfaces are created to connect streaming
	// instances to your VPC. At least two of these subnets must be in different
	// availability zones.
	SubnetIds []*string `locationName:"subnetIds" min:"2" type:"list"`

	// The VPC that streaming instances will connect to.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNetworkSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNetworkSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSettingsArn"))
	}
	if s.NetworkSettingsArn != nil && len(*s.NetworkSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkSettingsArn", 20))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 2))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateNetworkSettingsInput) SetClientToken(v string) *UpdateNetworkSettingsInput {
	s.ClientToken = &v
	return s
}

// SetNetworkSettingsArn sets the NetworkSettingsArn field's value.
func (s *UpdateNetworkSettingsInput) SetNetworkSettingsArn(v string) *UpdateNetworkSettingsInput {
	s.NetworkSettingsArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateNetworkSettingsInput) SetSecurityGroupIds(v []*string) *UpdateNetworkSettingsInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateNetworkSettingsInput) SetSubnetIds(v []*string) *UpdateNetworkSettingsInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *UpdateNetworkSettingsInput) SetVpcId(v string) *UpdateNetworkSettingsInput {
	s.VpcId = &v
	return s
}

type UpdateNetworkSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The network settings.
	//
	// NetworkSettings is a required field
	NetworkSettings *NetworkSettings `locationName:"networkSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSettingsOutput) GoString() string {
	return s.String()
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *UpdateNetworkSettingsOutput) SetNetworkSettings(v *NetworkSettings) *UpdateNetworkSettingsOutput {
	s.NetworkSettings = v
	return s
}

type UpdatePortalInput struct {
	_ struct{} `type:"structure"`

	// The type of authentication integration points used when signing into the
	// web portal. Defaults to Standard.
	//
	// Standard web portals are authenticated directly through your identity provider.
	// You need to call CreateIdentityProvider to integrate your identity provider
	// with your web portal. User and group access to your web portal is controlled
	// through your identity provider.
	//
	// IAM_Identity_Center web portals are authenticated through AWS IAM Identity
	// Center (successor to AWS Single Sign-On). They provide additional features,
	// such as IdP-initiated authentication. Identity sources (including external
	// identity provider integration), plus user and group access to your web portal,
	// can be configured in the IAM Identity Center.
	AuthenticationType *string `locationName:"authenticationType" type:"string" enum:"AuthenticationType"`

	// The name of the web portal. This is not visible to users who log into the
	// web portal.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePortalInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The ARN of the web portal.
	//
	// PortalArn is a required field
	PortalArn *string `location:"uri" locationName:"portalArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePortalInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.PortalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalArn"))
	}
	if s.PortalArn != nil && len(*s.PortalArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PortalArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *UpdatePortalInput) SetAuthenticationType(v string) *UpdatePortalInput {
	s.AuthenticationType = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdatePortalInput) SetDisplayName(v string) *UpdatePortalInput {
	s.DisplayName = &v
	return s
}

// SetPortalArn sets the PortalArn field's value.
func (s *UpdatePortalInput) SetPortalArn(v string) *UpdatePortalInput {
	s.PortalArn = &v
	return s
}

type UpdatePortalOutput struct {
	_ struct{} `type:"structure"`

	// The web portal.
	Portal *Portal `locationName:"portal" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePortalOutput) GoString() string {
	return s.String()
}

// SetPortal sets the Portal field's value.
func (s *UpdatePortalOutput) SetPortal(v *Portal) *UpdatePortalOutput {
	s.Portal = v
	return s
}

type UpdateTrustStoreInput struct {
	_ struct{} `type:"structure"`

	// A list of CA certificates to add to the trust store.
	CertificatesToAdd [][]byte `locationName:"certificatesToAdd" type:"list"`

	// A list of CA certificates to delete from a trust store.
	CertificatesToDelete []*string `locationName:"certificatesToDelete" type:"list"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token return the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the trust store.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `location:"uri" locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrustStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrustStoreInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.TrustStoreArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustStoreArn"))
	}
	if s.TrustStoreArn != nil && len(*s.TrustStoreArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrustStoreArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificatesToAdd sets the CertificatesToAdd field's value.
func (s *UpdateTrustStoreInput) SetCertificatesToAdd(v [][]byte) *UpdateTrustStoreInput {
	s.CertificatesToAdd = v
	return s
}

// SetCertificatesToDelete sets the CertificatesToDelete field's value.
func (s *UpdateTrustStoreInput) SetCertificatesToDelete(v []*string) *UpdateTrustStoreInput {
	s.CertificatesToDelete = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateTrustStoreInput) SetClientToken(v string) *UpdateTrustStoreInput {
	s.ClientToken = &v
	return s
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *UpdateTrustStoreInput) SetTrustStoreArn(v string) *UpdateTrustStoreInput {
	s.TrustStoreArn = &v
	return s
}

type UpdateTrustStoreOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the trust store.
	//
	// TrustStoreArn is a required field
	TrustStoreArn *string `locationName:"trustStoreArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustStoreOutput) GoString() string {
	return s.String()
}

// SetTrustStoreArn sets the TrustStoreArn field's value.
func (s *UpdateTrustStoreOutput) SetTrustStoreArn(v string) *UpdateTrustStoreOutput {
	s.TrustStoreArn = &v
	return s
}

type UpdateUserAccessLoggingSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token return the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the Kinesis stream.
	KinesisStreamArn *string `locationName:"kinesisStreamArn" min:"20" type:"string"`

	// The ARN of the user access logging settings.
	//
	// UserAccessLoggingSettingsArn is a required field
	UserAccessLoggingSettingsArn *string `location:"uri" locationName:"userAccessLoggingSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserAccessLoggingSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserAccessLoggingSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserAccessLoggingSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserAccessLoggingSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.KinesisStreamArn != nil && len(*s.KinesisStreamArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KinesisStreamArn", 20))
	}
	if s.UserAccessLoggingSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAccessLoggingSettingsArn"))
	}
	if s.UserAccessLoggingSettingsArn != nil && len(*s.UserAccessLoggingSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserAccessLoggingSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateUserAccessLoggingSettingsInput) SetClientToken(v string) *UpdateUserAccessLoggingSettingsInput {
	s.ClientToken = &v
	return s
}

// SetKinesisStreamArn sets the KinesisStreamArn field's value.
func (s *UpdateUserAccessLoggingSettingsInput) SetKinesisStreamArn(v string) *UpdateUserAccessLoggingSettingsInput {
	s.KinesisStreamArn = &v
	return s
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *UpdateUserAccessLoggingSettingsInput) SetUserAccessLoggingSettingsArn(v string) *UpdateUserAccessLoggingSettingsInput {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

type UpdateUserAccessLoggingSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The user access logging settings.
	//
	// UserAccessLoggingSettings is a required field
	UserAccessLoggingSettings *UserAccessLoggingSettings `locationName:"userAccessLoggingSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserAccessLoggingSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserAccessLoggingSettingsOutput) GoString() string {
	return s.String()
}

// SetUserAccessLoggingSettings sets the UserAccessLoggingSettings field's value.
func (s *UpdateUserAccessLoggingSettingsOutput) SetUserAccessLoggingSettings(v *UserAccessLoggingSettings) *UpdateUserAccessLoggingSettingsOutput {
	s.UserAccessLoggingSettings = v
	return s
}

type UpdateUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully,
	// subsequent retries with the same client token return the result from the
	// original successful request.
	//
	// If you do not specify a client token, one is automatically generated by the
	// AWS SDK.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Specifies whether the user can copy text from the streaming session to the
	// local device.
	CopyAllowed *string `locationName:"copyAllowed" type:"string" enum:"EnabledType"`

	// The amount of time that a streaming session remains active after users disconnect.
	DisconnectTimeoutInMinutes *int64 `locationName:"disconnectTimeoutInMinutes" min:"1" type:"integer"`

	// Specifies whether the user can download files from the streaming session
	// to the local device.
	DownloadAllowed *string `locationName:"downloadAllowed" type:"string" enum:"EnabledType"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the disconnect timeout interval begins.
	IdleDisconnectTimeoutInMinutes *int64 `locationName:"idleDisconnectTimeoutInMinutes" type:"integer"`

	// Specifies whether the user can paste text from the local device to the streaming
	// session.
	PasteAllowed *string `locationName:"pasteAllowed" type:"string" enum:"EnabledType"`

	// Specifies whether the user can print to the local device.
	PrintAllowed *string `locationName:"printAllowed" type:"string" enum:"EnabledType"`

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	UploadAllowed *string `locationName:"uploadAllowed" type:"string" enum:"EnabledType"`

	// The ARN of the user settings.
	//
	// UserSettingsArn is a required field
	UserSettingsArn *string `location:"uri" locationName:"userSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserSettingsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisconnectTimeoutInMinutes != nil && *s.DisconnectTimeoutInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DisconnectTimeoutInMinutes", 1))
	}
	if s.UserSettingsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserSettingsArn"))
	}
	if s.UserSettingsArn != nil && len(*s.UserSettingsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserSettingsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateUserSettingsInput) SetClientToken(v string) *UpdateUserSettingsInput {
	s.ClientToken = &v
	return s
}

// SetCopyAllowed sets the CopyAllowed field's value.
func (s *UpdateUserSettingsInput) SetCopyAllowed(v string) *UpdateUserSettingsInput {
	s.CopyAllowed = &v
	return s
}

// SetDisconnectTimeoutInMinutes sets the DisconnectTimeoutInMinutes field's value.
func (s *UpdateUserSettingsInput) SetDisconnectTimeoutInMinutes(v int64) *UpdateUserSettingsInput {
	s.DisconnectTimeoutInMinutes = &v
	return s
}

// SetDownloadAllowed sets the DownloadAllowed field's value.
func (s *UpdateUserSettingsInput) SetDownloadAllowed(v string) *UpdateUserSettingsInput {
	s.DownloadAllowed = &v
	return s
}

// SetIdleDisconnectTimeoutInMinutes sets the IdleDisconnectTimeoutInMinutes field's value.
func (s *UpdateUserSettingsInput) SetIdleDisconnectTimeoutInMinutes(v int64) *UpdateUserSettingsInput {
	s.IdleDisconnectTimeoutInMinutes = &v
	return s
}

// SetPasteAllowed sets the PasteAllowed field's value.
func (s *UpdateUserSettingsInput) SetPasteAllowed(v string) *UpdateUserSettingsInput {
	s.PasteAllowed = &v
	return s
}

// SetPrintAllowed sets the PrintAllowed field's value.
func (s *UpdateUserSettingsInput) SetPrintAllowed(v string) *UpdateUserSettingsInput {
	s.PrintAllowed = &v
	return s
}

// SetUploadAllowed sets the UploadAllowed field's value.
func (s *UpdateUserSettingsInput) SetUploadAllowed(v string) *UpdateUserSettingsInput {
	s.UploadAllowed = &v
	return s
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *UpdateUserSettingsInput) SetUserSettingsArn(v string) *UpdateUserSettingsInput {
	s.UserSettingsArn = &v
	return s
}

type UpdateUserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The user settings.
	//
	// UserSettings is a required field
	UserSettings *UserSettings `locationName:"userSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserSettingsOutput) GoString() string {
	return s.String()
}

// SetUserSettings sets the UserSettings field's value.
func (s *UpdateUserSettingsOutput) SetUserSettings(v *UserSettings) *UpdateUserSettingsOutput {
	s.UserSettings = v
	return s
}

// A user access logging settings resource that can be associated with a web
// portal.
type UserAccessLoggingSettings struct {
	_ struct{} `type:"structure"`

	// A list of web portal ARNs that this user access logging settings is associated
	// with.
	AssociatedPortalArns []*string `locationName:"associatedPortalArns" type:"list"`

	// The ARN of the Kinesis stream.
	KinesisStreamArn *string `locationName:"kinesisStreamArn" min:"20" type:"string"`

	// The ARN of the user access logging settings.
	//
	// UserAccessLoggingSettingsArn is a required field
	UserAccessLoggingSettingsArn *string `locationName:"userAccessLoggingSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessLoggingSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessLoggingSettings) GoString() string {
	return s.String()
}

// SetAssociatedPortalArns sets the AssociatedPortalArns field's value.
func (s *UserAccessLoggingSettings) SetAssociatedPortalArns(v []*string) *UserAccessLoggingSettings {
	s.AssociatedPortalArns = v
	return s
}

// SetKinesisStreamArn sets the KinesisStreamArn field's value.
func (s *UserAccessLoggingSettings) SetKinesisStreamArn(v string) *UserAccessLoggingSettings {
	s.KinesisStreamArn = &v
	return s
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *UserAccessLoggingSettings) SetUserAccessLoggingSettingsArn(v string) *UserAccessLoggingSettings {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

// The summary of user access logging settings.
type UserAccessLoggingSettingsSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the Kinesis stream.
	KinesisStreamArn *string `locationName:"kinesisStreamArn" min:"20" type:"string"`

	// The ARN of the user access logging settings.
	UserAccessLoggingSettingsArn *string `locationName:"userAccessLoggingSettingsArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessLoggingSettingsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAccessLoggingSettingsSummary) GoString() string {
	return s.String()
}

// SetKinesisStreamArn sets the KinesisStreamArn field's value.
func (s *UserAccessLoggingSettingsSummary) SetKinesisStreamArn(v string) *UserAccessLoggingSettingsSummary {
	s.KinesisStreamArn = &v
	return s
}

// SetUserAccessLoggingSettingsArn sets the UserAccessLoggingSettingsArn field's value.
func (s *UserAccessLoggingSettingsSummary) SetUserAccessLoggingSettingsArn(v string) *UserAccessLoggingSettingsSummary {
	s.UserAccessLoggingSettingsArn = &v
	return s
}

// A user settings resource that can be associated with a web portal. Once associated
// with a web portal, user settings control how users can transfer data between
// a streaming session and the their local devices.
type UserSettings struct {
	_ struct{} `type:"structure"`

	// A list of web portal ARNs that this user settings is associated with.
	AssociatedPortalArns []*string `locationName:"associatedPortalArns" type:"list"`

	// Specifies whether the user can copy text from the streaming session to the
	// local device.
	CopyAllowed *string `locationName:"copyAllowed" type:"string" enum:"EnabledType"`

	// The amount of time that a streaming session remains active after users disconnect.
	DisconnectTimeoutInMinutes *int64 `locationName:"disconnectTimeoutInMinutes" min:"1" type:"integer"`

	// Specifies whether the user can download files from the streaming session
	// to the local device.
	DownloadAllowed *string `locationName:"downloadAllowed" type:"string" enum:"EnabledType"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the disconnect timeout interval begins.
	IdleDisconnectTimeoutInMinutes *int64 `locationName:"idleDisconnectTimeoutInMinutes" type:"integer"`

	// Specifies whether the user can paste text from the local device to the streaming
	// session.
	PasteAllowed *string `locationName:"pasteAllowed" type:"string" enum:"EnabledType"`

	// Specifies whether the user can print to the local device.
	PrintAllowed *string `locationName:"printAllowed" type:"string" enum:"EnabledType"`

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	UploadAllowed *string `locationName:"uploadAllowed" type:"string" enum:"EnabledType"`

	// The ARN of the user settings.
	//
	// UserSettingsArn is a required field
	UserSettingsArn *string `locationName:"userSettingsArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserSettings) GoString() string {
	return s.String()
}

// SetAssociatedPortalArns sets the AssociatedPortalArns field's value.
func (s *UserSettings) SetAssociatedPortalArns(v []*string) *UserSettings {
	s.AssociatedPortalArns = v
	return s
}

// SetCopyAllowed sets the CopyAllowed field's value.
func (s *UserSettings) SetCopyAllowed(v string) *UserSettings {
	s.CopyAllowed = &v
	return s
}

// SetDisconnectTimeoutInMinutes sets the DisconnectTimeoutInMinutes field's value.
func (s *UserSettings) SetDisconnectTimeoutInMinutes(v int64) *UserSettings {
	s.DisconnectTimeoutInMinutes = &v
	return s
}

// SetDownloadAllowed sets the DownloadAllowed field's value.
func (s *UserSettings) SetDownloadAllowed(v string) *UserSettings {
	s.DownloadAllowed = &v
	return s
}

// SetIdleDisconnectTimeoutInMinutes sets the IdleDisconnectTimeoutInMinutes field's value.
func (s *UserSettings) SetIdleDisconnectTimeoutInMinutes(v int64) *UserSettings {
	s.IdleDisconnectTimeoutInMinutes = &v
	return s
}

// SetPasteAllowed sets the PasteAllowed field's value.
func (s *UserSettings) SetPasteAllowed(v string) *UserSettings {
	s.PasteAllowed = &v
	return s
}

// SetPrintAllowed sets the PrintAllowed field's value.
func (s *UserSettings) SetPrintAllowed(v string) *UserSettings {
	s.PrintAllowed = &v
	return s
}

// SetUploadAllowed sets the UploadAllowed field's value.
func (s *UserSettings) SetUploadAllowed(v string) *UserSettings {
	s.UploadAllowed = &v
	return s
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *UserSettings) SetUserSettingsArn(v string) *UserSettings {
	s.UserSettingsArn = &v
	return s
}

// The summary of user settings.
type UserSettingsSummary struct {
	_ struct{} `type:"structure"`

	// Specifies whether the user can copy text from the streaming session to the
	// local device.
	CopyAllowed *string `locationName:"copyAllowed" type:"string" enum:"EnabledType"`

	// The amount of time that a streaming session remains active after users disconnect.
	DisconnectTimeoutInMinutes *int64 `locationName:"disconnectTimeoutInMinutes" min:"1" type:"integer"`

	// Specifies whether the user can download files from the streaming session
	// to the local device.
	DownloadAllowed *string `locationName:"downloadAllowed" type:"string" enum:"EnabledType"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the disconnect timeout interval begins.
	IdleDisconnectTimeoutInMinutes *int64 `locationName:"idleDisconnectTimeoutInMinutes" type:"integer"`

	// Specifies whether the user can paste text from the local device to the streaming
	// session.
	PasteAllowed *string `locationName:"pasteAllowed" type:"string" enum:"EnabledType"`

	// Specifies whether the user can print to the local device.
	PrintAllowed *string `locationName:"printAllowed" type:"string" enum:"EnabledType"`

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	UploadAllowed *string `locationName:"uploadAllowed" type:"string" enum:"EnabledType"`

	// The ARN of the user settings.
	UserSettingsArn *string `locationName:"userSettingsArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserSettingsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserSettingsSummary) GoString() string {
	return s.String()
}

// SetCopyAllowed sets the CopyAllowed field's value.
func (s *UserSettingsSummary) SetCopyAllowed(v string) *UserSettingsSummary {
	s.CopyAllowed = &v
	return s
}

// SetDisconnectTimeoutInMinutes sets the DisconnectTimeoutInMinutes field's value.
func (s *UserSettingsSummary) SetDisconnectTimeoutInMinutes(v int64) *UserSettingsSummary {
	s.DisconnectTimeoutInMinutes = &v
	return s
}

// SetDownloadAllowed sets the DownloadAllowed field's value.
func (s *UserSettingsSummary) SetDownloadAllowed(v string) *UserSettingsSummary {
	s.DownloadAllowed = &v
	return s
}

// SetIdleDisconnectTimeoutInMinutes sets the IdleDisconnectTimeoutInMinutes field's value.
func (s *UserSettingsSummary) SetIdleDisconnectTimeoutInMinutes(v int64) *UserSettingsSummary {
	s.IdleDisconnectTimeoutInMinutes = &v
	return s
}

// SetPasteAllowed sets the PasteAllowed field's value.
func (s *UserSettingsSummary) SetPasteAllowed(v string) *UserSettingsSummary {
	s.PasteAllowed = &v
	return s
}

// SetPrintAllowed sets the PrintAllowed field's value.
func (s *UserSettingsSummary) SetPrintAllowed(v string) *UserSettingsSummary {
	s.PrintAllowed = &v
	return s
}

// SetUploadAllowed sets the UploadAllowed field's value.
func (s *UserSettingsSummary) SetUploadAllowed(v string) *UserSettingsSummary {
	s.UploadAllowed = &v
	return s
}

// SetUserSettingsArn sets the UserSettingsArn field's value.
func (s *UserSettingsSummary) SetUserSettingsArn(v string) *UserSettingsSummary {
	s.UserSettingsArn = &v
	return s
}

// There is a validation error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field that caused the error.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// Reason the request failed validation
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a field passed inside a request that resulted in an exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message describing why the field failed validation.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the field that failed validation.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AuthenticationTypeStandard is a AuthenticationType enum value
	AuthenticationTypeStandard = "Standard"

	// AuthenticationTypeIamIdentityCenter is a AuthenticationType enum value
	AuthenticationTypeIamIdentityCenter = "IAM_Identity_Center"
)

// AuthenticationType_Values returns all elements of the AuthenticationType enum
func AuthenticationType_Values() []string {
	return []string{
		AuthenticationTypeStandard,
		AuthenticationTypeIamIdentityCenter,
	}
}

const (
	// BrowserTypeChrome is a BrowserType enum value
	BrowserTypeChrome = "Chrome"
)

// BrowserType_Values returns all elements of the BrowserType enum
func BrowserType_Values() []string {
	return []string{
		BrowserTypeChrome,
	}
}

const (
	// EnabledTypeDisabled is a EnabledType enum value
	EnabledTypeDisabled = "Disabled"

	// EnabledTypeEnabled is a EnabledType enum value
	EnabledTypeEnabled = "Enabled"
)

// EnabledType_Values returns all elements of the EnabledType enum
func EnabledType_Values() []string {
	return []string{
		EnabledTypeDisabled,
		EnabledTypeEnabled,
	}
}

const (
	// IdentityProviderTypeSaml is a IdentityProviderType enum value
	IdentityProviderTypeSaml = "SAML"

	// IdentityProviderTypeFacebook is a IdentityProviderType enum value
	IdentityProviderTypeFacebook = "Facebook"

	// IdentityProviderTypeGoogle is a IdentityProviderType enum value
	IdentityProviderTypeGoogle = "Google"

	// IdentityProviderTypeLoginWithAmazon is a IdentityProviderType enum value
	IdentityProviderTypeLoginWithAmazon = "LoginWithAmazon"

	// IdentityProviderTypeSignInWithApple is a IdentityProviderType enum value
	IdentityProviderTypeSignInWithApple = "SignInWithApple"

	// IdentityProviderTypeOidc is a IdentityProviderType enum value
	IdentityProviderTypeOidc = "OIDC"
)

// IdentityProviderType_Values returns all elements of the IdentityProviderType enum
func IdentityProviderType_Values() []string {
	return []string{
		IdentityProviderTypeSaml,
		IdentityProviderTypeFacebook,
		IdentityProviderTypeGoogle,
		IdentityProviderTypeLoginWithAmazon,
		IdentityProviderTypeSignInWithApple,
		IdentityProviderTypeOidc,
	}
}

const (
	// PortalStatusIncomplete is a PortalStatus enum value
	PortalStatusIncomplete = "Incomplete"

	// PortalStatusPending is a PortalStatus enum value
	PortalStatusPending = "Pending"

	// PortalStatusActive is a PortalStatus enum value
	PortalStatusActive = "Active"
)

// PortalStatus_Values returns all elements of the PortalStatus enum
func PortalStatus_Values() []string {
	return []string{
		PortalStatusIncomplete,
		PortalStatusPending,
		PortalStatusActive,
	}
}

const (
	// RendererTypeAppStream is a RendererType enum value
	RendererTypeAppStream = "AppStream"
)

// RendererType_Values returns all elements of the RendererType enum
func RendererType_Values() []string {
	return []string{
		RendererTypeAppStream,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
