// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateAdminAccount = "AssociateAdminAccount"

// AssociateAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAdminAccount for more information on using the AssociateAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateAdminAccountRequest method.
//	req, resp := client.AssociateAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount
func (c *FMS) AssociateAdminAccountRequest(input *AssociateAdminAccountInput) (req *request.Request, output *AssociateAdminAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateAdminAccountInput{}
	}

	output = &AssociateAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateAdminAccount API operation for Firewall Management Service.
//
// Sets a Firewall Manager default administrator account. The Firewall Manager
// default administrator account can manage third-party firewalls and has full
// administrative scope that allows administration of all policy types, accounts,
// organizational units, and Regions. This account must be a member account
// of the organization in Organizations whose resources you want to protect.
//
// For information about working with Firewall Manager administrator accounts,
// see Managing Firewall Manager administrators (https://docs.aws.amazon.com/organizations/latest/userguide/fms-administrators.html)
// in the Firewall Manager Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation AssociateAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount
func (c *FMS) AssociateAdminAccount(input *AssociateAdminAccountInput) (*AssociateAdminAccountOutput, error) {
	req, out := c.AssociateAdminAccountRequest(input)
	return out, req.Send()
}

// AssociateAdminAccountWithContext is the same as AssociateAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) AssociateAdminAccountWithContext(ctx aws.Context, input *AssociateAdminAccountInput, opts ...request.Option) (*AssociateAdminAccountOutput, error) {
	req, out := c.AssociateAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateThirdPartyFirewall = "AssociateThirdPartyFirewall"

// AssociateThirdPartyFirewallRequest generates a "aws/request.Request" representing the
// client's request for the AssociateThirdPartyFirewall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateThirdPartyFirewall for more information on using the AssociateThirdPartyFirewall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateThirdPartyFirewallRequest method.
//	req, resp := client.AssociateThirdPartyFirewallRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateThirdPartyFirewall
func (c *FMS) AssociateThirdPartyFirewallRequest(input *AssociateThirdPartyFirewallInput) (req *request.Request, output *AssociateThirdPartyFirewallOutput) {
	op := &request.Operation{
		Name:       opAssociateThirdPartyFirewall,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateThirdPartyFirewallInput{}
	}

	output = &AssociateThirdPartyFirewallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateThirdPartyFirewall API operation for Firewall Management Service.
//
// Sets the Firewall Manager policy administrator as a tenant administrator
// of a third-party firewall service. A tenant is an instance of the third-party
// firewall service that's associated with your Amazon Web Services customer
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation AssociateThirdPartyFirewall for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateThirdPartyFirewall
func (c *FMS) AssociateThirdPartyFirewall(input *AssociateThirdPartyFirewallInput) (*AssociateThirdPartyFirewallOutput, error) {
	req, out := c.AssociateThirdPartyFirewallRequest(input)
	return out, req.Send()
}

// AssociateThirdPartyFirewallWithContext is the same as AssociateThirdPartyFirewall with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateThirdPartyFirewall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) AssociateThirdPartyFirewallWithContext(ctx aws.Context, input *AssociateThirdPartyFirewallInput, opts ...request.Option) (*AssociateThirdPartyFirewallOutput, error) {
	req, out := c.AssociateThirdPartyFirewallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAssociateResource = "BatchAssociateResource"

// BatchAssociateResourceRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateResource for more information on using the BatchAssociateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchAssociateResourceRequest method.
//	req, resp := client.BatchAssociateResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/BatchAssociateResource
func (c *FMS) BatchAssociateResourceRequest(input *BatchAssociateResourceInput) (req *request.Request, output *BatchAssociateResourceOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchAssociateResourceInput{}
	}

	output = &BatchAssociateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchAssociateResource API operation for Firewall Management Service.
//
// Associate resources to a Firewall Manager resource set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation BatchAssociateResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/BatchAssociateResource
func (c *FMS) BatchAssociateResource(input *BatchAssociateResourceInput) (*BatchAssociateResourceOutput, error) {
	req, out := c.BatchAssociateResourceRequest(input)
	return out, req.Send()
}

// BatchAssociateResourceWithContext is the same as BatchAssociateResource with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) BatchAssociateResourceWithContext(ctx aws.Context, input *BatchAssociateResourceInput, opts ...request.Option) (*BatchAssociateResourceOutput, error) {
	req, out := c.BatchAssociateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateResource = "BatchDisassociateResource"

// BatchDisassociateResourceRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateResource for more information on using the BatchDisassociateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDisassociateResourceRequest method.
//	req, resp := client.BatchDisassociateResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/BatchDisassociateResource
func (c *FMS) BatchDisassociateResourceRequest(input *BatchDisassociateResourceInput) (req *request.Request, output *BatchDisassociateResourceOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDisassociateResourceInput{}
	}

	output = &BatchDisassociateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisassociateResource API operation for Firewall Management Service.
//
// Disassociates resources from a Firewall Manager resource set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation BatchDisassociateResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/BatchDisassociateResource
func (c *FMS) BatchDisassociateResource(input *BatchDisassociateResourceInput) (*BatchDisassociateResourceOutput, error) {
	req, out := c.BatchDisassociateResourceRequest(input)
	return out, req.Send()
}

// BatchDisassociateResourceWithContext is the same as BatchDisassociateResource with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) BatchDisassociateResourceWithContext(ctx aws.Context, input *BatchDisassociateResourceInput, opts ...request.Option) (*BatchDisassociateResourceOutput, error) {
	req, out := c.BatchDisassociateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppsList = "DeleteAppsList"

// DeleteAppsListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppsList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppsList for more information on using the DeleteAppsList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppsListRequest method.
//	req, resp := client.DeleteAppsListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteAppsList
func (c *FMS) DeleteAppsListRequest(input *DeleteAppsListInput) (req *request.Request, output *DeleteAppsListOutput) {
	op := &request.Operation{
		Name:       opDeleteAppsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppsListInput{}
	}

	output = &DeleteAppsListOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppsList API operation for Firewall Management Service.
//
// Permanently deletes an Firewall Manager applications list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DeleteAppsList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteAppsList
func (c *FMS) DeleteAppsList(input *DeleteAppsListInput) (*DeleteAppsListOutput, error) {
	req, out := c.DeleteAppsListRequest(input)
	return out, req.Send()
}

// DeleteAppsListWithContext is the same as DeleteAppsList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppsList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DeleteAppsListWithContext(ctx aws.Context, input *DeleteAppsListInput, opts ...request.Option) (*DeleteAppsListOutput, error) {
	req, out := c.DeleteAppsListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotificationChannel = "DeleteNotificationChannel"

// DeleteNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotificationChannel for more information on using the DeleteNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNotificationChannelRequest method.
//	req, resp := client.DeleteNotificationChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel
func (c *FMS) DeleteNotificationChannelRequest(input *DeleteNotificationChannelInput) (req *request.Request, output *DeleteNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationChannelInput{}
	}

	output = &DeleteNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotificationChannel API operation for Firewall Management Service.
//
// Deletes an Firewall Manager association with the IAM role and the Amazon
// Simple Notification Service (SNS) topic that is used to record Firewall Manager
// SNS logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DeleteNotificationChannel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel
func (c *FMS) DeleteNotificationChannel(input *DeleteNotificationChannelInput) (*DeleteNotificationChannelOutput, error) {
	req, out := c.DeleteNotificationChannelRequest(input)
	return out, req.Send()
}

// DeleteNotificationChannelWithContext is the same as DeleteNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DeleteNotificationChannelWithContext(ctx aws.Context, input *DeleteNotificationChannelInput, opts ...request.Option) (*DeleteNotificationChannelOutput, error) {
	req, out := c.DeleteNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePolicyRequest method.
//	req, resp := client.DeletePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy
func (c *FMS) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for Firewall Management Service.
//
// Permanently deletes an Firewall Manager policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy
func (c *FMS) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProtocolsList = "DeleteProtocolsList"

// DeleteProtocolsListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProtocolsList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProtocolsList for more information on using the DeleteProtocolsList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProtocolsListRequest method.
//	req, resp := client.DeleteProtocolsListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteProtocolsList
func (c *FMS) DeleteProtocolsListRequest(input *DeleteProtocolsListInput) (req *request.Request, output *DeleteProtocolsListOutput) {
	op := &request.Operation{
		Name:       opDeleteProtocolsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProtocolsListInput{}
	}

	output = &DeleteProtocolsListOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProtocolsList API operation for Firewall Management Service.
//
// Permanently deletes an Firewall Manager protocols list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DeleteProtocolsList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteProtocolsList
func (c *FMS) DeleteProtocolsList(input *DeleteProtocolsListInput) (*DeleteProtocolsListOutput, error) {
	req, out := c.DeleteProtocolsListRequest(input)
	return out, req.Send()
}

// DeleteProtocolsListWithContext is the same as DeleteProtocolsList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProtocolsList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DeleteProtocolsListWithContext(ctx aws.Context, input *DeleteProtocolsListInput, opts ...request.Option) (*DeleteProtocolsListOutput, error) {
	req, out := c.DeleteProtocolsListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceSet = "DeleteResourceSet"

// DeleteResourceSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceSet for more information on using the DeleteResourceSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourceSetRequest method.
//	req, resp := client.DeleteResourceSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteResourceSet
func (c *FMS) DeleteResourceSetRequest(input *DeleteResourceSetInput) (req *request.Request, output *DeleteResourceSetOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceSetInput{}
	}

	output = &DeleteResourceSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceSet API operation for Firewall Management Service.
//
// Deletes the specified ResourceSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DeleteResourceSet for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteResourceSet
func (c *FMS) DeleteResourceSet(input *DeleteResourceSetInput) (*DeleteResourceSetOutput, error) {
	req, out := c.DeleteResourceSetRequest(input)
	return out, req.Send()
}

// DeleteResourceSetWithContext is the same as DeleteResourceSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DeleteResourceSetWithContext(ctx aws.Context, input *DeleteResourceSetInput, opts ...request.Option) (*DeleteResourceSetOutput, error) {
	req, out := c.DeleteResourceSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAdminAccount = "DisassociateAdminAccount"

// DisassociateAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAdminAccount for more information on using the DisassociateAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateAdminAccountRequest method.
//	req, resp := client.DisassociateAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount
func (c *FMS) DisassociateAdminAccountRequest(input *DisassociateAdminAccountInput) (req *request.Request, output *DisassociateAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateAdminAccountInput{}
	}

	output = &DisassociateAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAdminAccount API operation for Firewall Management Service.
//
// Disassociates an Firewall Manager administrator account. To set a different
// account as an Firewall Manager administrator, submit a PutAdminAccount request.
// To set an account as a default administrator account, you must submit an
// AssociateAdminAccount request.
//
// Disassociation of the default administrator account follows the first in,
// last out principle. If you are the default administrator, all Firewall Manager
// administrators within the organization must first disassociate their accounts
// before you can disassociate your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DisassociateAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount
func (c *FMS) DisassociateAdminAccount(input *DisassociateAdminAccountInput) (*DisassociateAdminAccountOutput, error) {
	req, out := c.DisassociateAdminAccountRequest(input)
	return out, req.Send()
}

// DisassociateAdminAccountWithContext is the same as DisassociateAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DisassociateAdminAccountWithContext(ctx aws.Context, input *DisassociateAdminAccountInput, opts ...request.Option) (*DisassociateAdminAccountOutput, error) {
	req, out := c.DisassociateAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateThirdPartyFirewall = "DisassociateThirdPartyFirewall"

// DisassociateThirdPartyFirewallRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateThirdPartyFirewall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateThirdPartyFirewall for more information on using the DisassociateThirdPartyFirewall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateThirdPartyFirewallRequest method.
//	req, resp := client.DisassociateThirdPartyFirewallRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateThirdPartyFirewall
func (c *FMS) DisassociateThirdPartyFirewallRequest(input *DisassociateThirdPartyFirewallInput) (req *request.Request, output *DisassociateThirdPartyFirewallOutput) {
	op := &request.Operation{
		Name:       opDisassociateThirdPartyFirewall,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateThirdPartyFirewallInput{}
	}

	output = &DisassociateThirdPartyFirewallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateThirdPartyFirewall API operation for Firewall Management Service.
//
// Disassociates a Firewall Manager policy administrator from a third-party
// firewall tenant. When you call DisassociateThirdPartyFirewall, the third-party
// firewall vendor deletes all of the firewalls that are associated with the
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DisassociateThirdPartyFirewall for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateThirdPartyFirewall
func (c *FMS) DisassociateThirdPartyFirewall(input *DisassociateThirdPartyFirewallInput) (*DisassociateThirdPartyFirewallOutput, error) {
	req, out := c.DisassociateThirdPartyFirewallRequest(input)
	return out, req.Send()
}

// DisassociateThirdPartyFirewallWithContext is the same as DisassociateThirdPartyFirewall with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateThirdPartyFirewall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DisassociateThirdPartyFirewallWithContext(ctx aws.Context, input *DisassociateThirdPartyFirewallInput, opts ...request.Option) (*DisassociateThirdPartyFirewallOutput, error) {
	req, out := c.DisassociateThirdPartyFirewallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdminAccount = "GetAdminAccount"

// GetAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdminAccount for more information on using the GetAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAdminAccountRequest method.
//	req, resp := client.GetAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount
func (c *FMS) GetAdminAccountRequest(input *GetAdminAccountInput) (req *request.Request, output *GetAdminAccountOutput) {
	op := &request.Operation{
		Name:       opGetAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAdminAccountInput{}
	}

	output = &GetAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdminAccount API operation for Firewall Management Service.
//
// Returns the Organizations account that is associated with Firewall Manager
// as the Firewall Manager default administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount
func (c *FMS) GetAdminAccount(input *GetAdminAccountInput) (*GetAdminAccountOutput, error) {
	req, out := c.GetAdminAccountRequest(input)
	return out, req.Send()
}

// GetAdminAccountWithContext is the same as GetAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetAdminAccountWithContext(ctx aws.Context, input *GetAdminAccountInput, opts ...request.Option) (*GetAdminAccountOutput, error) {
	req, out := c.GetAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdminScope = "GetAdminScope"

// GetAdminScopeRequest generates a "aws/request.Request" representing the
// client's request for the GetAdminScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdminScope for more information on using the GetAdminScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAdminScopeRequest method.
//	req, resp := client.GetAdminScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminScope
func (c *FMS) GetAdminScopeRequest(input *GetAdminScopeInput) (req *request.Request, output *GetAdminScopeOutput) {
	op := &request.Operation{
		Name:       opGetAdminScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAdminScopeInput{}
	}

	output = &GetAdminScopeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdminScope API operation for Firewall Management Service.
//
// Returns information about the specified account's administrative scope. The
// admistrative scope defines the resources that an Firewall Manager administrator
// can manage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetAdminScope for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminScope
func (c *FMS) GetAdminScope(input *GetAdminScopeInput) (*GetAdminScopeOutput, error) {
	req, out := c.GetAdminScopeRequest(input)
	return out, req.Send()
}

// GetAdminScopeWithContext is the same as GetAdminScope with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdminScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetAdminScopeWithContext(ctx aws.Context, input *GetAdminScopeInput, opts ...request.Option) (*GetAdminScopeOutput, error) {
	req, out := c.GetAdminScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppsList = "GetAppsList"

// GetAppsListRequest generates a "aws/request.Request" representing the
// client's request for the GetAppsList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppsList for more information on using the GetAppsList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAppsListRequest method.
//	req, resp := client.GetAppsListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAppsList
func (c *FMS) GetAppsListRequest(input *GetAppsListInput) (req *request.Request, output *GetAppsListOutput) {
	op := &request.Operation{
		Name:       opGetAppsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppsListInput{}
	}

	output = &GetAppsListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppsList API operation for Firewall Management Service.
//
// Returns information about the specified Firewall Manager applications list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetAppsList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAppsList
func (c *FMS) GetAppsList(input *GetAppsListInput) (*GetAppsListOutput, error) {
	req, out := c.GetAppsListRequest(input)
	return out, req.Send()
}

// GetAppsListWithContext is the same as GetAppsList with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppsList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetAppsListWithContext(ctx aws.Context, input *GetAppsListInput, opts ...request.Option) (*GetAppsListOutput, error) {
	req, out := c.GetAppsListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceDetail = "GetComplianceDetail"

// GetComplianceDetailRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetail for more information on using the GetComplianceDetail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComplianceDetailRequest method.
//	req, resp := client.GetComplianceDetailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail
func (c *FMS) GetComplianceDetailRequest(input *GetComplianceDetailInput) (req *request.Request, output *GetComplianceDetailOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailInput{}
	}

	output = &GetComplianceDetailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetail API operation for Firewall Management Service.
//
// Returns detailed compliance information about the specified member account.
// Details include resources that are in and out of compliance with the specified
// policy.
//
//   - Resources are considered noncompliant for WAF and Shield Advanced policies
//     if the specified policy has not been applied to them.
//
//   - Resources are considered noncompliant for security group policies if
//     they are in scope of the policy, they violate one or more of the policy
//     rules, and remediation is disabled or not possible.
//
//   - Resources are considered noncompliant for Network Firewall policies
//     if a firewall is missing in the VPC, if the firewall endpoint isn't set
//     up in an expected Availability Zone and subnet, if a subnet created by
//     the Firewall Manager doesn't have the expected route table, and for modifications
//     to a firewall policy that violate the Firewall Manager policy's rules.
//
//   - Resources are considered noncompliant for DNS Firewall policies if a
//     DNS Firewall rule group is missing from the rule group associations for
//     the VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetComplianceDetail for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail
func (c *FMS) GetComplianceDetail(input *GetComplianceDetailInput) (*GetComplianceDetailOutput, error) {
	req, out := c.GetComplianceDetailRequest(input)
	return out, req.Send()
}

// GetComplianceDetailWithContext is the same as GetComplianceDetail with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetComplianceDetailWithContext(ctx aws.Context, input *GetComplianceDetailInput, opts ...request.Option) (*GetComplianceDetailOutput, error) {
	req, out := c.GetComplianceDetailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNotificationChannel = "GetNotificationChannel"

// GetNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNotificationChannel for more information on using the GetNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetNotificationChannelRequest method.
//	req, resp := client.GetNotificationChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel
func (c *FMS) GetNotificationChannelRequest(input *GetNotificationChannelInput) (req *request.Request, output *GetNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opGetNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNotificationChannelInput{}
	}

	output = &GetNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNotificationChannel API operation for Firewall Management Service.
//
// Information about the Amazon Simple Notification Service (SNS) topic that
// is used to record Firewall Manager SNS logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetNotificationChannel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel
func (c *FMS) GetNotificationChannel(input *GetNotificationChannelInput) (*GetNotificationChannelOutput, error) {
	req, out := c.GetNotificationChannelRequest(input)
	return out, req.Send()
}

// GetNotificationChannelWithContext is the same as GetNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetNotificationChannelWithContext(ctx aws.Context, input *GetNotificationChannelInput, opts ...request.Option) (*GetNotificationChannelOutput, error) {
	req, out := c.GetNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPolicyRequest method.
//	req, resp := client.GetPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy
func (c *FMS) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for Firewall Management Service.
//
// Returns information about the specified Firewall Manager policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidTypeException
//     The value of the Type parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy
func (c *FMS) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProtectionStatus = "GetProtectionStatus"

// GetProtectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetProtectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProtectionStatus for more information on using the GetProtectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProtectionStatusRequest method.
//	req, resp := client.GetProtectionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus
func (c *FMS) GetProtectionStatusRequest(input *GetProtectionStatusInput) (req *request.Request, output *GetProtectionStatusOutput) {
	op := &request.Operation{
		Name:       opGetProtectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProtectionStatusInput{}
	}

	output = &GetProtectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProtectionStatus API operation for Firewall Management Service.
//
// If you created a Shield Advanced policy, returns policy-level attack summary
// information in the event of a potential DDoS attack. Other policy types are
// currently unsupported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetProtectionStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus
func (c *FMS) GetProtectionStatus(input *GetProtectionStatusInput) (*GetProtectionStatusOutput, error) {
	req, out := c.GetProtectionStatusRequest(input)
	return out, req.Send()
}

// GetProtectionStatusWithContext is the same as GetProtectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetProtectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetProtectionStatusWithContext(ctx aws.Context, input *GetProtectionStatusInput, opts ...request.Option) (*GetProtectionStatusOutput, error) {
	req, out := c.GetProtectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProtocolsList = "GetProtocolsList"

// GetProtocolsListRequest generates a "aws/request.Request" representing the
// client's request for the GetProtocolsList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProtocolsList for more information on using the GetProtocolsList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProtocolsListRequest method.
//	req, resp := client.GetProtocolsListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtocolsList
func (c *FMS) GetProtocolsListRequest(input *GetProtocolsListInput) (req *request.Request, output *GetProtocolsListOutput) {
	op := &request.Operation{
		Name:       opGetProtocolsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProtocolsListInput{}
	}

	output = &GetProtocolsListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProtocolsList API operation for Firewall Management Service.
//
// Returns information about the specified Firewall Manager protocols list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetProtocolsList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtocolsList
func (c *FMS) GetProtocolsList(input *GetProtocolsListInput) (*GetProtocolsListOutput, error) {
	req, out := c.GetProtocolsListRequest(input)
	return out, req.Send()
}

// GetProtocolsListWithContext is the same as GetProtocolsList with the addition of
// the ability to pass a context and additional request options.
//
// See GetProtocolsList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetProtocolsListWithContext(ctx aws.Context, input *GetProtocolsListInput, opts ...request.Option) (*GetProtocolsListOutput, error) {
	req, out := c.GetProtocolsListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceSet = "GetResourceSet"

// GetResourceSetRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceSet for more information on using the GetResourceSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceSetRequest method.
//	req, resp := client.GetResourceSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetResourceSet
func (c *FMS) GetResourceSetRequest(input *GetResourceSetInput) (req *request.Request, output *GetResourceSetOutput) {
	op := &request.Operation{
		Name:       opGetResourceSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceSetInput{}
	}

	output = &GetResourceSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceSet API operation for Firewall Management Service.
//
// Gets information about a specific resource set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetResourceSet for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetResourceSet
func (c *FMS) GetResourceSet(input *GetResourceSetInput) (*GetResourceSetOutput, error) {
	req, out := c.GetResourceSetRequest(input)
	return out, req.Send()
}

// GetResourceSetWithContext is the same as GetResourceSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetResourceSetWithContext(ctx aws.Context, input *GetResourceSetInput, opts ...request.Option) (*GetResourceSetOutput, error) {
	req, out := c.GetResourceSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetThirdPartyFirewallAssociationStatus = "GetThirdPartyFirewallAssociationStatus"

// GetThirdPartyFirewallAssociationStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetThirdPartyFirewallAssociationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetThirdPartyFirewallAssociationStatus for more information on using the GetThirdPartyFirewallAssociationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetThirdPartyFirewallAssociationStatusRequest method.
//	req, resp := client.GetThirdPartyFirewallAssociationStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetThirdPartyFirewallAssociationStatus
func (c *FMS) GetThirdPartyFirewallAssociationStatusRequest(input *GetThirdPartyFirewallAssociationStatusInput) (req *request.Request, output *GetThirdPartyFirewallAssociationStatusOutput) {
	op := &request.Operation{
		Name:       opGetThirdPartyFirewallAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetThirdPartyFirewallAssociationStatusInput{}
	}

	output = &GetThirdPartyFirewallAssociationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetThirdPartyFirewallAssociationStatus API operation for Firewall Management Service.
//
// The onboarding status of a Firewall Manager admin account to third-party
// firewall vendor tenant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetThirdPartyFirewallAssociationStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetThirdPartyFirewallAssociationStatus
func (c *FMS) GetThirdPartyFirewallAssociationStatus(input *GetThirdPartyFirewallAssociationStatusInput) (*GetThirdPartyFirewallAssociationStatusOutput, error) {
	req, out := c.GetThirdPartyFirewallAssociationStatusRequest(input)
	return out, req.Send()
}

// GetThirdPartyFirewallAssociationStatusWithContext is the same as GetThirdPartyFirewallAssociationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetThirdPartyFirewallAssociationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetThirdPartyFirewallAssociationStatusWithContext(ctx aws.Context, input *GetThirdPartyFirewallAssociationStatusInput, opts ...request.Option) (*GetThirdPartyFirewallAssociationStatusOutput, error) {
	req, out := c.GetThirdPartyFirewallAssociationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetViolationDetails = "GetViolationDetails"

// GetViolationDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetViolationDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetViolationDetails for more information on using the GetViolationDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetViolationDetailsRequest method.
//	req, resp := client.GetViolationDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetViolationDetails
func (c *FMS) GetViolationDetailsRequest(input *GetViolationDetailsInput) (req *request.Request, output *GetViolationDetailsOutput) {
	op := &request.Operation{
		Name:       opGetViolationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetViolationDetailsInput{}
	}

	output = &GetViolationDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetViolationDetails API operation for Firewall Management Service.
//
// Retrieves violations for a resource based on the specified Firewall Manager
// policy and Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetViolationDetails for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetViolationDetails
func (c *FMS) GetViolationDetails(input *GetViolationDetailsInput) (*GetViolationDetailsOutput, error) {
	req, out := c.GetViolationDetailsRequest(input)
	return out, req.Send()
}

// GetViolationDetailsWithContext is the same as GetViolationDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetViolationDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetViolationDetailsWithContext(ctx aws.Context, input *GetViolationDetailsInput, opts ...request.Option) (*GetViolationDetailsOutput, error) {
	req, out := c.GetViolationDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAdminAccountsForOrganization = "ListAdminAccountsForOrganization"

// ListAdminAccountsForOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the ListAdminAccountsForOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAdminAccountsForOrganization for more information on using the ListAdminAccountsForOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAdminAccountsForOrganizationRequest method.
//	req, resp := client.ListAdminAccountsForOrganizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAdminAccountsForOrganization
func (c *FMS) ListAdminAccountsForOrganizationRequest(input *ListAdminAccountsForOrganizationInput) (req *request.Request, output *ListAdminAccountsForOrganizationOutput) {
	op := &request.Operation{
		Name:       opListAdminAccountsForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAdminAccountsForOrganizationInput{}
	}

	output = &ListAdminAccountsForOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAdminAccountsForOrganization API operation for Firewall Management Service.
//
// Returns a AdminAccounts object that lists the Firewall Manager administrators
// within the organization that are onboarded to Firewall Manager by AssociateAdminAccount.
//
// This operation can be called only from the organization's management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListAdminAccountsForOrganization for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAdminAccountsForOrganization
func (c *FMS) ListAdminAccountsForOrganization(input *ListAdminAccountsForOrganizationInput) (*ListAdminAccountsForOrganizationOutput, error) {
	req, out := c.ListAdminAccountsForOrganizationRequest(input)
	return out, req.Send()
}

// ListAdminAccountsForOrganizationWithContext is the same as ListAdminAccountsForOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See ListAdminAccountsForOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListAdminAccountsForOrganizationWithContext(ctx aws.Context, input *ListAdminAccountsForOrganizationInput, opts ...request.Option) (*ListAdminAccountsForOrganizationOutput, error) {
	req, out := c.ListAdminAccountsForOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAdminAccountsForOrganizationPages iterates over the pages of a ListAdminAccountsForOrganization operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAdminAccountsForOrganization method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAdminAccountsForOrganization operation.
//	pageNum := 0
//	err := client.ListAdminAccountsForOrganizationPages(params,
//	    func(page *fms.ListAdminAccountsForOrganizationOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListAdminAccountsForOrganizationPages(input *ListAdminAccountsForOrganizationInput, fn func(*ListAdminAccountsForOrganizationOutput, bool) bool) error {
	return c.ListAdminAccountsForOrganizationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAdminAccountsForOrganizationPagesWithContext same as ListAdminAccountsForOrganizationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListAdminAccountsForOrganizationPagesWithContext(ctx aws.Context, input *ListAdminAccountsForOrganizationInput, fn func(*ListAdminAccountsForOrganizationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAdminAccountsForOrganizationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAdminAccountsForOrganizationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAdminAccountsForOrganizationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAdminsManagingAccount = "ListAdminsManagingAccount"

// ListAdminsManagingAccountRequest generates a "aws/request.Request" representing the
// client's request for the ListAdminsManagingAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAdminsManagingAccount for more information on using the ListAdminsManagingAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAdminsManagingAccountRequest method.
//	req, resp := client.ListAdminsManagingAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAdminsManagingAccount
func (c *FMS) ListAdminsManagingAccountRequest(input *ListAdminsManagingAccountInput) (req *request.Request, output *ListAdminsManagingAccountOutput) {
	op := &request.Operation{
		Name:       opListAdminsManagingAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAdminsManagingAccountInput{}
	}

	output = &ListAdminsManagingAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAdminsManagingAccount API operation for Firewall Management Service.
//
// Lists the accounts that are managing the specified Organizations member account.
// This is useful for any member account so that they can view the accounts
// who are managing their account. This operation only returns the managing
// administrators that have the requested account within their AdminScope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListAdminsManagingAccount for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAdminsManagingAccount
func (c *FMS) ListAdminsManagingAccount(input *ListAdminsManagingAccountInput) (*ListAdminsManagingAccountOutput, error) {
	req, out := c.ListAdminsManagingAccountRequest(input)
	return out, req.Send()
}

// ListAdminsManagingAccountWithContext is the same as ListAdminsManagingAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ListAdminsManagingAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListAdminsManagingAccountWithContext(ctx aws.Context, input *ListAdminsManagingAccountInput, opts ...request.Option) (*ListAdminsManagingAccountOutput, error) {
	req, out := c.ListAdminsManagingAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAdminsManagingAccountPages iterates over the pages of a ListAdminsManagingAccount operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAdminsManagingAccount method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAdminsManagingAccount operation.
//	pageNum := 0
//	err := client.ListAdminsManagingAccountPages(params,
//	    func(page *fms.ListAdminsManagingAccountOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListAdminsManagingAccountPages(input *ListAdminsManagingAccountInput, fn func(*ListAdminsManagingAccountOutput, bool) bool) error {
	return c.ListAdminsManagingAccountPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAdminsManagingAccountPagesWithContext same as ListAdminsManagingAccountPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListAdminsManagingAccountPagesWithContext(ctx aws.Context, input *ListAdminsManagingAccountInput, fn func(*ListAdminsManagingAccountOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAdminsManagingAccountInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAdminsManagingAccountRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAdminsManagingAccountOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppsLists = "ListAppsLists"

// ListAppsListsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppsLists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppsLists for more information on using the ListAppsLists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppsListsRequest method.
//	req, resp := client.ListAppsListsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAppsLists
func (c *FMS) ListAppsListsRequest(input *ListAppsListsInput) (req *request.Request, output *ListAppsListsOutput) {
	op := &request.Operation{
		Name:       opListAppsLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppsListsInput{}
	}

	output = &ListAppsListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppsLists API operation for Firewall Management Service.
//
// Returns an array of AppsListDataSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListAppsLists for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListAppsLists
func (c *FMS) ListAppsLists(input *ListAppsListsInput) (*ListAppsListsOutput, error) {
	req, out := c.ListAppsListsRequest(input)
	return out, req.Send()
}

// ListAppsListsWithContext is the same as ListAppsLists with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppsLists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListAppsListsWithContext(ctx aws.Context, input *ListAppsListsInput, opts ...request.Option) (*ListAppsListsOutput, error) {
	req, out := c.ListAppsListsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppsListsPages iterates over the pages of a ListAppsLists operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppsLists method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppsLists operation.
//	pageNum := 0
//	err := client.ListAppsListsPages(params,
//	    func(page *fms.ListAppsListsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListAppsListsPages(input *ListAppsListsInput, fn func(*ListAppsListsOutput, bool) bool) error {
	return c.ListAppsListsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppsListsPagesWithContext same as ListAppsListsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListAppsListsPagesWithContext(ctx aws.Context, input *ListAppsListsInput, fn func(*ListAppsListsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppsListsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppsListsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppsListsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComplianceStatus = "ListComplianceStatus"

// ListComplianceStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListComplianceStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComplianceStatus for more information on using the ListComplianceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComplianceStatusRequest method.
//	req, resp := client.ListComplianceStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus
func (c *FMS) ListComplianceStatusRequest(input *ListComplianceStatusInput) (req *request.Request, output *ListComplianceStatusOutput) {
	op := &request.Operation{
		Name:       opListComplianceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComplianceStatusInput{}
	}

	output = &ListComplianceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComplianceStatus API operation for Firewall Management Service.
//
// Returns an array of PolicyComplianceStatus objects. Use PolicyComplianceStatus
// to get a summary of which member accounts are protected by the specified
// policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListComplianceStatus for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus
func (c *FMS) ListComplianceStatus(input *ListComplianceStatusInput) (*ListComplianceStatusOutput, error) {
	req, out := c.ListComplianceStatusRequest(input)
	return out, req.Send()
}

// ListComplianceStatusWithContext is the same as ListComplianceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListComplianceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListComplianceStatusWithContext(ctx aws.Context, input *ListComplianceStatusInput, opts ...request.Option) (*ListComplianceStatusOutput, error) {
	req, out := c.ListComplianceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComplianceStatusPages iterates over the pages of a ListComplianceStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComplianceStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComplianceStatus operation.
//	pageNum := 0
//	err := client.ListComplianceStatusPages(params,
//	    func(page *fms.ListComplianceStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListComplianceStatusPages(input *ListComplianceStatusInput, fn func(*ListComplianceStatusOutput, bool) bool) error {
	return c.ListComplianceStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComplianceStatusPagesWithContext same as ListComplianceStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListComplianceStatusPagesWithContext(ctx aws.Context, input *ListComplianceStatusInput, fn func(*ListComplianceStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComplianceStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComplianceStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComplianceStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDiscoveredResources = "ListDiscoveredResources"

// ListDiscoveredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDiscoveredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDiscoveredResources for more information on using the ListDiscoveredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDiscoveredResourcesRequest method.
//	req, resp := client.ListDiscoveredResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListDiscoveredResources
func (c *FMS) ListDiscoveredResourcesRequest(input *ListDiscoveredResourcesInput) (req *request.Request, output *ListDiscoveredResourcesOutput) {
	op := &request.Operation{
		Name:       opListDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDiscoveredResourcesInput{}
	}

	output = &ListDiscoveredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDiscoveredResources API operation for Firewall Management Service.
//
// Returns an array of resources in the organization's accounts that are available
// to be associated with a resource set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListDiscoveredResources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListDiscoveredResources
func (c *FMS) ListDiscoveredResources(input *ListDiscoveredResourcesInput) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	return out, req.Send()
}

// ListDiscoveredResourcesWithContext is the same as ListDiscoveredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDiscoveredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListDiscoveredResourcesWithContext(ctx aws.Context, input *ListDiscoveredResourcesInput, opts ...request.Option) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMemberAccounts = "ListMemberAccounts"

// ListMemberAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListMemberAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMemberAccounts for more information on using the ListMemberAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMemberAccountsRequest method.
//	req, resp := client.ListMemberAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts
func (c *FMS) ListMemberAccountsRequest(input *ListMemberAccountsInput) (req *request.Request, output *ListMemberAccountsOutput) {
	op := &request.Operation{
		Name:       opListMemberAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMemberAccountsInput{}
	}

	output = &ListMemberAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMemberAccounts API operation for Firewall Management Service.
//
// Returns a MemberAccounts object that lists the member accounts in the administrator's
// Amazon Web Services organization.
//
// Either an Firewall Manager administrator or the organization's management
// account can make this request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListMemberAccounts for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts
func (c *FMS) ListMemberAccounts(input *ListMemberAccountsInput) (*ListMemberAccountsOutput, error) {
	req, out := c.ListMemberAccountsRequest(input)
	return out, req.Send()
}

// ListMemberAccountsWithContext is the same as ListMemberAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListMemberAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListMemberAccountsWithContext(ctx aws.Context, input *ListMemberAccountsInput, opts ...request.Option) (*ListMemberAccountsOutput, error) {
	req, out := c.ListMemberAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMemberAccountsPages iterates over the pages of a ListMemberAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMemberAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMemberAccounts operation.
//	pageNum := 0
//	err := client.ListMemberAccountsPages(params,
//	    func(page *fms.ListMemberAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListMemberAccountsPages(input *ListMemberAccountsInput, fn func(*ListMemberAccountsOutput, bool) bool) error {
	return c.ListMemberAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMemberAccountsPagesWithContext same as ListMemberAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListMemberAccountsPagesWithContext(ctx aws.Context, input *ListMemberAccountsInput, fn func(*ListMemberAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMemberAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMemberAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMemberAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicies for more information on using the ListPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPoliciesRequest method.
//	req, resp := client.ListPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies
func (c *FMS) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for Firewall Management Service.
//
// Returns an array of PolicySummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListPolicies for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies
func (c *FMS) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPoliciesPages iterates over the pages of a ListPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPolicies operation.
//	pageNum := 0
//	err := client.ListPoliciesPages(params,
//	    func(page *fms.ListPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListPoliciesPages(input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool) error {
	return c.ListPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPoliciesPagesWithContext same as ListPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListPoliciesPagesWithContext(ctx aws.Context, input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProtocolsLists = "ListProtocolsLists"

// ListProtocolsListsRequest generates a "aws/request.Request" representing the
// client's request for the ListProtocolsLists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProtocolsLists for more information on using the ListProtocolsLists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProtocolsListsRequest method.
//	req, resp := client.ListProtocolsListsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListProtocolsLists
func (c *FMS) ListProtocolsListsRequest(input *ListProtocolsListsInput) (req *request.Request, output *ListProtocolsListsOutput) {
	op := &request.Operation{
		Name:       opListProtocolsLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProtocolsListsInput{}
	}

	output = &ListProtocolsListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProtocolsLists API operation for Firewall Management Service.
//
// Returns an array of ProtocolsListDataSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListProtocolsLists for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListProtocolsLists
func (c *FMS) ListProtocolsLists(input *ListProtocolsListsInput) (*ListProtocolsListsOutput, error) {
	req, out := c.ListProtocolsListsRequest(input)
	return out, req.Send()
}

// ListProtocolsListsWithContext is the same as ListProtocolsLists with the addition of
// the ability to pass a context and additional request options.
//
// See ListProtocolsLists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListProtocolsListsWithContext(ctx aws.Context, input *ListProtocolsListsInput, opts ...request.Option) (*ListProtocolsListsOutput, error) {
	req, out := c.ListProtocolsListsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProtocolsListsPages iterates over the pages of a ListProtocolsLists operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProtocolsLists method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProtocolsLists operation.
//	pageNum := 0
//	err := client.ListProtocolsListsPages(params,
//	    func(page *fms.ListProtocolsListsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListProtocolsListsPages(input *ListProtocolsListsInput, fn func(*ListProtocolsListsOutput, bool) bool) error {
	return c.ListProtocolsListsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProtocolsListsPagesWithContext same as ListProtocolsListsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListProtocolsListsPagesWithContext(ctx aws.Context, input *ListProtocolsListsInput, fn func(*ListProtocolsListsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProtocolsListsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProtocolsListsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProtocolsListsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceSetResources = "ListResourceSetResources"

// ListResourceSetResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceSetResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceSetResources for more information on using the ListResourceSetResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceSetResourcesRequest method.
//	req, resp := client.ListResourceSetResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListResourceSetResources
func (c *FMS) ListResourceSetResourcesRequest(input *ListResourceSetResourcesInput) (req *request.Request, output *ListResourceSetResourcesOutput) {
	op := &request.Operation{
		Name:       opListResourceSetResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceSetResourcesInput{}
	}

	output = &ListResourceSetResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceSetResources API operation for Firewall Management Service.
//
// Returns an array of resources that are currently associated to a resource
// set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListResourceSetResources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListResourceSetResources
func (c *FMS) ListResourceSetResources(input *ListResourceSetResourcesInput) (*ListResourceSetResourcesOutput, error) {
	req, out := c.ListResourceSetResourcesRequest(input)
	return out, req.Send()
}

// ListResourceSetResourcesWithContext is the same as ListResourceSetResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceSetResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListResourceSetResourcesWithContext(ctx aws.Context, input *ListResourceSetResourcesInput, opts ...request.Option) (*ListResourceSetResourcesOutput, error) {
	req, out := c.ListResourceSetResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceSets = "ListResourceSets"

// ListResourceSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceSets for more information on using the ListResourceSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceSetsRequest method.
//	req, resp := client.ListResourceSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListResourceSets
func (c *FMS) ListResourceSetsRequest(input *ListResourceSetsInput) (req *request.Request, output *ListResourceSetsOutput) {
	op := &request.Operation{
		Name:       opListResourceSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceSetsInput{}
	}

	output = &ListResourceSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceSets API operation for Firewall Management Service.
//
// Returns an array of ResourceSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListResourceSets for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListResourceSets
func (c *FMS) ListResourceSets(input *ListResourceSetsInput) (*ListResourceSetsOutput, error) {
	req, out := c.ListResourceSetsRequest(input)
	return out, req.Send()
}

// ListResourceSetsWithContext is the same as ListResourceSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListResourceSetsWithContext(ctx aws.Context, input *ListResourceSetsInput, opts ...request.Option) (*ListResourceSetsOutput, error) {
	req, out := c.ListResourceSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource
func (c *FMS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Firewall Management Service.
//
// Retrieves the list of tags for the specified Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource
func (c *FMS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThirdPartyFirewallFirewallPolicies = "ListThirdPartyFirewallFirewallPolicies"

// ListThirdPartyFirewallFirewallPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListThirdPartyFirewallFirewallPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThirdPartyFirewallFirewallPolicies for more information on using the ListThirdPartyFirewallFirewallPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListThirdPartyFirewallFirewallPoliciesRequest method.
//	req, resp := client.ListThirdPartyFirewallFirewallPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListThirdPartyFirewallFirewallPolicies
func (c *FMS) ListThirdPartyFirewallFirewallPoliciesRequest(input *ListThirdPartyFirewallFirewallPoliciesInput) (req *request.Request, output *ListThirdPartyFirewallFirewallPoliciesOutput) {
	op := &request.Operation{
		Name:       opListThirdPartyFirewallFirewallPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThirdPartyFirewallFirewallPoliciesInput{}
	}

	output = &ListThirdPartyFirewallFirewallPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThirdPartyFirewallFirewallPolicies API operation for Firewall Management Service.
//
// Retrieves a list of all of the third-party firewall policies that are associated
// with the third-party firewall administrator's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListThirdPartyFirewallFirewallPolicies for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListThirdPartyFirewallFirewallPolicies
func (c *FMS) ListThirdPartyFirewallFirewallPolicies(input *ListThirdPartyFirewallFirewallPoliciesInput) (*ListThirdPartyFirewallFirewallPoliciesOutput, error) {
	req, out := c.ListThirdPartyFirewallFirewallPoliciesRequest(input)
	return out, req.Send()
}

// ListThirdPartyFirewallFirewallPoliciesWithContext is the same as ListThirdPartyFirewallFirewallPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListThirdPartyFirewallFirewallPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListThirdPartyFirewallFirewallPoliciesWithContext(ctx aws.Context, input *ListThirdPartyFirewallFirewallPoliciesInput, opts ...request.Option) (*ListThirdPartyFirewallFirewallPoliciesOutput, error) {
	req, out := c.ListThirdPartyFirewallFirewallPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThirdPartyFirewallFirewallPoliciesPages iterates over the pages of a ListThirdPartyFirewallFirewallPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThirdPartyFirewallFirewallPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListThirdPartyFirewallFirewallPolicies operation.
//	pageNum := 0
//	err := client.ListThirdPartyFirewallFirewallPoliciesPages(params,
//	    func(page *fms.ListThirdPartyFirewallFirewallPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FMS) ListThirdPartyFirewallFirewallPoliciesPages(input *ListThirdPartyFirewallFirewallPoliciesInput, fn func(*ListThirdPartyFirewallFirewallPoliciesOutput, bool) bool) error {
	return c.ListThirdPartyFirewallFirewallPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThirdPartyFirewallFirewallPoliciesPagesWithContext same as ListThirdPartyFirewallFirewallPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListThirdPartyFirewallFirewallPoliciesPagesWithContext(ctx aws.Context, input *ListThirdPartyFirewallFirewallPoliciesInput, fn func(*ListThirdPartyFirewallFirewallPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThirdPartyFirewallFirewallPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThirdPartyFirewallFirewallPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThirdPartyFirewallFirewallPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAdminAccount = "PutAdminAccount"

// PutAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the PutAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAdminAccount for more information on using the PutAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAdminAccountRequest method.
//	req, resp := client.PutAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAdminAccount
func (c *FMS) PutAdminAccountRequest(input *PutAdminAccountInput) (req *request.Request, output *PutAdminAccountOutput) {
	op := &request.Operation{
		Name:       opPutAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAdminAccountInput{}
	}

	output = &PutAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAdminAccount API operation for Firewall Management Service.
//
// Creates or updates an Firewall Manager administrator account. The account
// must be a member of the organization that was onboarded to Firewall Manager
// by AssociateAdminAccount. Only the organization's management account can
// create an Firewall Manager administrator account. When you create an Firewall
// Manager administrator account, the service checks to see if the account is
// already a delegated administrator within Organizations. If the account isn't
// a delegated administrator, Firewall Manager calls Organizations to delegate
// the account within Organizations. For more information about administrator
// accounts within Organizations, see Managing the Amazon Web Services Accounts
// in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAdminAccount
func (c *FMS) PutAdminAccount(input *PutAdminAccountInput) (*PutAdminAccountOutput, error) {
	req, out := c.PutAdminAccountRequest(input)
	return out, req.Send()
}

// PutAdminAccountWithContext is the same as PutAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See PutAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutAdminAccountWithContext(ctx aws.Context, input *PutAdminAccountInput, opts ...request.Option) (*PutAdminAccountOutput, error) {
	req, out := c.PutAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppsList = "PutAppsList"

// PutAppsListRequest generates a "aws/request.Request" representing the
// client's request for the PutAppsList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppsList for more information on using the PutAppsList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAppsListRequest method.
//	req, resp := client.PutAppsListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAppsList
func (c *FMS) PutAppsListRequest(input *PutAppsListInput) (req *request.Request, output *PutAppsListOutput) {
	op := &request.Operation{
		Name:       opPutAppsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAppsListInput{}
	}

	output = &PutAppsListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAppsList API operation for Firewall Management Service.
//
// Creates an Firewall Manager applications list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutAppsList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAppsList
func (c *FMS) PutAppsList(input *PutAppsListInput) (*PutAppsListOutput, error) {
	req, out := c.PutAppsListRequest(input)
	return out, req.Send()
}

// PutAppsListWithContext is the same as PutAppsList with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppsList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutAppsListWithContext(ctx aws.Context, input *PutAppsListInput, opts ...request.Option) (*PutAppsListOutput, error) {
	req, out := c.PutAppsListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutNotificationChannel = "PutNotificationChannel"

// PutNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the PutNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutNotificationChannel for more information on using the PutNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutNotificationChannelRequest method.
//	req, resp := client.PutNotificationChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel
func (c *FMS) PutNotificationChannelRequest(input *PutNotificationChannelInput) (req *request.Request, output *PutNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opPutNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutNotificationChannelInput{}
	}

	output = &PutNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutNotificationChannel API operation for Firewall Management Service.
//
// Designates the IAM role and Amazon Simple Notification Service (SNS) topic
// that Firewall Manager uses to record SNS logs.
//
// To perform this action outside of the console, you must first configure the
// SNS topic's access policy to allow the SnsRoleName to publish SNS logs. If
// the SnsRoleName provided is a role other than the AWSServiceRoleForFMS service-linked
// role, this role must have a trust relationship configured to allow the Firewall
// Manager service principal fms.amazonaws.com to assume this role. For information
// about configuring an SNS access policy, see Service roles for Firewall Manager
// (https://docs.aws.amazon.com/waf/latest/developerguide/fms-security_iam_service-with-iam.html#fms-security_iam_service-with-iam-roles-service)
// in the Firewall Manager Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutNotificationChannel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel
func (c *FMS) PutNotificationChannel(input *PutNotificationChannelInput) (*PutNotificationChannelOutput, error) {
	req, out := c.PutNotificationChannelRequest(input)
	return out, req.Send()
}

// PutNotificationChannelWithContext is the same as PutNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See PutNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutNotificationChannelWithContext(ctx aws.Context, input *PutNotificationChannelInput, opts ...request.Option) (*PutNotificationChannelOutput, error) {
	req, out := c.PutNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPolicy = "PutPolicy"

// PutPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPolicy for more information on using the PutPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPolicyRequest method.
//	req, resp := client.PutPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy
func (c *FMS) PutPolicyRequest(input *PutPolicyInput) (req *request.Request, output *PutPolicyOutput) {
	op := &request.Operation{
		Name:       opPutPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPolicyInput{}
	}

	output = &PutPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutPolicy API operation for Firewall Management Service.
//
// Creates an Firewall Manager policy.
//
// Firewall Manager provides the following types of policies:
//
//   - An WAF policy (type WAFV2), which defines rule groups to run first in
//     the corresponding WAF web ACL and rule groups to run last in the web ACL.
//
//   - An WAF Classic policy (type WAF), which defines a rule group.
//
//   - A Shield Advanced policy, which applies Shield Advanced protection to
//     specified accounts and resources.
//
//   - A security group policy, which manages VPC security groups across your
//     Amazon Web Services organization.
//
//   - An Network Firewall policy, which provides firewall rules to filter
//     network traffic in specified Amazon VPCs.
//
//   - A DNS Firewall policy, which provides Route 53 Resolver DNS Firewall
//     rules to filter DNS queries for specified VPCs.
//
// Each policy is specific to one of the types. If you want to enforce more
// than one policy type across accounts, create multiple policies. You can create
// multiple policies for each type.
//
// You must be subscribed to Shield Advanced to create a Shield Advanced policy.
// For more information about subscribing to Shield Advanced, see CreateSubscription
// (https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidTypeException
//     The value of the Type parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy
func (c *FMS) PutPolicy(input *PutPolicyInput) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	return out, req.Send()
}

// PutPolicyWithContext is the same as PutPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutPolicyWithContext(ctx aws.Context, input *PutPolicyInput, opts ...request.Option) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutProtocolsList = "PutProtocolsList"

// PutProtocolsListRequest generates a "aws/request.Request" representing the
// client's request for the PutProtocolsList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutProtocolsList for more information on using the PutProtocolsList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutProtocolsListRequest method.
//	req, resp := client.PutProtocolsListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutProtocolsList
func (c *FMS) PutProtocolsListRequest(input *PutProtocolsListInput) (req *request.Request, output *PutProtocolsListOutput) {
	op := &request.Operation{
		Name:       opPutProtocolsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutProtocolsListInput{}
	}

	output = &PutProtocolsListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutProtocolsList API operation for Firewall Management Service.
//
// Creates an Firewall Manager protocols list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutProtocolsList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutProtocolsList
func (c *FMS) PutProtocolsList(input *PutProtocolsListInput) (*PutProtocolsListOutput, error) {
	req, out := c.PutProtocolsListRequest(input)
	return out, req.Send()
}

// PutProtocolsListWithContext is the same as PutProtocolsList with the addition of
// the ability to pass a context and additional request options.
//
// See PutProtocolsList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutProtocolsListWithContext(ctx aws.Context, input *PutProtocolsListInput, opts ...request.Option) (*PutProtocolsListOutput, error) {
	req, out := c.PutProtocolsListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourceSet = "PutResourceSet"

// PutResourceSetRequest generates a "aws/request.Request" representing the
// client's request for the PutResourceSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourceSet for more information on using the PutResourceSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourceSetRequest method.
//	req, resp := client.PutResourceSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutResourceSet
func (c *FMS) PutResourceSetRequest(input *PutResourceSetInput) (req *request.Request, output *PutResourceSetOutput) {
	op := &request.Operation{
		Name:       opPutResourceSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourceSetInput{}
	}

	output = &PutResourceSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourceSet API operation for Firewall Management Service.
//
// Creates the resource set.
//
// An Firewall Manager resource set defines the resources to import into an
// Firewall Manager policy from another Amazon Web Services service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutResourceSet for usage and error information.
//
// Returned Error Types:
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutResourceSet
func (c *FMS) PutResourceSet(input *PutResourceSetInput) (*PutResourceSetOutput, error) {
	req, out := c.PutResourceSetRequest(input)
	return out, req.Send()
}

// PutResourceSetWithContext is the same as PutResourceSet with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourceSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutResourceSetWithContext(ctx aws.Context, input *PutResourceSetInput, opts ...request.Option) (*PutResourceSetOutput, error) {
	req, out := c.PutResourceSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource
func (c *FMS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Firewall Management Service.
//
// Adds one or more tags to an Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
//   - LimitExceededException
//     The operation exceeds a resource limit, for example, the maximum number of
//     policy objects that you can create for an Amazon Web Services account. For
//     more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//     in the WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource
func (c *FMS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource
func (c *FMS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Firewall Management Service.
//
// Removes one or more tags from an Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidOperationException
//     The operation failed because there was nothing to do or the operation wasn't
//     possible. For example, you might have submitted an AssociateAdminAccount
//     request for an account ID that was already set as the Firewall Manager administrator.
//     Or you might have tried to access a Region that's disabled by default, and
//     that you need to enable for the Firewall Manager administrator account and
//     for Organizations before you can access it.
//
//   - InternalErrorException
//     The operation failed because of a system problem, even though the request
//     was valid. Retry your request.
//
//   - InvalidInputException
//     The parameters of the request were invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource
func (c *FMS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Configures the accounts within the administrator's Organizations organization
// that the specified Firewall Manager administrator can apply policies to.
type AccountScope struct {
	_ struct{} `type:"structure"`

	// The list of accounts within the organization that the specified Firewall
	// Manager administrator either can or cannot apply policies to, based on the
	// value of ExcludeSpecifiedAccounts. If ExcludeSpecifiedAccounts is set to
	// true, then the Firewall Manager administrator can apply policies to all members
	// of the organization except for the accounts in this list. If ExcludeSpecifiedAccounts
	// is set to false, then the Firewall Manager administrator can only apply policies
	// to the accounts in this list.
	Accounts []*string `type:"list"`

	// A boolean value that indicates if the administrator can apply policies to
	// all accounts within an organization. If true, the administrator can apply
	// policies to all accounts within the organization. You can either enable management
	// of all accounts through this operation, or you can specify a list of accounts
	// to manage in AccountScope$Accounts. You cannot specify both.
	AllAccountsEnabled *bool `type:"boolean"`

	// A boolean value that excludes the accounts in AccountScope$Accounts from
	// the administrator's scope. If true, the Firewall Manager administrator can
	// apply policies to all members of the organization except for the accounts
	// listed in AccountScope$Accounts. You can either specify a list of accounts
	// to exclude by AccountScope$Accounts, or you can enable management of all
	// accounts by AccountScope$AllAccountsEnabled. You cannot specify both.
	ExcludeSpecifiedAccounts *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountScope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountScope) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *AccountScope) SetAccounts(v []*string) *AccountScope {
	s.Accounts = v
	return s
}

// SetAllAccountsEnabled sets the AllAccountsEnabled field's value.
func (s *AccountScope) SetAllAccountsEnabled(v bool) *AccountScope {
	s.AllAccountsEnabled = &v
	return s
}

// SetExcludeSpecifiedAccounts sets the ExcludeSpecifiedAccounts field's value.
func (s *AccountScope) SetExcludeSpecifiedAccounts(v bool) *AccountScope {
	s.ExcludeSpecifiedAccounts = &v
	return s
}

// Describes a remediation action target.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// A description of the remediation action target.
	Description *string `type:"string"`

	// The ID of the remediation target.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ActionTarget) SetDescription(v string) *ActionTarget {
	s.Description = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ActionTarget) SetResourceId(v string) *ActionTarget {
	s.ResourceId = &v
	return s
}

// Contains high level information about the Firewall Manager administrator
// account.
type AdminAccountSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the Firewall Manager administrator's
	// account.
	AdminAccount *string `min:"1" type:"string"`

	// A boolean value that indicates if the administrator is the default administrator.
	// If true, then this is the default administrator account. The default administrator
	// can manage third-party firewalls and has full administrative scope. There
	// is only one default administrator account per organization. For information
	// about Firewall Manager default administrator accounts, see Managing Firewall
	// Manager administrators (https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html)
	// in the Firewall Manager Developer Guide.
	DefaultAdmin *bool `type:"boolean"`

	// The current status of the request to onboard a member account as an Firewall
	// Manager administator.
	//
	//    * ONBOARDING - The account is onboarding to Firewall Manager as an administrator.
	//
	//    * ONBOARDING_COMPLETE - Firewall Manager The account is onboarded to Firewall
	//    Manager as an administrator, and can perform actions on the resources
	//    defined in their AdminScope.
	//
	//    * OFFBOARDING - The account is being removed as an Firewall Manager administrator.
	//
	//    * OFFBOARDING_COMPLETE - The account has been removed as an Firewall Manager
	//    administrator.
	Status *string `type:"string" enum:"OrganizationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAccountSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAccountSummary) GoString() string {
	return s.String()
}

// SetAdminAccount sets the AdminAccount field's value.
func (s *AdminAccountSummary) SetAdminAccount(v string) *AdminAccountSummary {
	s.AdminAccount = &v
	return s
}

// SetDefaultAdmin sets the DefaultAdmin field's value.
func (s *AdminAccountSummary) SetDefaultAdmin(v bool) *AdminAccountSummary {
	s.DefaultAdmin = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdminAccountSummary) SetStatus(v string) *AdminAccountSummary {
	s.Status = &v
	return s
}

// Defines the resources that the Firewall Manager administrator can manage.
// For more information about administrative scope, see Managing Firewall Manager
// administrators (https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html)
// in the Firewall Manager Developer Guide.
type AdminScope struct {
	_ struct{} `type:"structure"`

	// Defines the accounts that the specified Firewall Manager administrator can
	// apply policies to.
	AccountScope *AccountScope `type:"structure"`

	// Defines the Organizations organizational units that the specified Firewall
	// Manager administrator can apply policies to. For more information about OUs
	// in Organizations, see Managing organizational units (OUs) (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html)
	// in the Organizations User Guide.
	OrganizationalUnitScope *OrganizationalUnitScope `type:"structure"`

	// Defines the Firewall Manager policy types that the specified Firewall Manager
	// administrator can create and manage.
	PolicyTypeScope *PolicyTypeScope `type:"structure"`

	// Defines the Amazon Web Services Regions that the specified Firewall Manager
	// administrator can perform actions in.
	RegionScope *RegionScope `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminScope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminScope) GoString() string {
	return s.String()
}

// SetAccountScope sets the AccountScope field's value.
func (s *AdminScope) SetAccountScope(v *AccountScope) *AdminScope {
	s.AccountScope = v
	return s
}

// SetOrganizationalUnitScope sets the OrganizationalUnitScope field's value.
func (s *AdminScope) SetOrganizationalUnitScope(v *OrganizationalUnitScope) *AdminScope {
	s.OrganizationalUnitScope = v
	return s
}

// SetPolicyTypeScope sets the PolicyTypeScope field's value.
func (s *AdminScope) SetPolicyTypeScope(v *PolicyTypeScope) *AdminScope {
	s.PolicyTypeScope = v
	return s
}

// SetRegionScope sets the RegionScope field's value.
func (s *AdminScope) SetRegionScope(v *RegionScope) *AdminScope {
	s.RegionScope = v
	return s
}

// An individual Firewall Manager application.
type App struct {
	_ struct{} `type:"structure"`

	// The application's name.
	//
	// AppName is a required field
	AppName *string `min:"1" type:"string" required:"true"`

	// The application's port number, for example 80.
	//
	// Port is a required field
	Port *int64 `type:"long" required:"true"`

	// The IP protocol name or number. The name can be one of tcp, udp, or icmp.
	// For information on possible numbers, see Protocol Numbers (https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
	//
	// Protocol is a required field
	Protocol *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s App) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s App) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *App) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "App"}
	if s.AppName == nil {
		invalidParams.Add(request.NewErrParamRequired("AppName"))
	}
	if s.AppName != nil && len(*s.AppName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppName", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.Protocol != nil && len(*s.Protocol) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocol", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppName sets the AppName field's value.
func (s *App) SetAppName(v string) *App {
	s.AppName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *App) SetPort(v int64) *App {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *App) SetProtocol(v string) *App {
	s.Protocol = &v
	return s
}

// An Firewall Manager applications list.
type AppsListData struct {
	_ struct{} `type:"structure"`

	// An array of applications in the Firewall Manager applications list.
	//
	// AppsList is a required field
	AppsList []*App `type:"list" required:"true"`

	// The time that the Firewall Manager applications list was created.
	CreateTime *time.Time `type:"timestamp"`

	// The time that the Firewall Manager applications list was last updated.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The ID of the Firewall Manager applications list.
	ListId *string `min:"36" type:"string"`

	// The name of the Firewall Manager applications list.
	//
	// ListName is a required field
	ListName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for each update to the list. When you update the list,
	// the update token must match the token of the current version of the application
	// list. You can retrieve the update token by getting the list.
	ListUpdateToken *string `min:"1" type:"string"`

	// A map of previous version numbers to their corresponding App object arrays.
	PreviousAppsList map[string][]*App `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppsListData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppsListData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppsListData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppsListData"}
	if s.AppsList == nil {
		invalidParams.Add(request.NewErrParamRequired("AppsList"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ListId", 36))
	}
	if s.ListName == nil {
		invalidParams.Add(request.NewErrParamRequired("ListName"))
	}
	if s.ListName != nil && len(*s.ListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ListName", 1))
	}
	if s.ListUpdateToken != nil && len(*s.ListUpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ListUpdateToken", 1))
	}
	if s.AppsList != nil {
		for i, v := range s.AppsList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AppsList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppsList sets the AppsList field's value.
func (s *AppsListData) SetAppsList(v []*App) *AppsListData {
	s.AppsList = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AppsListData) SetCreateTime(v time.Time) *AppsListData {
	s.CreateTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *AppsListData) SetLastUpdateTime(v time.Time) *AppsListData {
	s.LastUpdateTime = &v
	return s
}

// SetListId sets the ListId field's value.
func (s *AppsListData) SetListId(v string) *AppsListData {
	s.ListId = &v
	return s
}

// SetListName sets the ListName field's value.
func (s *AppsListData) SetListName(v string) *AppsListData {
	s.ListName = &v
	return s
}

// SetListUpdateToken sets the ListUpdateToken field's value.
func (s *AppsListData) SetListUpdateToken(v string) *AppsListData {
	s.ListUpdateToken = &v
	return s
}

// SetPreviousAppsList sets the PreviousAppsList field's value.
func (s *AppsListData) SetPreviousAppsList(v map[string][]*App) *AppsListData {
	s.PreviousAppsList = v
	return s
}

// Details of the Firewall Manager applications list.
type AppsListDataSummary struct {
	_ struct{} `type:"structure"`

	// An array of App objects in the Firewall Manager applications list.
	AppsList []*App `type:"list"`

	// The Amazon Resource Name (ARN) of the applications list.
	ListArn *string `min:"1" type:"string"`

	// The ID of the applications list.
	ListId *string `min:"36" type:"string"`

	// The name of the applications list.
	ListName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppsListDataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppsListDataSummary) GoString() string {
	return s.String()
}

// SetAppsList sets the AppsList field's value.
func (s *AppsListDataSummary) SetAppsList(v []*App) *AppsListDataSummary {
	s.AppsList = v
	return s
}

// SetListArn sets the ListArn field's value.
func (s *AppsListDataSummary) SetListArn(v string) *AppsListDataSummary {
	s.ListArn = &v
	return s
}

// SetListId sets the ListId field's value.
func (s *AppsListDataSummary) SetListId(v string) *AppsListDataSummary {
	s.ListId = &v
	return s
}

// SetListName sets the ListName field's value.
func (s *AppsListDataSummary) SetListName(v string) *AppsListDataSummary {
	s.ListName = &v
	return s
}

type AssociateAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID to associate with Firewall Manager as
	// the Firewall Manager default administrator account. This account must be
	// a member account of the organization in Organizations whose resources you
	// want to protect. For more information about Organizations, see Managing the
	// Amazon Web Services Accounts in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html).
	//
	// AdminAccount is a required field
	AdminAccount *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAdminAccountInput"}
	if s.AdminAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccount"))
	}
	if s.AdminAccount != nil && len(*s.AdminAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdminAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccount sets the AdminAccount field's value.
func (s *AssociateAdminAccountInput) SetAdminAccount(v string) *AssociateAdminAccountInput {
	s.AdminAccount = &v
	return s
}

type AssociateAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAdminAccountOutput) GoString() string {
	return s.String()
}

type AssociateThirdPartyFirewallInput struct {
	_ struct{} `type:"structure"`

	// The name of the third-party firewall vendor.
	//
	// ThirdPartyFirewall is a required field
	ThirdPartyFirewall *string `type:"string" required:"true" enum:"ThirdPartyFirewall"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateThirdPartyFirewallInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateThirdPartyFirewallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateThirdPartyFirewallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateThirdPartyFirewallInput"}
	if s.ThirdPartyFirewall == nil {
		invalidParams.Add(request.NewErrParamRequired("ThirdPartyFirewall"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThirdPartyFirewall sets the ThirdPartyFirewall field's value.
func (s *AssociateThirdPartyFirewallInput) SetThirdPartyFirewall(v string) *AssociateThirdPartyFirewallInput {
	s.ThirdPartyFirewall = &v
	return s
}

type AssociateThirdPartyFirewallOutput struct {
	_ struct{} `type:"structure"`

	// The current status for setting a Firewall Manager policy administrator's
	// account as an administrator of the third-party firewall tenant.
	//
	//    * ONBOARDING - The Firewall Manager policy administrator is being designated
	//    as a tenant administrator.
	//
	//    * ONBOARD_COMPLETE - The Firewall Manager policy administrator is designated
	//    as a tenant administrator.
	//
	//    * OFFBOARDING - The Firewall Manager policy administrator is being removed
	//    as a tenant administrator.
	//
	//    * OFFBOARD_COMPLETE - The Firewall Manager policy administrator has been
	//    removed as a tenant administrator.
	//
	//    * NOT_EXIST - The Firewall Manager policy administrator doesn't exist
	//    as a tenant administrator.
	ThirdPartyFirewallStatus *string `type:"string" enum:"ThirdPartyFirewallAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateThirdPartyFirewallOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateThirdPartyFirewallOutput) GoString() string {
	return s.String()
}

// SetThirdPartyFirewallStatus sets the ThirdPartyFirewallStatus field's value.
func (s *AssociateThirdPartyFirewallOutput) SetThirdPartyFirewallStatus(v string) *AssociateThirdPartyFirewallOutput {
	s.ThirdPartyFirewallStatus = &v
	return s
}

// Violation detail for an EC2 instance resource.
type AwsEc2InstanceViolation struct {
	_ struct{} `type:"structure"`

	// Violation detail for network interfaces associated with the EC2 instance.
	AwsEc2NetworkInterfaceViolations []*AwsEc2NetworkInterfaceViolation `type:"list"`

	// The resource ID of the EC2 instance.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceViolation) GoString() string {
	return s.String()
}

// SetAwsEc2NetworkInterfaceViolations sets the AwsEc2NetworkInterfaceViolations field's value.
func (s *AwsEc2InstanceViolation) SetAwsEc2NetworkInterfaceViolations(v []*AwsEc2NetworkInterfaceViolation) *AwsEc2InstanceViolation {
	s.AwsEc2NetworkInterfaceViolations = v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *AwsEc2InstanceViolation) SetViolationTarget(v string) *AwsEc2InstanceViolation {
	s.ViolationTarget = &v
	return s
}

// Violation detail for network interfaces associated with an EC2 instance.
type AwsEc2NetworkInterfaceViolation struct {
	_ struct{} `type:"structure"`

	// List of security groups that violate the rules specified in the primary security
	// group of the Firewall Manager policy.
	ViolatingSecurityGroups []*string `type:"list"`

	// The resource ID of the network interface.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceViolation) GoString() string {
	return s.String()
}

// SetViolatingSecurityGroups sets the ViolatingSecurityGroups field's value.
func (s *AwsEc2NetworkInterfaceViolation) SetViolatingSecurityGroups(v []*string) *AwsEc2NetworkInterfaceViolation {
	s.ViolatingSecurityGroups = v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *AwsEc2NetworkInterfaceViolation) SetViolationTarget(v string) *AwsEc2NetworkInterfaceViolation {
	s.ViolationTarget = &v
	return s
}

// Violation detail for the rule violation in a security group when compared
// to the primary security group of the Firewall Manager policy.
type AwsVPCSecurityGroupViolation struct {
	_ struct{} `type:"structure"`

	// List of rules specified in the security group of the Firewall Manager policy
	// that partially match the ViolationTarget rule.
	PartialMatches []*PartialMatch `type:"list"`

	// Remediation options for the rule specified in the ViolationTarget.
	PossibleSecurityGroupRemediationActions []*SecurityGroupRemediationAction `type:"list"`

	// The security group rule that is being evaluated.
	ViolationTarget *string `type:"string"`

	// A description of the security group that violates the policy.
	ViolationTargetDescription *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVPCSecurityGroupViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVPCSecurityGroupViolation) GoString() string {
	return s.String()
}

// SetPartialMatches sets the PartialMatches field's value.
func (s *AwsVPCSecurityGroupViolation) SetPartialMatches(v []*PartialMatch) *AwsVPCSecurityGroupViolation {
	s.PartialMatches = v
	return s
}

// SetPossibleSecurityGroupRemediationActions sets the PossibleSecurityGroupRemediationActions field's value.
func (s *AwsVPCSecurityGroupViolation) SetPossibleSecurityGroupRemediationActions(v []*SecurityGroupRemediationAction) *AwsVPCSecurityGroupViolation {
	s.PossibleSecurityGroupRemediationActions = v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *AwsVPCSecurityGroupViolation) SetViolationTarget(v string) *AwsVPCSecurityGroupViolation {
	s.ViolationTarget = &v
	return s
}

// SetViolationTargetDescription sets the ViolationTargetDescription field's value.
func (s *AwsVPCSecurityGroupViolation) SetViolationTargetDescription(v string) *AwsVPCSecurityGroupViolation {
	s.ViolationTargetDescription = &v
	return s
}

type BatchAssociateResourceInput struct {
	_ struct{} `type:"structure"`

	// The uniform resource identifiers (URIs) of resources that should be associated
	// to the resource set. The URIs must be Amazon Resource Names (ARNs).
	//
	// Items is a required field
	Items []*string `type:"list" required:"true"`

	// A unique identifier for the resource set, used in a request to refer to the
	// resource set.
	//
	// ResourceSetIdentifier is a required field
	ResourceSetIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateResourceInput"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.ResourceSetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetIdentifier"))
	}
	if s.ResourceSetIdentifier != nil && len(*s.ResourceSetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceSetIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *BatchAssociateResourceInput) SetItems(v []*string) *BatchAssociateResourceInput {
	s.Items = v
	return s
}

// SetResourceSetIdentifier sets the ResourceSetIdentifier field's value.
func (s *BatchAssociateResourceInput) SetResourceSetIdentifier(v string) *BatchAssociateResourceInput {
	s.ResourceSetIdentifier = &v
	return s
}

type BatchAssociateResourceOutput struct {
	_ struct{} `type:"structure"`

	// The resources that failed to associate to the resource set.
	//
	// FailedItems is a required field
	FailedItems []*FailedItem `type:"list" required:"true"`

	// A unique identifier for the resource set, used in a request to refer to the
	// resource set.
	//
	// ResourceSetIdentifier is a required field
	ResourceSetIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourceOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *BatchAssociateResourceOutput) SetFailedItems(v []*FailedItem) *BatchAssociateResourceOutput {
	s.FailedItems = v
	return s
}

// SetResourceSetIdentifier sets the ResourceSetIdentifier field's value.
func (s *BatchAssociateResourceOutput) SetResourceSetIdentifier(v string) *BatchAssociateResourceOutput {
	s.ResourceSetIdentifier = &v
	return s
}

type BatchDisassociateResourceInput struct {
	_ struct{} `type:"structure"`

	// The uniform resource identifiers (URI) of resources that should be disassociated
	// from the resource set. The URIs must be Amazon Resource Names (ARNs).
	//
	// Items is a required field
	Items []*string `type:"list" required:"true"`

	// A unique identifier for the resource set, used in a request to refer to the
	// resource set.
	//
	// ResourceSetIdentifier is a required field
	ResourceSetIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateResourceInput"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.ResourceSetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetIdentifier"))
	}
	if s.ResourceSetIdentifier != nil && len(*s.ResourceSetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceSetIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *BatchDisassociateResourceInput) SetItems(v []*string) *BatchDisassociateResourceInput {
	s.Items = v
	return s
}

// SetResourceSetIdentifier sets the ResourceSetIdentifier field's value.
func (s *BatchDisassociateResourceInput) SetResourceSetIdentifier(v string) *BatchDisassociateResourceInput {
	s.ResourceSetIdentifier = &v
	return s
}

type BatchDisassociateResourceOutput struct {
	_ struct{} `type:"structure"`

	// The resources that failed to disassociate from the resource set.
	//
	// FailedItems is a required field
	FailedItems []*FailedItem `type:"list" required:"true"`

	// A unique identifier for the resource set, used in a request to refer to the
	// resource set.
	//
	// ResourceSetIdentifier is a required field
	ResourceSetIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourceOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *BatchDisassociateResourceOutput) SetFailedItems(v []*FailedItem) *BatchDisassociateResourceOutput {
	s.FailedItems = v
	return s
}

// SetResourceSetIdentifier sets the ResourceSetIdentifier field's value.
func (s *BatchDisassociateResourceOutput) SetResourceSetIdentifier(v string) *BatchDisassociateResourceOutput {
	s.ResourceSetIdentifier = &v
	return s
}

// Details of the resource that is not protected by the policy.
type ComplianceViolator struct {
	_ struct{} `type:"structure"`

	// Metadata about the resource that doesn't comply with the policy scope.
	Metadata map[string]*string `type:"map"`

	// The resource ID.
	ResourceId *string `min:"1" type:"string"`

	// The resource type. This is in the format shown in the Amazon Web Services
	// Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For example: AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::CloudFront::Distribution,
	// or AWS::NetworkFirewall::FirewallPolicy.
	ResourceType *string `min:"1" type:"string"`

	// The reason that the resource is not protected by the policy.
	ViolationReason *string `type:"string" enum:"ViolationReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceViolator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceViolator) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *ComplianceViolator) SetMetadata(v map[string]*string) *ComplianceViolator {
	s.Metadata = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ComplianceViolator) SetResourceId(v string) *ComplianceViolator {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceViolator) SetResourceType(v string) *ComplianceViolator {
	s.ResourceType = &v
	return s
}

// SetViolationReason sets the ViolationReason field's value.
func (s *ComplianceViolator) SetViolationReason(v string) *ComplianceViolator {
	s.ViolationReason = &v
	return s
}

type DeleteAppsListInput struct {
	_ struct{} `type:"structure"`

	// The ID of the applications list that you want to delete. You can retrieve
	// this ID from PutAppsList, ListAppsLists, and GetAppsList.
	//
	// ListId is a required field
	ListId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppsListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppsListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppsListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppsListInput"}
	if s.ListId == nil {
		invalidParams.Add(request.NewErrParamRequired("ListId"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ListId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListId sets the ListId field's value.
func (s *DeleteAppsListInput) SetListId(v string) *DeleteAppsListInput {
	s.ListId = &v
	return s
}

type DeleteAppsListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppsListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppsListOutput) GoString() string {
	return s.String()
}

type DeleteNotificationChannelInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationChannelInput) GoString() string {
	return s.String()
}

type DeleteNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationChannelOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// If True, the request performs cleanup according to the policy type.
	//
	// For WAF and Shield Advanced policies, the cleanup does the following:
	//
	//    * Deletes rule groups created by Firewall Manager
	//
	//    * Removes web ACLs from in-scope resources
	//
	//    * Deletes web ACLs that contain no rules or rule groups
	//
	// For security group policies, the cleanup does the following for each security
	// group in the policy:
	//
	//    * Disassociates the security group from in-scope resources
	//
	//    * Deletes the security group if it was created through Firewall Manager
	//    and if it's no longer associated with any resources through another policy
	//
	// After the cleanup, in-scope resources are no longer protected by web ACLs
	// in this policy. Protection of out-of-scope resources remains unchanged. Scope
	// is determined by tags that you create and accounts that you associate with
	// the policy. When creating the policy, if you specify that only resources
	// in specific accounts or with specific tags are in scope of the policy, those
	// accounts and resources are handled by the policy. All others are out of scope.
	// If you don't specify tags or accounts, all resources are in scope.
	DeleteAllPolicyResources *bool `type:"boolean"`

	// The ID of the policy that you want to delete. You can retrieve this ID from
	// PutPolicy and ListPolicies.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteAllPolicyResources sets the DeleteAllPolicyResources field's value.
func (s *DeletePolicyInput) SetDeleteAllPolicyResources(v bool) *DeletePolicyInput {
	s.DeleteAllPolicyResources = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeletePolicyInput) SetPolicyId(v string) *DeletePolicyInput {
	s.PolicyId = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DeleteProtocolsListInput struct {
	_ struct{} `type:"structure"`

	// The ID of the protocols list that you want to delete. You can retrieve this
	// ID from PutProtocolsList, ListProtocolsLists, and GetProtocolsLost.
	//
	// ListId is a required field
	ListId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProtocolsListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProtocolsListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProtocolsListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProtocolsListInput"}
	if s.ListId == nil {
		invalidParams.Add(request.NewErrParamRequired("ListId"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ListId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListId sets the ListId field's value.
func (s *DeleteProtocolsListInput) SetListId(v string) *DeleteProtocolsListInput {
	s.ListId = &v
	return s
}

type DeleteProtocolsListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProtocolsListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProtocolsListOutput) GoString() string {
	return s.String()
}

type DeleteResourceSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the resource set, used in a request to refer to the
	// resource set.
	//
	// Identifier is a required field
	Identifier *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceSetInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteResourceSetInput) SetIdentifier(v string) *DeleteResourceSetInput {
	s.Identifier = &v
	return s
}

type DeleteResourceSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetOutput) GoString() string {
	return s.String()
}

type DisassociateAdminAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAdminAccountInput) GoString() string {
	return s.String()
}

type DisassociateAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAdminAccountOutput) GoString() string {
	return s.String()
}

type DisassociateThirdPartyFirewallInput struct {
	_ struct{} `type:"structure"`

	// The name of the third-party firewall vendor.
	//
	// ThirdPartyFirewall is a required field
	ThirdPartyFirewall *string `type:"string" required:"true" enum:"ThirdPartyFirewall"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateThirdPartyFirewallInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateThirdPartyFirewallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateThirdPartyFirewallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateThirdPartyFirewallInput"}
	if s.ThirdPartyFirewall == nil {
		invalidParams.Add(request.NewErrParamRequired("ThirdPartyFirewall"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThirdPartyFirewall sets the ThirdPartyFirewall field's value.
func (s *DisassociateThirdPartyFirewallInput) SetThirdPartyFirewall(v string) *DisassociateThirdPartyFirewallInput {
	s.ThirdPartyFirewall = &v
	return s
}

type DisassociateThirdPartyFirewallOutput struct {
	_ struct{} `type:"structure"`

	// The current status for the disassociation of a Firewall Manager administrators
	// account with a third-party firewall.
	ThirdPartyFirewallStatus *string `type:"string" enum:"ThirdPartyFirewallAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateThirdPartyFirewallOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateThirdPartyFirewallOutput) GoString() string {
	return s.String()
}

// SetThirdPartyFirewallStatus sets the ThirdPartyFirewallStatus field's value.
func (s *DisassociateThirdPartyFirewallOutput) SetThirdPartyFirewallStatus(v string) *DisassociateThirdPartyFirewallOutput {
	s.ThirdPartyFirewallStatus = &v
	return s
}

// A resource in the organization that's available to be associated with a Firewall
// Manager resource set.
type DiscoveredResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID associated with the discovered resource.
	AccountId *string `min:"1" type:"string"`

	// The name of the discovered resource.
	Name *string `min:"1" type:"string"`

	// The type of the discovered resource.
	Type *string `min:"1" type:"string"`

	// The universal resource identifier (URI) of the discovered resource.
	URI *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoveredResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoveredResource) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *DiscoveredResource) SetAccountId(v string) *DiscoveredResource {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DiscoveredResource) SetName(v string) *DiscoveredResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *DiscoveredResource) SetType(v string) *DiscoveredResource {
	s.Type = &v
	return s
}

// SetURI sets the URI field's value.
func (s *DiscoveredResource) SetURI(v string) *DiscoveredResource {
	s.URI = &v
	return s
}

// A DNS Firewall rule group that Firewall Manager tried to associate with a
// VPC is already associated with the VPC and can't be associated again.
type DnsDuplicateRuleGroupViolation struct {
	_ struct{} `type:"structure"`

	// Information about the VPC ID.
	ViolationTarget *string `type:"string"`

	// A description of the violation that specifies the rule group and VPC.
	ViolationTargetDescription *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsDuplicateRuleGroupViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsDuplicateRuleGroupViolation) GoString() string {
	return s.String()
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *DnsDuplicateRuleGroupViolation) SetViolationTarget(v string) *DnsDuplicateRuleGroupViolation {
	s.ViolationTarget = &v
	return s
}

// SetViolationTargetDescription sets the ViolationTargetDescription field's value.
func (s *DnsDuplicateRuleGroupViolation) SetViolationTargetDescription(v string) *DnsDuplicateRuleGroupViolation {
	s.ViolationTargetDescription = &v
	return s
}

// The VPC that Firewall Manager was applying a DNS Fireall policy to reached
// the limit for associated DNS Firewall rule groups. Firewall Manager tried
// to associate another rule group with the VPC and failed due to the limit.
type DnsRuleGroupLimitExceededViolation struct {
	_ struct{} `type:"structure"`

	// The number of rule groups currently associated with the VPC.
	NumberOfRuleGroupsAlreadyAssociated *int64 `type:"integer"`

	// Information about the VPC ID.
	ViolationTarget *string `type:"string"`

	// A description of the violation that specifies the rule group and VPC.
	ViolationTargetDescription *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsRuleGroupLimitExceededViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsRuleGroupLimitExceededViolation) GoString() string {
	return s.String()
}

// SetNumberOfRuleGroupsAlreadyAssociated sets the NumberOfRuleGroupsAlreadyAssociated field's value.
func (s *DnsRuleGroupLimitExceededViolation) SetNumberOfRuleGroupsAlreadyAssociated(v int64) *DnsRuleGroupLimitExceededViolation {
	s.NumberOfRuleGroupsAlreadyAssociated = &v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *DnsRuleGroupLimitExceededViolation) SetViolationTarget(v string) *DnsRuleGroupLimitExceededViolation {
	s.ViolationTarget = &v
	return s
}

// SetViolationTargetDescription sets the ViolationTargetDescription field's value.
func (s *DnsRuleGroupLimitExceededViolation) SetViolationTargetDescription(v string) *DnsRuleGroupLimitExceededViolation {
	s.ViolationTargetDescription = &v
	return s
}

// A rule group that Firewall Manager tried to associate with a VPC has the
// same priority as a rule group that's already associated.
type DnsRuleGroupPriorityConflictViolation struct {
	_ struct{} `type:"structure"`

	// The ID of the Firewall Manager DNS Firewall policy that was already applied
	// to the VPC. This policy contains the rule group that's already associated
	// with the VPC.
	ConflictingPolicyId *string `min:"36" type:"string"`

	// The priority setting of the two conflicting rule groups.
	ConflictingPriority *int64 `type:"integer"`

	// The priorities of rule groups that are already associated with the VPC. To
	// retry your operation, choose priority settings that aren't in this list for
	// the rule groups in your new DNS Firewall policy.
	UnavailablePriorities []*int64 `type:"list"`

	// Information about the VPC ID.
	ViolationTarget *string `type:"string"`

	// A description of the violation that specifies the VPC and the rule group
	// that's already associated with it.
	ViolationTargetDescription *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsRuleGroupPriorityConflictViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DnsRuleGroupPriorityConflictViolation) GoString() string {
	return s.String()
}

// SetConflictingPolicyId sets the ConflictingPolicyId field's value.
func (s *DnsRuleGroupPriorityConflictViolation) SetConflictingPolicyId(v string) *DnsRuleGroupPriorityConflictViolation {
	s.ConflictingPolicyId = &v
	return s
}

// SetConflictingPriority sets the ConflictingPriority field's value.
func (s *DnsRuleGroupPriorityConflictViolation) SetConflictingPriority(v int64) *DnsRuleGroupPriorityConflictViolation {
	s.ConflictingPriority = &v
	return s
}

// SetUnavailablePriorities sets the UnavailablePriorities field's value.
func (s *DnsRuleGroupPriorityConflictViolation) SetUnavailablePriorities(v []*int64) *DnsRuleGroupPriorityConflictViolation {
	s.UnavailablePriorities = v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *DnsRuleGroupPriorityConflictViolation) SetViolationTarget(v string) *DnsRuleGroupPriorityConflictViolation {
	s.ViolationTarget = &v
	return s
}

// SetViolationTargetDescription sets the ViolationTargetDescription field's value.
func (s *DnsRuleGroupPriorityConflictViolation) SetViolationTargetDescription(v string) *DnsRuleGroupPriorityConflictViolation {
	s.ViolationTargetDescription = &v
	return s
}

// The action of associating an EC2 resource, such as a subnet or internet gateway,
// with a route table.
type EC2AssociateRouteTableAction struct {
	_ struct{} `type:"structure"`

	// A description of the EC2 route table that is associated with the remediation
	// action.
	Description *string `type:"string"`

	// The ID of the gateway to be used with the EC2 route table that is associated
	// with the remediation action.
	GatewayId *ActionTarget `type:"structure"`

	// The ID of the EC2 route table that is associated with the remediation action.
	//
	// RouteTableId is a required field
	RouteTableId *ActionTarget `type:"structure" required:"true"`

	// The ID of the subnet for the EC2 route table that is associated with the
	// remediation action.
	SubnetId *ActionTarget `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2AssociateRouteTableAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2AssociateRouteTableAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EC2AssociateRouteTableAction) SetDescription(v string) *EC2AssociateRouteTableAction {
	s.Description = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *EC2AssociateRouteTableAction) SetGatewayId(v *ActionTarget) *EC2AssociateRouteTableAction {
	s.GatewayId = v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *EC2AssociateRouteTableAction) SetRouteTableId(v *ActionTarget) *EC2AssociateRouteTableAction {
	s.RouteTableId = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *EC2AssociateRouteTableAction) SetSubnetId(v *ActionTarget) *EC2AssociateRouteTableAction {
	s.SubnetId = v
	return s
}

// An action that copies the EC2 route table for use in remediation.
type EC2CopyRouteTableAction struct {
	_ struct{} `type:"structure"`

	// A description of the copied EC2 route table that is associated with the remediation
	// action.
	Description *string `type:"string"`

	// The ID of the copied EC2 route table that is associated with the remediation
	// action.
	//
	// RouteTableId is a required field
	RouteTableId *ActionTarget `type:"structure" required:"true"`

	// The VPC ID of the copied EC2 route table that is associated with the remediation
	// action.
	//
	// VpcId is a required field
	VpcId *ActionTarget `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2CopyRouteTableAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2CopyRouteTableAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EC2CopyRouteTableAction) SetDescription(v string) *EC2CopyRouteTableAction {
	s.Description = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *EC2CopyRouteTableAction) SetRouteTableId(v *ActionTarget) *EC2CopyRouteTableAction {
	s.RouteTableId = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *EC2CopyRouteTableAction) SetVpcId(v *ActionTarget) *EC2CopyRouteTableAction {
	s.VpcId = v
	return s
}

// Information about the CreateRoute action in Amazon EC2.
type EC2CreateRouteAction struct {
	_ struct{} `type:"structure"`

	// A description of CreateRoute action in Amazon EC2.
	Description *string `type:"string"`

	// Information about the IPv4 CIDR address block used for the destination match.
	DestinationCidrBlock *string `type:"string"`

	// Information about the IPv6 CIDR block destination.
	DestinationIpv6CidrBlock *string `type:"string"`

	// Information about the ID of a prefix list used for the destination match.
	DestinationPrefixListId *string `min:"1" type:"string"`

	// Information about the ID of an internet gateway or virtual private gateway
	// attached to your VPC.
	GatewayId *ActionTarget `type:"structure"`

	// Information about the ID of the route table for the route.
	//
	// RouteTableId is a required field
	RouteTableId *ActionTarget `type:"structure" required:"true"`

	// Information about the ID of a VPC endpoint. Supported for Gateway Load Balancer
	// endpoints only.
	VpcEndpointId *ActionTarget `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2CreateRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2CreateRouteAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EC2CreateRouteAction) SetDescription(v string) *EC2CreateRouteAction {
	s.Description = &v
	return s
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *EC2CreateRouteAction) SetDestinationCidrBlock(v string) *EC2CreateRouteAction {
	s.DestinationCidrBlock = &v
	return s
}

// SetDestinationIpv6CidrBlock sets the DestinationIpv6CidrBlock field's value.
func (s *EC2CreateRouteAction) SetDestinationIpv6CidrBlock(v string) *EC2CreateRouteAction {
	s.DestinationIpv6CidrBlock = &v
	return s
}

// SetDestinationPrefixListId sets the DestinationPrefixListId field's value.
func (s *EC2CreateRouteAction) SetDestinationPrefixListId(v string) *EC2CreateRouteAction {
	s.DestinationPrefixListId = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *EC2CreateRouteAction) SetGatewayId(v *ActionTarget) *EC2CreateRouteAction {
	s.GatewayId = v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *EC2CreateRouteAction) SetRouteTableId(v *ActionTarget) *EC2CreateRouteAction {
	s.RouteTableId = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *EC2CreateRouteAction) SetVpcEndpointId(v *ActionTarget) *EC2CreateRouteAction {
	s.VpcEndpointId = v
	return s
}

// Information about the CreateRouteTable action in Amazon EC2.
type EC2CreateRouteTableAction struct {
	_ struct{} `type:"structure"`

	// A description of the CreateRouteTable action.
	Description *string `type:"string"`

	// Information about the ID of a VPC.
	//
	// VpcId is a required field
	VpcId *ActionTarget `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2CreateRouteTableAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2CreateRouteTableAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EC2CreateRouteTableAction) SetDescription(v string) *EC2CreateRouteTableAction {
	s.Description = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *EC2CreateRouteTableAction) SetVpcId(v *ActionTarget) *EC2CreateRouteTableAction {
	s.VpcId = v
	return s
}

// Information about the DeleteRoute action in Amazon EC2.
type EC2DeleteRouteAction struct {
	_ struct{} `type:"structure"`

	// A description of the DeleteRoute action.
	Description *string `type:"string"`

	// Information about the IPv4 CIDR range for the route. The value you specify
	// must match the CIDR for the route exactly.
	DestinationCidrBlock *string `type:"string"`

	// Information about the IPv6 CIDR range for the route. The value you specify
	// must match the CIDR for the route exactly.
	DestinationIpv6CidrBlock *string `type:"string"`

	// Information about the ID of the prefix list for the route.
	DestinationPrefixListId *string `min:"1" type:"string"`

	// Information about the ID of the route table.
	//
	// RouteTableId is a required field
	RouteTableId *ActionTarget `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2DeleteRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2DeleteRouteAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EC2DeleteRouteAction) SetDescription(v string) *EC2DeleteRouteAction {
	s.Description = &v
	return s
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *EC2DeleteRouteAction) SetDestinationCidrBlock(v string) *EC2DeleteRouteAction {
	s.DestinationCidrBlock = &v
	return s
}

// SetDestinationIpv6CidrBlock sets the DestinationIpv6CidrBlock field's value.
func (s *EC2DeleteRouteAction) SetDestinationIpv6CidrBlock(v string) *EC2DeleteRouteAction {
	s.DestinationIpv6CidrBlock = &v
	return s
}

// SetDestinationPrefixListId sets the DestinationPrefixListId field's value.
func (s *EC2DeleteRouteAction) SetDestinationPrefixListId(v string) *EC2DeleteRouteAction {
	s.DestinationPrefixListId = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *EC2DeleteRouteAction) SetRouteTableId(v *ActionTarget) *EC2DeleteRouteAction {
	s.RouteTableId = v
	return s
}

// Information about the ReplaceRoute action in Amazon EC2.
type EC2ReplaceRouteAction struct {
	_ struct{} `type:"structure"`

	// A description of the ReplaceRoute action in Amazon EC2.
	Description *string `type:"string"`

	// Information about the IPv4 CIDR address block used for the destination match.
	// The value that you provide must match the CIDR of an existing route in the
	// table.
	DestinationCidrBlock *string `type:"string"`

	// Information about the IPv6 CIDR address block used for the destination match.
	// The value that you provide must match the CIDR of an existing route in the
	// table.
	DestinationIpv6CidrBlock *string `type:"string"`

	// Information about the ID of the prefix list for the route.
	DestinationPrefixListId *string `min:"1" type:"string"`

	// Information about the ID of an internet gateway or virtual private gateway.
	GatewayId *ActionTarget `type:"structure"`

	// Information about the ID of the route table.
	//
	// RouteTableId is a required field
	RouteTableId *ActionTarget `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ReplaceRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ReplaceRouteAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EC2ReplaceRouteAction) SetDescription(v string) *EC2ReplaceRouteAction {
	s.Description = &v
	return s
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *EC2ReplaceRouteAction) SetDestinationCidrBlock(v string) *EC2ReplaceRouteAction {
	s.DestinationCidrBlock = &v
	return s
}

// SetDestinationIpv6CidrBlock sets the DestinationIpv6CidrBlock field's value.
func (s *EC2ReplaceRouteAction) SetDestinationIpv6CidrBlock(v string) *EC2ReplaceRouteAction {
	s.DestinationIpv6CidrBlock = &v
	return s
}

// SetDestinationPrefixListId sets the DestinationPrefixListId field's value.
func (s *EC2ReplaceRouteAction) SetDestinationPrefixListId(v string) *EC2ReplaceRouteAction {
	s.DestinationPrefixListId = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *EC2ReplaceRouteAction) SetGatewayId(v *ActionTarget) *EC2ReplaceRouteAction {
	s.GatewayId = v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *EC2ReplaceRouteAction) SetRouteTableId(v *ActionTarget) *EC2ReplaceRouteAction {
	s.RouteTableId = v
	return s
}

// Information about the ReplaceRouteTableAssociation action in Amazon EC2.
type EC2ReplaceRouteTableAssociationAction struct {
	_ struct{} `type:"structure"`

	// Information about the association ID.
	//
	// AssociationId is a required field
	AssociationId *ActionTarget `type:"structure" required:"true"`

	// A description of the ReplaceRouteTableAssociation action in Amazon EC2.
	Description *string `type:"string"`

	// Information about the ID of the new route table to associate with the subnet.
	//
	// RouteTableId is a required field
	RouteTableId *ActionTarget `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ReplaceRouteTableAssociationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2ReplaceRouteTableAssociationAction) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *EC2ReplaceRouteTableAssociationAction) SetAssociationId(v *ActionTarget) *EC2ReplaceRouteTableAssociationAction {
	s.AssociationId = v
	return s
}

// SetDescription sets the Description field's value.
func (s *EC2ReplaceRouteTableAssociationAction) SetDescription(v string) *EC2ReplaceRouteTableAssociationAction {
	s.Description = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *EC2ReplaceRouteTableAssociationAction) SetRouteTableId(v *ActionTarget) *EC2ReplaceRouteTableAssociationAction {
	s.RouteTableId = v
	return s
}

// Describes the compliance status for the account. An account is considered
// noncompliant if it includes resources that are not protected by the specified
// policy or that don't comply with the policy.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Describes an Amazon Web Services account's compliance with the Firewall Manager
	// policy.
	ComplianceStatus *string `type:"string" enum:"PolicyComplianceStatusType"`

	// Indicates that over 100 resources are noncompliant with the Firewall Manager
	// policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// The number of resources that are noncompliant with the specified policy.
	// For WAF and Shield Advanced policies, a resource is considered noncompliant
	// if it is not associated with the policy. For security group policies, a resource
	// is considered noncompliant if it doesn't comply with the rules of the policy
	// and remediation is disabled or not possible.
	ViolatorCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *EvaluationResult) SetComplianceStatus(v string) *EvaluationResult {
	s.ComplianceStatus = &v
	return s
}

// SetEvaluationLimitExceeded sets the EvaluationLimitExceeded field's value.
func (s *EvaluationResult) SetEvaluationLimitExceeded(v bool) *EvaluationResult {
	s.EvaluationLimitExceeded = &v
	return s
}

// SetViolatorCount sets the ViolatorCount field's value.
func (s *EvaluationResult) SetViolatorCount(v int64) *EvaluationResult {
	s.ViolatorCount = &v
	return s
}

// Information about the expected route in the route table.
type ExpectedRoute struct {
	_ struct{} `type:"structure"`

	// Information about the allowed targets.
	AllowedTargets []*string `type:"list"`

	// Information about the contributing subnets.
	ContributingSubnets []*string `type:"list"`

	// Information about the IPv4 CIDR block.
	IpV4Cidr *string `type:"string"`

	// Information about the IPv6 CIDR block.
	IpV6Cidr *string `type:"string"`

	// Information about the ID of the prefix list for the route.
	PrefixListId *string `type:"string"`

	// Information about the route table ID.
	RouteTableId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpectedRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpectedRoute) GoString() string {
	return s.String()
}

// SetAllowedTargets sets the AllowedTargets field's value.
func (s *ExpectedRoute) SetAllowedTargets(v []*string) *ExpectedRoute {
	s.AllowedTargets = v
	return s
}

// SetContributingSubnets sets the ContributingSubnets field's value.
func (s *ExpectedRoute) SetContributingSubnets(v []*string) *ExpectedRoute {
	s.ContributingSubnets = v
	return s
}

// SetIpV4Cidr sets the IpV4Cidr field's value.
func (s *ExpectedRoute) SetIpV4Cidr(v string) *ExpectedRoute {
	s.IpV4Cidr = &v
	return s
}

// SetIpV6Cidr sets the IpV6Cidr field's value.
func (s *ExpectedRoute) SetIpV6Cidr(v string) *ExpectedRoute {
	s.IpV6Cidr = &v
	return s
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *ExpectedRoute) SetPrefixListId(v string) *ExpectedRoute {
	s.PrefixListId = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *ExpectedRoute) SetRouteTableId(v string) *ExpectedRoute {
	s.RouteTableId = &v
	return s
}

// Contains information about the actions that you can take to remediate scope
// violations caused by your policy's FirewallCreationConfig. FirewallCreationConfig
// is an optional configuration that you can use to choose which Availability
// Zones Firewall Manager creates Network Firewall endpoints in.
type FMSPolicyUpdateFirewallCreationConfigAction struct {
	_ struct{} `type:"structure"`

	// Describes the remedial action.
	Description *string `type:"string"`

	// A FirewallCreationConfig that you can copy into your current policy's SecurityServiceData
	// (https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html)
	// in order to remedy scope violations.
	FirewallCreationConfig *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FMSPolicyUpdateFirewallCreationConfigAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FMSPolicyUpdateFirewallCreationConfigAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *FMSPolicyUpdateFirewallCreationConfigAction) SetDescription(v string) *FMSPolicyUpdateFirewallCreationConfigAction {
	s.Description = &v
	return s
}

// SetFirewallCreationConfig sets the FirewallCreationConfig field's value.
func (s *FMSPolicyUpdateFirewallCreationConfigAction) SetFirewallCreationConfig(v string) *FMSPolicyUpdateFirewallCreationConfigAction {
	s.FirewallCreationConfig = &v
	return s
}

// Details of a resource that failed when trying to update it's association
// to a resource set.
type FailedItem struct {
	_ struct{} `type:"structure"`

	// The reason the resource's association could not be updated.
	Reason *string `type:"string" enum:"FailedItemReason"`

	// The univeral resource indicator (URI) of the resource that failed.
	URI *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedItem) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *FailedItem) SetReason(v string) *FailedItem {
	s.Reason = &v
	return s
}

// SetURI sets the URI field's value.
func (s *FailedItem) SetURI(v string) *FailedItem {
	s.URI = &v
	return s
}

// Contains details about the firewall subnet that violates the policy scope.
type FirewallSubnetIsOutOfScopeViolation struct {
	_ struct{} `type:"structure"`

	// The ID of the firewall subnet that violates the policy scope.
	FirewallSubnetId *string `min:"1" type:"string"`

	// The Availability Zone of the firewall subnet that violates the policy scope.
	SubnetAvailabilityZone *string `type:"string"`

	// The Availability Zone ID of the firewall subnet that violates the policy
	// scope.
	SubnetAvailabilityZoneId *string `type:"string"`

	// The VPC endpoint ID of the firewall subnet that violates the policy scope.
	VpcEndpointId *string `min:"1" type:"string"`

	// The VPC ID of the firewall subnet that violates the policy scope.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallSubnetIsOutOfScopeViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallSubnetIsOutOfScopeViolation) GoString() string {
	return s.String()
}

// SetFirewallSubnetId sets the FirewallSubnetId field's value.
func (s *FirewallSubnetIsOutOfScopeViolation) SetFirewallSubnetId(v string) *FirewallSubnetIsOutOfScopeViolation {
	s.FirewallSubnetId = &v
	return s
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *FirewallSubnetIsOutOfScopeViolation) SetSubnetAvailabilityZone(v string) *FirewallSubnetIsOutOfScopeViolation {
	s.SubnetAvailabilityZone = &v
	return s
}

// SetSubnetAvailabilityZoneId sets the SubnetAvailabilityZoneId field's value.
func (s *FirewallSubnetIsOutOfScopeViolation) SetSubnetAvailabilityZoneId(v string) *FirewallSubnetIsOutOfScopeViolation {
	s.SubnetAvailabilityZoneId = &v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *FirewallSubnetIsOutOfScopeViolation) SetVpcEndpointId(v string) *FirewallSubnetIsOutOfScopeViolation {
	s.VpcEndpointId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *FirewallSubnetIsOutOfScopeViolation) SetVpcId(v string) *FirewallSubnetIsOutOfScopeViolation {
	s.VpcId = &v
	return s
}

// The violation details for a firewall subnet's VPC endpoint that's deleted
// or missing.
type FirewallSubnetMissingVPCEndpointViolation struct {
	_ struct{} `type:"structure"`

	// The ID of the firewall that this VPC endpoint is associated with.
	FirewallSubnetId *string `min:"1" type:"string"`

	// The name of the Availability Zone of the deleted VPC subnet.
	SubnetAvailabilityZone *string `type:"string"`

	// The ID of the Availability Zone of the deleted VPC subnet.
	SubnetAvailabilityZoneId *string `type:"string"`

	// The resource ID of the VPC associated with the deleted VPC subnet.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallSubnetMissingVPCEndpointViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallSubnetMissingVPCEndpointViolation) GoString() string {
	return s.String()
}

// SetFirewallSubnetId sets the FirewallSubnetId field's value.
func (s *FirewallSubnetMissingVPCEndpointViolation) SetFirewallSubnetId(v string) *FirewallSubnetMissingVPCEndpointViolation {
	s.FirewallSubnetId = &v
	return s
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *FirewallSubnetMissingVPCEndpointViolation) SetSubnetAvailabilityZone(v string) *FirewallSubnetMissingVPCEndpointViolation {
	s.SubnetAvailabilityZone = &v
	return s
}

// SetSubnetAvailabilityZoneId sets the SubnetAvailabilityZoneId field's value.
func (s *FirewallSubnetMissingVPCEndpointViolation) SetSubnetAvailabilityZoneId(v string) *FirewallSubnetMissingVPCEndpointViolation {
	s.SubnetAvailabilityZoneId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *FirewallSubnetMissingVPCEndpointViolation) SetVpcId(v string) *FirewallSubnetMissingVPCEndpointViolation {
	s.VpcId = &v
	return s
}

type GetAdminAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminAccountInput) GoString() string {
	return s.String()
}

type GetAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The account that is set as the Firewall Manager default administrator.
	AdminAccount *string `min:"1" type:"string"`

	// The status of the account that you set as the Firewall Manager default administrator.
	RoleStatus *string `type:"string" enum:"AccountRoleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminAccountOutput) GoString() string {
	return s.String()
}

// SetAdminAccount sets the AdminAccount field's value.
func (s *GetAdminAccountOutput) SetAdminAccount(v string) *GetAdminAccountOutput {
	s.AdminAccount = &v
	return s
}

// SetRoleStatus sets the RoleStatus field's value.
func (s *GetAdminAccountOutput) SetRoleStatus(v string) *GetAdminAccountOutput {
	s.RoleStatus = &v
	return s
}

type GetAdminScopeInput struct {
	_ struct{} `type:"structure"`

	// The administator account that you want to get the details for.
	//
	// AdminAccount is a required field
	AdminAccount *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminScopeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminScopeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAdminScopeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAdminScopeInput"}
	if s.AdminAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccount"))
	}
	if s.AdminAccount != nil && len(*s.AdminAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdminAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccount sets the AdminAccount field's value.
func (s *GetAdminScopeInput) SetAdminAccount(v string) *GetAdminScopeInput {
	s.AdminAccount = &v
	return s
}

type GetAdminScopeOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the administrative scope of the requested account.
	AdminScope *AdminScope `type:"structure"`

	// The current status of the request to onboard a member account as an Firewall
	// Manager administator.
	//
	//    * ONBOARDING - The account is onboarding to Firewall Manager as an administrator.
	//
	//    * ONBOARDING_COMPLETE - Firewall Manager The account is onboarded to Firewall
	//    Manager as an administrator, and can perform actions on the resources
	//    defined in their AdminScope.
	//
	//    * OFFBOARDING - The account is being removed as an Firewall Manager administrator.
	//
	//    * OFFBOARDING_COMPLETE - The account has been removed as an Firewall Manager
	//    administrator.
	Status *string `type:"string" enum:"OrganizationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminScopeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAdminScopeOutput) GoString() string {
	return s.String()
}

// SetAdminScope sets the AdminScope field's value.
func (s *GetAdminScopeOutput) SetAdminScope(v *AdminScope) *GetAdminScopeOutput {
	s.AdminScope = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetAdminScopeOutput) SetStatus(v string) *GetAdminScopeOutput {
	s.Status = &v
	return s
}

type GetAppsListInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the list to retrieve is a default list owned by Firewall
	// Manager.
	DefaultList *bool `type:"boolean"`

	// The ID of the Firewall Manager applications list that you want the details
	// for.
	//
	// ListId is a required field
	ListId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppsListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppsListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppsListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppsListInput"}
	if s.ListId == nil {
		invalidParams.Add(request.NewErrParamRequired("ListId"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ListId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultList sets the DefaultList field's value.
func (s *GetAppsListInput) SetDefaultList(v bool) *GetAppsListInput {
	s.DefaultList = &v
	return s
}

// SetListId sets the ListId field's value.
func (s *GetAppsListInput) SetListId(v string) *GetAppsListInput {
	s.ListId = &v
	return s
}

type GetAppsListOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified Firewall Manager applications list.
	AppsList *AppsListData `type:"structure"`

	// The Amazon Resource Name (ARN) of the applications list.
	AppsListArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppsListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppsListOutput) GoString() string {
	return s.String()
}

// SetAppsList sets the AppsList field's value.
func (s *GetAppsListOutput) SetAppsList(v *AppsListData) *GetAppsListOutput {
	s.AppsList = v
	return s
}

// SetAppsListArn sets the AppsListArn field's value.
func (s *GetAppsListOutput) SetAppsListArn(v string) *GetAppsListOutput {
	s.AppsListArn = &v
	return s
}

type GetComplianceDetailInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account that owns the resources that you want to
	// get the details for.
	//
	// MemberAccount is a required field
	MemberAccount *string `min:"1" type:"string" required:"true"`

	// The ID of the policy that you want to get the details for. PolicyId is returned
	// by PutPolicy and by ListPolicies.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailInput"}
	if s.MemberAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberAccount"))
	}
	if s.MemberAccount != nil && len(*s.MemberAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberAccount", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *GetComplianceDetailInput) SetMemberAccount(v string) *GetComplianceDetailInput {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetComplianceDetailInput) SetPolicyId(v string) *GetComplianceDetailInput {
	s.PolicyId = &v
	return s
}

type GetComplianceDetailOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resources and the policy that you specified in the
	// GetComplianceDetail request.
	PolicyComplianceDetail *PolicyComplianceDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailOutput) GoString() string {
	return s.String()
}

// SetPolicyComplianceDetail sets the PolicyComplianceDetail field's value.
func (s *GetComplianceDetailOutput) SetPolicyComplianceDetail(v *PolicyComplianceDetail) *GetComplianceDetailOutput {
	s.PolicyComplianceDetail = v
	return s
}

type GetNotificationChannelInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNotificationChannelInput) GoString() string {
	return s.String()
}

type GetNotificationChannelOutput struct {
	_ struct{} `type:"structure"`

	// The IAM role that is used by Firewall Manager to record activity to SNS.
	SnsRoleName *string `min:"1" type:"string"`

	// The SNS topic that records Firewall Manager activity.
	SnsTopicArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNotificationChannelOutput) GoString() string {
	return s.String()
}

// SetSnsRoleName sets the SnsRoleName field's value.
func (s *GetNotificationChannelOutput) SetSnsRoleName(v string) *GetNotificationChannelOutput {
	s.SnsRoleName = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *GetNotificationChannelOutput) SetSnsTopicArn(v string) *GetNotificationChannelOutput {
	s.SnsTopicArn = &v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Firewall Manager policy that you want the details for.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetPolicyInput) SetPolicyId(v string) *GetPolicyInput {
	s.PolicyId = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified Firewall Manager policy.
	Policy *Policy `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v *Policy) *GetPolicyOutput {
	s.Policy = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyOutput) SetPolicyArn(v string) *GetPolicyOutput {
	s.PolicyArn = &v
	return s
}

type GetProtectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period to query for the attacks. This is a timestamp
	// type. The request syntax listing indicates a number type because the default
	// used by Firewall Manager is Unix time in seconds. However, any valid timestamp
	// format is allowed.
	EndTime *time.Time `type:"timestamp"`

	// Specifies the number of objects that you want Firewall Manager to return
	// for this request. If you have more objects than the number that you specify
	// for MaxResults, the response includes a NextToken value that you can use
	// to get another batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// The Amazon Web Services account that is in scope of the policy that you want
	// to get the details for.
	MemberAccountId *string `min:"1" type:"string"`

	// If you specify a value for MaxResults and you have more objects than the
	// number that you specify for MaxResults, Firewall Manager returns a NextToken
	// value in the response, which you can use to retrieve another group of objects.
	// For the second and subsequent GetProtectionStatus requests, specify the value
	// of NextToken from the previous response to get information about another
	// batch of objects.
	NextToken *string `min:"1" type:"string"`

	// The ID of the policy for which you want to get the attack information.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`

	// The start of the time period to query for the attacks. This is a timestamp
	// type. The request syntax listing indicates a number type because the default
	// used by Firewall Manager is Unix time in seconds. However, any valid timestamp
	// format is allowed.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProtectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProtectionStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MemberAccountId != nil && len(*s.MemberAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberAccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetProtectionStatusInput) SetEndTime(v time.Time) *GetProtectionStatusInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetProtectionStatusInput) SetMaxResults(v int64) *GetProtectionStatusInput {
	s.MaxResults = &v
	return s
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *GetProtectionStatusInput) SetMemberAccountId(v string) *GetProtectionStatusInput {
	s.MemberAccountId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetProtectionStatusInput) SetNextToken(v string) *GetProtectionStatusInput {
	s.NextToken = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetProtectionStatusInput) SetPolicyId(v string) *GetProtectionStatusInput {
	s.PolicyId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetProtectionStatusInput) SetStartTime(v time.Time) *GetProtectionStatusInput {
	s.StartTime = &v
	return s
}

type GetProtectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Firewall Manager administrator account for this policy.
	AdminAccountId *string `min:"1" type:"string"`

	// Details about the attack, including the following:
	//
	//    * Attack type
	//
	//    * Account ID
	//
	//    * ARN of the resource attacked
	//
	//    * Start time of the attack
	//
	//    * End time of the attack (ongoing attacks will not have an end time)
	//
	// The details are in JSON format.
	Data *string `type:"string"`

	// If you have more objects than the number that you specified for MaxResults
	// in the request, the response includes a NextToken value. To list more objects,
	// submit another GetProtectionStatus request, and specify the NextToken value
	// from the response in the NextToken value in the next request.
	//
	// Amazon Web Services SDKs provide auto-pagination that identify NextToken
	// in a response and make subsequent request calls automatically on your behalf.
	// However, this feature is not supported by GetProtectionStatus. You must submit
	// subsequent requests with NextToken using your own processes.
	NextToken *string `min:"1" type:"string"`

	// The service type that is protected by the policy. Currently, this is always
	// SHIELD_ADVANCED.
	ServiceType *string `type:"string" enum:"SecurityServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtectionStatusOutput) GoString() string {
	return s.String()
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *GetProtectionStatusOutput) SetAdminAccountId(v string) *GetProtectionStatusOutput {
	s.AdminAccountId = &v
	return s
}

// SetData sets the Data field's value.
func (s *GetProtectionStatusOutput) SetData(v string) *GetProtectionStatusOutput {
	s.Data = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetProtectionStatusOutput) SetNextToken(v string) *GetProtectionStatusOutput {
	s.NextToken = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetProtectionStatusOutput) SetServiceType(v string) *GetProtectionStatusOutput {
	s.ServiceType = &v
	return s
}

type GetProtocolsListInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the list to retrieve is a default list owned by Firewall
	// Manager.
	DefaultList *bool `type:"boolean"`

	// The ID of the Firewall Manager protocols list that you want the details for.
	//
	// ListId is a required field
	ListId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtocolsListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtocolsListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProtocolsListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProtocolsListInput"}
	if s.ListId == nil {
		invalidParams.Add(request.NewErrParamRequired("ListId"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ListId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultList sets the DefaultList field's value.
func (s *GetProtocolsListInput) SetDefaultList(v bool) *GetProtocolsListInput {
	s.DefaultList = &v
	return s
}

// SetListId sets the ListId field's value.
func (s *GetProtocolsListInput) SetListId(v string) *GetProtocolsListInput {
	s.ListId = &v
	return s
}

type GetProtocolsListOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified Firewall Manager protocols list.
	ProtocolsList *ProtocolsListData `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified protocols list.
	ProtocolsListArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtocolsListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProtocolsListOutput) GoString() string {
	return s.String()
}

// SetProtocolsList sets the ProtocolsList field's value.
func (s *GetProtocolsListOutput) SetProtocolsList(v *ProtocolsListData) *GetProtocolsListOutput {
	s.ProtocolsList = v
	return s
}

// SetProtocolsListArn sets the ProtocolsListArn field's value.
func (s *GetProtocolsListOutput) SetProtocolsListArn(v string) *GetProtocolsListOutput {
	s.ProtocolsListArn = &v
	return s
}

type GetResourceSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the resource set, used in a request to refer to the
	// resource set.
	//
	// Identifier is a required field
	Identifier *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceSetInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceSetInput) SetIdentifier(v string) *GetResourceSetInput {
	s.Identifier = &v
	return s
}

type GetResourceSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified resource set.
	//
	// ResourceSet is a required field
	ResourceSet *ResourceSet `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the resource set.
	//
	// ResourceSetArn is a required field
	ResourceSetArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetOutput) GoString() string {
	return s.String()
}

// SetResourceSet sets the ResourceSet field's value.
func (s *GetResourceSetOutput) SetResourceSet(v *ResourceSet) *GetResourceSetOutput {
	s.ResourceSet = v
	return s
}

// SetResourceSetArn sets the ResourceSetArn field's value.
func (s *GetResourceSetOutput) SetResourceSetArn(v string) *GetResourceSetOutput {
	s.ResourceSetArn = &v
	return s
}

type GetThirdPartyFirewallAssociationStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the third-party firewall vendor.
	//
	// ThirdPartyFirewall is a required field
	ThirdPartyFirewall *string `type:"string" required:"true" enum:"ThirdPartyFirewall"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyFirewallAssociationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyFirewallAssociationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThirdPartyFirewallAssociationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetThirdPartyFirewallAssociationStatusInput"}
	if s.ThirdPartyFirewall == nil {
		invalidParams.Add(request.NewErrParamRequired("ThirdPartyFirewall"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThirdPartyFirewall sets the ThirdPartyFirewall field's value.
func (s *GetThirdPartyFirewallAssociationStatusInput) SetThirdPartyFirewall(v string) *GetThirdPartyFirewallAssociationStatusInput {
	s.ThirdPartyFirewall = &v
	return s
}

type GetThirdPartyFirewallAssociationStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status for subscribing to the third-party firewall vendor in the Amazon
	// Web Services Marketplace.
	//
	//    * NO_SUBSCRIPTION - The Firewall Manager policy administrator isn't subscribed
	//    to the third-party firewall service in the Amazon Web Services Marketplace.
	//
	//    * NOT_COMPLETE - The Firewall Manager policy administrator is in the process
	//    of subscribing to the third-party firewall service in the Amazon Web Services
	//    Marketplace, but doesn't yet have an active subscription.
	//
	//    * COMPLETE - The Firewall Manager policy administrator has an active subscription
	//    to the third-party firewall service in the Amazon Web Services Marketplace.
	MarketplaceOnboardingStatus *string `type:"string" enum:"MarketplaceSubscriptionOnboardingStatus"`

	// The current status for setting a Firewall Manager policy administrators account
	// as an administrator of the third-party firewall tenant.
	//
	//    * ONBOARDING - The Firewall Manager policy administrator is being designated
	//    as a tenant administrator.
	//
	//    * ONBOARD_COMPLETE - The Firewall Manager policy administrator is designated
	//    as a tenant administrator.
	//
	//    * OFFBOARDING - The Firewall Manager policy administrator is being removed
	//    as a tenant administrator.
	//
	//    * OFFBOARD_COMPLETE - The Firewall Manager policy administrator has been
	//    removed as a tenant administrator.
	//
	//    * NOT_EXIST - The Firewall Manager policy administrator doesn't exist
	//    as a tenant administrator.
	ThirdPartyFirewallStatus *string `type:"string" enum:"ThirdPartyFirewallAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyFirewallAssociationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyFirewallAssociationStatusOutput) GoString() string {
	return s.String()
}

// SetMarketplaceOnboardingStatus sets the MarketplaceOnboardingStatus field's value.
func (s *GetThirdPartyFirewallAssociationStatusOutput) SetMarketplaceOnboardingStatus(v string) *GetThirdPartyFirewallAssociationStatusOutput {
	s.MarketplaceOnboardingStatus = &v
	return s
}

// SetThirdPartyFirewallStatus sets the ThirdPartyFirewallStatus field's value.
func (s *GetThirdPartyFirewallAssociationStatusOutput) SetThirdPartyFirewallStatus(v string) *GetThirdPartyFirewallAssociationStatusOutput {
	s.ThirdPartyFirewallStatus = &v
	return s
}

type GetViolationDetailsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that you want the details for.
	//
	// MemberAccount is a required field
	MemberAccount *string `min:"1" type:"string" required:"true"`

	// The ID of the Firewall Manager policy that you want the details for. This
	// currently only supports security group content audit policies.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`

	// The ID of the resource that has violations.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The resource type. This is in the format shown in the Amazon Web Services
	// Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// Supported resource types are: AWS::EC2::Instance, AWS::EC2::NetworkInterface,
	// AWS::EC2::SecurityGroup, AWS::NetworkFirewall::FirewallPolicy, and AWS::EC2::Subnet.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViolationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViolationDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetViolationDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetViolationDetailsInput"}
	if s.MemberAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberAccount"))
	}
	if s.MemberAccount != nil && len(*s.MemberAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberAccount", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *GetViolationDetailsInput) SetMemberAccount(v string) *GetViolationDetailsInput {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetViolationDetailsInput) SetPolicyId(v string) *GetViolationDetailsInput {
	s.PolicyId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetViolationDetailsInput) SetResourceId(v string) *GetViolationDetailsInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetViolationDetailsInput) SetResourceType(v string) *GetViolationDetailsInput {
	s.ResourceType = &v
	return s
}

type GetViolationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Violation detail for a resource.
	ViolationDetail *ViolationDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViolationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViolationDetailsOutput) GoString() string {
	return s.String()
}

// SetViolationDetail sets the ViolationDetail field's value.
func (s *GetViolationDetailsOutput) SetViolationDetail(v *ViolationDetail) *GetViolationDetailsOutput {
	s.ViolationDetail = v
	return s
}

// The operation failed because of a system problem, even though the request
// was valid. Retry your request.
type InternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalErrorException) Code() string {
	return "InternalErrorException"
}

// Message returns the exception's message.
func (s *InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalErrorException) OrigErr() error {
	return nil
}

func (s *InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The parameters of the request were invalid.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because there was nothing to do or the operation wasn't
// possible. For example, you might have submitted an AssociateAdminAccount
// request for an account ID that was already set as the Firewall Manager administrator.
// Or you might have tried to access a Region that's disabled by default, and
// that you need to enable for the Firewall Manager administrator account and
// for Organizations before you can access it.
type InvalidOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationException) GoString() string {
	return s.String()
}

func newErrorInvalidOperationException(v protocol.ResponseMetadata) error {
	return &InvalidOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidOperationException) Code() string {
	return "InvalidOperationException"
}

// Message returns the exception's message.
func (s *InvalidOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidOperationException) OrigErr() error {
	return nil
}

func (s *InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value of the Type parameter is invalid.
type InvalidTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) GoString() string {
	return s.String()
}

func newErrorInvalidTypeException(v protocol.ResponseMetadata) error {
	return &InvalidTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTypeException) Code() string {
	return "InvalidTypeException"
}

// Message returns the exception's message.
func (s *InvalidTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTypeException) OrigErr() error {
	return nil
}

func (s *InvalidTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation exceeds a resource limit, for example, the maximum number of
// policy objects that you can create for an Amazon Web Services account. For
// more information, see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
// in the WAF Developer Guide.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAdminAccountsForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Firewall Manager to return for
	// this request. If more objects are available, in the response, Firewall Manager
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminAccountsForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminAccountsForOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAdminAccountsForOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAdminAccountsForOrganizationInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAdminAccountsForOrganizationInput) SetMaxResults(v int64) *ListAdminAccountsForOrganizationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAdminAccountsForOrganizationInput) SetNextToken(v string) *ListAdminAccountsForOrganizationInput {
	s.NextToken = &v
	return s
}

type ListAdminAccountsForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A list of Firewall Manager administrator accounts within the organization
	// that were onboarded as administrators by AssociateAdminAccount or PutAdminAccount.
	AdminAccounts []*AdminAccountSummary `type:"list"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminAccountsForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminAccountsForOrganizationOutput) GoString() string {
	return s.String()
}

// SetAdminAccounts sets the AdminAccounts field's value.
func (s *ListAdminAccountsForOrganizationOutput) SetAdminAccounts(v []*AdminAccountSummary) *ListAdminAccountsForOrganizationOutput {
	s.AdminAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAdminAccountsForOrganizationOutput) SetNextToken(v string) *ListAdminAccountsForOrganizationOutput {
	s.NextToken = &v
	return s
}

type ListAdminsManagingAccountInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Firewall Manager to return for
	// this request. If more objects are available, in the response, Firewall Manager
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminsManagingAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminsManagingAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAdminsManagingAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAdminsManagingAccountInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAdminsManagingAccountInput) SetMaxResults(v int64) *ListAdminsManagingAccountInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAdminsManagingAccountInput) SetNextToken(v string) *ListAdminsManagingAccountInput {
	s.NextToken = &v
	return s
}

type ListAdminsManagingAccountOutput struct {
	_ struct{} `type:"structure"`

	// The list of accounts who manage member accounts within their AdminScope.
	AdminAccounts []*string `type:"list"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminsManagingAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAdminsManagingAccountOutput) GoString() string {
	return s.String()
}

// SetAdminAccounts sets the AdminAccounts field's value.
func (s *ListAdminsManagingAccountOutput) SetAdminAccounts(v []*string) *ListAdminsManagingAccountOutput {
	s.AdminAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAdminsManagingAccountOutput) SetNextToken(v string) *ListAdminsManagingAccountOutput {
	s.NextToken = &v
	return s
}

type ListAppsListsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the lists to retrieve are default lists owned by Firewall
	// Manager.
	DefaultLists *bool `type:"boolean"`

	// The maximum number of objects that you want Firewall Manager to return for
	// this request. If more objects are available, in the response, Firewall Manager
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	//
	// If you don't specify this, Firewall Manager returns all available objects.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for MaxResults in your list request, and you have
	// more objects than the maximum, Firewall Manager returns this token in the
	// response. For all but the first request, you provide the token returned by
	// the prior request in the request parameters, to retrieve the next batch of
	// objects.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsListsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsListsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppsListsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppsListsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultLists sets the DefaultLists field's value.
func (s *ListAppsListsInput) SetDefaultLists(v bool) *ListAppsListsInput {
	s.DefaultLists = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppsListsInput) SetMaxResults(v int64) *ListAppsListsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsListsInput) SetNextToken(v string) *ListAppsListsInput {
	s.NextToken = &v
	return s
}

type ListAppsListsOutput struct {
	_ struct{} `type:"structure"`

	// An array of AppsListDataSummary objects.
	AppsLists []*AppsListDataSummary `type:"list"`

	// If you specify a value for MaxResults in your list request, and you have
	// more objects than the maximum, Firewall Manager returns this token in the
	// response. You can use this token in subsequent requests to retrieve the next
	// batch of objects.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsListsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsListsOutput) GoString() string {
	return s.String()
}

// SetAppsLists sets the AppsLists field's value.
func (s *ListAppsListsOutput) SetAppsLists(v []*AppsListDataSummary) *ListAppsListsOutput {
	s.AppsLists = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsListsOutput) SetNextToken(v string) *ListAppsListsOutput {
	s.NextToken = &v
	return s
}

type ListComplianceStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of PolicyComplianceStatus objects that you want Firewall
	// Manager to return for this request. If you have more PolicyComplianceStatus
	// objects than the number that you specify for MaxResults, the response includes
	// a NextToken value that you can use to get another batch of PolicyComplianceStatus
	// objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify a value for MaxResults and you have more PolicyComplianceStatus
	// objects than the number that you specify for MaxResults, Firewall Manager
	// returns a NextToken value in the response that allows you to list another
	// group of PolicyComplianceStatus objects. For the second and subsequent ListComplianceStatus
	// requests, specify the value of NextToken from the previous response to get
	// information about another batch of PolicyComplianceStatus objects.
	NextToken *string `min:"1" type:"string"`

	// The ID of the Firewall Manager policy that you want the details for.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComplianceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComplianceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComplianceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComplianceStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComplianceStatusInput) SetMaxResults(v int64) *ListComplianceStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceStatusInput) SetNextToken(v string) *ListComplianceStatusInput {
	s.NextToken = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *ListComplianceStatusInput) SetPolicyId(v string) *ListComplianceStatusInput {
	s.PolicyId = &v
	return s
}

type ListComplianceStatusOutput struct {
	_ struct{} `type:"structure"`

	// If you have more PolicyComplianceStatus objects than the number that you
	// specified for MaxResults in the request, the response includes a NextToken
	// value. To list more PolicyComplianceStatus objects, submit another ListComplianceStatus
	// request, and specify the NextToken value from the response in the NextToken
	// value in the next request.
	NextToken *string `min:"1" type:"string"`

	// An array of PolicyComplianceStatus objects.
	PolicyComplianceStatusList []*PolicyComplianceStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComplianceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComplianceStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceStatusOutput) SetNextToken(v string) *ListComplianceStatusOutput {
	s.NextToken = &v
	return s
}

// SetPolicyComplianceStatusList sets the PolicyComplianceStatusList field's value.
func (s *ListComplianceStatusOutput) SetPolicyComplianceStatusList(v []*PolicyComplianceStatus) *ListComplianceStatusOutput {
	s.PolicyComplianceStatusList = v
	return s
}

type ListDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Firewall Manager to return for
	// this request. If more objects are available, in the response, Firewall Manager
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// The Amazon Web Services account IDs to discover resources in. Only one account
	// is supported per request. The account must be a member of your organization.
	//
	// MemberAccountIds is a required field
	MemberAccountIds []*string `type:"list" required:"true"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`

	// The type of resources to discover.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDiscoveredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDiscoveredResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MemberAccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberAccountIds"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDiscoveredResourcesInput) SetMaxResults(v int64) *ListDiscoveredResourcesInput {
	s.MaxResults = &v
	return s
}

// SetMemberAccountIds sets the MemberAccountIds field's value.
func (s *ListDiscoveredResourcesInput) SetMemberAccountIds(v []*string) *ListDiscoveredResourcesInput {
	s.MemberAccountIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesInput) SetNextToken(v string) *ListDiscoveredResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListDiscoveredResourcesInput) SetResourceType(v string) *ListDiscoveredResourcesInput {
	s.ResourceType = &v
	return s
}

type ListDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Details of the resources that were discovered.
	Items []*DiscoveredResource `type:"list"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDiscoveredResourcesOutput) SetItems(v []*DiscoveredResource) *ListDiscoveredResourcesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesOutput) SetNextToken(v string) *ListDiscoveredResourcesOutput {
	s.NextToken = &v
	return s
}

type ListMemberAccountsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of member account IDs that you want Firewall Manager
	// to return for this request. If you have more IDs than the number that you
	// specify for MaxResults, the response includes a NextToken value that you
	// can use to get another batch of member account IDs.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify a value for MaxResults and you have more account IDs than
	// the number that you specify for MaxResults, Firewall Manager returns a NextToken
	// value in the response that allows you to list another group of IDs. For the
	// second and subsequent ListMemberAccountsRequest requests, specify the value
	// of NextToken from the previous response to get information about another
	// batch of member account IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMemberAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMemberAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMemberAccountsInput) SetMaxResults(v int64) *ListMemberAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMemberAccountsInput) SetNextToken(v string) *ListMemberAccountsInput {
	s.NextToken = &v
	return s
}

type ListMemberAccountsOutput struct {
	_ struct{} `type:"structure"`

	// An array of account IDs.
	MemberAccounts []*string `type:"list"`

	// If you have more member account IDs than the number that you specified for
	// MaxResults in the request, the response includes a NextToken value. To list
	// more IDs, submit another ListMemberAccounts request, and specify the NextToken
	// value from the response in the NextToken value in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsOutput) GoString() string {
	return s.String()
}

// SetMemberAccounts sets the MemberAccounts field's value.
func (s *ListMemberAccountsOutput) SetMemberAccounts(v []*string) *ListMemberAccountsOutput {
	s.MemberAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMemberAccountsOutput) SetNextToken(v string) *ListMemberAccountsOutput {
	s.NextToken = &v
	return s
}

type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of PolicySummary objects that you want Firewall Manager
	// to return for this request. If you have more PolicySummary objects than the
	// number that you specify for MaxResults, the response includes a NextToken
	// value that you can use to get another batch of PolicySummary objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify a value for MaxResults and you have more PolicySummary objects
	// than the number that you specify for MaxResults, Firewall Manager returns
	// a NextToken value in the response that allows you to list another group of
	// PolicySummary objects. For the second and subsequent ListPolicies requests,
	// specify the value of NextToken from the previous response to get information
	// about another batch of PolicySummary objects.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoliciesInput) SetMaxResults(v int64) *ListPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesInput) SetNextToken(v string) *ListPoliciesInput {
	s.NextToken = &v
	return s
}

type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// If you have more PolicySummary objects than the number that you specified
	// for MaxResults in the request, the response includes a NextToken value. To
	// list more PolicySummary objects, submit another ListPolicies request, and
	// specify the NextToken value from the response in the NextToken value in the
	// next request.
	NextToken *string `min:"1" type:"string"`

	// An array of PolicySummary objects.
	PolicyList []*PolicySummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesOutput) SetNextToken(v string) *ListPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPolicyList sets the PolicyList field's value.
func (s *ListPoliciesOutput) SetPolicyList(v []*PolicySummary) *ListPoliciesOutput {
	s.PolicyList = v
	return s
}

type ListProtocolsListsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the lists to retrieve are default lists owned by Firewall
	// Manager.
	DefaultLists *bool `type:"boolean"`

	// The maximum number of objects that you want Firewall Manager to return for
	// this request. If more objects are available, in the response, Firewall Manager
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	//
	// If you don't specify this, Firewall Manager returns all available objects.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for MaxResults in your list request, and you have
	// more objects than the maximum, Firewall Manager returns this token in the
	// response. For all but the first request, you provide the token returned by
	// the prior request in the request parameters, to retrieve the next batch of
	// objects.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtocolsListsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtocolsListsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProtocolsListsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProtocolsListsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultLists sets the DefaultLists field's value.
func (s *ListProtocolsListsInput) SetDefaultLists(v bool) *ListProtocolsListsInput {
	s.DefaultLists = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProtocolsListsInput) SetMaxResults(v int64) *ListProtocolsListsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtocolsListsInput) SetNextToken(v string) *ListProtocolsListsInput {
	s.NextToken = &v
	return s
}

type ListProtocolsListsOutput struct {
	_ struct{} `type:"structure"`

	// If you specify a value for MaxResults in your list request, and you have
	// more objects than the maximum, Firewall Manager returns this token in the
	// response. You can use this token in subsequent requests to retrieve the next
	// batch of objects.
	NextToken *string `min:"1" type:"string"`

	// An array of ProtocolsListDataSummary objects.
	ProtocolsLists []*ProtocolsListDataSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtocolsListsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtocolsListsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtocolsListsOutput) SetNextToken(v string) *ListProtocolsListsOutput {
	s.NextToken = &v
	return s
}

// SetProtocolsLists sets the ProtocolsLists field's value.
func (s *ListProtocolsListsOutput) SetProtocolsLists(v []*ProtocolsListDataSummary) *ListProtocolsListsOutput {
	s.ProtocolsLists = v
	return s
}

type ListResourceSetResourcesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the resource set, used in a request to refer to the
	// resource set.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The maximum number of objects that you want Firewall Manager to return for
	// this request. If more objects are available, in the response, Firewall Manager
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceSetResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceSetResourcesInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *ListResourceSetResourcesInput) SetIdentifier(v string) *ListResourceSetResourcesInput {
	s.Identifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceSetResourcesInput) SetMaxResults(v int64) *ListResourceSetResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSetResourcesInput) SetNextToken(v string) *ListResourceSetResourcesInput {
	s.NextToken = &v
	return s
}

type ListResourceSetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// An array of the associated resources' uniform resource identifiers (URI).
	//
	// Items is a required field
	Items []*Resource `type:"list" required:"true"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetResourcesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListResourceSetResourcesOutput) SetItems(v []*Resource) *ListResourceSetResourcesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSetResourcesOutput) SetNextToken(v string) *ListResourceSetResourcesOutput {
	s.NextToken = &v
	return s
}

type ListResourceSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Firewall Manager to return for
	// this request. If more objects are available, in the response, Firewall Manager
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceSetsInput) SetMaxResults(v int64) *ListResourceSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSetsInput) SetNextToken(v string) *ListResourceSetsInput {
	s.NextToken = &v
	return s
}

type ListResourceSetsOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Firewall Manager returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`

	// An array of ResourceSetSummary objects.
	ResourceSets []*ResourceSetSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSetsOutput) SetNextToken(v string) *ListResourceSetsOutput {
	s.NextToken = &v
	return s
}

// SetResourceSets sets the ResourceSets field's value.
func (s *ListResourceSetsOutput) SetResourceSets(v []*ResourceSetSummary) *ListResourceSetsOutput {
	s.ResourceSets = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall
	// Manager resources that support tagging are policies, applications lists,
	// and protocols lists.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

type ListThirdPartyFirewallFirewallPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of third-party firewall policies that you want Firewall
	// Manager to return. If the specified third-party firewall vendor is associated
	// with more than MaxResults firewall policies, the response includes a NextToken
	// element. NextToken contains an encrypted token that identifies the first
	// third-party firewall policies that Firewall Manager will return if you submit
	// another request.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// If the previous response included a NextToken element, the specified third-party
	// firewall vendor is associated with more third-party firewall policies. To
	// get more third-party firewall policies, submit another ListThirdPartyFirewallFirewallPoliciesRequest
	// request.
	//
	// For the value of NextToken, specify the value of NextToken from the previous
	// response. If the previous response didn't include a NextToken element, there
	// are no more third-party firewall policies to get.
	NextToken *string `min:"1" type:"string"`

	// The name of the third-party firewall vendor.
	//
	// ThirdPartyFirewall is a required field
	ThirdPartyFirewall *string `type:"string" required:"true" enum:"ThirdPartyFirewall"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThirdPartyFirewallFirewallPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThirdPartyFirewallFirewallPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThirdPartyFirewallFirewallPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThirdPartyFirewallFirewallPoliciesInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ThirdPartyFirewall == nil {
		invalidParams.Add(request.NewErrParamRequired("ThirdPartyFirewall"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListThirdPartyFirewallFirewallPoliciesInput) SetMaxResults(v int64) *ListThirdPartyFirewallFirewallPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThirdPartyFirewallFirewallPoliciesInput) SetNextToken(v string) *ListThirdPartyFirewallFirewallPoliciesInput {
	s.NextToken = &v
	return s
}

// SetThirdPartyFirewall sets the ThirdPartyFirewall field's value.
func (s *ListThirdPartyFirewallFirewallPoliciesInput) SetThirdPartyFirewall(v string) *ListThirdPartyFirewallFirewallPoliciesInput {
	s.ThirdPartyFirewall = &v
	return s
}

type ListThirdPartyFirewallFirewallPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The value that you will use for NextToken in the next ListThirdPartyFirewallFirewallPolicies
	// request.
	NextToken *string `min:"1" type:"string"`

	// A list that contains one ThirdPartyFirewallFirewallPolicies element for each
	// third-party firewall policies that the specified third-party firewall vendor
	// is associated with. Each ThirdPartyFirewallFirewallPolicies element contains
	// the firewall policy name and ID.
	ThirdPartyFirewallFirewallPolicies []*ThirdPartyFirewallFirewallPolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThirdPartyFirewallFirewallPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThirdPartyFirewallFirewallPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListThirdPartyFirewallFirewallPoliciesOutput) SetNextToken(v string) *ListThirdPartyFirewallFirewallPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetThirdPartyFirewallFirewallPolicies sets the ThirdPartyFirewallFirewallPolicies field's value.
func (s *ListThirdPartyFirewallFirewallPoliciesOutput) SetThirdPartyFirewallFirewallPolicies(v []*ThirdPartyFirewallFirewallPolicy) *ListThirdPartyFirewallFirewallPoliciesOutput {
	s.ThirdPartyFirewallFirewallPolicies = v
	return s
}

// Violation detail for an internet gateway route with an inactive state in
// the customer subnet route table or Network Firewall subnet route table.
type NetworkFirewallBlackHoleRouteDetectedViolation struct {
	_ struct{} `type:"structure"`

	// Information about the route table ID.
	RouteTableId *string `min:"1" type:"string"`

	// Information about the route or routes that are in violation.
	ViolatingRoutes []*Route `type:"list"`

	// The subnet that has an inactive state.
	ViolationTarget *string `type:"string"`

	// Information about the VPC ID.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallBlackHoleRouteDetectedViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallBlackHoleRouteDetectedViolation) GoString() string {
	return s.String()
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *NetworkFirewallBlackHoleRouteDetectedViolation) SetRouteTableId(v string) *NetworkFirewallBlackHoleRouteDetectedViolation {
	s.RouteTableId = &v
	return s
}

// SetViolatingRoutes sets the ViolatingRoutes field's value.
func (s *NetworkFirewallBlackHoleRouteDetectedViolation) SetViolatingRoutes(v []*Route) *NetworkFirewallBlackHoleRouteDetectedViolation {
	s.ViolatingRoutes = v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *NetworkFirewallBlackHoleRouteDetectedViolation) SetViolationTarget(v string) *NetworkFirewallBlackHoleRouteDetectedViolation {
	s.ViolationTarget = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkFirewallBlackHoleRouteDetectedViolation) SetVpcId(v string) *NetworkFirewallBlackHoleRouteDetectedViolation {
	s.VpcId = &v
	return s
}

// Violation detail for the subnet for which internet traffic that hasn't been
// inspected.
type NetworkFirewallInternetTrafficNotInspectedViolation struct {
	_ struct{} `type:"structure"`

	// The actual firewall subnet routes.
	ActualFirewallSubnetRoutes []*Route `type:"list"`

	// The actual internet gateway routes.
	ActualInternetGatewayRoutes []*Route `type:"list"`

	// Information about the subnet route table for the current firewall.
	CurrentFirewallSubnetRouteTable *string `min:"1" type:"string"`

	// The current route table for the internet gateway.
	CurrentInternetGatewayRouteTable *string `min:"1" type:"string"`

	// The expected endpoint for the current firewall.
	ExpectedFirewallEndpoint *string `min:"1" type:"string"`

	// The firewall subnet routes that are expected.
	ExpectedFirewallSubnetRoutes []*ExpectedRoute `type:"list"`

	// The internet gateway routes that are expected.
	ExpectedInternetGatewayRoutes []*ExpectedRoute `type:"list"`

	// The firewall subnet ID.
	FirewallSubnetId *string `min:"1" type:"string"`

	// The internet gateway ID.
	InternetGatewayId *string `min:"1" type:"string"`

	// Information about whether the route table is used in another Availability
	// Zone.
	IsRouteTableUsedInDifferentAZ *bool `type:"boolean"`

	// Information about the route table ID.
	RouteTableId *string `min:"1" type:"string"`

	// The subnet Availability Zone.
	SubnetAvailabilityZone *string `type:"string"`

	// The subnet ID.
	SubnetId *string `min:"1" type:"string"`

	// The route or routes that are in violation.
	ViolatingRoutes []*Route `type:"list"`

	// Information about the VPC ID.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallInternetTrafficNotInspectedViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallInternetTrafficNotInspectedViolation) GoString() string {
	return s.String()
}

// SetActualFirewallSubnetRoutes sets the ActualFirewallSubnetRoutes field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetActualFirewallSubnetRoutes(v []*Route) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.ActualFirewallSubnetRoutes = v
	return s
}

// SetActualInternetGatewayRoutes sets the ActualInternetGatewayRoutes field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetActualInternetGatewayRoutes(v []*Route) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.ActualInternetGatewayRoutes = v
	return s
}

// SetCurrentFirewallSubnetRouteTable sets the CurrentFirewallSubnetRouteTable field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetCurrentFirewallSubnetRouteTable(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.CurrentFirewallSubnetRouteTable = &v
	return s
}

// SetCurrentInternetGatewayRouteTable sets the CurrentInternetGatewayRouteTable field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetCurrentInternetGatewayRouteTable(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.CurrentInternetGatewayRouteTable = &v
	return s
}

// SetExpectedFirewallEndpoint sets the ExpectedFirewallEndpoint field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetExpectedFirewallEndpoint(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.ExpectedFirewallEndpoint = &v
	return s
}

// SetExpectedFirewallSubnetRoutes sets the ExpectedFirewallSubnetRoutes field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetExpectedFirewallSubnetRoutes(v []*ExpectedRoute) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.ExpectedFirewallSubnetRoutes = v
	return s
}

// SetExpectedInternetGatewayRoutes sets the ExpectedInternetGatewayRoutes field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetExpectedInternetGatewayRoutes(v []*ExpectedRoute) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.ExpectedInternetGatewayRoutes = v
	return s
}

// SetFirewallSubnetId sets the FirewallSubnetId field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetFirewallSubnetId(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.FirewallSubnetId = &v
	return s
}

// SetInternetGatewayId sets the InternetGatewayId field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetInternetGatewayId(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.InternetGatewayId = &v
	return s
}

// SetIsRouteTableUsedInDifferentAZ sets the IsRouteTableUsedInDifferentAZ field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetIsRouteTableUsedInDifferentAZ(v bool) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.IsRouteTableUsedInDifferentAZ = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetRouteTableId(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.RouteTableId = &v
	return s
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetSubnetAvailabilityZone(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.SubnetAvailabilityZone = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetSubnetId(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.SubnetId = &v
	return s
}

// SetViolatingRoutes sets the ViolatingRoutes field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetViolatingRoutes(v []*Route) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.ViolatingRoutes = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkFirewallInternetTrafficNotInspectedViolation) SetVpcId(v string) *NetworkFirewallInternetTrafficNotInspectedViolation {
	s.VpcId = &v
	return s
}

// Violation detail for the improperly configured subnet route. It's possible
// there is a missing route table route, or a configuration that causes traffic
// to cross an Availability Zone boundary.
type NetworkFirewallInvalidRouteConfigurationViolation struct {
	_ struct{} `type:"structure"`

	// The actual firewall endpoint.
	ActualFirewallEndpoint *string `min:"1" type:"string"`

	// The actual subnet ID for the firewall.
	ActualFirewallSubnetId *string `min:"1" type:"string"`

	// The actual firewall subnet routes that are expected.
	ActualFirewallSubnetRoutes []*Route `type:"list"`

	// The actual internet gateway routes.
	ActualInternetGatewayRoutes []*Route `type:"list"`

	// The subnets that are affected.
	AffectedSubnets []*string `type:"list"`

	// The subnet route table for the current firewall.
	CurrentFirewallSubnetRouteTable *string `min:"1" type:"string"`

	// The route table for the current internet gateway.
	CurrentInternetGatewayRouteTable *string `min:"1" type:"string"`

	// The firewall endpoint that's expected.
	ExpectedFirewallEndpoint *string `min:"1" type:"string"`

	// The expected subnet ID for the firewall.
	ExpectedFirewallSubnetId *string `min:"1" type:"string"`

	// The firewall subnet routes that are expected.
	ExpectedFirewallSubnetRoutes []*ExpectedRoute `type:"list"`

	// The expected routes for the internet gateway.
	ExpectedInternetGatewayRoutes []*ExpectedRoute `type:"list"`

	// The internet gateway ID.
	InternetGatewayId *string `min:"1" type:"string"`

	// Information about whether the route table is used in another Availability
	// Zone.
	IsRouteTableUsedInDifferentAZ *bool `type:"boolean"`

	// The route table ID.
	RouteTableId *string `min:"1" type:"string"`

	// The route that's in violation.
	ViolatingRoute *Route `type:"structure"`

	// Information about the VPC ID.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallInvalidRouteConfigurationViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallInvalidRouteConfigurationViolation) GoString() string {
	return s.String()
}

// SetActualFirewallEndpoint sets the ActualFirewallEndpoint field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetActualFirewallEndpoint(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ActualFirewallEndpoint = &v
	return s
}

// SetActualFirewallSubnetId sets the ActualFirewallSubnetId field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetActualFirewallSubnetId(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ActualFirewallSubnetId = &v
	return s
}

// SetActualFirewallSubnetRoutes sets the ActualFirewallSubnetRoutes field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetActualFirewallSubnetRoutes(v []*Route) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ActualFirewallSubnetRoutes = v
	return s
}

// SetActualInternetGatewayRoutes sets the ActualInternetGatewayRoutes field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetActualInternetGatewayRoutes(v []*Route) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ActualInternetGatewayRoutes = v
	return s
}

// SetAffectedSubnets sets the AffectedSubnets field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetAffectedSubnets(v []*string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.AffectedSubnets = v
	return s
}

// SetCurrentFirewallSubnetRouteTable sets the CurrentFirewallSubnetRouteTable field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetCurrentFirewallSubnetRouteTable(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.CurrentFirewallSubnetRouteTable = &v
	return s
}

// SetCurrentInternetGatewayRouteTable sets the CurrentInternetGatewayRouteTable field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetCurrentInternetGatewayRouteTable(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.CurrentInternetGatewayRouteTable = &v
	return s
}

// SetExpectedFirewallEndpoint sets the ExpectedFirewallEndpoint field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetExpectedFirewallEndpoint(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ExpectedFirewallEndpoint = &v
	return s
}

// SetExpectedFirewallSubnetId sets the ExpectedFirewallSubnetId field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetExpectedFirewallSubnetId(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ExpectedFirewallSubnetId = &v
	return s
}

// SetExpectedFirewallSubnetRoutes sets the ExpectedFirewallSubnetRoutes field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetExpectedFirewallSubnetRoutes(v []*ExpectedRoute) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ExpectedFirewallSubnetRoutes = v
	return s
}

// SetExpectedInternetGatewayRoutes sets the ExpectedInternetGatewayRoutes field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetExpectedInternetGatewayRoutes(v []*ExpectedRoute) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ExpectedInternetGatewayRoutes = v
	return s
}

// SetInternetGatewayId sets the InternetGatewayId field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetInternetGatewayId(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.InternetGatewayId = &v
	return s
}

// SetIsRouteTableUsedInDifferentAZ sets the IsRouteTableUsedInDifferentAZ field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetIsRouteTableUsedInDifferentAZ(v bool) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.IsRouteTableUsedInDifferentAZ = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetRouteTableId(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.RouteTableId = &v
	return s
}

// SetViolatingRoute sets the ViolatingRoute field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetViolatingRoute(v *Route) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.ViolatingRoute = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkFirewallInvalidRouteConfigurationViolation) SetVpcId(v string) *NetworkFirewallInvalidRouteConfigurationViolation {
	s.VpcId = &v
	return s
}

// Violation detail for Network Firewall for a subnet that's not associated
// to the expected Firewall Manager managed route table.
type NetworkFirewallMissingExpectedRTViolation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of a violating subnet.
	AvailabilityZone *string `type:"string"`

	// The resource ID of the current route table that's associated with the subnet,
	// if one is available.
	CurrentRouteTable *string `min:"1" type:"string"`

	// The resource ID of the route table that should be associated with the subnet.
	ExpectedRouteTable *string `min:"1" type:"string"`

	// The resource ID of the VPC associated with a violating subnet.
	VPC *string `min:"1" type:"string"`

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingExpectedRTViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingExpectedRTViolation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *NetworkFirewallMissingExpectedRTViolation) SetAvailabilityZone(v string) *NetworkFirewallMissingExpectedRTViolation {
	s.AvailabilityZone = &v
	return s
}

// SetCurrentRouteTable sets the CurrentRouteTable field's value.
func (s *NetworkFirewallMissingExpectedRTViolation) SetCurrentRouteTable(v string) *NetworkFirewallMissingExpectedRTViolation {
	s.CurrentRouteTable = &v
	return s
}

// SetExpectedRouteTable sets the ExpectedRouteTable field's value.
func (s *NetworkFirewallMissingExpectedRTViolation) SetExpectedRouteTable(v string) *NetworkFirewallMissingExpectedRTViolation {
	s.ExpectedRouteTable = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *NetworkFirewallMissingExpectedRTViolation) SetVPC(v string) *NetworkFirewallMissingExpectedRTViolation {
	s.VPC = &v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *NetworkFirewallMissingExpectedRTViolation) SetViolationTarget(v string) *NetworkFirewallMissingExpectedRTViolation {
	s.ViolationTarget = &v
	return s
}

// Violation detail for an expected route missing in Network Firewall.
type NetworkFirewallMissingExpectedRoutesViolation struct {
	_ struct{} `type:"structure"`

	// The expected routes.
	ExpectedRoutes []*ExpectedRoute `type:"list"`

	// The target of the violation.
	ViolationTarget *string `type:"string"`

	// Information about the VPC ID.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingExpectedRoutesViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingExpectedRoutesViolation) GoString() string {
	return s.String()
}

// SetExpectedRoutes sets the ExpectedRoutes field's value.
func (s *NetworkFirewallMissingExpectedRoutesViolation) SetExpectedRoutes(v []*ExpectedRoute) *NetworkFirewallMissingExpectedRoutesViolation {
	s.ExpectedRoutes = v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *NetworkFirewallMissingExpectedRoutesViolation) SetViolationTarget(v string) *NetworkFirewallMissingExpectedRoutesViolation {
	s.ViolationTarget = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkFirewallMissingExpectedRoutesViolation) SetVpcId(v string) *NetworkFirewallMissingExpectedRoutesViolation {
	s.VpcId = &v
	return s
}

// Violation detail for Network Firewall for a subnet that doesn't have a Firewall
// Manager managed firewall in its VPC.
type NetworkFirewallMissingFirewallViolation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of a violating subnet.
	AvailabilityZone *string `type:"string"`

	// The reason the resource has this violation, if one is available.
	TargetViolationReason *string `type:"string"`

	// The resource ID of the VPC associated with a violating subnet.
	VPC *string `min:"1" type:"string"`

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingFirewallViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingFirewallViolation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *NetworkFirewallMissingFirewallViolation) SetAvailabilityZone(v string) *NetworkFirewallMissingFirewallViolation {
	s.AvailabilityZone = &v
	return s
}

// SetTargetViolationReason sets the TargetViolationReason field's value.
func (s *NetworkFirewallMissingFirewallViolation) SetTargetViolationReason(v string) *NetworkFirewallMissingFirewallViolation {
	s.TargetViolationReason = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *NetworkFirewallMissingFirewallViolation) SetVPC(v string) *NetworkFirewallMissingFirewallViolation {
	s.VPC = &v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *NetworkFirewallMissingFirewallViolation) SetViolationTarget(v string) *NetworkFirewallMissingFirewallViolation {
	s.ViolationTarget = &v
	return s
}

// Violation detail for Network Firewall for an Availability Zone that's missing
// the expected Firewall Manager managed subnet.
type NetworkFirewallMissingSubnetViolation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of a violating subnet.
	AvailabilityZone *string `type:"string"`

	// The reason the resource has this violation, if one is available.
	TargetViolationReason *string `type:"string"`

	// The resource ID of the VPC associated with a violating subnet.
	VPC *string `min:"1" type:"string"`

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingSubnetViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallMissingSubnetViolation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *NetworkFirewallMissingSubnetViolation) SetAvailabilityZone(v string) *NetworkFirewallMissingSubnetViolation {
	s.AvailabilityZone = &v
	return s
}

// SetTargetViolationReason sets the TargetViolationReason field's value.
func (s *NetworkFirewallMissingSubnetViolation) SetTargetViolationReason(v string) *NetworkFirewallMissingSubnetViolation {
	s.TargetViolationReason = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *NetworkFirewallMissingSubnetViolation) SetVPC(v string) *NetworkFirewallMissingSubnetViolation {
	s.VPC = &v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *NetworkFirewallMissingSubnetViolation) SetViolationTarget(v string) *NetworkFirewallMissingSubnetViolation {
	s.ViolationTarget = &v
	return s
}

// Configures the firewall policy deployment model of Network Firewall. For
// information about Network Firewall deployment models, see Network Firewall
// example architectures with routing (https://docs.aws.amazon.com/network-firewall/latest/developerguide/architectures.html)
// in the Network Firewall Developer Guide.
type NetworkFirewallPolicy struct {
	_ struct{} `type:"structure"`

	// Defines the deployment model to use for the firewall policy. To use a distributed
	// model, set PolicyOption (https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html)
	// to NULL.
	FirewallDeploymentModel *string `type:"string" enum:"FirewallDeploymentModel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallPolicy) GoString() string {
	return s.String()
}

// SetFirewallDeploymentModel sets the FirewallDeploymentModel field's value.
func (s *NetworkFirewallPolicy) SetFirewallDeploymentModel(v string) *NetworkFirewallPolicy {
	s.FirewallDeploymentModel = &v
	return s
}

// The definition of the Network Firewall firewall policy.
type NetworkFirewallPolicyDescription struct {
	_ struct{} `type:"structure"`

	// The default actions to take on a packet that doesn't match any stateful rules.
	// The stateful default action is optional, and is only valid when using the
	// strict rule order.
	//
	// Valid values of the stateful default action:
	//
	//    * aws:drop_strict
	//
	//    * aws:drop_established
	//
	//    * aws:alert_strict
	//
	//    * aws:alert_established
	StatefulDefaultActions []*string `type:"list"`

	// Additional options governing how Network Firewall handles stateful rules.
	// The stateful rule groups that you use in your policy must have stateful rule
	// options settings that are compatible with these settings.
	StatefulEngineOptions *StatefulEngineOptions `type:"structure"`

	// The stateful rule groups that are used in the Network Firewall firewall policy.
	StatefulRuleGroups []*StatefulRuleGroup `type:"list"`

	// Names of custom actions that are available for use in the stateless default
	// actions settings.
	StatelessCustomActions []*string `type:"list"`

	// The actions to take on packets that don't match any of the stateless rule
	// groups.
	StatelessDefaultActions []*string `type:"list"`

	// The actions to take on packet fragments that don't match any of the stateless
	// rule groups.
	StatelessFragmentDefaultActions []*string `type:"list"`

	// The stateless rule groups that are used in the Network Firewall firewall
	// policy.
	StatelessRuleGroups []*StatelessRuleGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallPolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallPolicyDescription) GoString() string {
	return s.String()
}

// SetStatefulDefaultActions sets the StatefulDefaultActions field's value.
func (s *NetworkFirewallPolicyDescription) SetStatefulDefaultActions(v []*string) *NetworkFirewallPolicyDescription {
	s.StatefulDefaultActions = v
	return s
}

// SetStatefulEngineOptions sets the StatefulEngineOptions field's value.
func (s *NetworkFirewallPolicyDescription) SetStatefulEngineOptions(v *StatefulEngineOptions) *NetworkFirewallPolicyDescription {
	s.StatefulEngineOptions = v
	return s
}

// SetStatefulRuleGroups sets the StatefulRuleGroups field's value.
func (s *NetworkFirewallPolicyDescription) SetStatefulRuleGroups(v []*StatefulRuleGroup) *NetworkFirewallPolicyDescription {
	s.StatefulRuleGroups = v
	return s
}

// SetStatelessCustomActions sets the StatelessCustomActions field's value.
func (s *NetworkFirewallPolicyDescription) SetStatelessCustomActions(v []*string) *NetworkFirewallPolicyDescription {
	s.StatelessCustomActions = v
	return s
}

// SetStatelessDefaultActions sets the StatelessDefaultActions field's value.
func (s *NetworkFirewallPolicyDescription) SetStatelessDefaultActions(v []*string) *NetworkFirewallPolicyDescription {
	s.StatelessDefaultActions = v
	return s
}

// SetStatelessFragmentDefaultActions sets the StatelessFragmentDefaultActions field's value.
func (s *NetworkFirewallPolicyDescription) SetStatelessFragmentDefaultActions(v []*string) *NetworkFirewallPolicyDescription {
	s.StatelessFragmentDefaultActions = v
	return s
}

// SetStatelessRuleGroups sets the StatelessRuleGroups field's value.
func (s *NetworkFirewallPolicyDescription) SetStatelessRuleGroups(v []*StatelessRuleGroup) *NetworkFirewallPolicyDescription {
	s.StatelessRuleGroups = v
	return s
}

// Violation detail for Network Firewall for a firewall policy that has a different
// NetworkFirewallPolicyDescription than is required by the Firewall Manager
// policy.
type NetworkFirewallPolicyModifiedViolation struct {
	_ struct{} `type:"structure"`

	// The policy that's currently in use in the individual account.
	CurrentPolicyDescription *NetworkFirewallPolicyDescription `type:"structure"`

	// The policy that should be in use in the individual account in order to be
	// compliant.
	ExpectedPolicyDescription *NetworkFirewallPolicyDescription `type:"structure"`

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallPolicyModifiedViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallPolicyModifiedViolation) GoString() string {
	return s.String()
}

// SetCurrentPolicyDescription sets the CurrentPolicyDescription field's value.
func (s *NetworkFirewallPolicyModifiedViolation) SetCurrentPolicyDescription(v *NetworkFirewallPolicyDescription) *NetworkFirewallPolicyModifiedViolation {
	s.CurrentPolicyDescription = v
	return s
}

// SetExpectedPolicyDescription sets the ExpectedPolicyDescription field's value.
func (s *NetworkFirewallPolicyModifiedViolation) SetExpectedPolicyDescription(v *NetworkFirewallPolicyDescription) *NetworkFirewallPolicyModifiedViolation {
	s.ExpectedPolicyDescription = v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *NetworkFirewallPolicyModifiedViolation) SetViolationTarget(v string) *NetworkFirewallPolicyModifiedViolation {
	s.ViolationTarget = &v
	return s
}

// The setting that allows the policy owner to change the behavior of the rule
// group within a policy.
type NetworkFirewallStatefulRuleGroupOverride struct {
	_ struct{} `type:"structure"`

	// The action that changes the rule group from DROP to ALERT. This only applies
	// to managed rule groups.
	Action *string `type:"string" enum:"NetworkFirewallOverrideAction"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallStatefulRuleGroupOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallStatefulRuleGroupOverride) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *NetworkFirewallStatefulRuleGroupOverride) SetAction(v string) *NetworkFirewallStatefulRuleGroupOverride {
	s.Action = &v
	return s
}

// Violation detail for an unexpected route that's present in a route table.
type NetworkFirewallUnexpectedFirewallRoutesViolation struct {
	_ struct{} `type:"structure"`

	// The endpoint of the firewall.
	FirewallEndpoint *string `min:"1" type:"string"`

	// The subnet ID for the firewall.
	FirewallSubnetId *string `min:"1" type:"string"`

	// The ID of the route table.
	RouteTableId *string `min:"1" type:"string"`

	// The routes that are in violation.
	ViolatingRoutes []*Route `type:"list"`

	// Information about the VPC ID.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallUnexpectedFirewallRoutesViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallUnexpectedFirewallRoutesViolation) GoString() string {
	return s.String()
}

// SetFirewallEndpoint sets the FirewallEndpoint field's value.
func (s *NetworkFirewallUnexpectedFirewallRoutesViolation) SetFirewallEndpoint(v string) *NetworkFirewallUnexpectedFirewallRoutesViolation {
	s.FirewallEndpoint = &v
	return s
}

// SetFirewallSubnetId sets the FirewallSubnetId field's value.
func (s *NetworkFirewallUnexpectedFirewallRoutesViolation) SetFirewallSubnetId(v string) *NetworkFirewallUnexpectedFirewallRoutesViolation {
	s.FirewallSubnetId = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *NetworkFirewallUnexpectedFirewallRoutesViolation) SetRouteTableId(v string) *NetworkFirewallUnexpectedFirewallRoutesViolation {
	s.RouteTableId = &v
	return s
}

// SetViolatingRoutes sets the ViolatingRoutes field's value.
func (s *NetworkFirewallUnexpectedFirewallRoutesViolation) SetViolatingRoutes(v []*Route) *NetworkFirewallUnexpectedFirewallRoutesViolation {
	s.ViolatingRoutes = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkFirewallUnexpectedFirewallRoutesViolation) SetVpcId(v string) *NetworkFirewallUnexpectedFirewallRoutesViolation {
	s.VpcId = &v
	return s
}

// Violation detail for an unexpected gateway route that’s present in a route
// table.
type NetworkFirewallUnexpectedGatewayRoutesViolation struct {
	_ struct{} `type:"structure"`

	// Information about the gateway ID.
	GatewayId *string `min:"1" type:"string"`

	// Information about the route table.
	RouteTableId *string `min:"1" type:"string"`

	// The routes that are in violation.
	ViolatingRoutes []*Route `type:"list"`

	// Information about the VPC ID.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallUnexpectedGatewayRoutesViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFirewallUnexpectedGatewayRoutesViolation) GoString() string {
	return s.String()
}

// SetGatewayId sets the GatewayId field's value.
func (s *NetworkFirewallUnexpectedGatewayRoutesViolation) SetGatewayId(v string) *NetworkFirewallUnexpectedGatewayRoutesViolation {
	s.GatewayId = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *NetworkFirewallUnexpectedGatewayRoutesViolation) SetRouteTableId(v string) *NetworkFirewallUnexpectedGatewayRoutesViolation {
	s.RouteTableId = &v
	return s
}

// SetViolatingRoutes sets the ViolatingRoutes field's value.
func (s *NetworkFirewallUnexpectedGatewayRoutesViolation) SetViolatingRoutes(v []*Route) *NetworkFirewallUnexpectedGatewayRoutesViolation {
	s.ViolatingRoutes = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkFirewallUnexpectedGatewayRoutesViolation) SetVpcId(v string) *NetworkFirewallUnexpectedGatewayRoutesViolation {
	s.VpcId = &v
	return s
}

// Defines the Organizations organizational units (OUs) that the specified Firewall
// Manager administrator can apply policies to. For more information about OUs
// in Organizations, see Managing organizational units (OUs) (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html)
// in the Organizations User Guide.
type OrganizationalUnitScope struct {
	_ struct{} `type:"structure"`

	// A boolean value that indicates if the administrator can apply policies to
	// all OUs within an organization. If true, the administrator can manage all
	// OUs within the organization. You can either enable management of all OUs
	// through this operation, or you can specify OUs to manage in OrganizationalUnitScope$OrganizationalUnits.
	// You cannot specify both.
	AllOrganizationalUnitsEnabled *bool `type:"boolean"`

	// A boolean value that excludes the OUs in OrganizationalUnitScope$OrganizationalUnits
	// from the administrator's scope. If true, the Firewall Manager administrator
	// can apply policies to all OUs in the organization except for the OUs listed
	// in OrganizationalUnitScope$OrganizationalUnits. You can either specify a
	// list of OUs to exclude by OrganizationalUnitScope$OrganizationalUnits, or
	// you can enable management of all OUs by OrganizationalUnitScope$AllOrganizationalUnitsEnabled.
	// You cannot specify both.
	ExcludeSpecifiedOrganizationalUnits *bool `type:"boolean"`

	// The list of OUs within the organization that the specified Firewall Manager
	// administrator either can or cannot apply policies to, based on the value
	// of OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits. If OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits
	// is set to true, then the Firewall Manager administrator can apply policies
	// to all OUs in the organization except for the OUs in this list. If OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits
	// is set to false, then the Firewall Manager administrator can only apply policies
	// to the OUs in this list.
	OrganizationalUnits []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationalUnitScope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationalUnitScope) GoString() string {
	return s.String()
}

// SetAllOrganizationalUnitsEnabled sets the AllOrganizationalUnitsEnabled field's value.
func (s *OrganizationalUnitScope) SetAllOrganizationalUnitsEnabled(v bool) *OrganizationalUnitScope {
	s.AllOrganizationalUnitsEnabled = &v
	return s
}

// SetExcludeSpecifiedOrganizationalUnits sets the ExcludeSpecifiedOrganizationalUnits field's value.
func (s *OrganizationalUnitScope) SetExcludeSpecifiedOrganizationalUnits(v bool) *OrganizationalUnitScope {
	s.ExcludeSpecifiedOrganizationalUnits = &v
	return s
}

// SetOrganizationalUnits sets the OrganizationalUnits field's value.
func (s *OrganizationalUnitScope) SetOrganizationalUnits(v []*string) *OrganizationalUnitScope {
	s.OrganizationalUnits = v
	return s
}

// The reference rule that partially matches the ViolationTarget rule and violation
// reason.
type PartialMatch struct {
	_ struct{} `type:"structure"`

	// The reference rule from the primary security group of the Firewall Manager
	// policy.
	Reference *string `type:"string"`

	// The violation reason.
	TargetViolationReasons []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartialMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartialMatch) GoString() string {
	return s.String()
}

// SetReference sets the Reference field's value.
func (s *PartialMatch) SetReference(v string) *PartialMatch {
	s.Reference = &v
	return s
}

// SetTargetViolationReasons sets the TargetViolationReasons field's value.
func (s *PartialMatch) SetTargetViolationReasons(v []*string) *PartialMatch {
	s.TargetViolationReasons = v
	return s
}

// An Firewall Manager policy.
type Policy struct {
	_ struct{} `type:"structure"`

	// Indicates whether Firewall Manager should automatically remove protections
	// from resources that leave the policy scope and clean up resources that Firewall
	// Manager is managing for accounts when those accounts leave policy scope.
	// For example, Firewall Manager will disassociate a Firewall Manager managed
	// web ACL from a protected customer resource when the customer resource leaves
	// policy scope.
	//
	// By default, Firewall Manager doesn't remove protections or delete Firewall
	// Manager managed resources.
	//
	// This option is not available for Shield Advanced or WAF Classic policies.
	DeleteUnusedFMManagedResources *bool `type:"boolean"`

	// Specifies the Amazon Web Services account IDs and Organizations organizational
	// units (OUs) to exclude from the policy. Specifying an OU is the equivalent
	// of specifying all accounts in the OU and in any of its child OUs, including
	// any child OUs and accounts that are added at a later time.
	//
	// You can specify inclusions or exclusions, but not both. If you specify an
	// IncludeMap, Firewall Manager applies the policy to all accounts specified
	// by the IncludeMap, and does not evaluate any ExcludeMap specifications. If
	// you do not specify an IncludeMap, then Firewall Manager applies the policy
	// to all accounts except for those specified by the ExcludeMap.
	//
	// You can specify account IDs, OUs, or a combination:
	//
	//    * Specify account IDs by setting the key to ACCOUNT. For example, the
	//    following is a valid map: {“ACCOUNT” : [“accountID1”, “accountID2”]}.
	//
	//    * Specify OUs by setting the key to ORG_UNIT. For example, the following
	//    is a valid map: {“ORG_UNIT” : [“ouid111”, “ouid112”]}.
	//
	//    * Specify accounts and OUs together in a single map, separated with a
	//    comma. For example, the following is a valid map: {“ACCOUNT” : [“accountID1”,
	//    “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}.
	ExcludeMap map[string][]*string `type:"map"`

	// If set to True, resources with the tags that are specified in the ResourceTag
	// array are not in scope of the policy. If set to False, and the ResourceTag
	// array is not null, only resources with the specified tags are in scope of
	// the policy.
	//
	// ExcludeResourceTags is a required field
	ExcludeResourceTags *bool `type:"boolean" required:"true"`

	// Specifies the Amazon Web Services account IDs and Organizations organizational
	// units (OUs) to include in the policy. Specifying an OU is the equivalent
	// of specifying all accounts in the OU and in any of its child OUs, including
	// any child OUs and accounts that are added at a later time.
	//
	// You can specify inclusions or exclusions, but not both. If you specify an
	// IncludeMap, Firewall Manager applies the policy to all accounts specified
	// by the IncludeMap, and does not evaluate any ExcludeMap specifications. If
	// you do not specify an IncludeMap, then Firewall Manager applies the policy
	// to all accounts except for those specified by the ExcludeMap.
	//
	// You can specify account IDs, OUs, or a combination:
	//
	//    * Specify account IDs by setting the key to ACCOUNT. For example, the
	//    following is a valid map: {“ACCOUNT” : [“accountID1”, “accountID2”]}.
	//
	//    * Specify OUs by setting the key to ORG_UNIT. For example, the following
	//    is a valid map: {“ORG_UNIT” : [“ouid111”, “ouid112”]}.
	//
	//    * Specify accounts and OUs together in a single map, separated with a
	//    comma. For example, the following is a valid map: {“ACCOUNT” : [“accountID1”,
	//    “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}.
	IncludeMap map[string][]*string `type:"map"`

	// The definition of the Network Firewall firewall policy.
	PolicyDescription *string `type:"string"`

	// The ID of the Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The name of the Firewall Manager policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the policy is in or out of an admin's policy or Region
	// scope.
	//
	//    * ACTIVE - The administrator can manage and delete the policy.
	//
	//    * OUT_OF_ADMIN_SCOPE - The administrator can view the policy, but they
	//    can't edit or delete the policy. Existing policy protections stay in place.
	//    Any new resources that come into scope of the policy won't be protected.
	PolicyStatus *string `type:"string" enum:"CustomerPolicyStatus"`

	// A unique identifier for each update to the policy. When issuing a PutPolicy
	// request, the PolicyUpdateToken in the request must match the PolicyUpdateToken
	// of the current policy version. To get the PolicyUpdateToken of the current
	// policy version, use a GetPolicy request.
	PolicyUpdateToken *string `min:"1" type:"string"`

	// Indicates if the policy should be automatically applied to new resources.
	//
	// RemediationEnabled is a required field
	RemediationEnabled *bool `type:"boolean" required:"true"`

	// The unique identifiers of the resource sets used by the policy.
	ResourceSetIds []*string `type:"list"`

	// An array of ResourceTag objects.
	ResourceTags []*ResourceTag `type:"list"`

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the Amazon Web Services Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// To apply this policy to multiple resource types, specify a resource type
	// of ResourceTypeList and then specify the resource types in a ResourceTypeList.
	//
	// For WAF and Shield Advanced, resource types include AWS::ElasticLoadBalancingV2::LoadBalancer,
	// AWS::ElasticLoadBalancing::LoadBalancer, AWS::EC2::EIP, and AWS::CloudFront::Distribution.
	// For a security group common policy, valid values are AWS::EC2::NetworkInterface
	// and AWS::EC2::Instance. For a security group content audit policy, valid
	// values are AWS::EC2::SecurityGroup, AWS::EC2::NetworkInterface, and AWS::EC2::Instance.
	// For a security group usage audit policy, the value is AWS::EC2::SecurityGroup.
	// For an Network Firewall policy or DNS Firewall policy, the value is AWS::EC2::VPC.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// An array of ResourceType objects. Use this only to specify multiple resource
	// types. To specify a single resource type, use ResourceType.
	ResourceTypeList []*string `type:"list"`

	// Details about the security service that is being used to protect the resources.
	//
	// SecurityServicePolicyData is a required field
	SecurityServicePolicyData *SecurityServicePolicyData `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Policy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Policy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Policy"}
	if s.ExcludeResourceTags == nil {
		invalidParams.Add(request.NewErrParamRequired("ExcludeResourceTags"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyUpdateToken != nil && len(*s.PolicyUpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyUpdateToken", 1))
	}
	if s.RemediationEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("RemediationEnabled"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.SecurityServicePolicyData == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityServicePolicyData"))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecurityServicePolicyData != nil {
		if err := s.SecurityServicePolicyData.Validate(); err != nil {
			invalidParams.AddNested("SecurityServicePolicyData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteUnusedFMManagedResources sets the DeleteUnusedFMManagedResources field's value.
func (s *Policy) SetDeleteUnusedFMManagedResources(v bool) *Policy {
	s.DeleteUnusedFMManagedResources = &v
	return s
}

// SetExcludeMap sets the ExcludeMap field's value.
func (s *Policy) SetExcludeMap(v map[string][]*string) *Policy {
	s.ExcludeMap = v
	return s
}

// SetExcludeResourceTags sets the ExcludeResourceTags field's value.
func (s *Policy) SetExcludeResourceTags(v bool) *Policy {
	s.ExcludeResourceTags = &v
	return s
}

// SetIncludeMap sets the IncludeMap field's value.
func (s *Policy) SetIncludeMap(v map[string][]*string) *Policy {
	s.IncludeMap = v
	return s
}

// SetPolicyDescription sets the PolicyDescription field's value.
func (s *Policy) SetPolicyDescription(v string) *Policy {
	s.PolicyDescription = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *Policy) SetPolicyId(v string) *Policy {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *Policy) SetPolicyName(v string) *Policy {
	s.PolicyName = &v
	return s
}

// SetPolicyStatus sets the PolicyStatus field's value.
func (s *Policy) SetPolicyStatus(v string) *Policy {
	s.PolicyStatus = &v
	return s
}

// SetPolicyUpdateToken sets the PolicyUpdateToken field's value.
func (s *Policy) SetPolicyUpdateToken(v string) *Policy {
	s.PolicyUpdateToken = &v
	return s
}

// SetRemediationEnabled sets the RemediationEnabled field's value.
func (s *Policy) SetRemediationEnabled(v bool) *Policy {
	s.RemediationEnabled = &v
	return s
}

// SetResourceSetIds sets the ResourceSetIds field's value.
func (s *Policy) SetResourceSetIds(v []*string) *Policy {
	s.ResourceSetIds = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *Policy) SetResourceTags(v []*ResourceTag) *Policy {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Policy) SetResourceType(v string) *Policy {
	s.ResourceType = &v
	return s
}

// SetResourceTypeList sets the ResourceTypeList field's value.
func (s *Policy) SetResourceTypeList(v []*string) *Policy {
	s.ResourceTypeList = v
	return s
}

// SetSecurityServicePolicyData sets the SecurityServicePolicyData field's value.
func (s *Policy) SetSecurityServicePolicyData(v *SecurityServicePolicyData) *Policy {
	s.SecurityServicePolicyData = v
	return s
}

// Describes the noncompliant resources in a member account for a specific Firewall
// Manager policy. A maximum of 100 entries are displayed. If more than 100
// resources are noncompliant, EvaluationLimitExceeded is set to True.
type PolicyComplianceDetail struct {
	_ struct{} `type:"structure"`

	// Indicates if over 100 resources are noncompliant with the Firewall Manager
	// policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// A timestamp that indicates when the returned information should be considered
	// out of date.
	ExpiredAt *time.Time `type:"timestamp"`

	// Details about problems with dependent services, such as WAF or Config, and
	// the error message received that indicates the problem with the service.
	IssueInfoMap map[string]*string `type:"map"`

	// The Amazon Web Services account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The Amazon Web Services account that created the Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`

	// An array of resources that aren't protected by the WAF or Shield Advanced
	// policy or that aren't in compliance with the security group policy.
	Violators []*ComplianceViolator `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyComplianceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyComplianceDetail) GoString() string {
	return s.String()
}

// SetEvaluationLimitExceeded sets the EvaluationLimitExceeded field's value.
func (s *PolicyComplianceDetail) SetEvaluationLimitExceeded(v bool) *PolicyComplianceDetail {
	s.EvaluationLimitExceeded = &v
	return s
}

// SetExpiredAt sets the ExpiredAt field's value.
func (s *PolicyComplianceDetail) SetExpiredAt(v time.Time) *PolicyComplianceDetail {
	s.ExpiredAt = &v
	return s
}

// SetIssueInfoMap sets the IssueInfoMap field's value.
func (s *PolicyComplianceDetail) SetIssueInfoMap(v map[string]*string) *PolicyComplianceDetail {
	s.IssueInfoMap = v
	return s
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *PolicyComplianceDetail) SetMemberAccount(v string) *PolicyComplianceDetail {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicyComplianceDetail) SetPolicyId(v string) *PolicyComplianceDetail {
	s.PolicyId = &v
	return s
}

// SetPolicyOwner sets the PolicyOwner field's value.
func (s *PolicyComplianceDetail) SetPolicyOwner(v string) *PolicyComplianceDetail {
	s.PolicyOwner = &v
	return s
}

// SetViolators sets the Violators field's value.
func (s *PolicyComplianceDetail) SetViolators(v []*ComplianceViolator) *PolicyComplianceDetail {
	s.Violators = v
	return s
}

// Indicates whether the account is compliant with the specified policy. An
// account is considered noncompliant if it includes resources that are not
// protected by the policy, for WAF and Shield Advanced policies, or that are
// noncompliant with the policy, for security group policies.
type PolicyComplianceStatus struct {
	_ struct{} `type:"structure"`

	// An array of EvaluationResult objects.
	EvaluationResults []*EvaluationResult `type:"list"`

	// Details about problems with dependent services, such as WAF or Config, and
	// the error message received that indicates the problem with the service.
	IssueInfoMap map[string]*string `type:"map"`

	// Timestamp of the last update to the EvaluationResult objects.
	LastUpdated *time.Time `type:"timestamp"`

	// The member account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The name of the Firewall Manager policy.
	PolicyName *string `min:"1" type:"string"`

	// The Amazon Web Services account that created the Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyComplianceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyComplianceStatus) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *PolicyComplianceStatus) SetEvaluationResults(v []*EvaluationResult) *PolicyComplianceStatus {
	s.EvaluationResults = v
	return s
}

// SetIssueInfoMap sets the IssueInfoMap field's value.
func (s *PolicyComplianceStatus) SetIssueInfoMap(v map[string]*string) *PolicyComplianceStatus {
	s.IssueInfoMap = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *PolicyComplianceStatus) SetLastUpdated(v time.Time) *PolicyComplianceStatus {
	s.LastUpdated = &v
	return s
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *PolicyComplianceStatus) SetMemberAccount(v string) *PolicyComplianceStatus {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicyComplianceStatus) SetPolicyId(v string) *PolicyComplianceStatus {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PolicyComplianceStatus) SetPolicyName(v string) *PolicyComplianceStatus {
	s.PolicyName = &v
	return s
}

// SetPolicyOwner sets the PolicyOwner field's value.
func (s *PolicyComplianceStatus) SetPolicyOwner(v string) *PolicyComplianceStatus {
	s.PolicyOwner = &v
	return s
}

// Contains the Network Firewall firewall policy options to configure the policy's
// deployment model and third-party firewall policy settings.
type PolicyOption struct {
	_ struct{} `type:"structure"`

	// Defines the deployment model to use for the firewall policy.
	NetworkFirewallPolicy *NetworkFirewallPolicy `type:"structure"`

	// Defines the policy options for a third-party firewall policy.
	ThirdPartyFirewallPolicy *ThirdPartyFirewallPolicy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyOption) GoString() string {
	return s.String()
}

// SetNetworkFirewallPolicy sets the NetworkFirewallPolicy field's value.
func (s *PolicyOption) SetNetworkFirewallPolicy(v *NetworkFirewallPolicy) *PolicyOption {
	s.NetworkFirewallPolicy = v
	return s
}

// SetThirdPartyFirewallPolicy sets the ThirdPartyFirewallPolicy field's value.
func (s *PolicyOption) SetThirdPartyFirewallPolicy(v *ThirdPartyFirewallPolicy) *PolicyOption {
	s.ThirdPartyFirewallPolicy = v
	return s
}

// Details of the Firewall Manager policy.
type PolicySummary struct {
	_ struct{} `type:"structure"`

	// Indicates whether Firewall Manager should automatically remove protections
	// from resources that leave the policy scope and clean up resources that Firewall
	// Manager is managing for accounts when those accounts leave policy scope.
	// For example, Firewall Manager will disassociate a Firewall Manager managed
	// web ACL from a protected customer resource when the customer resource leaves
	// policy scope.
	//
	// By default, Firewall Manager doesn't remove protections or delete Firewall
	// Manager managed resources.
	//
	// This option is not available for Shield Advanced or WAF Classic policies.
	DeleteUnusedFMManagedResources *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string `min:"1" type:"string"`

	// The ID of the specified policy.
	PolicyId *string `min:"36" type:"string"`

	// The name of the specified policy.
	PolicyName *string `min:"1" type:"string"`

	// Indicates whether the policy is in or out of an admin's policy or Region
	// scope.
	//
	//    * ACTIVE - The administrator can manage and delete the policy.
	//
	//    * OUT_OF_ADMIN_SCOPE - The administrator can view the policy, but they
	//    can't edit or delete the policy. Existing policy protections stay in place.
	//    Any new resources that come into scope of the policy won't be protected.
	PolicyStatus *string `type:"string" enum:"CustomerPolicyStatus"`

	// Indicates if the policy should be automatically applied to new resources.
	RemediationEnabled *bool `type:"boolean"`

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the Amazon Web Services Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For WAF and Shield Advanced, examples include AWS::ElasticLoadBalancingV2::LoadBalancer
	// and AWS::CloudFront::Distribution. For a security group common policy, valid
	// values are AWS::EC2::NetworkInterface and AWS::EC2::Instance. For a security
	// group content audit policy, valid values are AWS::EC2::SecurityGroup, AWS::EC2::NetworkInterface,
	// and AWS::EC2::Instance. For a security group usage audit policy, the value
	// is AWS::EC2::SecurityGroup. For an Network Firewall policy or DNS Firewall
	// policy, the value is AWS::EC2::VPC.
	ResourceType *string `min:"1" type:"string"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an WAF policy, a Shield Advanced
	// policy, or a security group policy.
	SecurityServiceType *string `type:"string" enum:"SecurityServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicySummary) GoString() string {
	return s.String()
}

// SetDeleteUnusedFMManagedResources sets the DeleteUnusedFMManagedResources field's value.
func (s *PolicySummary) SetDeleteUnusedFMManagedResources(v bool) *PolicySummary {
	s.DeleteUnusedFMManagedResources = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *PolicySummary) SetPolicyArn(v string) *PolicySummary {
	s.PolicyArn = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicySummary) SetPolicyId(v string) *PolicySummary {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PolicySummary) SetPolicyName(v string) *PolicySummary {
	s.PolicyName = &v
	return s
}

// SetPolicyStatus sets the PolicyStatus field's value.
func (s *PolicySummary) SetPolicyStatus(v string) *PolicySummary {
	s.PolicyStatus = &v
	return s
}

// SetRemediationEnabled sets the RemediationEnabled field's value.
func (s *PolicySummary) SetRemediationEnabled(v bool) *PolicySummary {
	s.RemediationEnabled = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *PolicySummary) SetResourceType(v string) *PolicySummary {
	s.ResourceType = &v
	return s
}

// SetSecurityServiceType sets the SecurityServiceType field's value.
func (s *PolicySummary) SetSecurityServiceType(v string) *PolicySummary {
	s.SecurityServiceType = &v
	return s
}

// Defines the policy types that the specified Firewall Manager administrator
// can manage.
type PolicyTypeScope struct {
	_ struct{} `type:"structure"`

	// Allows the specified Firewall Manager administrator to manage all Firewall
	// Manager policy types, except for third-party policy types. Third-party policy
	// types can only be managed by the Firewall Manager default administrator.
	AllPolicyTypesEnabled *bool `type:"boolean"`

	// The list of policy types that the specified Firewall Manager administrator
	// can manage.
	PolicyTypes []*string `type:"list" enum:"SecurityServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyTypeScope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyTypeScope) GoString() string {
	return s.String()
}

// SetAllPolicyTypesEnabled sets the AllPolicyTypesEnabled field's value.
func (s *PolicyTypeScope) SetAllPolicyTypesEnabled(v bool) *PolicyTypeScope {
	s.AllPolicyTypesEnabled = &v
	return s
}

// SetPolicyTypes sets the PolicyTypes field's value.
func (s *PolicyTypeScope) SetPolicyTypes(v []*string) *PolicyTypeScope {
	s.PolicyTypes = v
	return s
}

// A list of remediation actions.
type PossibleRemediationAction struct {
	_ struct{} `type:"structure"`

	// A description of the list of remediation actions.
	Description *string `type:"string"`

	// Information about whether an action is taken by default.
	IsDefaultAction *bool `type:"boolean"`

	// The ordered list of remediation actions.
	//
	// OrderedRemediationActions is a required field
	OrderedRemediationActions []*RemediationActionWithOrder `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PossibleRemediationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PossibleRemediationAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *PossibleRemediationAction) SetDescription(v string) *PossibleRemediationAction {
	s.Description = &v
	return s
}

// SetIsDefaultAction sets the IsDefaultAction field's value.
func (s *PossibleRemediationAction) SetIsDefaultAction(v bool) *PossibleRemediationAction {
	s.IsDefaultAction = &v
	return s
}

// SetOrderedRemediationActions sets the OrderedRemediationActions field's value.
func (s *PossibleRemediationAction) SetOrderedRemediationActions(v []*RemediationActionWithOrder) *PossibleRemediationAction {
	s.OrderedRemediationActions = v
	return s
}

// A list of possible remediation action lists. Each individual possible remediation
// action is a list of individual remediation actions.
type PossibleRemediationActions struct {
	_ struct{} `type:"structure"`

	// Information about the actions.
	Actions []*PossibleRemediationAction `type:"list"`

	// A description of the possible remediation actions list.
	Description *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PossibleRemediationActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PossibleRemediationActions) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *PossibleRemediationActions) SetActions(v []*PossibleRemediationAction) *PossibleRemediationActions {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *PossibleRemediationActions) SetDescription(v string) *PossibleRemediationActions {
	s.Description = &v
	return s
}

// An Firewall Manager protocols list.
type ProtocolsListData struct {
	_ struct{} `type:"structure"`

	// The time that the Firewall Manager protocols list was created.
	CreateTime *time.Time `type:"timestamp"`

	// The time that the Firewall Manager protocols list was last updated.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The ID of the Firewall Manager protocols list.
	ListId *string `min:"36" type:"string"`

	// The name of the Firewall Manager protocols list.
	//
	// ListName is a required field
	ListName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for each update to the list. When you update the list,
	// the update token must match the token of the current version of the application
	// list. You can retrieve the update token by getting the list.
	ListUpdateToken *string `min:"1" type:"string"`

	// A map of previous version numbers to their corresponding protocol arrays.
	PreviousProtocolsList map[string][]*string `type:"map"`

	// An array of protocols in the Firewall Manager protocols list.
	//
	// ProtocolsList is a required field
	ProtocolsList []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolsListData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolsListData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtocolsListData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProtocolsListData"}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ListId", 36))
	}
	if s.ListName == nil {
		invalidParams.Add(request.NewErrParamRequired("ListName"))
	}
	if s.ListName != nil && len(*s.ListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ListName", 1))
	}
	if s.ListUpdateToken != nil && len(*s.ListUpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ListUpdateToken", 1))
	}
	if s.ProtocolsList == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtocolsList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateTime sets the CreateTime field's value.
func (s *ProtocolsListData) SetCreateTime(v time.Time) *ProtocolsListData {
	s.CreateTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ProtocolsListData) SetLastUpdateTime(v time.Time) *ProtocolsListData {
	s.LastUpdateTime = &v
	return s
}

// SetListId sets the ListId field's value.
func (s *ProtocolsListData) SetListId(v string) *ProtocolsListData {
	s.ListId = &v
	return s
}

// SetListName sets the ListName field's value.
func (s *ProtocolsListData) SetListName(v string) *ProtocolsListData {
	s.ListName = &v
	return s
}

// SetListUpdateToken sets the ListUpdateToken field's value.
func (s *ProtocolsListData) SetListUpdateToken(v string) *ProtocolsListData {
	s.ListUpdateToken = &v
	return s
}

// SetPreviousProtocolsList sets the PreviousProtocolsList field's value.
func (s *ProtocolsListData) SetPreviousProtocolsList(v map[string][]*string) *ProtocolsListData {
	s.PreviousProtocolsList = v
	return s
}

// SetProtocolsList sets the ProtocolsList field's value.
func (s *ProtocolsListData) SetProtocolsList(v []*string) *ProtocolsListData {
	s.ProtocolsList = v
	return s
}

// Details of the Firewall Manager protocols list.
type ProtocolsListDataSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified protocols list.
	ListArn *string `min:"1" type:"string"`

	// The ID of the specified protocols list.
	ListId *string `min:"36" type:"string"`

	// The name of the specified protocols list.
	ListName *string `min:"1" type:"string"`

	// An array of protocols in the Firewall Manager protocols list.
	ProtocolsList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolsListDataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolsListDataSummary) GoString() string {
	return s.String()
}

// SetListArn sets the ListArn field's value.
func (s *ProtocolsListDataSummary) SetListArn(v string) *ProtocolsListDataSummary {
	s.ListArn = &v
	return s
}

// SetListId sets the ListId field's value.
func (s *ProtocolsListDataSummary) SetListId(v string) *ProtocolsListDataSummary {
	s.ListId = &v
	return s
}

// SetListName sets the ListName field's value.
func (s *ProtocolsListDataSummary) SetListName(v string) *ProtocolsListDataSummary {
	s.ListName = &v
	return s
}

// SetProtocolsList sets the ProtocolsList field's value.
func (s *ProtocolsListDataSummary) SetProtocolsList(v []*string) *ProtocolsListDataSummary {
	s.ProtocolsList = v
	return s
}

type PutAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID to add as an Firewall Manager administrator
	// account. The account must be a member of the organization that was onboarded
	// to Firewall Manager by AssociateAdminAccount. For more information about
	// Organizations, see Managing the Amazon Web Services Accounts in Your Organization
	// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html).
	//
	// AdminAccount is a required field
	AdminAccount *string `min:"1" type:"string" required:"true"`

	// Configures the resources that the specified Firewall Manager administrator
	// can manage. As a best practice, set the administrative scope according to
	// the principles of least privilege. Only grant the administrator the specific
	// resources or permissions that they need to perform the duties of their role.
	AdminScope *AdminScope `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAdminAccountInput"}
	if s.AdminAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccount"))
	}
	if s.AdminAccount != nil && len(*s.AdminAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdminAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccount sets the AdminAccount field's value.
func (s *PutAdminAccountInput) SetAdminAccount(v string) *PutAdminAccountInput {
	s.AdminAccount = &v
	return s
}

// SetAdminScope sets the AdminScope field's value.
func (s *PutAdminAccountInput) SetAdminScope(v *AdminScope) *PutAdminAccountInput {
	s.AdminScope = v
	return s
}

type PutAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAdminAccountOutput) GoString() string {
	return s.String()
}

type PutAppsListInput struct {
	_ struct{} `type:"structure"`

	// The details of the Firewall Manager applications list to be created.
	//
	// AppsList is a required field
	AppsList *AppsListData `type:"structure" required:"true"`

	// The tags associated with the resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppsListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppsListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAppsListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAppsListInput"}
	if s.AppsList == nil {
		invalidParams.Add(request.NewErrParamRequired("AppsList"))
	}
	if s.AppsList != nil {
		if err := s.AppsList.Validate(); err != nil {
			invalidParams.AddNested("AppsList", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppsList sets the AppsList field's value.
func (s *PutAppsListInput) SetAppsList(v *AppsListData) *PutAppsListInput {
	s.AppsList = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *PutAppsListInput) SetTagList(v []*Tag) *PutAppsListInput {
	s.TagList = v
	return s
}

type PutAppsListOutput struct {
	_ struct{} `type:"structure"`

	// The details of the Firewall Manager applications list.
	AppsList *AppsListData `type:"structure"`

	// The Amazon Resource Name (ARN) of the applications list.
	AppsListArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppsListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppsListOutput) GoString() string {
	return s.String()
}

// SetAppsList sets the AppsList field's value.
func (s *PutAppsListOutput) SetAppsList(v *AppsListData) *PutAppsListOutput {
	s.AppsList = v
	return s
}

// SetAppsListArn sets the AppsListArn field's value.
func (s *PutAppsListOutput) SetAppsListArn(v string) *PutAppsListOutput {
	s.AppsListArn = &v
	return s
}

type PutNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to
	// record Firewall Manager activity.
	//
	// SnsRoleName is a required field
	SnsRoleName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the SNS topic that collects notifications
	// from Firewall Manager.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutNotificationChannelInput"}
	if s.SnsRoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsRoleName"))
	}
	if s.SnsRoleName != nil && len(*s.SnsRoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnsRoleName", 1))
	}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SnsTopicArn != nil && len(*s.SnsTopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnsTopicArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnsRoleName sets the SnsRoleName field's value.
func (s *PutNotificationChannelInput) SetSnsRoleName(v string) *PutNotificationChannelInput {
	s.SnsRoleName = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *PutNotificationChannelInput) SetSnsTopicArn(v string) *PutNotificationChannelInput {
	s.SnsTopicArn = &v
	return s
}

type PutNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationChannelOutput) GoString() string {
	return s.String()
}

type PutPolicyInput struct {
	_ struct{} `type:"structure"`

	// The details of the Firewall Manager policy to be created.
	//
	// Policy is a required field
	Policy *Policy `type:"structure" required:"true"`

	// The tags to add to the Amazon Web Services resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil {
		if err := s.Policy.Validate(); err != nil {
			invalidParams.AddNested("Policy", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutPolicyInput) SetPolicy(v *Policy) *PutPolicyInput {
	s.Policy = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *PutPolicyInput) SetTagList(v []*Tag) *PutPolicyInput {
	s.TagList = v
	return s
}

type PutPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The details of the Firewall Manager policy.
	Policy *Policy `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutPolicyOutput) SetPolicy(v *Policy) *PutPolicyOutput {
	s.Policy = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *PutPolicyOutput) SetPolicyArn(v string) *PutPolicyOutput {
	s.PolicyArn = &v
	return s
}

type PutProtocolsListInput struct {
	_ struct{} `type:"structure"`

	// The details of the Firewall Manager protocols list to be created.
	//
	// ProtocolsList is a required field
	ProtocolsList *ProtocolsListData `type:"structure" required:"true"`

	// The tags associated with the resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProtocolsListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProtocolsListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutProtocolsListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutProtocolsListInput"}
	if s.ProtocolsList == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtocolsList"))
	}
	if s.ProtocolsList != nil {
		if err := s.ProtocolsList.Validate(); err != nil {
			invalidParams.AddNested("ProtocolsList", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProtocolsList sets the ProtocolsList field's value.
func (s *PutProtocolsListInput) SetProtocolsList(v *ProtocolsListData) *PutProtocolsListInput {
	s.ProtocolsList = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *PutProtocolsListInput) SetTagList(v []*Tag) *PutProtocolsListInput {
	s.TagList = v
	return s
}

type PutProtocolsListOutput struct {
	_ struct{} `type:"structure"`

	// The details of the Firewall Manager protocols list.
	ProtocolsList *ProtocolsListData `type:"structure"`

	// The Amazon Resource Name (ARN) of the protocols list.
	ProtocolsListArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProtocolsListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProtocolsListOutput) GoString() string {
	return s.String()
}

// SetProtocolsList sets the ProtocolsList field's value.
func (s *PutProtocolsListOutput) SetProtocolsList(v *ProtocolsListData) *PutProtocolsListOutput {
	s.ProtocolsList = v
	return s
}

// SetProtocolsListArn sets the ProtocolsListArn field's value.
func (s *PutProtocolsListOutput) SetProtocolsListArn(v string) *PutProtocolsListOutput {
	s.ProtocolsListArn = &v
	return s
}

type PutResourceSetInput struct {
	_ struct{} `type:"structure"`

	// Details about the resource set to be created or updated.>
	//
	// ResourceSet is a required field
	ResourceSet *ResourceSet `type:"structure" required:"true"`

	// Retrieves the tags associated with the specified resource set. Tags are key:value
	// pairs that you can use to categorize and manage your resources, for purposes
	// like billing. For example, you might set the tag key to "customer" and the
	// value to the customer name or ID. You can specify one or more tags to add
	// to each Amazon Web Services resource, up to 50 tags for a resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourceSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourceSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourceSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourceSetInput"}
	if s.ResourceSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSet"))
	}
	if s.ResourceSet != nil {
		if err := s.ResourceSet.Validate(); err != nil {
			invalidParams.AddNested("ResourceSet", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceSet sets the ResourceSet field's value.
func (s *PutResourceSetInput) SetResourceSet(v *ResourceSet) *PutResourceSetInput {
	s.ResourceSet = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *PutResourceSetInput) SetTagList(v []*Tag) *PutResourceSetInput {
	s.TagList = v
	return s
}

type PutResourceSetOutput struct {
	_ struct{} `type:"structure"`

	// Details about the resource set.
	//
	// ResourceSet is a required field
	ResourceSet *ResourceSet `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the resource set.
	//
	// ResourceSetArn is a required field
	ResourceSetArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourceSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourceSetOutput) GoString() string {
	return s.String()
}

// SetResourceSet sets the ResourceSet field's value.
func (s *PutResourceSetOutput) SetResourceSet(v *ResourceSet) *PutResourceSetOutput {
	s.ResourceSet = v
	return s
}

// SetResourceSetArn sets the ResourceSetArn field's value.
func (s *PutResourceSetOutput) SetResourceSetArn(v string) *PutResourceSetOutput {
	s.ResourceSetArn = &v
	return s
}

// Defines the Amazon Web Services Regions that the specified Firewall Manager
// administrator can manage.
type RegionScope struct {
	_ struct{} `type:"structure"`

	// Allows the specified Firewall Manager administrator to manage all Amazon
	// Web Services Regions.
	AllRegionsEnabled *bool `type:"boolean"`

	// The Amazon Web Services Regions that the specified Firewall Manager administrator
	// can perform actions in.
	Regions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionScope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionScope) GoString() string {
	return s.String()
}

// SetAllRegionsEnabled sets the AllRegionsEnabled field's value.
func (s *RegionScope) SetAllRegionsEnabled(v bool) *RegionScope {
	s.AllRegionsEnabled = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *RegionScope) SetRegions(v []*string) *RegionScope {
	s.Regions = v
	return s
}

// Information about an individual action you can take to remediate a violation.
type RemediationAction struct {
	_ struct{} `type:"structure"`

	// A description of a remediation action.
	Description *string `type:"string"`

	// Information about the AssociateRouteTable action in the Amazon EC2 API.
	EC2AssociateRouteTableAction *EC2AssociateRouteTableAction `type:"structure"`

	// Information about the CopyRouteTable action in the Amazon EC2 API.
	EC2CopyRouteTableAction *EC2CopyRouteTableAction `type:"structure"`

	// Information about the CreateRoute action in the Amazon EC2 API.
	EC2CreateRouteAction *EC2CreateRouteAction `type:"structure"`

	// Information about the CreateRouteTable action in the Amazon EC2 API.
	EC2CreateRouteTableAction *EC2CreateRouteTableAction `type:"structure"`

	// Information about the DeleteRoute action in the Amazon EC2 API.
	EC2DeleteRouteAction *EC2DeleteRouteAction `type:"structure"`

	// Information about the ReplaceRoute action in the Amazon EC2 API.
	EC2ReplaceRouteAction *EC2ReplaceRouteAction `type:"structure"`

	// Information about the ReplaceRouteTableAssociation action in the Amazon EC2
	// API.
	EC2ReplaceRouteTableAssociationAction *EC2ReplaceRouteTableAssociationAction `type:"structure"`

	// The remedial action to take when updating a firewall configuration.
	FMSPolicyUpdateFirewallCreationConfigAction *FMSPolicyUpdateFirewallCreationConfigAction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemediationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemediationAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *RemediationAction) SetDescription(v string) *RemediationAction {
	s.Description = &v
	return s
}

// SetEC2AssociateRouteTableAction sets the EC2AssociateRouteTableAction field's value.
func (s *RemediationAction) SetEC2AssociateRouteTableAction(v *EC2AssociateRouteTableAction) *RemediationAction {
	s.EC2AssociateRouteTableAction = v
	return s
}

// SetEC2CopyRouteTableAction sets the EC2CopyRouteTableAction field's value.
func (s *RemediationAction) SetEC2CopyRouteTableAction(v *EC2CopyRouteTableAction) *RemediationAction {
	s.EC2CopyRouteTableAction = v
	return s
}

// SetEC2CreateRouteAction sets the EC2CreateRouteAction field's value.
func (s *RemediationAction) SetEC2CreateRouteAction(v *EC2CreateRouteAction) *RemediationAction {
	s.EC2CreateRouteAction = v
	return s
}

// SetEC2CreateRouteTableAction sets the EC2CreateRouteTableAction field's value.
func (s *RemediationAction) SetEC2CreateRouteTableAction(v *EC2CreateRouteTableAction) *RemediationAction {
	s.EC2CreateRouteTableAction = v
	return s
}

// SetEC2DeleteRouteAction sets the EC2DeleteRouteAction field's value.
func (s *RemediationAction) SetEC2DeleteRouteAction(v *EC2DeleteRouteAction) *RemediationAction {
	s.EC2DeleteRouteAction = v
	return s
}

// SetEC2ReplaceRouteAction sets the EC2ReplaceRouteAction field's value.
func (s *RemediationAction) SetEC2ReplaceRouteAction(v *EC2ReplaceRouteAction) *RemediationAction {
	s.EC2ReplaceRouteAction = v
	return s
}

// SetEC2ReplaceRouteTableAssociationAction sets the EC2ReplaceRouteTableAssociationAction field's value.
func (s *RemediationAction) SetEC2ReplaceRouteTableAssociationAction(v *EC2ReplaceRouteTableAssociationAction) *RemediationAction {
	s.EC2ReplaceRouteTableAssociationAction = v
	return s
}

// SetFMSPolicyUpdateFirewallCreationConfigAction sets the FMSPolicyUpdateFirewallCreationConfigAction field's value.
func (s *RemediationAction) SetFMSPolicyUpdateFirewallCreationConfigAction(v *FMSPolicyUpdateFirewallCreationConfigAction) *RemediationAction {
	s.FMSPolicyUpdateFirewallCreationConfigAction = v
	return s
}

// An ordered list of actions you can take to remediate a violation.
type RemediationActionWithOrder struct {
	_ struct{} `type:"structure"`

	// The order of the remediation actions in the list.
	Order *int64 `type:"integer"`

	// Information about an action you can take to remediate a violation.
	RemediationAction *RemediationAction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemediationActionWithOrder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemediationActionWithOrder) GoString() string {
	return s.String()
}

// SetOrder sets the Order field's value.
func (s *RemediationActionWithOrder) SetOrder(v int64) *RemediationActionWithOrder {
	s.Order = &v
	return s
}

// SetRemediationAction sets the RemediationAction field's value.
func (s *RemediationActionWithOrder) SetRemediationAction(v *RemediationAction) *RemediationActionWithOrder {
	s.RemediationAction = v
	return s
}

// Details of a resource that is associated to an Firewall Manager resource
// set.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that the associated resource belongs to.
	AccountId *string `min:"1" type:"string"`

	// The resource's universal resource indicator (URI).
	//
	// URI is a required field
	URI *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Resource) SetAccountId(v string) *Resource {
	s.AccountId = &v
	return s
}

// SetURI sets the URI field's value.
func (s *Resource) SetURI(v string) *Resource {
	s.URI = &v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A set of resources to include in a policy.
type ResourceSet struct {
	_ struct{} `type:"structure"`

	// A description of the resource set.
	Description *string `type:"string"`

	// A unique identifier for the resource set. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string `min:"22" type:"string"`

	// The last time that the resource set was changed.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The descriptive name of the resource set. You can't change the name of a
	// resource set after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Indicates whether the resource set is in or out of an admin's Region scope.
	//
	//    * ACTIVE - The administrator can manage and delete the resource set.
	//
	//    * OUT_OF_ADMIN_SCOPE - The administrator can view the resource set, but
	//    they can't edit or delete the resource set. Existing protections stay
	//    in place. Any new resource that come into scope of the resource set won't
	//    be protected.
	ResourceSetStatus *string `type:"string" enum:"ResourceSetStatus"`

	// Determines the resources that can be associated to the resource set. Depending
	// on your setting for max results and the number of resource sets, a single
	// call might not return the full list.
	//
	// ResourceTypeList is a required field
	ResourceTypeList []*string `type:"list" required:"true"`

	// An optional token that you can use for optimistic locking. Firewall Manager
	// returns a token to your requests that access the resource set. The token
	// marks the state of the resource set resource at the time of the request.
	// Update tokens are not allowed when creating a resource set. After creation,
	// each subsequent update call to the resource set requires the update token.
	//
	// To make an unconditional change to the resource set, omit the token in your
	// update request. Without the token, Firewall Manager performs your updates
	// regardless of whether the resource set has changed since you last retrieved
	// it.
	//
	// To make a conditional change to the resource set, provide the token in your
	// update request. Firewall Manager uses the token to ensure that the resource
	// set hasn't changed since you last retrieved it. If it has changed, the operation
	// fails with an InvalidTokenException. If this happens, retrieve the resource
	// set again to get a current copy of it with a new token. Reapply your changes
	// as needed, then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceSet"}
	if s.Id != nil && len(*s.Id) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 22))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceTypeList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTypeList"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ResourceSet) SetDescription(v string) *ResourceSet {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResourceSet) SetId(v string) *ResourceSet {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ResourceSet) SetLastUpdateTime(v time.Time) *ResourceSet {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceSet) SetName(v string) *ResourceSet {
	s.Name = &v
	return s
}

// SetResourceSetStatus sets the ResourceSetStatus field's value.
func (s *ResourceSet) SetResourceSetStatus(v string) *ResourceSet {
	s.ResourceSetStatus = &v
	return s
}

// SetResourceTypeList sets the ResourceTypeList field's value.
func (s *ResourceSet) SetResourceTypeList(v []*string) *ResourceSet {
	s.ResourceTypeList = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *ResourceSet) SetUpdateToken(v string) *ResourceSet {
	s.UpdateToken = &v
	return s
}

// Summarizes the resource sets used in a policy.
type ResourceSetSummary struct {
	_ struct{} `type:"structure"`

	// A description of the resource set.
	Description *string `type:"string"`

	// A unique identifier for the resource set. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string `min:"22" type:"string"`

	// The last time that the resource set was changed.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The descriptive name of the resource set. You can't change the name of a
	// resource set after you create it.
	Name *string `min:"1" type:"string"`

	// Indicates whether the resource set is in or out of an admin's Region scope.
	//
	//    * ACTIVE - The administrator can manage and delete the resource set.
	//
	//    * OUT_OF_ADMIN_SCOPE - The administrator can view the resource set, but
	//    they can't edit or delete the resource set. Existing protections stay
	//    in place. Any new resource that come into scope of the resource set won't
	//    be protected.
	ResourceSetStatus *string `type:"string" enum:"ResourceSetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSetSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ResourceSetSummary) SetDescription(v string) *ResourceSetSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResourceSetSummary) SetId(v string) *ResourceSetSummary {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ResourceSetSummary) SetLastUpdateTime(v time.Time) *ResourceSetSummary {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceSetSummary) SetName(v string) *ResourceSetSummary {
	s.Name = &v
	return s
}

// SetResourceSetStatus sets the ResourceSetStatus field's value.
func (s *ResourceSetSummary) SetResourceSetStatus(v string) *ResourceSetSummary {
	s.ResourceSetStatus = &v
	return s
}

// The resource tags that Firewall Manager uses to determine if a particular
// resource should be included or excluded from the Firewall Manager policy.
// Tags enable you to categorize your Amazon Web Services resources in different
// ways, for example, by purpose, owner, or environment. Each tag consists of
// a key and an optional value. Firewall Manager combines the tags with "AND"
// so that, if you add more than one tag to a policy scope, a resource must
// have all the specified tags to be included or excluded. For more information,
// see Working with Tag Editor (https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html).
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The resource tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The resource tag value.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceTag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ResourceTag) SetKey(v string) *ResourceTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTag) SetValue(v string) *ResourceTag {
	s.Value = &v
	return s
}

// Violation detail based on resource type.
type ResourceViolation struct {
	_ struct{} `type:"structure"`

	// Violation detail for an EC2 instance.
	AwsEc2InstanceViolation *AwsEc2InstanceViolation `type:"structure"`

	// Violation detail for a network interface.
	AwsEc2NetworkInterfaceViolation *AwsEc2NetworkInterfaceViolation `type:"structure"`

	// Violation detail for security groups.
	AwsVPCSecurityGroupViolation *AwsVPCSecurityGroupViolation `type:"structure"`

	// Violation detail for a DNS Firewall policy that indicates that a rule group
	// that Firewall Manager tried to associate with a VPC is already associated
	// with the VPC and can't be associated again.
	DnsDuplicateRuleGroupViolation *DnsDuplicateRuleGroupViolation `type:"structure"`

	// Violation detail for a DNS Firewall policy that indicates that the VPC reached
	// the limit for associated DNS Firewall rule groups. Firewall Manager tried
	// to associate another rule group with the VPC and failed.
	DnsRuleGroupLimitExceededViolation *DnsRuleGroupLimitExceededViolation `type:"structure"`

	// Violation detail for a DNS Firewall policy that indicates that a rule group
	// that Firewall Manager tried to associate with a VPC has the same priority
	// as a rule group that's already associated.
	DnsRuleGroupPriorityConflictViolation *DnsRuleGroupPriorityConflictViolation `type:"structure"`

	// Contains details about the firewall subnet that violates the policy scope.
	FirewallSubnetIsOutOfScopeViolation *FirewallSubnetIsOutOfScopeViolation `type:"structure"`

	// The violation details for a third-party firewall's VPC endpoint subnet that
	// was deleted.
	FirewallSubnetMissingVPCEndpointViolation *FirewallSubnetMissingVPCEndpointViolation `type:"structure"`

	// Violation detail for an internet gateway route with an inactive state in
	// the customer subnet route table or Network Firewall subnet route table.
	NetworkFirewallBlackHoleRouteDetectedViolation *NetworkFirewallBlackHoleRouteDetectedViolation `type:"structure"`

	// Violation detail for the subnet for which internet traffic hasn't been inspected.
	NetworkFirewallInternetTrafficNotInspectedViolation *NetworkFirewallInternetTrafficNotInspectedViolation `type:"structure"`

	// The route configuration is invalid.
	NetworkFirewallInvalidRouteConfigurationViolation *NetworkFirewallInvalidRouteConfigurationViolation `type:"structure"`

	// Violation detail for an Network Firewall policy that indicates that a subnet
	// is not associated with the expected Firewall Manager managed route table.
	NetworkFirewallMissingExpectedRTViolation *NetworkFirewallMissingExpectedRTViolation `type:"structure"`

	// Expected routes are missing from Network Firewall.
	NetworkFirewallMissingExpectedRoutesViolation *NetworkFirewallMissingExpectedRoutesViolation `type:"structure"`

	// Violation detail for an Network Firewall policy that indicates that a subnet
	// has no Firewall Manager managed firewall in its VPC.
	NetworkFirewallMissingFirewallViolation *NetworkFirewallMissingFirewallViolation `type:"structure"`

	// Violation detail for an Network Firewall policy that indicates that an Availability
	// Zone is missing the expected Firewall Manager managed subnet.
	NetworkFirewallMissingSubnetViolation *NetworkFirewallMissingSubnetViolation `type:"structure"`

	// Violation detail for an Network Firewall policy that indicates that a firewall
	// policy in an individual account has been modified in a way that makes it
	// noncompliant. For example, the individual account owner might have deleted
	// a rule group, changed the priority of a stateless rule group, or changed
	// a policy default action.
	NetworkFirewallPolicyModifiedViolation *NetworkFirewallPolicyModifiedViolation `type:"structure"`

	// There's an unexpected firewall route.
	NetworkFirewallUnexpectedFirewallRoutesViolation *NetworkFirewallUnexpectedFirewallRoutesViolation `type:"structure"`

	// There's an unexpected gateway route.
	NetworkFirewallUnexpectedGatewayRoutesViolation *NetworkFirewallUnexpectedGatewayRoutesViolation `type:"structure"`

	// A list of possible remediation action lists. Each individual possible remediation
	// action is a list of individual remediation actions.
	PossibleRemediationActions *PossibleRemediationActions `type:"structure"`

	// Contains details about the route endpoint that violates the policy scope.
	RouteHasOutOfScopeEndpointViolation *RouteHasOutOfScopeEndpointViolation `type:"structure"`

	// The violation details for a third-party firewall that has the Firewall Manager
	// managed route table that was associated with the third-party firewall has
	// been deleted.
	ThirdPartyFirewallMissingExpectedRouteTableViolation *ThirdPartyFirewallMissingExpectedRouteTableViolation `type:"structure"`

	// The violation details for a third-party firewall that's been deleted.
	ThirdPartyFirewallMissingFirewallViolation *ThirdPartyFirewallMissingFirewallViolation `type:"structure"`

	// The violation details for a third-party firewall's subnet that's been deleted.
	ThirdPartyFirewallMissingSubnetViolation *ThirdPartyFirewallMissingSubnetViolation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceViolation) GoString() string {
	return s.String()
}

// SetAwsEc2InstanceViolation sets the AwsEc2InstanceViolation field's value.
func (s *ResourceViolation) SetAwsEc2InstanceViolation(v *AwsEc2InstanceViolation) *ResourceViolation {
	s.AwsEc2InstanceViolation = v
	return s
}

// SetAwsEc2NetworkInterfaceViolation sets the AwsEc2NetworkInterfaceViolation field's value.
func (s *ResourceViolation) SetAwsEc2NetworkInterfaceViolation(v *AwsEc2NetworkInterfaceViolation) *ResourceViolation {
	s.AwsEc2NetworkInterfaceViolation = v
	return s
}

// SetAwsVPCSecurityGroupViolation sets the AwsVPCSecurityGroupViolation field's value.
func (s *ResourceViolation) SetAwsVPCSecurityGroupViolation(v *AwsVPCSecurityGroupViolation) *ResourceViolation {
	s.AwsVPCSecurityGroupViolation = v
	return s
}

// SetDnsDuplicateRuleGroupViolation sets the DnsDuplicateRuleGroupViolation field's value.
func (s *ResourceViolation) SetDnsDuplicateRuleGroupViolation(v *DnsDuplicateRuleGroupViolation) *ResourceViolation {
	s.DnsDuplicateRuleGroupViolation = v
	return s
}

// SetDnsRuleGroupLimitExceededViolation sets the DnsRuleGroupLimitExceededViolation field's value.
func (s *ResourceViolation) SetDnsRuleGroupLimitExceededViolation(v *DnsRuleGroupLimitExceededViolation) *ResourceViolation {
	s.DnsRuleGroupLimitExceededViolation = v
	return s
}

// SetDnsRuleGroupPriorityConflictViolation sets the DnsRuleGroupPriorityConflictViolation field's value.
func (s *ResourceViolation) SetDnsRuleGroupPriorityConflictViolation(v *DnsRuleGroupPriorityConflictViolation) *ResourceViolation {
	s.DnsRuleGroupPriorityConflictViolation = v
	return s
}

// SetFirewallSubnetIsOutOfScopeViolation sets the FirewallSubnetIsOutOfScopeViolation field's value.
func (s *ResourceViolation) SetFirewallSubnetIsOutOfScopeViolation(v *FirewallSubnetIsOutOfScopeViolation) *ResourceViolation {
	s.FirewallSubnetIsOutOfScopeViolation = v
	return s
}

// SetFirewallSubnetMissingVPCEndpointViolation sets the FirewallSubnetMissingVPCEndpointViolation field's value.
func (s *ResourceViolation) SetFirewallSubnetMissingVPCEndpointViolation(v *FirewallSubnetMissingVPCEndpointViolation) *ResourceViolation {
	s.FirewallSubnetMissingVPCEndpointViolation = v
	return s
}

// SetNetworkFirewallBlackHoleRouteDetectedViolation sets the NetworkFirewallBlackHoleRouteDetectedViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallBlackHoleRouteDetectedViolation(v *NetworkFirewallBlackHoleRouteDetectedViolation) *ResourceViolation {
	s.NetworkFirewallBlackHoleRouteDetectedViolation = v
	return s
}

// SetNetworkFirewallInternetTrafficNotInspectedViolation sets the NetworkFirewallInternetTrafficNotInspectedViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallInternetTrafficNotInspectedViolation(v *NetworkFirewallInternetTrafficNotInspectedViolation) *ResourceViolation {
	s.NetworkFirewallInternetTrafficNotInspectedViolation = v
	return s
}

// SetNetworkFirewallInvalidRouteConfigurationViolation sets the NetworkFirewallInvalidRouteConfigurationViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallInvalidRouteConfigurationViolation(v *NetworkFirewallInvalidRouteConfigurationViolation) *ResourceViolation {
	s.NetworkFirewallInvalidRouteConfigurationViolation = v
	return s
}

// SetNetworkFirewallMissingExpectedRTViolation sets the NetworkFirewallMissingExpectedRTViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallMissingExpectedRTViolation(v *NetworkFirewallMissingExpectedRTViolation) *ResourceViolation {
	s.NetworkFirewallMissingExpectedRTViolation = v
	return s
}

// SetNetworkFirewallMissingExpectedRoutesViolation sets the NetworkFirewallMissingExpectedRoutesViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallMissingExpectedRoutesViolation(v *NetworkFirewallMissingExpectedRoutesViolation) *ResourceViolation {
	s.NetworkFirewallMissingExpectedRoutesViolation = v
	return s
}

// SetNetworkFirewallMissingFirewallViolation sets the NetworkFirewallMissingFirewallViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallMissingFirewallViolation(v *NetworkFirewallMissingFirewallViolation) *ResourceViolation {
	s.NetworkFirewallMissingFirewallViolation = v
	return s
}

// SetNetworkFirewallMissingSubnetViolation sets the NetworkFirewallMissingSubnetViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallMissingSubnetViolation(v *NetworkFirewallMissingSubnetViolation) *ResourceViolation {
	s.NetworkFirewallMissingSubnetViolation = v
	return s
}

// SetNetworkFirewallPolicyModifiedViolation sets the NetworkFirewallPolicyModifiedViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallPolicyModifiedViolation(v *NetworkFirewallPolicyModifiedViolation) *ResourceViolation {
	s.NetworkFirewallPolicyModifiedViolation = v
	return s
}

// SetNetworkFirewallUnexpectedFirewallRoutesViolation sets the NetworkFirewallUnexpectedFirewallRoutesViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallUnexpectedFirewallRoutesViolation(v *NetworkFirewallUnexpectedFirewallRoutesViolation) *ResourceViolation {
	s.NetworkFirewallUnexpectedFirewallRoutesViolation = v
	return s
}

// SetNetworkFirewallUnexpectedGatewayRoutesViolation sets the NetworkFirewallUnexpectedGatewayRoutesViolation field's value.
func (s *ResourceViolation) SetNetworkFirewallUnexpectedGatewayRoutesViolation(v *NetworkFirewallUnexpectedGatewayRoutesViolation) *ResourceViolation {
	s.NetworkFirewallUnexpectedGatewayRoutesViolation = v
	return s
}

// SetPossibleRemediationActions sets the PossibleRemediationActions field's value.
func (s *ResourceViolation) SetPossibleRemediationActions(v *PossibleRemediationActions) *ResourceViolation {
	s.PossibleRemediationActions = v
	return s
}

// SetRouteHasOutOfScopeEndpointViolation sets the RouteHasOutOfScopeEndpointViolation field's value.
func (s *ResourceViolation) SetRouteHasOutOfScopeEndpointViolation(v *RouteHasOutOfScopeEndpointViolation) *ResourceViolation {
	s.RouteHasOutOfScopeEndpointViolation = v
	return s
}

// SetThirdPartyFirewallMissingExpectedRouteTableViolation sets the ThirdPartyFirewallMissingExpectedRouteTableViolation field's value.
func (s *ResourceViolation) SetThirdPartyFirewallMissingExpectedRouteTableViolation(v *ThirdPartyFirewallMissingExpectedRouteTableViolation) *ResourceViolation {
	s.ThirdPartyFirewallMissingExpectedRouteTableViolation = v
	return s
}

// SetThirdPartyFirewallMissingFirewallViolation sets the ThirdPartyFirewallMissingFirewallViolation field's value.
func (s *ResourceViolation) SetThirdPartyFirewallMissingFirewallViolation(v *ThirdPartyFirewallMissingFirewallViolation) *ResourceViolation {
	s.ThirdPartyFirewallMissingFirewallViolation = v
	return s
}

// SetThirdPartyFirewallMissingSubnetViolation sets the ThirdPartyFirewallMissingSubnetViolation field's value.
func (s *ResourceViolation) SetThirdPartyFirewallMissingSubnetViolation(v *ThirdPartyFirewallMissingSubnetViolation) *ResourceViolation {
	s.ThirdPartyFirewallMissingSubnetViolation = v
	return s
}

// Describes a route in a route table.
type Route struct {
	_ struct{} `type:"structure"`

	// The destination of the route.
	Destination *string `type:"string"`

	// The type of destination for the route.
	DestinationType *string `type:"string" enum:"DestinationType"`

	// The route's target.
	Target *string `type:"string"`

	// The type of target for the route.
	TargetType *string `type:"string" enum:"TargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Route) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Route) GoString() string {
	return s.String()
}

// SetDestination sets the Destination field's value.
func (s *Route) SetDestination(v string) *Route {
	s.Destination = &v
	return s
}

// SetDestinationType sets the DestinationType field's value.
func (s *Route) SetDestinationType(v string) *Route {
	s.DestinationType = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *Route) SetTarget(v string) *Route {
	s.Target = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *Route) SetTargetType(v string) *Route {
	s.TargetType = &v
	return s
}

// Contains details about the route endpoint that violates the policy scope.
type RouteHasOutOfScopeEndpointViolation struct {
	_ struct{} `type:"structure"`

	// The route table associated with the current firewall subnet.
	CurrentFirewallSubnetRouteTable *string `min:"1" type:"string"`

	// The current route table associated with the Internet Gateway.
	CurrentInternetGatewayRouteTable *string `min:"1" type:"string"`

	// The ID of the firewall subnet.
	FirewallSubnetId *string `min:"1" type:"string"`

	// The list of firewall subnet routes.
	FirewallSubnetRoutes []*Route `type:"list"`

	// The ID of the Internet Gateway.
	InternetGatewayId *string `min:"1" type:"string"`

	// The routes in the route table associated with the Internet Gateway.
	InternetGatewayRoutes []*Route `type:"list"`

	// The ID of the route table.
	RouteTableId *string `min:"1" type:"string"`

	// The subnet's Availability Zone.
	SubnetAvailabilityZone *string `type:"string"`

	// The ID of the subnet's Availability Zone.
	SubnetAvailabilityZoneId *string `type:"string"`

	// The ID of the subnet associated with the route that violates the policy scope.
	SubnetId *string `min:"1" type:"string"`

	// The list of routes that violate the route table.
	ViolatingRoutes []*Route `type:"list"`

	// The VPC ID of the route that violates the policy scope.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteHasOutOfScopeEndpointViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteHasOutOfScopeEndpointViolation) GoString() string {
	return s.String()
}

// SetCurrentFirewallSubnetRouteTable sets the CurrentFirewallSubnetRouteTable field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetCurrentFirewallSubnetRouteTable(v string) *RouteHasOutOfScopeEndpointViolation {
	s.CurrentFirewallSubnetRouteTable = &v
	return s
}

// SetCurrentInternetGatewayRouteTable sets the CurrentInternetGatewayRouteTable field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetCurrentInternetGatewayRouteTable(v string) *RouteHasOutOfScopeEndpointViolation {
	s.CurrentInternetGatewayRouteTable = &v
	return s
}

// SetFirewallSubnetId sets the FirewallSubnetId field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetFirewallSubnetId(v string) *RouteHasOutOfScopeEndpointViolation {
	s.FirewallSubnetId = &v
	return s
}

// SetFirewallSubnetRoutes sets the FirewallSubnetRoutes field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetFirewallSubnetRoutes(v []*Route) *RouteHasOutOfScopeEndpointViolation {
	s.FirewallSubnetRoutes = v
	return s
}

// SetInternetGatewayId sets the InternetGatewayId field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetInternetGatewayId(v string) *RouteHasOutOfScopeEndpointViolation {
	s.InternetGatewayId = &v
	return s
}

// SetInternetGatewayRoutes sets the InternetGatewayRoutes field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetInternetGatewayRoutes(v []*Route) *RouteHasOutOfScopeEndpointViolation {
	s.InternetGatewayRoutes = v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetRouteTableId(v string) *RouteHasOutOfScopeEndpointViolation {
	s.RouteTableId = &v
	return s
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetSubnetAvailabilityZone(v string) *RouteHasOutOfScopeEndpointViolation {
	s.SubnetAvailabilityZone = &v
	return s
}

// SetSubnetAvailabilityZoneId sets the SubnetAvailabilityZoneId field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetSubnetAvailabilityZoneId(v string) *RouteHasOutOfScopeEndpointViolation {
	s.SubnetAvailabilityZoneId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetSubnetId(v string) *RouteHasOutOfScopeEndpointViolation {
	s.SubnetId = &v
	return s
}

// SetViolatingRoutes sets the ViolatingRoutes field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetViolatingRoutes(v []*Route) *RouteHasOutOfScopeEndpointViolation {
	s.ViolatingRoutes = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *RouteHasOutOfScopeEndpointViolation) SetVpcId(v string) *RouteHasOutOfScopeEndpointViolation {
	s.VpcId = &v
	return s
}

// Remediation option for the rule specified in the ViolationTarget.
type SecurityGroupRemediationAction struct {
	_ struct{} `type:"structure"`

	// Brief description of the action that will be performed.
	Description *string `type:"string"`

	// Indicates if the current action is the default action.
	IsDefaultAction *bool `type:"boolean"`

	// The remediation action that will be performed.
	RemediationActionType *string `type:"string" enum:"RemediationActionType"`

	// The final state of the rule specified in the ViolationTarget after it is
	// remediated.
	RemediationResult *SecurityGroupRuleDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupRemediationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupRemediationAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SecurityGroupRemediationAction) SetDescription(v string) *SecurityGroupRemediationAction {
	s.Description = &v
	return s
}

// SetIsDefaultAction sets the IsDefaultAction field's value.
func (s *SecurityGroupRemediationAction) SetIsDefaultAction(v bool) *SecurityGroupRemediationAction {
	s.IsDefaultAction = &v
	return s
}

// SetRemediationActionType sets the RemediationActionType field's value.
func (s *SecurityGroupRemediationAction) SetRemediationActionType(v string) *SecurityGroupRemediationAction {
	s.RemediationActionType = &v
	return s
}

// SetRemediationResult sets the RemediationResult field's value.
func (s *SecurityGroupRemediationAction) SetRemediationResult(v *SecurityGroupRuleDescription) *SecurityGroupRemediationAction {
	s.RemediationResult = v
	return s
}

// Describes a set of permissions for a security group rule.
type SecurityGroupRuleDescription struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number. A value of -1 indicates all ICMP/ICMPv6 types.
	FromPort *int64 `type:"long"`

	// The IPv4 ranges for the security group rule.
	IPV4Range *string `type:"string"`

	// The IPv6 ranges for the security group rule.
	IPV6Range *string `type:"string"`

	// The ID of the prefix list for the security group rule.
	PrefixListId *string `min:"1" type:"string"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number.
	Protocol *string `type:"string"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code. A value of -1 indicates all ICMP/ICMPv6 codes.
	ToPort *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupRuleDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupRuleDescription) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *SecurityGroupRuleDescription) SetFromPort(v int64) *SecurityGroupRuleDescription {
	s.FromPort = &v
	return s
}

// SetIPV4Range sets the IPV4Range field's value.
func (s *SecurityGroupRuleDescription) SetIPV4Range(v string) *SecurityGroupRuleDescription {
	s.IPV4Range = &v
	return s
}

// SetIPV6Range sets the IPV6Range field's value.
func (s *SecurityGroupRuleDescription) SetIPV6Range(v string) *SecurityGroupRuleDescription {
	s.IPV6Range = &v
	return s
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *SecurityGroupRuleDescription) SetPrefixListId(v string) *SecurityGroupRuleDescription {
	s.PrefixListId = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *SecurityGroupRuleDescription) SetProtocol(v string) *SecurityGroupRuleDescription {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *SecurityGroupRuleDescription) SetToPort(v int64) *SecurityGroupRuleDescription {
	s.ToPort = &v
	return s
}

// Details about the security service that is being used to protect the resources.
type SecurityServicePolicyData struct {
	_ struct{} `type:"structure"`

	// Details about the service that are specific to the service type, in JSON
	// format.
	//
	//    * Example: DNS_FIREWALL "{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"
	//    Valid values for preProcessRuleGroups are between 1 and 99. Valid values
	//    for postProcessRuleGroups are between 9901 and 10000.
	//
	//    * Example: IMPORT_NETWORK_FIREWALL "{\"type\":\"IMPORT_NETWORK_FIREWALL\",\"awsNetworkFirewallConfig\":{\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-2:000000000000:stateless-rulegroup\/rg1\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:drop\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:pass\"],\"networkFirewallStatelessCustomActions\":[],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-2:aws-managed:stateful-rulegroup\/ThreatSignaturesEmergingEventsStrictOrder\",\"priority\":8}],\"networkFirewallStatefulEngineOptions\":{\"ruleOrder\":\"STRICT_ORDER\"},\"networkFirewallStatefulDefaultActions\":[\"aws:drop_strict\"]}}"
	//    "{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"
	//    Valid values for preProcessRuleGroups are between 1 and 99. Valid values
	//    for postProcessRuleGroups are between 9901 and 10000.
	//
	//    * Example: NETWORK_FIREWALL - Centralized deployment model "{\"type\":\"NETWORK_FIREWALL\",\"awsNetworkFirewallConfig\":{\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}},\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"
	//    To use the centralized deployment model, you must set PolicyOption (https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html)
	//    to CENTRALIZED.
	//
	//    * Example: NETWORK_FIREWALL - Distributed deployment model with automatic
	//    Availability Zone configuration "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"OFF\"},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"
	//    With automatic Availbility Zone configuration, Firewall Manager chooses
	//    which Availability Zones to create the endpoints in. To use the distributed
	//    deployment model, you must set PolicyOption (https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html)
	//    to NULL.
	//
	//    * Example: NETWORK_FIREWALL - Distributed deployment model with automatic
	//    Availability Zone configuration and route management "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"]},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":
	//    \"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"
	//    To use the distributed deployment model, you must set PolicyOption (https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html)
	//    to NULL.
	//
	//    * Example: NETWORK_FIREWALL - Distributed deployment model with custom
	//    Availability Zone configuration "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",
	//    \"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{
	//    \"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[
	//    \"10.0.0.0/28\"]}]} },\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"OFF\",\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"
	//    With custom Availability Zone configuration, you define which specific
	//    Availability Zones to create endpoints in by configuring firewallCreationConfig.
	//    To configure the Availability Zones in firewallCreationConfig, specify
	//    either the availabilityZoneName or availabilityZoneId parameter, not both
	//    parameters. To use the distributed deployment model, you must set PolicyOption
	//    (https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html)
	//    to NULL.
	//
	//    * Example: NETWORK_FIREWALL - Distributed deployment model with custom
	//    Availability Zone configuration and route management "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"],\"routeManagementConfig\":{\"allowCrossAZTrafficIfNoEndpoint\":true}},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"
	//    To use the distributed deployment model, you must set PolicyOption (https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html)
	//    to NULL.
	//
	//    * Example: THIRD_PARTY_FIREWALL "{ "type":"THIRD_PARTY_FIREWALL", "thirdPartyFirewall":"PALO_ALTO_NETWORKS_CLOUD_NGFW",
	//    "thirdPartyFirewallConfig":{ "thirdPartyFirewallPolicyList":["global-1"]
	//    }, "firewallDeploymentModel":{ "distributedFirewallDeploymentModel":{
	//    "distributedFirewallOrchestrationConfig":{ "firewallCreationConfig":{
	//    "endpointLocation":{ "availabilityZoneConfigList":[ { "availabilityZoneName":"${AvailabilityZone}"
	//    } ] } }, "allowedIPV4CidrList":[ ] } } } }"
	//
	//    * Example: SECURITY_GROUPS_COMMON "{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,
	//    \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"
	//
	//    * Example: SECURITY_GROUPS_COMMON - Security group tag distribution ""{\"type\":\"SECURITY_GROUPS_COMMON\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"revertManualSecurityGroupChanges\":true,\"exclusiveResourceSecurityGroupManagement\":false,\"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":false,\"enableTagDistribution\":true}""
	//    Firewall Manager automatically distributes tags from the primary group
	//    to the security groups created by this policy. To use security group tag
	//    distribution, you must also set revertManualSecurityGroupChanges to true,
	//    otherwise Firewall Manager won't be able to create the policy. When you
	//    enable revertManualSecurityGroupChanges, Firewall Manager identifies and
	//    reports when the security groups created by this policy become non-compliant.
	//    Firewall Manager won't distrubute system tags added by Amazon Web Services
	//    services into the replica security groups. System tags begin with the
	//    aws: prefix.
	//
	//    * Example: Shared VPCs. Apply the preceding policy to resources in shared
	//    VPCs as well as to those in VPCs that the account owns "{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,
	//    \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\"
	//    sg-000e55995d61a06bd\"}]}"
	//
	//    * Example: SECURITY_GROUPS_CONTENT_AUDIT "{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"
	//    The security group action for content audit can be ALLOW or DENY. For
	//    ALLOW, all in-scope security group rules must be within the allowed range
	//    of the policy's security group rules. For DENY, all in-scope security
	//    group rules must not contain a value or a range that matches a rule value
	//    or range in the policy security group.
	//
	//    * Example: SECURITY_GROUPS_USAGE_AUDIT "{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"
	//
	//    * Specification for SHIELD_ADVANCED for Amazon CloudFront distributions
	//    "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\",
	//    \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"
	//    For example: "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\":
	//    {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"
	//    The default value for automaticResponseStatus is IGNORED. The value for
	//    automaticResponseAction is only required when automaticResponseStatus
	//    is set to ENABLED. The default value for overrideCustomerWebaclClassic
	//    is false. For other resource types that you can protect with a Shield
	//    Advanced policy, this ManagedServiceData configuration is an empty string.
	//
	//    * Example: WAFV2 - Account takeover prevention and Bot Control managed
	//    rule groups, and rule action override "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesATPRuleSet\",\"managedRuleGroupConfigs\":[{\"awsmanagedRulesATPRuleSet\":{\"loginPath\":\"/loginpath\",\"requestInspection\":{\"payloadType\":\"FORM_ENCODED|JSON\",\"usernameField\":{\"identifier\":\"/form/username\"},\"passwordField\":{\"identifier\":\"/form/password\"}}}}]},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[],\"sampledRequestsEnabled\":true},{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesBotControlRuleSet\",\"managedRuleGroupConfigs\":[{\"awsmanagedRulesBotControlRuleSet\":{\"inspectionLevel\":\"TARGETED|COMMON\"}}]},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[],\"sampledRequestsEnabled\":true,\"ruleActionOverrides\":[{\"name\":\"Rule1\",\"actionToUse\":{\"allow|block|count|captcha|challenge\":{}}},{\"name\":\"Rule2\",\"actionToUse\":{\"allow|block|count|captcha|challenge\":{}}}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"customRequestHandling\":null,\"customResponse\":null,\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":null,\"sampledRequestsEnabledForDefaultActions\":true}"
	//    Fraud Control account takeover prevention (ATP) - For information about
	//    the properties available for AWSManagedRulesATPRuleSet managed rule groups,
	//    see AWSManagedRulesATPRuleSet (https://docs.aws.amazon.com/waf/latest/APIReference/API_AWSManagedRulesATPRuleSet.html)
	//    in the WAF API Reference. Bot Control - For information about AWSManagedRulesBotControlRuleSet
	//    managed rule groups, see AWSManagedRulesBotControlRuleSet (https://docs.aws.amazon.com/waf/latest/APIReference/API_AWSManagedRulesBotControlRuleSet.html)
	//    in the WAF API Reference. Rule action overrides - Firewall Manager supports
	//    rule action overrides only for managed rule groups. To configure a RuleActionOverrides
	//    add the Name of the rule to override, and ActionToUse, which is the new
	//    action to use for the rule. For information about using rule action override,
	//    see RuleActionOverride (https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleActionOverride.html)
	//    in the WAF API Reference.
	//
	//    * Example: WAFV2 - CAPTCHA and Challenge configs "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAdminProtectionRuleSet\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[],\"sampledRequestsEnabled\":true}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"customRequestHandling\":null,\"customResponse\":null,\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":null,\"sampledRequestsEnabledForDefaultActions\":true,\"captchaConfig\":{\"immunityTimeProperty\":{\"immunityTime\":500}},\"challengeConfig\":{\"immunityTimeProperty\":{\"immunityTime\":800}},\"tokenDomains\":[\"google.com\",\"amazon.com\"]}"
	//    If you update the policy's values for captchaConfig, challengeConfig,
	//    or tokenDomains, Firewall Manager will overwrite your local web ACLs to
	//    contain the new value(s). However, if you don't update the policy's captchaConfig,
	//    challengeConfig, or tokenDomains values, the values in your local web
	//    ACLs will remain unchanged. For information about CAPTCHA and Challenge
	//    configs, see CaptchaConfig (https://docs.aws.amazon.com/waf/latest/APIReference/API_CaptchaConfig.html)
	//    and ChallengeConfig (https://docs.aws.amazon.com/waf/latest/APIReference/API_ChallengeConfig.html)
	//    in the WAF API Reference.
	//
	//    * Example: WAFV2 - Firewall Manager support for WAF managed rule group
	//    versioning "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":true,\"version\":\"Version_2.0\",\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesCommonRuleSet\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"
	//    To use a specific version of a WAF managed rule group in your Firewall
	//    Manager policy, you must set versionEnabled to true, and set version to
	//    the version you'd like to use. If you don't set versionEnabled to true,
	//    or if you omit versionEnabled, then Firewall Manager uses the default
	//    version of the WAF managed rule group.
	//
	//    * Example: WAFV2 - Logging configurations "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,
	//    \"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":
	//    {\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\", \"managedRuleGroupName\":\"AWSManagedRulesAdminProtectionRuleSet\"}
	//    ,\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[], \"sampledRequestsEnabled\":true}],\"postProcessRuleGroups\":[],
	//    \"defaultAction\":{\"type\":\"ALLOW\"},\"customRequestHandling\" :null,\"customResponse\":null,\"overrideCustomerWebACLAssociation\"
	//    :false,\"loggingConfiguration\":{\"logDestinationConfigs\": [\"arn:aws:s3:::aws-waf-logs-example-bucket\"]
	//    ,\"redactedFields\":[],\"loggingFilterConfigs\":{\"defaultBehavior\":\"KEEP\",
	//    \"filters\":[{\"behavior\":\"KEEP\",\"requirement\":\"MEETS_ALL\", \"conditions\":[{\"actionCondition\":\"CAPTCHA\"},{\"actionCondition\":
	//    \"CHALLENGE\"}, {\"actionCondition\":\"EXCLUDED_AS_COUNT\"}]}]}},\"sampledRequestsEnabledForDefaultActions\":true}"
	//    Firewall Manager supports Amazon Kinesis Data Firehose and Amazon S3 as
	//    the logDestinationConfigs in your loggingConfiguration. For information
	//    about WAF logging configurations, see LoggingConfiguration (https://docs.aws.amazon.com/waf/latest/APIReference/API_LoggingConfiguration.html)
	//    in the WAF API Reference In the loggingConfiguration, you can specify
	//    one logDestinationConfigs. Optionally provide as many as 20 redactedFields.
	//    The RedactedFieldType must be one of URI, QUERY_STRING, HEADER, or METHOD.
	//
	//    * Example: WAF Classic "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\",
	//    \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\":
	//    \"BLOCK\"}}"
	ManagedServiceData *string `min:"1" type:"string"`

	// Contains the Network Firewall firewall policy options to configure a centralized
	// deployment model.
	PolicyOption *PolicyOption `type:"structure"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an WAF policy, a Shield Advanced
	// policy, or a security group policy. For security group policies, Firewall
	// Manager supports one security group for each common policy and for each content
	// audit policy. This is an adjustable limit that you can increase by contacting
	// Amazon Web Services Support.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"SecurityServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityServicePolicyData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityServicePolicyData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SecurityServicePolicyData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SecurityServicePolicyData"}
	if s.ManagedServiceData != nil && len(*s.ManagedServiceData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedServiceData", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedServiceData sets the ManagedServiceData field's value.
func (s *SecurityServicePolicyData) SetManagedServiceData(v string) *SecurityServicePolicyData {
	s.ManagedServiceData = &v
	return s
}

// SetPolicyOption sets the PolicyOption field's value.
func (s *SecurityServicePolicyData) SetPolicyOption(v *PolicyOption) *SecurityServicePolicyData {
	s.PolicyOption = v
	return s
}

// SetType sets the Type field's value.
func (s *SecurityServicePolicyData) SetType(v string) *SecurityServicePolicyData {
	s.Type = &v
	return s
}

// Configuration settings for the handling of the stateful rule groups in a
// Network Firewall firewall policy.
type StatefulEngineOptions struct {
	_ struct{} `type:"structure"`

	// Indicates how to manage the order of stateful rule evaluation for the policy.
	// DEFAULT_ACTION_ORDER is the default behavior. Stateful rules are provided
	// to the rule engine as Suricata compatible strings, and Suricata evaluates
	// them based on certain settings. For more information, see Evaluation order
	// for stateful rules (https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html)
	// in the Network Firewall Developer Guide.
	RuleOrder *string `type:"string" enum:"RuleOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulEngineOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulEngineOptions) GoString() string {
	return s.String()
}

// SetRuleOrder sets the RuleOrder field's value.
func (s *StatefulEngineOptions) SetRuleOrder(v string) *StatefulEngineOptions {
	s.RuleOrder = &v
	return s
}

// Network Firewall stateful rule group, used in a NetworkFirewallPolicyDescription.
type StatefulRuleGroup struct {
	_ struct{} `type:"structure"`

	// The action that allows the policy owner to override the behavior of the rule
	// group within a policy.
	Override *NetworkFirewallStatefulRuleGroupOverride `type:"structure"`

	// An integer setting that indicates the order in which to run the stateful
	// rule groups in a single Network Firewall firewall policy. This setting only
	// applies to firewall policies that specify the STRICT_ORDER rule order in
	// the stateful engine options settings.
	//
	// Network Firewall evalutes each stateful rule group against a packet starting
	// with the group that has the lowest priority setting. You must ensure that
	// the priority settings are unique within each policy. For information about
	//
	// You can change the priority settings of your rule groups at any time. To
	// make it easier to insert rule groups later, number them so there's a wide
	// range in between, for example use 100, 200, and so on.
	Priority *int64 `type:"integer"`

	// The resource ID of the rule group.
	ResourceId *string `min:"1" type:"string"`

	// The name of the rule group.
	RuleGroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleGroup) GoString() string {
	return s.String()
}

// SetOverride sets the Override field's value.
func (s *StatefulRuleGroup) SetOverride(v *NetworkFirewallStatefulRuleGroupOverride) *StatefulRuleGroup {
	s.Override = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *StatefulRuleGroup) SetPriority(v int64) *StatefulRuleGroup {
	s.Priority = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *StatefulRuleGroup) SetResourceId(v string) *StatefulRuleGroup {
	s.ResourceId = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *StatefulRuleGroup) SetRuleGroupName(v string) *StatefulRuleGroup {
	s.RuleGroupName = &v
	return s
}

// Network Firewall stateless rule group, used in a NetworkFirewallPolicyDescription.
type StatelessRuleGroup struct {
	_ struct{} `type:"structure"`

	// The priority of the rule group. Network Firewall evaluates the stateless
	// rule groups in a firewall policy starting from the lowest priority setting.
	Priority *int64 `min:"1" type:"integer"`

	// The resource ID of the rule group.
	ResourceId *string `min:"1" type:"string"`

	// The name of the rule group.
	RuleGroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRuleGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRuleGroup) GoString() string {
	return s.String()
}

// SetPriority sets the Priority field's value.
func (s *StatelessRuleGroup) SetPriority(v int64) *StatelessRuleGroup {
	s.Priority = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *StatelessRuleGroup) SetResourceId(v string) *StatelessRuleGroup {
	s.ResourceId = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *StatelessRuleGroup) SetRuleGroupName(v string) *StatelessRuleGroup {
	s.RuleGroupName = &v
	return s
}

// A collection of key:value pairs associated with an Amazon Web Services resource.
// The key:value pair can be anything you define. Typically, the tag key represents
// a category (such as "environment") and the tag value represents a specific
// value within that category (such as "test," "development," or "production").
// You can add up to 50 tags to each Amazon Web Services resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// Part of the key:value pair that defines a tag. You can use a tag key to describe
	// a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall
	// Manager resources that support tagging are policies, applications lists,
	// and protocols lists.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *TagResourceInput) SetTagList(v []*Tag) *TagResourceInput {
	s.TagList = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Configures the third-party firewall's firewall policy.
type ThirdPartyFirewallFirewallPolicy struct {
	_ struct{} `type:"structure"`

	// The ID of the specified firewall policy.
	FirewallPolicyId *string `min:"1" type:"string"`

	// The name of the specified firewall policy.
	FirewallPolicyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallFirewallPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallFirewallPolicy) GoString() string {
	return s.String()
}

// SetFirewallPolicyId sets the FirewallPolicyId field's value.
func (s *ThirdPartyFirewallFirewallPolicy) SetFirewallPolicyId(v string) *ThirdPartyFirewallFirewallPolicy {
	s.FirewallPolicyId = &v
	return s
}

// SetFirewallPolicyName sets the FirewallPolicyName field's value.
func (s *ThirdPartyFirewallFirewallPolicy) SetFirewallPolicyName(v string) *ThirdPartyFirewallFirewallPolicy {
	s.FirewallPolicyName = &v
	return s
}

// The violation details for a third-party firewall that's not associated with
// an Firewall Manager managed route table.
type ThirdPartyFirewallMissingExpectedRouteTableViolation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the firewall subnet that's causing the violation.
	AvailabilityZone *string `type:"string"`

	// The resource ID of the current route table that's associated with the subnet,
	// if one is available.
	CurrentRouteTable *string `min:"1" type:"string"`

	// The resource ID of the route table that should be associated with the subnet.
	ExpectedRouteTable *string `min:"1" type:"string"`

	// The resource ID of the VPC associated with a fireawll subnet that's causing
	// the violation.
	VPC *string `min:"1" type:"string"`

	// The ID of the third-party firewall or VPC resource that's causing the violation.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallMissingExpectedRouteTableViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallMissingExpectedRouteTableViolation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ThirdPartyFirewallMissingExpectedRouteTableViolation) SetAvailabilityZone(v string) *ThirdPartyFirewallMissingExpectedRouteTableViolation {
	s.AvailabilityZone = &v
	return s
}

// SetCurrentRouteTable sets the CurrentRouteTable field's value.
func (s *ThirdPartyFirewallMissingExpectedRouteTableViolation) SetCurrentRouteTable(v string) *ThirdPartyFirewallMissingExpectedRouteTableViolation {
	s.CurrentRouteTable = &v
	return s
}

// SetExpectedRouteTable sets the ExpectedRouteTable field's value.
func (s *ThirdPartyFirewallMissingExpectedRouteTableViolation) SetExpectedRouteTable(v string) *ThirdPartyFirewallMissingExpectedRouteTableViolation {
	s.ExpectedRouteTable = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *ThirdPartyFirewallMissingExpectedRouteTableViolation) SetVPC(v string) *ThirdPartyFirewallMissingExpectedRouteTableViolation {
	s.VPC = &v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *ThirdPartyFirewallMissingExpectedRouteTableViolation) SetViolationTarget(v string) *ThirdPartyFirewallMissingExpectedRouteTableViolation {
	s.ViolationTarget = &v
	return s
}

// The violation details about a third-party firewall's subnet that doesn't
// have a Firewall Manager managed firewall in its VPC.
type ThirdPartyFirewallMissingFirewallViolation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the third-party firewall that's causing the violation.
	AvailabilityZone *string `type:"string"`

	// The reason the resource is causing this violation, if a reason is available.
	TargetViolationReason *string `type:"string"`

	// The resource ID of the VPC associated with a third-party firewall.
	VPC *string `min:"1" type:"string"`

	// The ID of the third-party firewall that's causing the violation.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallMissingFirewallViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallMissingFirewallViolation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ThirdPartyFirewallMissingFirewallViolation) SetAvailabilityZone(v string) *ThirdPartyFirewallMissingFirewallViolation {
	s.AvailabilityZone = &v
	return s
}

// SetTargetViolationReason sets the TargetViolationReason field's value.
func (s *ThirdPartyFirewallMissingFirewallViolation) SetTargetViolationReason(v string) *ThirdPartyFirewallMissingFirewallViolation {
	s.TargetViolationReason = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *ThirdPartyFirewallMissingFirewallViolation) SetVPC(v string) *ThirdPartyFirewallMissingFirewallViolation {
	s.VPC = &v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *ThirdPartyFirewallMissingFirewallViolation) SetViolationTarget(v string) *ThirdPartyFirewallMissingFirewallViolation {
	s.ViolationTarget = &v
	return s
}

// The violation details for a third-party firewall for an Availability Zone
// that's missing the Firewall Manager managed subnet.
type ThirdPartyFirewallMissingSubnetViolation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of a subnet that's causing the violation.
	AvailabilityZone *string `type:"string"`

	// The reason the resource is causing the violation, if a reason is available.
	TargetViolationReason *string `type:"string"`

	// The resource ID of the VPC associated with a subnet that's causing the violation.
	VPC *string `min:"1" type:"string"`

	// The ID of the third-party firewall or VPC resource that's causing the violation.
	ViolationTarget *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallMissingSubnetViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallMissingSubnetViolation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ThirdPartyFirewallMissingSubnetViolation) SetAvailabilityZone(v string) *ThirdPartyFirewallMissingSubnetViolation {
	s.AvailabilityZone = &v
	return s
}

// SetTargetViolationReason sets the TargetViolationReason field's value.
func (s *ThirdPartyFirewallMissingSubnetViolation) SetTargetViolationReason(v string) *ThirdPartyFirewallMissingSubnetViolation {
	s.TargetViolationReason = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *ThirdPartyFirewallMissingSubnetViolation) SetVPC(v string) *ThirdPartyFirewallMissingSubnetViolation {
	s.VPC = &v
	return s
}

// SetViolationTarget sets the ViolationTarget field's value.
func (s *ThirdPartyFirewallMissingSubnetViolation) SetViolationTarget(v string) *ThirdPartyFirewallMissingSubnetViolation {
	s.ViolationTarget = &v
	return s
}

// Configures the deployment model for the third-party firewall.
type ThirdPartyFirewallPolicy struct {
	_ struct{} `type:"structure"`

	// Defines the deployment model to use for the third-party firewall policy.
	FirewallDeploymentModel *string `type:"string" enum:"FirewallDeploymentModel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyFirewallPolicy) GoString() string {
	return s.String()
}

// SetFirewallDeploymentModel sets the FirewallDeploymentModel field's value.
func (s *ThirdPartyFirewallPolicy) SetFirewallDeploymentModel(v string) *ThirdPartyFirewallPolicy {
	s.FirewallDeploymentModel = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall
	// Manager resources that support tagging are policies, applications lists,
	// and protocols lists.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The keys of the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Violations for a resource based on the specified Firewall Manager policy
// and Amazon Web Services account.
type ViolationDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account that the violation details were requested
	// for.
	//
	// MemberAccount is a required field
	MemberAccount *string `min:"1" type:"string" required:"true"`

	// The ID of the Firewall Manager policy that the violation details were requested
	// for.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`

	// Brief description for the requested resource.
	ResourceDescription *string `type:"string"`

	// The resource ID that the violation details were requested for.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The ResourceTag objects associated with the resource.
	ResourceTags []*Tag `type:"list"`

	// The resource type that the violation details were requested for.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// List of violations for the requested resource.
	//
	// ResourceViolations is a required field
	ResourceViolations []*ResourceViolation `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViolationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViolationDetail) GoString() string {
	return s.String()
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *ViolationDetail) SetMemberAccount(v string) *ViolationDetail {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *ViolationDetail) SetPolicyId(v string) *ViolationDetail {
	s.PolicyId = &v
	return s
}

// SetResourceDescription sets the ResourceDescription field's value.
func (s *ViolationDetail) SetResourceDescription(v string) *ViolationDetail {
	s.ResourceDescription = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ViolationDetail) SetResourceId(v string) *ViolationDetail {
	s.ResourceId = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ViolationDetail) SetResourceTags(v []*Tag) *ViolationDetail {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ViolationDetail) SetResourceType(v string) *ViolationDetail {
	s.ResourceType = &v
	return s
}

// SetResourceViolations sets the ResourceViolations field's value.
func (s *ViolationDetail) SetResourceViolations(v []*ResourceViolation) *ViolationDetail {
	s.ResourceViolations = v
	return s
}

const (
	// AccountRoleStatusReady is a AccountRoleStatus enum value
	AccountRoleStatusReady = "READY"

	// AccountRoleStatusCreating is a AccountRoleStatus enum value
	AccountRoleStatusCreating = "CREATING"

	// AccountRoleStatusPendingDeletion is a AccountRoleStatus enum value
	AccountRoleStatusPendingDeletion = "PENDING_DELETION"

	// AccountRoleStatusDeleting is a AccountRoleStatus enum value
	AccountRoleStatusDeleting = "DELETING"

	// AccountRoleStatusDeleted is a AccountRoleStatus enum value
	AccountRoleStatusDeleted = "DELETED"
)

// AccountRoleStatus_Values returns all elements of the AccountRoleStatus enum
func AccountRoleStatus_Values() []string {
	return []string{
		AccountRoleStatusReady,
		AccountRoleStatusCreating,
		AccountRoleStatusPendingDeletion,
		AccountRoleStatusDeleting,
		AccountRoleStatusDeleted,
	}
}

const (
	// CustomerPolicyScopeIdTypeAccount is a CustomerPolicyScopeIdType enum value
	CustomerPolicyScopeIdTypeAccount = "ACCOUNT"

	// CustomerPolicyScopeIdTypeOrgUnit is a CustomerPolicyScopeIdType enum value
	CustomerPolicyScopeIdTypeOrgUnit = "ORG_UNIT"
)

// CustomerPolicyScopeIdType_Values returns all elements of the CustomerPolicyScopeIdType enum
func CustomerPolicyScopeIdType_Values() []string {
	return []string{
		CustomerPolicyScopeIdTypeAccount,
		CustomerPolicyScopeIdTypeOrgUnit,
	}
}

const (
	// CustomerPolicyStatusActive is a CustomerPolicyStatus enum value
	CustomerPolicyStatusActive = "ACTIVE"

	// CustomerPolicyStatusOutOfAdminScope is a CustomerPolicyStatus enum value
	CustomerPolicyStatusOutOfAdminScope = "OUT_OF_ADMIN_SCOPE"
)

// CustomerPolicyStatus_Values returns all elements of the CustomerPolicyStatus enum
func CustomerPolicyStatus_Values() []string {
	return []string{
		CustomerPolicyStatusActive,
		CustomerPolicyStatusOutOfAdminScope,
	}
}

const (
	// DependentServiceNameAwsconfig is a DependentServiceName enum value
	DependentServiceNameAwsconfig = "AWSCONFIG"

	// DependentServiceNameAwswaf is a DependentServiceName enum value
	DependentServiceNameAwswaf = "AWSWAF"

	// DependentServiceNameAwsshieldAdvanced is a DependentServiceName enum value
	DependentServiceNameAwsshieldAdvanced = "AWSSHIELD_ADVANCED"

	// DependentServiceNameAwsvpc is a DependentServiceName enum value
	DependentServiceNameAwsvpc = "AWSVPC"
)

// DependentServiceName_Values returns all elements of the DependentServiceName enum
func DependentServiceName_Values() []string {
	return []string{
		DependentServiceNameAwsconfig,
		DependentServiceNameAwswaf,
		DependentServiceNameAwsshieldAdvanced,
		DependentServiceNameAwsvpc,
	}
}

const (
	// DestinationTypeIpv4 is a DestinationType enum value
	DestinationTypeIpv4 = "IPV4"

	// DestinationTypeIpv6 is a DestinationType enum value
	DestinationTypeIpv6 = "IPV6"

	// DestinationTypePrefixList is a DestinationType enum value
	DestinationTypePrefixList = "PREFIX_LIST"
)

// DestinationType_Values returns all elements of the DestinationType enum
func DestinationType_Values() []string {
	return []string{
		DestinationTypeIpv4,
		DestinationTypeIpv6,
		DestinationTypePrefixList,
	}
}

const (
	// FailedItemReasonNotValidArn is a FailedItemReason enum value
	FailedItemReasonNotValidArn = "NOT_VALID_ARN"

	// FailedItemReasonNotValidPartition is a FailedItemReason enum value
	FailedItemReasonNotValidPartition = "NOT_VALID_PARTITION"

	// FailedItemReasonNotValidRegion is a FailedItemReason enum value
	FailedItemReasonNotValidRegion = "NOT_VALID_REGION"

	// FailedItemReasonNotValidService is a FailedItemReason enum value
	FailedItemReasonNotValidService = "NOT_VALID_SERVICE"

	// FailedItemReasonNotValidResourceType is a FailedItemReason enum value
	FailedItemReasonNotValidResourceType = "NOT_VALID_RESOURCE_TYPE"

	// FailedItemReasonNotValidAccountId is a FailedItemReason enum value
	FailedItemReasonNotValidAccountId = "NOT_VALID_ACCOUNT_ID"
)

// FailedItemReason_Values returns all elements of the FailedItemReason enum
func FailedItemReason_Values() []string {
	return []string{
		FailedItemReasonNotValidArn,
		FailedItemReasonNotValidPartition,
		FailedItemReasonNotValidRegion,
		FailedItemReasonNotValidService,
		FailedItemReasonNotValidResourceType,
		FailedItemReasonNotValidAccountId,
	}
}

const (
	// FirewallDeploymentModelCentralized is a FirewallDeploymentModel enum value
	FirewallDeploymentModelCentralized = "CENTRALIZED"

	// FirewallDeploymentModelDistributed is a FirewallDeploymentModel enum value
	FirewallDeploymentModelDistributed = "DISTRIBUTED"
)

// FirewallDeploymentModel_Values returns all elements of the FirewallDeploymentModel enum
func FirewallDeploymentModel_Values() []string {
	return []string{
		FirewallDeploymentModelCentralized,
		FirewallDeploymentModelDistributed,
	}
}

const (
	// MarketplaceSubscriptionOnboardingStatusNoSubscription is a MarketplaceSubscriptionOnboardingStatus enum value
	MarketplaceSubscriptionOnboardingStatusNoSubscription = "NO_SUBSCRIPTION"

	// MarketplaceSubscriptionOnboardingStatusNotComplete is a MarketplaceSubscriptionOnboardingStatus enum value
	MarketplaceSubscriptionOnboardingStatusNotComplete = "NOT_COMPLETE"

	// MarketplaceSubscriptionOnboardingStatusComplete is a MarketplaceSubscriptionOnboardingStatus enum value
	MarketplaceSubscriptionOnboardingStatusComplete = "COMPLETE"
)

// MarketplaceSubscriptionOnboardingStatus_Values returns all elements of the MarketplaceSubscriptionOnboardingStatus enum
func MarketplaceSubscriptionOnboardingStatus_Values() []string {
	return []string{
		MarketplaceSubscriptionOnboardingStatusNoSubscription,
		MarketplaceSubscriptionOnboardingStatusNotComplete,
		MarketplaceSubscriptionOnboardingStatusComplete,
	}
}

const (
	// NetworkFirewallOverrideActionDropToAlert is a NetworkFirewallOverrideAction enum value
	NetworkFirewallOverrideActionDropToAlert = "DROP_TO_ALERT"
)

// NetworkFirewallOverrideAction_Values returns all elements of the NetworkFirewallOverrideAction enum
func NetworkFirewallOverrideAction_Values() []string {
	return []string{
		NetworkFirewallOverrideActionDropToAlert,
	}
}

const (
	// OrganizationStatusOnboarding is a OrganizationStatus enum value
	OrganizationStatusOnboarding = "ONBOARDING"

	// OrganizationStatusOnboardingComplete is a OrganizationStatus enum value
	OrganizationStatusOnboardingComplete = "ONBOARDING_COMPLETE"

	// OrganizationStatusOffboarding is a OrganizationStatus enum value
	OrganizationStatusOffboarding = "OFFBOARDING"

	// OrganizationStatusOffboardingComplete is a OrganizationStatus enum value
	OrganizationStatusOffboardingComplete = "OFFBOARDING_COMPLETE"
)

// OrganizationStatus_Values returns all elements of the OrganizationStatus enum
func OrganizationStatus_Values() []string {
	return []string{
		OrganizationStatusOnboarding,
		OrganizationStatusOnboardingComplete,
		OrganizationStatusOffboarding,
		OrganizationStatusOffboardingComplete,
	}
}

const (
	// PolicyComplianceStatusTypeCompliant is a PolicyComplianceStatusType enum value
	PolicyComplianceStatusTypeCompliant = "COMPLIANT"

	// PolicyComplianceStatusTypeNonCompliant is a PolicyComplianceStatusType enum value
	PolicyComplianceStatusTypeNonCompliant = "NON_COMPLIANT"
)

// PolicyComplianceStatusType_Values returns all elements of the PolicyComplianceStatusType enum
func PolicyComplianceStatusType_Values() []string {
	return []string{
		PolicyComplianceStatusTypeCompliant,
		PolicyComplianceStatusTypeNonCompliant,
	}
}

const (
	// RemediationActionTypeRemove is a RemediationActionType enum value
	RemediationActionTypeRemove = "REMOVE"

	// RemediationActionTypeModify is a RemediationActionType enum value
	RemediationActionTypeModify = "MODIFY"
)

// RemediationActionType_Values returns all elements of the RemediationActionType enum
func RemediationActionType_Values() []string {
	return []string{
		RemediationActionTypeRemove,
		RemediationActionTypeModify,
	}
}

const (
	// ResourceSetStatusActive is a ResourceSetStatus enum value
	ResourceSetStatusActive = "ACTIVE"

	// ResourceSetStatusOutOfAdminScope is a ResourceSetStatus enum value
	ResourceSetStatusOutOfAdminScope = "OUT_OF_ADMIN_SCOPE"
)

// ResourceSetStatus_Values returns all elements of the ResourceSetStatus enum
func ResourceSetStatus_Values() []string {
	return []string{
		ResourceSetStatusActive,
		ResourceSetStatusOutOfAdminScope,
	}
}

const (
	// RuleOrderStrictOrder is a RuleOrder enum value
	RuleOrderStrictOrder = "STRICT_ORDER"

	// RuleOrderDefaultActionOrder is a RuleOrder enum value
	RuleOrderDefaultActionOrder = "DEFAULT_ACTION_ORDER"
)

// RuleOrder_Values returns all elements of the RuleOrder enum
func RuleOrder_Values() []string {
	return []string{
		RuleOrderStrictOrder,
		RuleOrderDefaultActionOrder,
	}
}

const (
	// SecurityServiceTypeWaf is a SecurityServiceType enum value
	SecurityServiceTypeWaf = "WAF"

	// SecurityServiceTypeWafv2 is a SecurityServiceType enum value
	SecurityServiceTypeWafv2 = "WAFV2"

	// SecurityServiceTypeShieldAdvanced is a SecurityServiceType enum value
	SecurityServiceTypeShieldAdvanced = "SHIELD_ADVANCED"

	// SecurityServiceTypeSecurityGroupsCommon is a SecurityServiceType enum value
	SecurityServiceTypeSecurityGroupsCommon = "SECURITY_GROUPS_COMMON"

	// SecurityServiceTypeSecurityGroupsContentAudit is a SecurityServiceType enum value
	SecurityServiceTypeSecurityGroupsContentAudit = "SECURITY_GROUPS_CONTENT_AUDIT"

	// SecurityServiceTypeSecurityGroupsUsageAudit is a SecurityServiceType enum value
	SecurityServiceTypeSecurityGroupsUsageAudit = "SECURITY_GROUPS_USAGE_AUDIT"

	// SecurityServiceTypeNetworkFirewall is a SecurityServiceType enum value
	SecurityServiceTypeNetworkFirewall = "NETWORK_FIREWALL"

	// SecurityServiceTypeDnsFirewall is a SecurityServiceType enum value
	SecurityServiceTypeDnsFirewall = "DNS_FIREWALL"

	// SecurityServiceTypeThirdPartyFirewall is a SecurityServiceType enum value
	SecurityServiceTypeThirdPartyFirewall = "THIRD_PARTY_FIREWALL"

	// SecurityServiceTypeImportNetworkFirewall is a SecurityServiceType enum value
	SecurityServiceTypeImportNetworkFirewall = "IMPORT_NETWORK_FIREWALL"
)

// SecurityServiceType_Values returns all elements of the SecurityServiceType enum
func SecurityServiceType_Values() []string {
	return []string{
		SecurityServiceTypeWaf,
		SecurityServiceTypeWafv2,
		SecurityServiceTypeShieldAdvanced,
		SecurityServiceTypeSecurityGroupsCommon,
		SecurityServiceTypeSecurityGroupsContentAudit,
		SecurityServiceTypeSecurityGroupsUsageAudit,
		SecurityServiceTypeNetworkFirewall,
		SecurityServiceTypeDnsFirewall,
		SecurityServiceTypeThirdPartyFirewall,
		SecurityServiceTypeImportNetworkFirewall,
	}
}

const (
	// TargetTypeGateway is a TargetType enum value
	TargetTypeGateway = "GATEWAY"

	// TargetTypeCarrierGateway is a TargetType enum value
	TargetTypeCarrierGateway = "CARRIER_GATEWAY"

	// TargetTypeInstance is a TargetType enum value
	TargetTypeInstance = "INSTANCE"

	// TargetTypeLocalGateway is a TargetType enum value
	TargetTypeLocalGateway = "LOCAL_GATEWAY"

	// TargetTypeNatGateway is a TargetType enum value
	TargetTypeNatGateway = "NAT_GATEWAY"

	// TargetTypeNetworkInterface is a TargetType enum value
	TargetTypeNetworkInterface = "NETWORK_INTERFACE"

	// TargetTypeVpcEndpoint is a TargetType enum value
	TargetTypeVpcEndpoint = "VPC_ENDPOINT"

	// TargetTypeVpcPeeringConnection is a TargetType enum value
	TargetTypeVpcPeeringConnection = "VPC_PEERING_CONNECTION"

	// TargetTypeEgressOnlyInternetGateway is a TargetType enum value
	TargetTypeEgressOnlyInternetGateway = "EGRESS_ONLY_INTERNET_GATEWAY"

	// TargetTypeTransitGateway is a TargetType enum value
	TargetTypeTransitGateway = "TRANSIT_GATEWAY"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeGateway,
		TargetTypeCarrierGateway,
		TargetTypeInstance,
		TargetTypeLocalGateway,
		TargetTypeNatGateway,
		TargetTypeNetworkInterface,
		TargetTypeVpcEndpoint,
		TargetTypeVpcPeeringConnection,
		TargetTypeEgressOnlyInternetGateway,
		TargetTypeTransitGateway,
	}
}

const (
	// ThirdPartyFirewallPaloAltoNetworksCloudNgfw is a ThirdPartyFirewall enum value
	ThirdPartyFirewallPaloAltoNetworksCloudNgfw = "PALO_ALTO_NETWORKS_CLOUD_NGFW"

	// ThirdPartyFirewallFortigateCloudNativeFirewall is a ThirdPartyFirewall enum value
	ThirdPartyFirewallFortigateCloudNativeFirewall = "FORTIGATE_CLOUD_NATIVE_FIREWALL"
)

// ThirdPartyFirewall_Values returns all elements of the ThirdPartyFirewall enum
func ThirdPartyFirewall_Values() []string {
	return []string{
		ThirdPartyFirewallPaloAltoNetworksCloudNgfw,
		ThirdPartyFirewallFortigateCloudNativeFirewall,
	}
}

const (
	// ThirdPartyFirewallAssociationStatusOnboarding is a ThirdPartyFirewallAssociationStatus enum value
	ThirdPartyFirewallAssociationStatusOnboarding = "ONBOARDING"

	// ThirdPartyFirewallAssociationStatusOnboardComplete is a ThirdPartyFirewallAssociationStatus enum value
	ThirdPartyFirewallAssociationStatusOnboardComplete = "ONBOARD_COMPLETE"

	// ThirdPartyFirewallAssociationStatusOffboarding is a ThirdPartyFirewallAssociationStatus enum value
	ThirdPartyFirewallAssociationStatusOffboarding = "OFFBOARDING"

	// ThirdPartyFirewallAssociationStatusOffboardComplete is a ThirdPartyFirewallAssociationStatus enum value
	ThirdPartyFirewallAssociationStatusOffboardComplete = "OFFBOARD_COMPLETE"

	// ThirdPartyFirewallAssociationStatusNotExist is a ThirdPartyFirewallAssociationStatus enum value
	ThirdPartyFirewallAssociationStatusNotExist = "NOT_EXIST"
)

// ThirdPartyFirewallAssociationStatus_Values returns all elements of the ThirdPartyFirewallAssociationStatus enum
func ThirdPartyFirewallAssociationStatus_Values() []string {
	return []string{
		ThirdPartyFirewallAssociationStatusOnboarding,
		ThirdPartyFirewallAssociationStatusOnboardComplete,
		ThirdPartyFirewallAssociationStatusOffboarding,
		ThirdPartyFirewallAssociationStatusOffboardComplete,
		ThirdPartyFirewallAssociationStatusNotExist,
	}
}

const (
	// ViolationReasonWebAclMissingRuleGroup is a ViolationReason enum value
	ViolationReasonWebAclMissingRuleGroup = "WEB_ACL_MISSING_RULE_GROUP"

	// ViolationReasonResourceMissingWebAcl is a ViolationReason enum value
	ViolationReasonResourceMissingWebAcl = "RESOURCE_MISSING_WEB_ACL"

	// ViolationReasonResourceIncorrectWebAcl is a ViolationReason enum value
	ViolationReasonResourceIncorrectWebAcl = "RESOURCE_INCORRECT_WEB_ACL"

	// ViolationReasonResourceMissingShieldProtection is a ViolationReason enum value
	ViolationReasonResourceMissingShieldProtection = "RESOURCE_MISSING_SHIELD_PROTECTION"

	// ViolationReasonResourceMissingWebAclOrShieldProtection is a ViolationReason enum value
	ViolationReasonResourceMissingWebAclOrShieldProtection = "RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION"

	// ViolationReasonResourceMissingSecurityGroup is a ViolationReason enum value
	ViolationReasonResourceMissingSecurityGroup = "RESOURCE_MISSING_SECURITY_GROUP"

	// ViolationReasonResourceViolatesAuditSecurityGroup is a ViolationReason enum value
	ViolationReasonResourceViolatesAuditSecurityGroup = "RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP"

	// ViolationReasonSecurityGroupUnused is a ViolationReason enum value
	ViolationReasonSecurityGroupUnused = "SECURITY_GROUP_UNUSED"

	// ViolationReasonSecurityGroupRedundant is a ViolationReason enum value
	ViolationReasonSecurityGroupRedundant = "SECURITY_GROUP_REDUNDANT"

	// ViolationReasonFmsCreatedSecurityGroupEdited is a ViolationReason enum value
	ViolationReasonFmsCreatedSecurityGroupEdited = "FMS_CREATED_SECURITY_GROUP_EDITED"

	// ViolationReasonMissingFirewall is a ViolationReason enum value
	ViolationReasonMissingFirewall = "MISSING_FIREWALL"

	// ViolationReasonMissingFirewallSubnetInAz is a ViolationReason enum value
	ViolationReasonMissingFirewallSubnetInAz = "MISSING_FIREWALL_SUBNET_IN_AZ"

	// ViolationReasonMissingExpectedRouteTable is a ViolationReason enum value
	ViolationReasonMissingExpectedRouteTable = "MISSING_EXPECTED_ROUTE_TABLE"

	// ViolationReasonNetworkFirewallPolicyModified is a ViolationReason enum value
	ViolationReasonNetworkFirewallPolicyModified = "NETWORK_FIREWALL_POLICY_MODIFIED"

	// ViolationReasonFirewallSubnetIsOutOfScope is a ViolationReason enum value
	ViolationReasonFirewallSubnetIsOutOfScope = "FIREWALL_SUBNET_IS_OUT_OF_SCOPE"

	// ViolationReasonInternetGatewayMissingExpectedRoute is a ViolationReason enum value
	ViolationReasonInternetGatewayMissingExpectedRoute = "INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE"

	// ViolationReasonFirewallSubnetMissingExpectedRoute is a ViolationReason enum value
	ViolationReasonFirewallSubnetMissingExpectedRoute = "FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE"

	// ViolationReasonUnexpectedFirewallRoutes is a ViolationReason enum value
	ViolationReasonUnexpectedFirewallRoutes = "UNEXPECTED_FIREWALL_ROUTES"

	// ViolationReasonUnexpectedTargetGatewayRoutes is a ViolationReason enum value
	ViolationReasonUnexpectedTargetGatewayRoutes = "UNEXPECTED_TARGET_GATEWAY_ROUTES"

	// ViolationReasonTrafficInspectionCrossesAzBoundary is a ViolationReason enum value
	ViolationReasonTrafficInspectionCrossesAzBoundary = "TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY"

	// ViolationReasonInvalidRouteConfiguration is a ViolationReason enum value
	ViolationReasonInvalidRouteConfiguration = "INVALID_ROUTE_CONFIGURATION"

	// ViolationReasonMissingTargetGateway is a ViolationReason enum value
	ViolationReasonMissingTargetGateway = "MISSING_TARGET_GATEWAY"

	// ViolationReasonInternetTrafficNotInspected is a ViolationReason enum value
	ViolationReasonInternetTrafficNotInspected = "INTERNET_TRAFFIC_NOT_INSPECTED"

	// ViolationReasonBlackHoleRouteDetected is a ViolationReason enum value
	ViolationReasonBlackHoleRouteDetected = "BLACK_HOLE_ROUTE_DETECTED"

	// ViolationReasonBlackHoleRouteDetectedInFirewallSubnet is a ViolationReason enum value
	ViolationReasonBlackHoleRouteDetectedInFirewallSubnet = "BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET"

	// ViolationReasonResourceMissingDnsFirewall is a ViolationReason enum value
	ViolationReasonResourceMissingDnsFirewall = "RESOURCE_MISSING_DNS_FIREWALL"

	// ViolationReasonRouteHasOutOfScopeEndpoint is a ViolationReason enum value
	ViolationReasonRouteHasOutOfScopeEndpoint = "ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT"

	// ViolationReasonFirewallSubnetMissingVpceEndpoint is a ViolationReason enum value
	ViolationReasonFirewallSubnetMissingVpceEndpoint = "FIREWALL_SUBNET_MISSING_VPCE_ENDPOINT"
)

// ViolationReason_Values returns all elements of the ViolationReason enum
func ViolationReason_Values() []string {
	return []string{
		ViolationReasonWebAclMissingRuleGroup,
		ViolationReasonResourceMissingWebAcl,
		ViolationReasonResourceIncorrectWebAcl,
		ViolationReasonResourceMissingShieldProtection,
		ViolationReasonResourceMissingWebAclOrShieldProtection,
		ViolationReasonResourceMissingSecurityGroup,
		ViolationReasonResourceViolatesAuditSecurityGroup,
		ViolationReasonSecurityGroupUnused,
		ViolationReasonSecurityGroupRedundant,
		ViolationReasonFmsCreatedSecurityGroupEdited,
		ViolationReasonMissingFirewall,
		ViolationReasonMissingFirewallSubnetInAz,
		ViolationReasonMissingExpectedRouteTable,
		ViolationReasonNetworkFirewallPolicyModified,
		ViolationReasonFirewallSubnetIsOutOfScope,
		ViolationReasonInternetGatewayMissingExpectedRoute,
		ViolationReasonFirewallSubnetMissingExpectedRoute,
		ViolationReasonUnexpectedFirewallRoutes,
		ViolationReasonUnexpectedTargetGatewayRoutes,
		ViolationReasonTrafficInspectionCrossesAzBoundary,
		ViolationReasonInvalidRouteConfiguration,
		ViolationReasonMissingTargetGateway,
		ViolationReasonInternetTrafficNotInspected,
		ViolationReasonBlackHoleRouteDetected,
		ViolationReasonBlackHoleRouteDetectedInFirewallSubnet,
		ViolationReasonResourceMissingDnsFirewall,
		ViolationReasonRouteHasOutOfScopeEndpoint,
		ViolationReasonFirewallSubnetMissingVpceEndpoint,
	}
}
