/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class DetailedLabelFigure
extends Figure {
    private static final FontCache FONTCACHE = new FontCache();
    private static final Border PAGE_BORDER = new MarginBorder(0, 1, 0, 1);
    private final SelectableImageFigure image = new SelectableImageFigure();
    private final FlowPage page;
    private final TextFlow nameText;
    private final TextFlow descText;
    private Font boldFont;
    private boolean selectionState;
    private int layoutMode = -1;
    private Font cachedFont;

    public DetailedLabelFigure() {
        this.image.setAlignment(1);
        this.page = new FlowPage();
        this.page.setBorder(PAGE_BORDER);
        this.nameText = new TextFlow();
        this.nameText.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.nameText, 2));
        this.descText = new TextFlow();
        this.descText.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.descText, 2));
        this.page.add((IFigure)this.nameText);
        this.add((IFigure)this.image);
        this.add((IFigure)this.page);
        BorderLayout layout = new BorderLayout();
        layout.setHorizontalSpacing(2);
        layout.setVerticalSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
    }

    public void addNotify() {
        super.addNotify();
        this.updateFont(this.layoutMode);
    }

    protected void dispose() {
        if (this.boldFont != null) {
            this.nameText.setFont(null);
            FONTCACHE.checkIn(this.boldFont);
            this.boldFont = null;
        }
        if (this.image != null) {
            this.image.disposeShadedImage();
        }
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
        this.updateImage();
    }

    public void handleFocusLost(FocusEvent event) {
        super.handleFocusLost(event);
        this.updateImage();
    }

    public boolean isNameTruncated() {
        return this.nameText.isTextTruncated();
    }

    public boolean isSelected() {
        return this.selectionState;
    }

    public void setDescription(String s) {
        Object str = "";
        if (s != null && !s.trim().equals("") && !s.trim().equals(this.nameText.getText().trim())) {
            str = " " + PaletteMessages.NAME_DESCRIPTION_SEPARATOR + " " + s;
        }
        if (this.descText.getText().equals(str)) {
            return;
        }
        this.descText.setText((String)str);
    }

    public void setImage(Image icon) {
        this.image.setImage(icon);
    }

    public void setLayoutMode(int layoutMode) {
        this.updateFont(layoutMode);
        if (layoutMode == this.layoutMode) {
            return;
        }
        this.layoutMode = layoutMode;
        this.add((IFigure)this.page);
        if (this.descText.getParent() == this.page) {
            this.page.remove((IFigure)this.descText);
        }
        BorderLayout layout = (BorderLayout)this.getLayoutManager();
        switch (layoutMode) {
            case 1: {
                this.page.setHorizontalAligment(2);
                layout.setConstraint((IFigure)this.image, (Object)BorderLayout.TOP);
                layout.setConstraint((IFigure)this.page, (Object)BorderLayout.CENTER);
                break;
            }
            case 2: {
                layout.setConstraint((IFigure)this.image, (Object)BorderLayout.CENTER);
                this.remove((IFigure)this.page);
                break;
            }
            case 0: {
                this.page.setHorizontalAligment(1);
                layout.setConstraint((IFigure)this.image, (Object)BorderLayout.LEFT);
                layout.setConstraint((IFigure)this.page, (Object)BorderLayout.CENTER);
                break;
            }
            case 3: {
                this.page.add((IFigure)this.descText);
                this.page.setHorizontalAligment(1);
                layout.setConstraint((IFigure)this.image, (Object)BorderLayout.LEFT);
                layout.setConstraint((IFigure)this.page, (Object)BorderLayout.CENTER);
                break;
            }
        }
    }

    public void setName(String str) {
        if (this.nameText.getText().equals(str)) {
            return;
        }
        this.nameText.setText(str);
    }

    public void setSelected(boolean state) {
        this.selectionState = state;
        this.updateImage();
    }

    private void updateImage() {
        if (this.isSelected()) {
            if (this.hasFocus()) {
                this.image.useShadedImage();
            } else {
                this.image.disposeShadedImage();
            }
        } else {
            this.image.disposeShadedImage();
        }
    }

    private void updateFont(int layout) {
        boolean layoutChanged = this.layoutMode != layout;
        boolean fontChanged = this.cachedFont == null || this.cachedFont != this.getFont();
        this.cachedFont = this.getFont();
        if (layoutChanged || fontChanged) {
            if (this.boldFont != null) {
                FONTCACHE.checkIn(this.boldFont);
                this.boldFont = null;
            }
            if (layout == 3 && this.cachedFont != null) {
                this.boldFont = FONTCACHE.checkOut(this.cachedFont);
            }
            this.nameText.setFont(this.boldFont);
        }
    }

    private static class FontCache {
        private final Map<FontData, FontInfo> table = new HashMap<FontData, FontInfo>();

        private FontCache() {
        }

        public void checkIn(Font boldFont) {
            Map.Entry fontEntry = this.table.entrySet().stream().filter(entry -> ((FontInfo)entry.getValue()).boldFont == boldFont).findAny().orElse(null);
            if (fontEntry != null) {
                FontInfo info = (FontInfo)fontEntry.getValue();
                --info.refCount;
                if (info.refCount == 0) {
                    boldFont.dispose();
                    this.table.remove(fontEntry.getKey());
                }
            }
        }

        public Font checkOut(Font font) {
            FontData key = font.getFontData()[0];
            FontInfo info = this.table.computeIfAbsent(key, dummykey -> {
                FontData[] boldDatas;
                FontData[] fontDataArray = boldDatas = font.getFontData();
                int n = boldDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    FontData element = fontDataArray[n2];
                    element.setStyle(1);
                    ++n2;
                }
                return new FontInfo(new Font((Device)Display.getCurrent(), boldDatas));
            });
            ++info.refCount;
            return info.boldFont;
        }

        private static class FontInfo {
            private final Font boldFont;
            private int refCount;

            public FontInfo(Font boldFont) {
                this.boldFont = boldFont;
            }
        }
    }

    private static class SelectableImageFigure
    extends ImageFigure {
        private Image shadedImage;

        private SelectableImageFigure() {
        }

        protected void useShadedImage() {
            this.disposeShadedImage();
            if (super.getImage() != null) {
                ImageData data = ImageUtilities.createShadedImage((Image)super.getImage(), (Color)ColorConstants.menuBackgroundSelected);
                this.shadedImage = new Image(null, data, data.getTransparencyMask());
            }
        }

        protected void disposeShadedImage() {
            if (this.shadedImage != null) {
                this.shadedImage.dispose();
                this.shadedImage = null;
            }
        }

        public Image getImage() {
            if (this.shadedImage != null) {
                return this.shadedImage;
            }
            return super.getImage();
        }

        public void setImage(Image image) {
            if (image == super.getImage()) {
                return;
            }
            boolean wasShaded = this.shadedImage != null;
            this.disposeShadedImage();
            super.setImage(image);
            if (wasShaded) {
                this.useShadedImage();
            }
        }
    }
}

