To decouple the building of a conda package from Pixi we provide something what are called build backends.
These are essentially executables following a specific protocol that is implemented for both Pixi and the build backend.
This also allows for decoupling of the build backend from Pixi and it's manifest specification.

## Available Backends

| Backend   | Use Case |
|---------|----------|
| [**`pixi-build-cmake`**](./backends/pixi-build-cmake.md) |  Projects using CMake |
| [**`pixi-build-python`**](./backends/pixi-build-python.md) | Building Python packages |
| [**`pixi-build-rattler-build`**](./backends/pixi-build-rattler-build.md) | Direct `recipe.yaml` builds with full control |
| [**`pixi-build-ros`**](./backends/pixi-build-ros.md) | ROS (Robot Operating System) packages |
| [**`pixi-build-rust`**](./backends/pixi-build-rust.md) |  Cargo-based Rust applications and libraries |
| [**`pixi-build-mojo`**](./backends/pixi-build-mojo.md) |  Mojo applications and packages |

All backends are available through the [conda-forge](https://prefix.dev/channels/conda-forge) conda channel and work across multiple platforms (Linux, macOS, Windows).
For the latest backend versions, you can prepend the channel list with the [prefix.dev/pixi-build-backends](https://prefix.dev/channels/pixi-build-backends) conda channel.

## Key Concepts

- [Compilers](./key_concepts/compilers.md) - How pixi-build integrates with conda-forge's compiler infrastructure

### Installation

Install a certain build backend by adding it to the `package.build` section of the manifest file.:

```toml
--8<-- "docs/source_files/pixi_tomls/simple_pixi_build.toml:build-system"
```

For custom backend channels, you can add the channel to the `channels` section of the manifest file:
```toml
--8<-- "docs/source_files/pixi_tomls/pixi-build-backend-channel.toml:build"
```


### Overriding the Build Backend

Sometimes you want to override the build backend that is used by pixi. Meaning overriding the backend that is specified in the [`[package.build]`](../reference/pixi_manifest.md#build-table). We currently have two environment variables that allow for this:

1. `PIXI_BUILD_BACKEND_OVERRIDE`: This environment variable allows for overriding of one or multiple backends.  Use `{name}={path}` to specify a backend name mapped to a path and `,` to separate multiple backends.
For example: `pixi-build-cmake=/path/to/bin,pixi-build-python` will:
   1. override the `pixi-build-cmake` backend with the executable located at `/path/to/bin`
   2. and will use the `pixi-build-python` backend from the `PATH`.
2. `PIXI_BUILD_BACKEND_OVERRIDE_ALL`: If this environment variable is set to *some* value e.g `1` or `true`, it will not install any backends in isolation and will assume that all backends are overridden and available in the `PATH`. This is useful for development purposes. e.g `PIXI_BUILD_BACKEND_OVERRIDE_ALL=1 pixi install`

## Troubleshooting

### Rebuilding Generated Recipes

When you build a package using `pixi build`, the build backends generate a complete rattler-build recipe that is stored in your project's build directory. This can be useful for debugging build issues or understanding exactly how your package is being built.

### Recipe Locations

The build backends generate recipes in two locations:

#### 1. General Recipe (all outputs)

```
<your_project>/.pixi/build/work/<package-name>--<hash>/debug/
```

This directory contains:

- `recipe.yaml` - A general recipe that can build all package outputs
- `variants.yaml` - All variant configurations for the package

#### 2. Variant-Specific Recipe (single output)

```
<your_project>/.pixi/build/work/<package-name>--<hash>/debug/recipe/<variant_hash>/
```

This directory contains:

- `recipe.yaml` - The complete rattler-build recipe generated by the build backend
- `variants.yaml` - The variant configuration used for this specific build

### Rebuilding a Package

To debug or rebuild a package using the same configuration, you have two options:

#### Option 1: Navigate to the recipe directory

1. Navigate to the recipe directory:
   ```bash
   cd .pixi/build/work/<package-name>--<hash>/recipe/<variant_hash>/debug/
   ```

2. Use `rattler-build` to rebuild the package:
   ```bash
   rattler-build build
   ```

#### Option 2: Point to the recipe directory

Use the `--recipe` flag to build without changing directories:

```bash
rattler-build build --recipe .pixi/build/work/<package-name>--<hash>/debug/recipe/<variant_hash>/
```

This allows you to:

* Inspect the exact recipe that was generated
* Debug build failures with direct access to `rattler-build`
* Understand how the build backend translated your project model (`pixi.toml`)

!!! tip
    The `<variant_hash>` ensures that each unique combination of build variants gets its own recipe directory, making it easy to compare different build configurations.

### Debugging JSON-RPC

You can find JSON version of your project model and requests/responses in the same directory alongside `recipe.yaml`.
We store:

- Project model: `project_model.json`
- Requests: `*_params.json`
- Responses: `*_response.json`
