/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;

public class SymbolicName {
    private int kind;
    private StructuredQName name;
    private int arity = -1;

    public SymbolicName(int kind, StructuredQName name) {
        this.kind = kind;
        this.name = name;
    }

    public SymbolicName(int kind, StructuredQName name, int arity) {
        this.kind = kind;
        this.name = name;
        this.arity = arity;
    }

    public int hashCode() {
        return this.kind << 16 ^ this.arity ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SymbolicName && ((SymbolicName)obj).kind == this.kind && ((SymbolicName)obj).arity == this.arity && ((SymbolicName)obj).name.equals(this.name);
    }

    public int getComponentKind() {
        return this.kind;
    }

    public StructuredQName getComponentName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public String toString() {
        return StandardNames.getLocalName(this.kind) + " " + this.name.getDisplayName() + (this.arity == -1 ? "" : "#" + this.arity);
    }
}

