//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A view that extends content to fill its own bounds.
    ///
    /// A background extension view can be laid out to extend outside the safe area,
    /// such as under the titlebar, sidebar, or inspector. By default it lays out
    /// its content to stay within the safe area, and uses modifications of the
    /// content along the edges to fill the container view.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundextensionview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSBackgroundExtensionView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSBackgroundExtensionView {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSBackgroundExtensionView {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSBackgroundExtensionView {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSBackgroundExtensionView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSBackgroundExtensionView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSBackgroundExtensionView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSBackgroundExtensionView {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSBackgroundExtensionView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSBackgroundExtensionView {
    extern_methods!(
        /// The content view to extend to fill the `NSBackgroundExtensionView`.
        ///
        /// The content view will be added as a subview of the extension view and
        /// placed within the safe area by default. See `automaticallyPlacesContentView`
        /// to customize the layout.
        #[unsafe(method(contentView))]
        #[unsafe(method_family = none)]
        pub fn contentView(&self) -> Option<Retained<NSView>>;

        /// Setter for [`contentView`][Self::contentView].
        #[unsafe(method(setContentView:))]
        #[unsafe(method_family = none)]
        pub fn setContentView(&self, content_view: Option<&NSView>);

        /// Controls the automatic safe area placement of the `contentView` within the
        /// container.
        ///
        /// When `NO`, the frame of the content view must be explicitly set or
        /// constraints added. The extension effect will be used to fill the container
        /// view around the content.
        ///
        /// Defaults to `YES`.
        #[unsafe(method(automaticallyPlacesContentView))]
        #[unsafe(method_family = none)]
        pub fn automaticallyPlacesContentView(&self) -> bool;

        /// Setter for [`automaticallyPlacesContentView`][Self::automaticallyPlacesContentView].
        #[unsafe(method(setAutomaticallyPlacesContentView:))]
        #[unsafe(method_family = none)]
        pub fn setAutomaticallyPlacesContentView(&self, automatically_places_content_view: bool);
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSBackgroundExtensionView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSBackgroundExtensionView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSBackgroundExtensionView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
