/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.parsers;

import java.text.ParseException;
import java.util.List;
import org.hampelratte.svdrp.parsers.EPGParser;
import org.hampelratte.svdrp.responses.highlevel.EPGEntry;
import org.hampelratte.svdrp.responses.highlevel.Recording;

public class RecordingParser
extends EPGParser {
    public void parseRecording(Recording recording, String epgData) throws ParseException {
        List<EPGEntry> list = this.parse(epgData = this.addEpgEntryEnd(epgData));
        if (list.isEmpty()) {
            throw new ParseException("Couldn't parse recording. EPGParser returned an empty list.", -1);
        }
        EPGEntry entry = list.get(0);
        recording.copyFrom(entry);
        recording.setPriority(((Recording)entry).getPriority());
        recording.setLifetime(((Recording)entry).getLifetime());
        recording.setDisplayTitle(entry.getTitle());
    }

    private String addEpgEntryEnd(String epgData) {
        String[] lines = epgData.split("\n");
        StringBuffer mesg = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            if (i == lines.length - 1) {
                mesg.append("e\n");
            }
            mesg.append(lines[i] + "\n");
        }
        return mesg.toString();
    }

    @Override
    protected void parseLine(String line, List<EPGEntry> list) {
        switch (line.charAt(0)) {
            case 'P': {
                ((Recording)this.epg).setPriority(Integer.parseInt(line.substring(2)));
                break;
            }
            case 'L': {
                ((Recording)this.epg).setLifetime(Integer.parseInt(line.substring(2)));
                break;
            }
            default: {
                super.parseLine(line, list);
            }
        }
    }

    @Override
    protected EPGEntry createNewEpgEntry() {
        return new Recording();
    }
}

